/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FormatDenylist {
    static final Logger log;
    private static final ArrayList<String> DENYLIST_EXCLUSIONS;
    private static final ArrayList<FormatDenylistEntry> DENYLIST;

    private FormatDenylist() {
    }

    public static boolean isDenied(Class<?> cls, String methodName, Class<?>[] params) {
        return DENYLIST.stream().anyMatch(e -> ((FormatDenylistEntry)e).isDeniedAndNotExcluded(cls, methodName, params));
    }

    public static boolean isExcludedFromDenylist(Class<?> cls, String methodName, Class<?>[] params) {
        Object compare2;
        if (DENYLIST_EXCLUSIONS.isEmpty()) {
            return false;
        }
        boolean excluded = false;
        try {
            cls.getMethod(methodName, params);
            compare2 = cls.getName() + '.' + methodName;
            excluded = DENYLIST_EXCLUSIONS.stream().anyMatch(e -> e.equals(compare2));
        }
        catch (Exception compare2) {
            // empty catch block
        }
        if (!excluded) {
            Class<?> superCls;
            Class<?> iface;
            compare2 = cls.getInterfaces();
            int n = ((Class<?>[])compare2).length;
            for (int i = 0; i < n && !(excluded = FormatDenylist.isExcludedFromDenylist(iface = compare2[i], methodName, params)); ++i) {
            }
            if (!excluded && (superCls = cls.getSuperclass()) != null) {
                excluded = FormatDenylist.isExcludedFromDenylist(superCls, methodName, params);
            }
        }
        return excluded;
    }

    private static void addDenylistEntry(String cls, String method, boolean allowExclusions) {
        DENYLIST.add(new FormatDenylistEntry(cls, method, allowExclusions));
    }

    static {
        StringTokenizer st;
        log = Logger.getLogger("baja");
        DENYLIST_EXCLUSIONS = new ArrayList();
        String denylistExclusions = AccessController.doPrivileged(() -> System.getProperty("niagara.baja.formatBlacklistExclusions", null));
        if (denylistExclusions != null) {
            try {
                st = new StringTokenizer(denylistExclusions, ";");
                while (st.hasMoreTokens()) {
                    String entry = st.nextToken();
                    int idx = entry.lastIndexOf(40);
                    if (idx > -1) {
                        entry = entry.substring(0, idx);
                    }
                    DENYLIST_EXCLUSIONS.add(entry);
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Could not parse BFormat denylist exclusion entries from system.properties", e);
            }
        }
        DENYLIST = new ArrayList();
        String denylist = AccessController.doPrivileged(() -> System.getProperty("niagara.baja.formatBlacklist", null));
        if (denylist != null) {
            try {
                st = new StringTokenizer(denylist, ";");
                while (st.hasMoreTokens()) {
                    DENYLIST.add(new FormatDenylistEntry(st.nextToken()));
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Could not parse BFormat denylist entries from system.properties", e);
            }
        }
        FormatDenylist.addDenylistEntry("javax.baja.job.BJob", "submit", false);
        FormatDenylist.addDenylistEntry("javax.baja.schedule.BDaySchedule", "clear", false);
        FormatDenylist.addDenylistEntry("javax.baja.schedule.BEnumSetSchedule", "clear", false);
        FormatDenylist.addDenylistEntry("com.tridium.program.BCode", "newInstance", false);
        FormatDenylist.addDenylistEntry("com.tridium.program.BProgramCode", "newProgramInstance", false);
    }

    private static class FormatDenylistEntry {
        private final String deniedClass;
        private final String deniedMethod;
        private final boolean allowExclusions;

        public FormatDenylistEntry(String deniedClass, String deniedMethod, boolean allowExclusions) {
            this.deniedClass = deniedClass;
            this.deniedMethod = deniedMethod;
            this.allowExclusions = allowExclusions;
        }

        public FormatDenylistEntry(String classAndMethod) {
            int idx = classAndMethod.lastIndexOf(46);
            String className = classAndMethod.substring(0, idx);
            String methodName = classAndMethod.substring(idx + 1);
            idx = methodName.lastIndexOf(40);
            if (idx > -1) {
                methodName = methodName.substring(0, idx);
            }
            this.deniedClass = className;
            this.deniedMethod = methodName;
            this.allowExclusions = true;
        }

        private boolean isDeniedAndNotExcluded(Class<?> cls, String methodName, Class<?>[] params) {
            boolean denylist = this.inDenylist(cls, methodName, params);
            if (denylist && this.allowExclusions) {
                denylist = !FormatDenylist.isExcludedFromDenylist(cls, methodName, params);
            }
            return denylist;
        }

        private boolean inDenylist(Class<?> cls, String methodName, Class<?>[] params) {
            if (!this.deniedMethod.equals(methodName)) {
                return false;
            }
            boolean denied = false;
            try {
                cls.getMethod(methodName, params);
                denied = this.deniedClass.equals(cls.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!denied) {
                Class<?> superCls;
                Class<?> iface;
                Class<?>[] classArray = cls.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && !(denied = this.isDeniedAndNotExcluded(iface = classArray[i], methodName, params)); ++i) {
                }
                if (!denied && (superCls = cls.getSuperclass()) != null) {
                    denied = this.isDeniedAndNotExcluded(superCls, methodName, params);
                }
            }
            return denied;
        }
    }
}

