/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.LinkedList;
import javax.baja.sys.BObject;
import javax.baja.sys.Type;

public abstract class ClassUtil {
    public static Class<?>[] classes(Object[] objects) {
        Class[] cls = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            cls[i] = objects[i].getClass();
        }
        return cls;
    }

    public static Class<?> baseClass(Class[] classes) {
        LinkedList[] superclasses = new LinkedList[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            superclasses[i] = new LinkedList();
            for (Class cls = classes[i]; cls != null; cls = cls.getSuperclass()) {
                superclasses[i].addFirst(cls);
            }
        }
        Class baseClass = (Class)superclasses[0].get(0);
        block2: for (int n = 0; n != superclasses[0].size(); ++n) {
            Class cls = (Class)superclasses[0].get(n);
            for (int i = 1; i < superclasses.length; ++i) {
                if (n == superclasses[i].size() || !cls.equals(superclasses[i].get(n))) break block2;
            }
            baseClass = cls;
        }
        return baseClass;
    }

    public static boolean all(Object[] objects, Class<?> cls) {
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) {
                return false;
            }
            if (cls.isAssignableFrom(objects[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public static boolean any(Object[] objects, Class<?> cls) {
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null || !cls.isAssignableFrom(objects[i].getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean allNull(Object[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean anyNull(Object[] obj) {
        for (int i = 0; i < obj.length; ++i) {
            if (obj[i] != null) continue;
            return true;
        }
        return false;
    }

    public static boolean sameClass(Object[] objects) {
        if (objects[0] == null) {
            return false;
        }
        Class<?> cls = objects[0].getClass();
        for (int i = 1; i < objects.length; ++i) {
            if (objects[i] == null) {
                return false;
            }
            if (cls.equals(objects[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public static Type getCommonSuperType(BObject[] objects) {
        Type[] types = new Type[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            types[i] = objects[i].getType();
        }
        return ClassUtil.getCommonSuperType(types);
    }

    public static Type getCommonSuperType(Type[] types) {
        if (types.length == 1) {
            return types[0];
        }
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isInterface()) continue;
            return BObject.TYPE;
        }
        Type result = types[0];
        while (result != BObject.TYPE) {
            boolean allMatch = true;
            for (int i = 1; i < types.length; ++i) {
                if (types[i].is(result)) continue;
                allMatch = false;
                break;
            }
            if (allMatch) {
                return result;
            }
            if ((result = result.getSuperType()) != null) continue;
            return BObject.TYPE;
        }
        return BObject.TYPE;
    }
}

