/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.util.ArrayUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Validatable;
import javax.baja.user.BUser;

public final class CategoryValidator
implements IPropertyValidator {
    public static final CategoryValidator INSTANCE = new CategoryValidator();
    private static final Logger LOG = Logger.getLogger("sys.service");

    private CategoryValidator() {
    }

    @Override
    public void validateSet(Validatable validatable, Context context) {
    }

    @Override
    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
    }

    @Override
    public BValue[] adjustPendingSetValues(BComplex instance, Property[] properties, BValue[] values, Context context) {
        int idx;
        if (instance.getType().is(BCategoryService.TYPE) && instance.asComponent().isRunning() && context != null && context.getUser() != null && !context.getUser().getPermissions().isSuperUser() && (idx = ArrayUtil.indexOf(properties, BCategoryService.ordMap)) >= 0) {
            values[idx] = this.adjustPendingSetValue(instance, properties[idx], values[idx], context);
        }
        return values;
    }

    @Override
    public BValue adjustPendingSetValue(BComplex instance, Property property, BValue value, Context context) {
        BUser user;
        BCategoryService categoryService;
        if (instance.getType().is(BCategoryService.TYPE) && (categoryService = instance.as(BCategoryService.class)).isRunning() && context != null && property.equals(BCategoryService.ordMap) && (user = context.getUser()) != null && !user.getPermissions().isSuperUser()) {
            ArrayList<BOrd> ords = new ArrayList<BOrd>();
            ArrayList<BCategoryMask> cats = new ArrayList<BCategoryMask>();
            BOrdToCategoryMap currentMap = categoryService.getOrdMap();
            BOrdToCategoryMap newMap = value.as(BOrdToCategoryMap.class);
            int newSize = newMap.size();
            for (int i = 0; i < newSize; ++i) {
                BOrd ord = newMap.getOrd(i);
                BCategoryMask currentMask = currentMap.getAppliedCategoryMask(ord);
                if (currentMask == null) {
                    BObject obj = ord.get(instance);
                    if (obj instanceof BICategorizable) {
                        currentMask = ((BICategorizable)((Object)obj)).getAppliedCategoryMask();
                    }
                    if (currentMask == null) {
                        currentMask = BCategoryMask.NULL;
                    }
                }
                BCategoryMask newMask = CategoryValidator.doAdjustPendingCategoryMask(categoryService, ord, newMap.getCategoryMask(i), newMap.getAppliedCategoryMask(ord), currentMask, context);
                ords.add(ord);
                cats.add(newMask);
            }
            int currentSize = currentMap.size();
            for (int i = 0; i < currentSize; ++i) {
                BOrd ord = currentMap.getOrd(i);
                BCategoryMask currentCatMask = currentMap.getCategoryMask(i);
                BCategoryMask newCatMask = newMap.getCategoryMask(ord);
                BCategoryMask newAppliedCatMask = newMap.getAppliedCategoryMask(ord);
                if (newCatMask == null && newAppliedCatMask != null) {
                    int size = newAppliedCatMask.isWildcard() ? categoryService.getMaxCategoryIndex() : newAppliedCatMask.size();
                    for (int j = 1; j <= size; ++j) {
                        if (!newAppliedCatMask.get(j) || currentCatMask != null && currentCatMask.get(j) || user.getPermissions().getPermissions(j).hasOperatorWrite()) continue;
                        throw new LocalizableRuntimeException("baja", "UnauthorizedCategoryMaskChange");
                    }
                }
                boolean adjusted = false;
                if (currentCatMask != null) {
                    int size = currentCatMask.isWildcard() ? categoryService.getMaxCategoryIndex() : currentCatMask.size();
                    for (int j = 1; j <= size; ++j) {
                        if (!currentCatMask.get(j) || newAppliedCatMask != null && newAppliedCatMask.get(j) || user.getPermissions().getPermissions(j).hasOperatorWrite()) continue;
                        BCategoryMask individualMask = BCategoryMask.make(new int[]{j});
                        newCatMask = newCatMask == null ? individualMask : BCategoryMask.or(newCatMask, individualMask);
                        adjusted = true;
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.fine("User " + user + " is modifying the category mask for an object but does not have permission to (unintentionally) remove category " + categoryService.getCategory(j).getDisplayName(null) + "from the mask. That category will be restored on the category mask for object " + ord);
                    }
                }
                if (!adjusted) continue;
                int idx = ords.indexOf(ord);
                if (idx >= 0) {
                    cats.set(idx, newCatMask);
                    continue;
                }
                ords.add(ord);
                cats.add(newCatMask);
            }
            return BOrdToCategoryMap.make(ords.toArray(new BOrd[ords.size()]), cats.toArray(new BCategoryMask[cats.size()]));
        }
        return value;
    }

    public static BCategoryMask adjustPendingCategoryMask(BComponent instance, BCategoryMask newMask, Context cx) {
        if (instance.isRunning()) {
            BComplex parent = instance.getParent();
            return CategoryValidator.doAdjustPendingCategoryMask((BCategoryService)Sys.getService(BCategoryService.TYPE), instance, newMask, newMask.isNull() && parent != null ? parent.asComponent().getAppliedCategoryMask() : newMask, instance.getAppliedCategoryMask(), cx);
        }
        return newMask;
    }

    private static BCategoryMask doAdjustPendingCategoryMask(BCategoryService categoryService, BObject ordOrObj, BCategoryMask newCategoryMask, BCategoryMask newAppliedCategoryMask, BCategoryMask oldAppliedCategoryMask, Context context) {
        BUser user;
        if (categoryService.isRunning() && context != null && (user = context.getUser()) != null && !user.getPermissions().isSuperUser()) {
            int i;
            BCategoryMask newMask = newCategoryMask;
            int size = newAppliedCategoryMask.isWildcard() ? categoryService.getMaxCategoryIndex() : newAppliedCategoryMask.size();
            for (i = 1; i <= size; ++i) {
                if (!newAppliedCategoryMask.get(i) || oldAppliedCategoryMask != null && oldAppliedCategoryMask.get(i) || user.getPermissions().getPermissions(i).hasOperatorWrite()) continue;
                throw new LocalizableRuntimeException("baja", "UnauthorizedCategoryMaskChange");
            }
            size = oldAppliedCategoryMask.isWildcard() ? categoryService.getMaxCategoryIndex() : oldAppliedCategoryMask.size();
            for (i = 1; i <= size; ++i) {
                if (!oldAppliedCategoryMask.get(i) || newAppliedCategoryMask != null && newAppliedCategoryMask.get(i) || user.getPermissions().getPermissions(i).hasOperatorWrite()) continue;
                newMask = BCategoryMask.or(newMask, BCategoryMask.make(new int[]{i}));
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("User " + user + " is modifying the category mask for an object but does not have permission to (unintentionally) remove category " + categoryService.getCategory(i).getDisplayName(null) + "from the mask. That category will be restored on the category mask for object " + (ordOrObj.isComponent() ? ordOrObj.asComponent().toDisplayPathString(null) : ordOrObj));
            }
            return newMask;
        }
        return newCategoryMask;
    }
}

