/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.net.Socket;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BSessionInfo
extends BComponent {
    public static final Type TYPE = Sys.loadType(BSessionInfo.class);
    private static Lexicon lex = Lexicon.make("baja");
    protected BAbsTime connected = BAbsTime.NULL;
    protected String name = null;
    protected String username = null;
    protected String hostname = null;
    protected boolean isFips = false;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BSessionInfo make(String hostname, BAbsTime connected, Socket socket, String username, String hostName, boolean isFips) {
        return new BSessionInfo(hostname, connected, username, hostName, isFips);
    }

    public BSessionInfo() {
    }

    public BSessionInfo(String name, BAbsTime connected, String username, String hostname, boolean isFips) {
        this.name = name;
        this.connected = connected;
        this.username = username;
        this.hostname = hostname;
        this.isFips = isFips;
    }

    public String getHostname() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getConnectedAsMessage(String userName) {
        return lex.getText("session.info.connectedAs", userName);
    }

    public BIcon getLastConnectedIcon() {
        return BIcon.make(lex.getText("session.info.lastConnected.icon"));
    }

    public String getLastConnectedMessage() {
        return lex.getText("session.info.lastConnected", this.connected.toString());
    }

    public BIcon getIdentityVerifiedIcon() {
        return BIcon.make(lex.getText("session.info.identityVerified.icon"));
    }

    public String getIdentityVerifiedMessage() {
        return lex.getText("session.info.identityVerified");
    }

    public BIcon getHostnameIcon() {
        return BIcon.make(lex.getText("session.info.hostname.icon"));
    }

    public String getHostnameMessage() {
        return lex.getText("session.info.hostname", this.hostname);
    }

    public BIcon getSessionEncryptedIcon() {
        return BIcon.make(lex.getText("session.info.sessionEncrypted.icon"));
    }

    public String getSessionEncryptedMessage() {
        return lex.getText("session.info.sessionEncrypted", this.name);
    }

    public boolean isFips() {
        return this.isFips;
    }

    public BIcon getFipsIcon() {
        if (this.isFips) {
            return BIcon.make(lex.getText("session.info.fips.icon"));
        }
        return BIcon.make(lex.getText("session.info.notFips.icon"));
    }

    public String getFipsMessage() {
        if (this.isFips) {
            return lex.getText("session.info.fips");
        }
        return lex.getText("session.info.notFips");
    }
}

