/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.spy;

import com.tridium.sys.Nre;
import java.io.IOException;
import java.security.AccessController;
import java.util.Locale;
import java.util.TimeZone;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

public class SysInfoSpy
extends Spy {
    private static BAbsTime bootTime = Clock.time();
    private static long bootTicks = Clock.ticks();

    @Override
    public void write(SpyWriter out) throws IOException {
        long totalMem = Runtime.getRuntime().totalMemory() / 1024L;
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        String hostname = Sys.getHostName();
        out.startProps("System Overview");
        out.prop((Object)"hostname", hostname);
        out.prop((Object)"hostModel", Nre.getHostModel());
        out.prop((Object)"hostModelVersion", Nre.getHostModelVersion());
        out.prop((Object)"hostProduct", Nre.getHostProduct());
        out.prop((Object)"baja.vendor", Sys.getBajaModule().getVendor(RuntimeProfile.rt));
        out.prop((Object)"baja.vendorVersion", Sys.getBajaVersion());
        out.prop((Object)"commandLine", Nre.commandLine);
        out.prop((Object)"niagara.home", Sys.getNiagaraHome());
        out.prop((Object)"niagara.user.home", Sys.getNiagaraUserHome());
        if (Sys.getStation() != null) {
            BStation station = Sys.getStation();
            out.trTitle("Station", 2);
            out.prop((Object)"station.name", station.getStationName());
            out.prop((Object)"station.home", Sys.getStationHome());
            out.prop((Object)"atSteadyState", Sys.atSteadyState());
            out.prop((Object)"componentCount", "" + station.getComponentSpace().getComponentCount());
            BFacets sysInfo = station.getSysInfo();
            String[] keys = sysInfo.list();
            if (keys.length > 0) {
                out.trTitle("Station - sysInfo", 2);
                for (int i = 0; i < keys.length; ++i) {
                    out.prop((Object)keys[i], sysInfo.get(keys[i]));
                }
            }
        }
        out.trTitle("Time", 2);
        out.prop((Object)"currentTime", Clock.time());
        out.prop((Object)"currentTicks", "" + Clock.ticks());
        out.prop((Object)"bootTime", bootTime);
        out.prop((Object)"bootTicks", "" + bootTicks);
        out.prop((Object)"upTime", BRelTime.toString(Clock.ticks() - bootTicks));
        out.trTitle("Performance", 2);
        out.prop((Object)"totalMemory", totalMem + "kb");
        out.prop((Object)"freeMemory", freeMem + "kb");
        out.prop((Object)"usedMemory", totalMem - freeMem + "kb");
        out.trTitle("Platform", 2);
        out.prop((Object)"java.version", AccessController.doPrivileged(() -> System.getProperty("java.version")));
        out.prop((Object)"java.vendor", AccessController.doPrivileged(() -> System.getProperty("java.vendor")));
        out.prop((Object)"java.vm.name", AccessController.doPrivileged(() -> System.getProperty("java.vm.name")));
        out.prop((Object)"java.vm.version", AccessController.doPrivileged(() -> System.getProperty("java.vm.version")));
        out.prop((Object)"classpath", AccessController.doPrivileged(() -> System.getProperty("java.class.path")));
        out.prop((Object)"java.home", AccessController.doPrivileged(() -> System.getProperty("java.home")));
        out.prop((Object)"os.name", AccessController.doPrivileged(() -> System.getProperty("os.name")));
        out.prop((Object)"os.version", AccessController.doPrivileged(() -> System.getProperty("os.version")));
        out.prop((Object)"os.arch", AccessController.doPrivileged(() -> System.getProperty("os.arch")));
        out.prop((Object)"niagara.home", AccessController.doPrivileged(() -> System.getProperty("niagara.home")));
        out.prop((Object)"nre.hostid", Nre.getHostId());
        out.prop((Object)"nre.vmUuid", Nre.vmUuid);
        out.prop((Object)"language", Sys.getLanguage());
        out.prop((Object)"locale", Locale.getDefault());
        out.prop((Object)"timezone", TimeZone.getDefault().getID());
        out.endProps();
    }
}

