/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.sys.schema.ComplexIntrospector;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import com.tridium.sys.schema.NTopic;
import com.tridium.sys.schema.SyntheticComplexSlotMap;
import com.tridium.sys.schema.SyntheticComplexType;
import com.tridium.sys.schema.SyntheticComponentSlotMap;
import com.tridium.util.jar.ModuleEntry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.io.BIEncodable;
import javax.baja.io.ValueDocDecoder;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class SyntheticComplexIntrospector
extends ComplexIntrospector {
    public SyntheticComplexIntrospector(int id, Class<?> cls) {
        super(id, cls);
    }

    @Override
    protected void mapSlots() throws Exception {
        NModule nmodule = AccessController.doPrivileged(() -> Nre.getModuleManager()).getModuleForClass(this.cls);
        ArrayList<NSlot> slotList = new ArrayList<NSlot>();
        ArrayList<NProperty> propertyList = new ArrayList<NProperty>();
        ArrayList<NAction> actionList = new ArrayList<NAction>();
        ArrayList<NTopic> topicList = new ArrayList<NTopic>();
        ComplexType superType = (ComplexType)this.cls.getSuperclass().getField("TYPE").get(null);
        if (superType instanceof SyntheticComplexType) {
            SyntheticComplexType superSynthType = (SyntheticComplexType)superType;
            slotList.addAll(Arrays.asList(superSynthType.slots));
            propertyList.addAll(Arrays.asList(superSynthType.properties));
            actionList.addAll(Arrays.asList(superSynthType.actions));
            topicList.addAll(Arrays.asList(superSynthType.topics));
        } else {
            Field[] fields = this.resolveFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field == null) continue;
                Class<?> type = field.getType();
                NSlot slot = null;
                try {
                    if (type == propertyClass) {
                        NProperty prop = this.mapProperty((NProperty)this.getSlotField(field));
                        propertyList.add(prop);
                        slot = prop;
                    } else if (type == actionClass) {
                        NAction action = this.mapAction((NAction)this.getSlotField(field));
                        actionList.add(action);
                        slot = action;
                    } else if (type == topicClass) {
                        NTopic topic = this.mapTopic((NTopic)this.getSlotField(field));
                        topicList.add(topic);
                        slot = topic;
                    }
                }
                catch (Exception e) {
                    this.err("" + field);
                    throw e;
                }
                if (slot == null) continue;
                slot.index = slotList.size();
                slotList.add(slot);
            }
        }
        if (nmodule.moduleFile != null) {
            ModuleEntry entry = nmodule.moduleFile.getJarEntry("META-INF/module.xml");
            if (entry == null) {
                entry = nmodule.moduleFile.getJarEntry("meta-inf/module.xml");
            }
            if (entry == null) {
                throw new ModuleException("Module missing META-INF/module.xml: " + nmodule.moduleFile.getFile());
            }
            XElem manifest = XParser.make((InputStream)new BufferedInputStream(entry.getInputStream())).parse();
            if (manifest.elem("types") != null) {
                XElem[] types = manifest.elem("types").elems("type");
                for (int i = 0; i < types.length; ++i) {
                    XElem slotsElem;
                    if (!types[i].get("name").equals(this.typeName) || (slotsElem = types[i].elem("slots")) == null) continue;
                    XElem[] propertiesXElem = slotsElem.elems("property");
                    block6: for (int j = 0; j < propertiesXElem.length; ++j) {
                        try {
                            NSlot propIter;
                            int k;
                            String name = propertiesXElem[j].get("name");
                            int flags = propertiesXElem[j].geti("flags", 0);
                            BTypeSpec type = BTypeSpec.make(propertiesXElem[j].get("type"));
                            BValue defaultValue = type.getResolvedType().is(BIEncodable.TYPE) ? (BValue)((BIEncodable)((Object)type.getInstance())).decodeFromString(propertiesXElem[j].get("value")) : ValueDocDecoder.unmarshal(propertiesXElem[j].get("value"));
                            BFacets facets = (BFacets)BFacets.DEFAULT.decodeFromString(propertiesXElem[j].get("facets", ""));
                            NProperty prop = new NProperty(name, flags, defaultValue, facets, true);
                            boolean isOverridden = false;
                            for (k = 0; k < propertyList.size(); ++k) {
                                propIter = (NProperty)propertyList.get(k);
                                if (!propIter.name.equals(prop.name)) continue;
                                propertyList.set(k, prop);
                                isOverridden = true;
                                break;
                            }
                            if (isOverridden) {
                                for (k = 0; k < slotList.size(); ++k) {
                                    propIter = (NSlot)slotList.get(k);
                                    if (!propIter.name.equals(prop.name)) continue;
                                    prop.index = k;
                                    slotList.set(k, prop);
                                    continue block6;
                                }
                                continue;
                            }
                            prop.index = slotList.size();
                            propertyList.add(prop);
                            slotList.add(prop);
                            continue;
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    break;
                }
            }
        }
        this.slots = slotList.toArray(new NSlot[slotList.size()]);
        this.properties = propertyList.toArray(new NProperty[propertyList.size()]);
        this.actions = actionList.toArray(new NAction[actionList.size()]);
        this.topics = topicList.toArray(new NTopic[topicList.size()]);
        if (this.superSlotsToFix != null) {
            this.fixSuperSlots();
        }
    }

    @Override
    protected Type makeType() {
        return new SyntheticComplexType(this, this.cls);
    }

    @Override
    protected void generateSlotMapClass() throws Exception {
        if (BComponent.class.isAssignableFrom(this.cls)) {
            this.slotMap = new SyntheticComponentSlotMap();
        } else if (BComplex.class.isAssignableFrom(this.cls)) {
            this.slotMap = new SyntheticComplexSlotMap();
        } else {
            throw new IllegalStateException();
        }
    }
}

