/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.module.NModule;
import com.tridium.sys.schema.Introspector;
import java.util.ArrayList;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.AbstractTypeException;
import javax.baja.sys.BInterface;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public abstract class NType
implements Type {
    final int id;
    final NModule module;
    final Class<?> typeClass;
    final String typeName;
    final boolean isAbstract;
    final boolean isFinal;
    private Object typeSpec;
    private Type[] interfaces;
    private Type superType;
    private boolean haveSuperType;
    protected TypeInfo typeInfo;
    private Object fields;

    NType(Introspector introspector) {
        this.id = introspector.id;
        this.module = introspector.module;
        this.typeClass = introspector.cls;
        this.typeName = introspector.typeName;
        this.isAbstract = introspector.isAbstract;
        this.isFinal = introspector.isFinal;
        this.module.register(this.typeName, this);
    }

    NType(NType innerType) {
        this.id = innerType.id;
        this.module = innerType.module;
        this.typeClass = innerType.typeClass;
        this.typeName = innerType.typeName;
        this.isAbstract = innerType.isAbstract;
        this.isFinal = innerType.isFinal;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final BModule getModule() {
        return this.module.bmodule();
    }

    @Override
    public final RuntimeProfile getRuntimeProfile() {
        return this.module.getRuntimeProfile();
    }

    @Override
    public final Class<?> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public final String getTypeName() {
        return this.typeName;
    }

    @Override
    public final String getDisplayName(Context c) {
        return this.getTypeInfo().getDisplayName(c);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public final boolean isAbstract() {
        return this.isAbstract;
    }

    public final boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isDataType() {
        return false;
    }

    @Override
    public char getDataTypeSymbol() {
        return '\u0000';
    }

    @Override
    public final TypeInfo getTypeInfo() {
        if (this.typeInfo == null) {
            this.typeInfo = Sys.getRegistry().getType(this.toString());
        }
        return this.typeInfo;
    }

    @Override
    public final boolean is(Type type) {
        return this.getTypeInfo().is(type.getTypeInfo());
    }

    @Override
    public final boolean is(TypeInfo typeInfo) {
        return this.getTypeInfo().is(typeInfo);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public final Type[] getInterfaces() {
        if (this.interfaces == null) {
            ArrayList<Type> list = new ArrayList<Type>();
            Class<?>[] ifaces = this.typeClass.getInterfaces();
            for (int i = 0; i < ifaces.length; ++i) {
                Class<?> iface = ifaces[i];
                if (!BInterface.class.isAssignableFrom(iface)) continue;
                list.add(Sys.getType(iface));
            }
            this.interfaces = list.toArray(new Type[list.size()]);
        }
        return this.interfaces;
    }

    @Override
    public final Type getSuperType() {
        if (!this.haveSuperType) {
            Class<?> superClass = this.typeClass.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                this.superType = Sys.getType(superClass);
            }
            this.haveSuperType = true;
        }
        return this.superType;
    }

    @Override
    public final BTypeSpec getTypeSpec() {
        if (this.typeSpec == null) {
            this.typeSpec = BTypeSpec.make(this);
        }
        return (BTypeSpec)this.typeSpec;
    }

    @Override
    public final String toString() {
        return this.module.getModuleName() + ":" + this.typeName;
    }

    public Object getFields() {
        return this.fields;
    }

    public void setFields(Object fields) {
        this.fields = fields;
    }

    final void checkConcrete() {
        if (this.isAbstract) {
            throw new AbstractTypeException(this.toString());
        }
    }

    static String getTypeName(String className) {
        String name = className;
        int dot = name.lastIndexOf(46);
        if (dot > 0 && (name = name.substring(dot + 1)).length() > 1 && name.charAt(0) == 'B' && Character.isUpperCase(name.charAt(1))) {
            name = name.substring(1, name.length());
        }
        return name;
    }
}

