/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.engine.SlotKnobs;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public abstract class NSlot
implements Slot {
    public int index;
    Type declaringType;
    String name;
    String displayName;
    int flags;
    boolean isFrozen;
    SlotKnobs knobs;
    BFacets facets;

    NSlot(String name, int flags, BFacets facets, boolean isFrozen) {
        this.name = name;
        this.flags = flags;
        this.facets = facets;
        this.isFrozen = isFrozen;
    }

    @Override
    public final Type getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getDefaultDisplayName(Context cx) {
        try {
            String module = this.declaringType.getModule().getModuleName();
            String n = Lexicon.make(module, cx).get(this.name);
            if (n != null) {
                return n;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.displayName == null) {
            this.displayName = SlotPath.unescape(this.name);
        }
        return this.displayName;
    }

    @Override
    public final boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public final boolean isDynamic() {
        return !this.isFrozen;
    }

    @Override
    public final int getDefaultFlags() {
        return this.flags;
    }

    @Override
    public BFacets getFacets() {
        return this.facets;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof NSlot) {
            NSlot slot = (NSlot)object;
            return this.index == slot.index;
        }
        return false;
    }

    boolean equivalent(NSlot slot) {
        return this.name.equals(slot.name) && this.flags == slot.flags && this.isFrozen == slot.isFrozen && this.facets.equals(slot.facets);
    }

    void copyFrom(NSlot slot) {
        this.index = slot.index;
        this.declaringType = slot.declaringType;
        this.name = slot.name;
        this.displayName = slot.displayName;
        this.isFrozen = slot.isFrozen;
    }
}

