/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.dataRecovery.BDataRecoveryComponentEvent;
import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.sys.Nre;
import com.tridium.sys.engine.ComponentKnobs;
import com.tridium.sys.engine.EngineUtil;
import com.tridium.sys.engine.LocalKnob;
import com.tridium.sys.engine.LocalRelationKnob;
import com.tridium.sys.engine.NKnob;
import com.tridium.sys.engine.NRelationKnob;
import com.tridium.sys.engine.SlotKnobs;
import com.tridium.sys.schema.ActionCursor;
import com.tridium.sys.schema.ComplexSlotMap;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.DynamicTable;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NActionProperty;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import com.tridium.sys.schema.NTopic;
import com.tridium.sys.schema.NTopicProperty;
import com.tridium.sys.schema.PropertyCursor;
import com.tridium.sys.schema.SlotsCursor;
import com.tridium.sys.schema.TopicCursor;
import com.tridium.sys.schema.UnhandledSlotException;
import com.tridium.sys.station.Station;
import com.tridium.sys.transfer.TransferListener;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.util.CategoryValidator;
import com.tridium.util.EscUtil;
import com.tridium.util.ObjectUtil;
import com.tridium.util.PasswordUtil;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BasicQuery;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIDeferOwnership;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.space.BComponentSpace;
import javax.baja.space.TrapCallbacks;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.AlreadyParentedException;
import javax.baja.sys.BAction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.sys.BString;
import javax.baja.sys.BTopic;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Flags;
import javax.baja.sys.FrozenSlotException;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Knob;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Topic;
import javax.baja.tag.Id;
import javax.baja.tag.TagDictionaryService;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUnrestrictedFolder;

public abstract class ComponentSlotMap
extends ComplexSlotMap
implements ObjectUtil.NameContainer {
    static final int CHANGED = 0;
    static final int ADDED = 1;
    static final int REMOVED = 2;
    static final int RENAMED = 3;
    static final int REORDERED = 4;
    static final int PARENTED = 5;
    static final int UNPARENTED = 6;
    static final int ACTION_INVOKED = 7;
    static final int TOPIC_FIRED = 8;
    static final int FLAGS_CHANGED = 9;
    static final int FACETS_CHANGED = 10;
    static final int RECATEGORIZED = 11;
    static final int KNOB_ADDED = 12;
    static final int KNOB_REMOVED = 13;
    static final int STARTED = 14;
    static final int STOPPED = 15;
    static final int RELATION_KNOB_ADDED = 16;
    static final int RELATION_KNOB_REMOVED = 17;
    static final int[] COMPONENT_EVENT = new int[]{0, 1, 2, 3, 4, -1, -1, -1, 5, 6, 7, 10, 8, 9, 19, 20, 17, 18};
    static final int[] COMPONENT_CHILD_EVENT = new int[]{-1, 11, 12, 13, 14, -1, -1, -1, -1, 15, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    static final int INITIALIZED = 1;
    static final int MOUNTED = 2;
    static final int RUNNING = 4;
    static final int BROKER_PROPS_LOADED = 8;
    static final int PENDING_MOVE = 16;
    static final int PERMANENT_SUBSCRIBE = 32;
    static final int IS_WIDGET = 64;
    static final Logger serviceLog = Logger.getLogger("sys.service");
    static TypeInfo PROG_OBJ_TYPE_INFO;
    static TypeInfo PROG_CODE_TYPE_INFO;
    public static final String SWIZZLE_PREFIX = "copy-";
    private static final Subscriber[] noSubscribers;
    private static final NKnob[] noKnobs;
    private static final NRelationKnob[] noRelationKnobs;
    private int[] frozenFlags;
    private DynamicTable table;
    private SlotKnobs[] frozenKnobs;
    private Subscriber[] subscribers = noSubscribers;
    private short knobCount;
    private short relationKnobCount;
    private byte mask;
    private String handle;
    private BComponentSpace space;
    private BPermissions cachedPermissions;
    private BCategoryMask cat = BCategoryMask.NULL;
    private BCategoryMask catDeepOr = BCategoryMask.NULL;
    private ComponentKnobs componentKnobs;

    @Override
    public final void init(ComplexType type, BComplex instance) {
        super.init(type, instance);
        this.setInitialized(true);
        int[] defaultFlags = type.defaultFlags;
        int[] frozenFlags = new int[defaultFlags.length];
        System.arraycopy(defaultFlags, 0, frozenFlags, 0, frozenFlags.length);
        this.frozenFlags = frozenFlags;
        if (instance.fw(301) != null) {
            this.setIsWidget(true);
        }
    }

    @Override
    public final String getName() {
        if (this.propertyInParent != null) {
            return this.propertyInParent.getName();
        }
        return (String)this.instance.fw(24);
    }

    @Override
    public final String getDisplayName(Context c) {
        if (this.propertyInParent != null) {
            return super.getDisplayName(c);
        }
        if (this.space != null && this.space.getRootComponent() == this.instance) {
            return this.space.getNavDisplayName(c);
        }
        return (String)this.instance.fw(25, c, null, null, null);
    }

    @Override
    public final Object getHandle() {
        return this.handle;
    }

    public final void setHandle(Object handle) {
        this.handle = (String)handle;
    }

    @Override
    public final SlotPath getSlotPath() {
        if (this.space == null) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>();
        BComponent root = this.space.getRootComponent();
        for (BComponent p = this.instance.asComponent(); p != null && p != root; p = (BComponent)p.getParent()) {
            v.add(p.getName());
        }
        String[] names = new String[v.size()];
        int count = v.size();
        for (int i = 0; i < count; ++i) {
            names[count - i - 1] = (String)v.get(i);
        }
        return new SlotPath("slot", names);
    }

    @Override
    public final boolean equivalent(ComplexSlotMap map) {
        if (!super.equivalent(map)) {
            return false;
        }
        ComponentSlotMap x = (ComponentSlotMap)map;
        if (this.table == null || this.table.count == 0) {
            return x.table == null || x.table.count == 0;
        }
        return this.table.equivalent(x.table);
    }

    @Override
    public final BComplex newCopy(CopyHints hints, int serialNum) {
        if (hints instanceof TransferListener) {
            TransferListener listener = (TransferListener)((Object)hints);
            listener.updateStatus("Copying \"" + TransferStrategy.toString(this.instance) + "\"...");
        }
        if (this.space != null) {
            BValue[] temp = new BValue[]{this.instance};
            temp = this.space.getLoadCallbacks().newCopy(temp, hints);
            if (temp != null && temp[0] != null) {
                return (BComplex)temp[0];
            }
        }
        BComponent copy = (BComponent)super.newCopy(hints, serialNum);
        Context cx = Context.copying;
        boolean hasUser = hints.cx != null && (hints.cx.getUser() != null || hints.cx.getFacets() != null && hints.cx.getFacets().gets("username", null) != null);
        ComponentSlotMap map = ComponentSlotMap.getComponentSlotMap(copy);
        if (this.handle != null) {
            if (hints.swizzleHandles) {
                map.handle = ComponentSlotMap.swizzle(this.handle, serialNum);
            } else if (hints.keepHandles) {
                map.handle = this.handle;
            }
        }
        map.frozenFlags = new int[this.frozenFlags.length];
        System.arraycopy(this.frozenFlags, 0, map.frozenFlags, 0, this.frozenFlags.length);
        map.cat = this.cat;
        if (this.table != null) {
            for (int i = 0; i < this.table.count; ++i) {
                NProperty slot = this.table.slots[i];
                String name = slot.name;
                BValue value = slot.value;
                if (value instanceof BLink && ((BLink)value).isDirect() || copy.getSlot(name) != null || hints.defaultOnClone && (slot.flags & 0x2000) == 8192 || hasUser && slot.getType().equals(BPassword.TYPE)) continue;
                if (value.isComponent() && hints.cx != null) {
                    if (!((BComponent)value).getPermissions(hints.cx).hasOperatorRead()) continue;
                    value = ComponentSlotMap.newCopy(value, hints, serialNum);
                    copy.add(name, value, slot.flags, slot.facets, cx);
                    continue;
                }
                value = ComponentSlotMap.newCopy(value, hints, serialNum);
                copy.add(name, value, slot.flags, slot.facets, cx);
            }
        }
        return copy;
    }

    @Override
    BValue getOverride(Property prop) {
        if (this.isWidget()) {
            return (BValue)this.instance.fw(19, prop, null, null, null);
        }
        return null;
    }

    @Override
    public final int getSlotCount() {
        if (this.table == null) {
            return this.getType().slots.length;
        }
        return this.getType().slots.length + this.table.count;
    }

    @Override
    public final Slot getSlot(String name) {
        Slot slot = this.getType().byName.get(name);
        if (slot != null) {
            return slot;
        }
        if (this.table != null) {
            return this.table.get(name);
        }
        return null;
    }

    public final Property getDynamicPropertyByIndex(int index) {
        return this.table != null && index >= 0 && index < this.table.count ? this.table.slots[index] : null;
    }

    @Override
    public final Slot[] getSlotsArray() {
        if (this.table == null) {
            return super.getSlotsArray();
        }
        NSlot[] frozen = this.getType().slots;
        Object[] copy = new Slot[frozen.length + this.table.count];
        System.arraycopy(frozen, 0, copy, 0, frozen.length);
        this.table.copyInto(copy, frozen.length);
        return copy;
    }

    @Override
    public final int getPropertyCount() {
        if (this.table == null) {
            return super.getPropertyCount();
        }
        return super.getPropertyCount() + this.table.size();
    }

    @Override
    public final Property[] getPropertiesArray() {
        if (this.table == null) {
            return super.getPropertiesArray();
        }
        NProperty[] frozen = this.getType().properties;
        Object[] copy = new Property[frozen.length + this.table.count];
        System.arraycopy(frozen, 0, copy, 0, frozen.length);
        this.table.copyInto(copy, frozen.length);
        return copy;
    }

    @Override
    public Property[] getFrozenPropertiesArray() {
        return super.getPropertiesArray();
    }

    @Override
    public Property[] getDynamicPropertiesArray() {
        if (this.table == null) {
            return super.getDynamicPropertiesArray();
        }
        Object[] copy = new Property[this.table.count];
        this.table.copyInto(copy, 0);
        return copy;
    }

    @Override
    public final Action[] getActionsArray() {
        if (this.table == null) {
            return super.getActionsArray();
        }
        NAction[] frozen = this.getType().actions;
        Action[] copy = new Action[frozen.length + this.table.count];
        int count = frozen.length;
        System.arraycopy(frozen, 0, copy, 0, count);
        for (int i = 0; i < this.table.count; ++i) {
            if (!this.table.slots[i].isAction()) continue;
            copy[count++] = this.table.slots[i].asAction();
        }
        Action[] result = new Action[count];
        System.arraycopy(copy, 0, result, 0, count);
        return result;
    }

    @Override
    public final Topic[] getTopicsArray() {
        if (this.table == null) {
            return super.getTopicsArray();
        }
        NTopic[] frozen = this.getType().topics;
        Topic[] copy = new Topic[frozen.length + this.table.count];
        int count = frozen.length;
        System.arraycopy(frozen, 0, copy, 0, count);
        for (int i = 0; i < this.table.count; ++i) {
            if (!this.table.slots[i].isTopic()) continue;
            copy[count++] = this.table.slots[i].asTopic();
        }
        Topic[] result = new Topic[count];
        System.arraycopy(copy, 0, result, 0, count);
        return result;
    }

    @Override
    public final SlotCursor<Slot> getSlots() {
        return new SlotsCursor(this.instance, this.getType().slots, this.table);
    }

    @Override
    public final SlotCursor<Property> getProperties() {
        return new PropertyCursor(this.instance, this.getType().properties, this.table);
    }

    @Override
    public final SlotCursor<Action> getActions() {
        return new ActionCursor(this.instance, this.getType().actions, this.table);
    }

    @Override
    public final SlotCursor<Topic> getTopics() {
        return new TopicCursor(this.instance, this.getType().topics, this.table);
    }

    @Override
    public int getFlags(Slot s) {
        NSlot slot = (NSlot)s;
        try {
            if (slot.isFrozen) {
                return this.frozenFlags[slot.index];
            }
            return slot.flags;
        }
        catch (RuntimeException e) {
            System.out.println("ComponentSlotMap.getFlags: " + slot);
            System.out.println("  instance.type  " + this.getType());
            System.out.println("  slot.type:     " + slot.getDeclaringType());
            System.out.println("  slot.index:    " + slot.index);
            System.out.println("  slot.isFrozen: " + slot.isFrozen);
            System.out.println("  type.slots.length:        " + this.getType().slots.length);
            System.out.println("  type.defaultFlags.length: " + this.getType().defaultFlags.length);
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFlags(Slot s, int flags, Context context) {
        NSlot slot = (NSlot)s;
        if (this.getFlags(slot) == flags) {
            return;
        }
        BComponent instance = (BComponent)this.instance;
        instance.checkSetFlags(s, flags, context);
        if (context instanceof Transaction) {
            ((Transaction)context).setFlags(instance, slot, flags, null);
            return;
        }
        TrapCallbacks trap = this.getSpaceTrap();
        if (trap != null && trap.isTrapEnabled() && context != Context.commit) {
            trap.setFlags(instance, slot, flags, context);
            return;
        }
        BUser user = null;
        String oldValue = null;
        if (context != null && context.getUser() != null) {
            BValue value;
            user = context.getUser();
            user.check(instance, BPermissions.adminWrite);
            if (slot instanceof NProperty && (value = this.get((NProperty)slot)) instanceof BIProtected) {
                user.check((BIProtected)((Object)value), BPermissions.adminWrite);
            }
            oldValue = Flags.encodeToString(this.getFlags(s));
        }
        int oldMetaFlag = this.getFlags(s) & 0x4000;
        int newMetaFlag = flags & 0x4000;
        BDataRecoveryComponentRecorder recorder = this.findRecoveryData(6, slot, flags, context);
        if (recorder != null) {
            recorder.record(BDataRecoveryComponentEvent.makeFlagsChangeEvent(instance, slot.getName(), flags), context);
        }
        BComponent bComponent = instance;
        synchronized (bComponent) {
            if (slot.isFrozen) {
                if (this.frozenFlags[slot.index] == flags) {
                    return;
                }
                this.frozenFlags[slot.index] = flags;
            } else {
                if (slot.flags == flags) {
                    return;
                }
                slot.flags = flags;
            }
        }
        this.fireComponentEvent(9, slot, null, null, context);
        if (user != null) {
            String value = Flags.encodeToString(flags);
            this.audit(ComponentSlotMap.getAuditSlotPath(instance, context), user, "Flags Changed", slot.name, oldValue, value);
        }
    }

    @Override
    public final BComponentSpace getSpace() {
        return this.space;
    }

    @Override
    public final TrapCallbacks getSpaceTrap() {
        if (this.space == null) {
            return null;
        }
        return this.space.getTrapCallbacks();
    }

    @Override
    public void loadSlots() {
        if (this.space == null) {
            return;
        }
        if (this.isBrokerPropsLoaded()) {
            return;
        }
        this.space.getLoadCallbacks().loadSlots((BComponent)this.instance);
        this.setBrokerPropsLoaded(true);
    }

    @Override
    public final boolean isSubscribed() {
        if (this.isPermanentlySubscribed() || this.knobCount > 0 && this.isRunning()) {
            return true;
        }
        boolean foundValidSubscriber = false;
        for (int i = 0; i < this.subscribers.length; ++i) {
            Subscriber s = null;
            try {
                s = this.subscribers[i];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (s instanceof PendingSubscriber) continue;
            foundValidSubscriber = true;
            break;
        }
        return foundValidSubscriber;
    }

    @Override
    public final boolean isPermanentlySubscribed() {
        return (this.mask & 0x20) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setPermanentlySubscribed(boolean subscribed) {
        if (subscribed == this.isPermanentlySubscribed()) {
            return;
        }
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            boolean oldState = this.isSubscribed();
            this.mask = subscribed ? (byte)(this.mask | 0x20) : (byte)(this.mask & 0xFFFFFFDF);
            boolean newState = this.isSubscribed();
            if (oldState != newState) {
                if (newState) {
                    this.subscribe(true);
                } else {
                    this.unsubscribe(true);
                }
            }
        }
    }

    @Override
    public Subscriber[] getSubscribers() {
        int len = this.subscribers.length;
        ArrayList<Subscriber> copy = new ArrayList<Subscriber>();
        for (int i = 0; i < len; ++i) {
            if (this.subscribers[i] instanceof PendingSubscriber) continue;
            copy.add(this.subscribers[i]);
        }
        return copy.toArray(new Subscriber[copy.size()]);
    }

    public boolean isSubscribed(int componentEventId) {
        if (componentEventId == -1) {
            return false;
        }
        for (int i = 0; i < this.subscribers.length; ++i) {
            Subscriber s = this.subscribers[i];
            if (s instanceof PendingSubscriber) {
                s = ((PendingSubscriber)s).subscriber;
            }
            if (!s.getMask().includes(componentEventId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void subscribe(Subscriber s) {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            boolean newState;
            boolean oldState = this.isSubscribed();
            int len = this.subscribers.length;
            boolean noMatch = true;
            for (int i = 0; i < len; ++i) {
                Subscriber subscriber = this.subscribers[i];
                if (!(subscriber instanceof PendingSubscriber) || ((PendingSubscriber)subscriber).subscriber != s) continue;
                this.subscribers[i] = s;
                noMatch = false;
                break;
            }
            if (noMatch) {
                Subscriber[] temp = new Subscriber[this.subscribers.length + 1];
                System.arraycopy(this.subscribers, 0, temp, 0, this.subscribers.length);
                temp[this.subscribers.length] = s;
                this.subscribers = temp;
            }
            if (oldState != (newState = this.isSubscribed())) {
                this.subscribe(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsubscribe(Subscriber s) {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            boolean newState;
            boolean oldState = this.isSubscribed();
            for (int i = 0; i < this.subscribers.length; ++i) {
                if (this.subscribers[i] != s && (!(this.subscribers[i] instanceof PendingSubscriber) || ((PendingSubscriber)this.subscribers[i]).subscriber != s)) continue;
                Subscriber[] temp = new Subscriber[this.subscribers.length - 1];
                System.arraycopy(this.subscribers, 0, temp, 0, i);
                if (i < this.subscribers.length) {
                    System.arraycopy(this.subscribers, i + 1, temp, i, this.subscribers.length - i - 1);
                }
                this.subscribers = temp;
                break;
            }
            if (oldState != (newState = this.isSubscribed())) {
                this.unsubscribe(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsubscribeAll() {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            boolean oldState = this.isSubscribed();
            this.subscribers = noSubscribers;
            boolean newState = this.isSubscribed();
            if (oldState != newState) {
                this.unsubscribe(true);
            }
        }
    }

    public final void subscribe(boolean callSpace) {
        try {
            if (callSpace && this.space != null) {
                this.space.getSubscribeCallbacks().subscribe(new BComponent[]{(BComponent)this.instance}, 0);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.instance.fw(17, null, null, null, null);
            if (this.space == null || this.space.fireDirectCallbacks()) {
                ((BComponent)this.instance).subscribed();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public final void unsubscribe(boolean callSpace) {
        try {
            if (callSpace && this.space != null) {
                this.space.getSubscribeCallbacks().unsubscribe(new BComponent[]{(BComponent)this.instance});
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.instance.fw(18, null, null, null, null);
            if (this.space == null || this.space.fireDirectCallbacks()) {
                ((BComponent)this.instance).unsubscribed();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public final BPermissions getCachedPermissions() {
        return this.cachedPermissions;
    }

    public final void setCachedPermissions(BPermissions p) {
        this.cachedPermissions = p;
    }

    @Override
    final void modified(NProperty prop, Context cx, BDataRecoveryComponentRecorder recorder) {
        SlotKnobs knobs = this.getSlotKnobs(prop);
        if (knobs != null) {
            knobs.propagate(null);
        }
        this.fireComponentEvent(0, prop, null, null, cx);
    }

    @Override
    void batchModified(Property[] properties, Context context) {
        BComponent comp = this.instance.asComponent();
        try {
            comp.fw(30, properties, context, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.space == null || this.space.fireDirectCallbacks()) {
            try {
                comp.batchChanged(properties, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireComponentEvent(int id, Slot slot, Object obj, String str, Context context) {
        BComponentEvent event;
        boolean typeSubscribed;
        boolean componentSubscribed;
        BComponent comp;
        block90: {
            block89: {
                if (!this.isInitialized()) {
                    return;
                }
                comp = this.instance.asComponent();
                try {
                    switch (id) {
                        case 0: {
                            comp.fw(2, slot, context, null, null);
                            break;
                        }
                        case 1: {
                            comp.fw(3, slot, context, null, null);
                            break;
                        }
                        case 2: {
                            comp.fw(4, slot, obj, context, null);
                            break;
                        }
                        case 3: {
                            comp.fw(5, slot, str, context, null);
                            break;
                        }
                        case 4: {
                            comp.fw(6, context, null, null, null);
                            break;
                        }
                        case 5: {
                            comp.fw(7, slot, obj, context, null);
                            break;
                        }
                        case 6: {
                            comp.fw(8, slot, obj, context, null);
                            break;
                        }
                        case 7: {
                            comp.fw(9, slot, obj, context, null);
                            break;
                        }
                        case 8: {
                            comp.fw(10, slot, obj, context, null);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.space == null || this.space.fireDirectCallbacks()) {
                    try {
                        switch (id) {
                            case 0: {
                                comp.changed((Property)slot, context);
                                break;
                            }
                            case 1: {
                                comp.added((Property)slot, context);
                                break;
                            }
                            case 2: {
                                comp.removed((Property)slot, (BValue)obj, context);
                                break;
                            }
                            case 3: {
                                comp.renamed((Property)slot, str, context);
                                break;
                            }
                            case 4: {
                                comp.reordered(context);
                                break;
                            }
                            case 5: {
                                comp.childParented((Property)slot, (BValue)obj, context);
                                break;
                            }
                            case 6: {
                                comp.childUnparented((Property)slot, (BValue)obj, context);
                                break;
                            }
                            case 7: {
                                break;
                            }
                            case 8: {
                                break;
                            }
                            case 9: {
                                comp.flagsChanged(slot, context);
                                break;
                            }
                            case 10: {
                                comp.facetsChanged(slot, context);
                                break;
                            }
                            case 11: {
                                comp.recategorized(context);
                                break;
                            }
                            case 12: {
                                comp.knobAdded((Knob)obj, context);
                                break;
                            }
                            case 13: {
                                comp.knobRemoved((Knob)obj, context);
                                break;
                            }
                            case 14: {
                                break;
                            }
                            case 15: {
                                break;
                            }
                            case 16: {
                                comp.relationKnobAdded((RelationKnob)obj, context);
                                break;
                            }
                            case 17: {
                                comp.relationKnobRemoved((RelationKnob)obj, context);
                                break;
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.space != null) {
                    try {
                        switch (id) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 9: 
                            case 10: 
                            case 11: {
                                this.space.modified(comp, context);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                BValue targetValue = null;
                switch (id) {
                    case 1: {
                        if (!slot.isProperty()) break;
                        targetValue = this.get((NProperty)slot);
                        break;
                    }
                    case 2: {
                        targetValue = (BValue)obj;
                        break;
                    }
                    case 3: {
                        if (!slot.isProperty()) break;
                        targetValue = this.get((NProperty)slot);
                        break;
                    }
                    case 9: {
                        if (!slot.isProperty()) break;
                        targetValue = this.get((NProperty)slot);
                        break;
                    }
                    case 10: {
                        if (!slot.isProperty()) break;
                        targetValue = this.get((NProperty)slot);
                        break;
                    }
                    case 4: {
                        targetValue = null;
                        break;
                    }
                    case 12: {
                        if (!slot.isProperty()) break;
                        targetValue = this.get((NProperty)slot);
                        break;
                    }
                    case 13: {
                        if (!slot.isProperty()) break;
                        targetValue = this.get((NProperty)slot);
                    }
                }
                if (targetValue == null || !targetValue.isComponent()) break block89;
                componentSubscribed = ((ComponentSlotMap)targetValue.asComponent().fw(1)).isSubscribed(COMPONENT_CHILD_EVENT[id]);
                boolean bl = typeSubscribed = this.getSpace() != null && this.getSpace().isSubscribed(targetValue.getType(), COMPONENT_CHILD_EVENT[id]);
                if (!typeSubscribed && !componentSubscribed) break block90;
                event = null;
                switch (id) {
                    case 1: {
                        event = new BComponentEvent(11, targetValue.asComponent(), null, comp);
                        break;
                    }
                    case 2: {
                        event = new BComponentEvent(12, targetValue.asComponent(), null, comp);
                        break;
                    }
                    case 3: {
                        event = new BComponentEvent(13, targetValue.asComponent(), null, BString.make(str));
                        break;
                    }
                    case 9: {
                        event = new BComponentEvent(15, targetValue.asComponent(), null, null);
                        break;
                    }
                    case 10: {
                        event = new BComponentEvent(16, targetValue.asComponent(), null, (BFacets)obj);
                    }
                }
                Subscriber[] subscribers = ((ComponentSlotMap)targetValue.asComponent().fw((int)1)).subscribers;
                for (int i = 0; i < subscribers.length; ++i) {
                    try {
                        Subscriber s = subscribers[i];
                        if (s instanceof PendingSubscriber) {
                            s = ((PendingSubscriber)s).subscriber;
                        }
                        s.event(event);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!typeSubscribed) break block90;
                this.getSpace().event(event);
                break block90;
            }
            if (id == 4 && this.getSpace() != null) {
                BComponent[] children = comp.getChildComponents();
                for (int i = 0; i < children.length; ++i) {
                    if (!this.getSpace().isSubscribed(children[i].getType(), 14)) continue;
                    this.getSpace().event(new BComponentEvent(14, children[i], null, comp));
                }
            }
        }
        componentSubscribed = this.isSubscribed(COMPONENT_EVENT[id]);
        boolean bl = typeSubscribed = this.getSpace() != null && this.getSpace().isSubscribed(this.getType(), COMPONENT_EVENT[id]);
        if (typeSubscribed || componentSubscribed) {
            event = null;
            switch (id) {
                case 0: {
                    BValue cv = this.get((NProperty)slot);
                    event = new BComponentEvent(0, comp, slot, cv);
                    break;
                }
                case 1: {
                    BValue av = this.get((NProperty)slot);
                    event = new BComponentEvent(1, comp, slot, av);
                    break;
                }
                case 2: {
                    BValue rv = (BValue)obj;
                    event = new BComponentEvent(2, comp, slot, rv);
                    break;
                }
                case 3: {
                    event = new BComponentEvent(3, comp, slot, BString.make(str));
                    break;
                }
                case 4: {
                    event = new BComponentEvent(4, comp, null, null);
                    break;
                }
                case 8: {
                    event = new BComponentEvent(5, comp, slot, (BValue)obj);
                    break;
                }
                case 9: {
                    event = new BComponentEvent(6, comp, slot, null);
                    break;
                }
                case 10: {
                    event = new BComponentEvent(7, comp, slot, (BFacets)obj);
                    break;
                }
                case 11: {
                    event = new BComponentEvent(10, comp, null, (BCategoryMask)obj);
                    break;
                }
                case 12: {
                    event = new BComponentEvent(8, comp, (Knob)obj);
                    break;
                }
                case 13: {
                    event = new BComponentEvent(9, comp, (Knob)obj);
                    break;
                }
                case 16: {
                    event = new BComponentEvent(17, comp, (RelationKnob)obj);
                    break;
                }
                case 17: {
                    event = new BComponentEvent(18, comp, (RelationKnob)obj);
                    break;
                }
                case 14: {
                    event = new BComponentEvent(19, comp, null, null);
                    break;
                }
                case 15: {
                    event = new BComponentEvent(20, comp, null, null);
                    break;
                }
                default: {
                    return;
                }
            }
            for (int i = 0; i < this.subscribers.length; ++i) {
                try {
                    Subscriber s = this.subscribers[i];
                    if (s instanceof PendingSubscriber) {
                        s = ((PendingSubscriber)s).subscriber;
                    }
                    s.event(event);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (typeSubscribed) {
                this.getSpace().event(event);
            }
        }
    }

    @Override
    BDataRecoveryComponentRecorder findRecoveryData(int eventId, Slot slot, Context context) {
        boolean notifyDataRecovery;
        if (!this.isInitialized()) {
            return null;
        }
        BComponent comp = this.instance.asComponent();
        BDataRecoveryComponentRecorder recoveryDataRecorder = Nre.getServiceManager().getDataRecoveryComponentRecorder(this.space);
        boolean bl = notifyDataRecovery = recoveryDataRecorder != null;
        if (notifyDataRecovery) {
            int flags = slot != null ? this.getFlags(slot) : -1;
            notifyDataRecovery = recoveryDataRecorder.isEventCritical(eventId, comp, slot, flags, context);
        }
        if (!notifyDataRecovery) {
            return null;
        }
        return recoveryDataRecorder;
    }

    @Override
    BDataRecoveryComponentRecorder findRecoveryData(int eventId, Slot slot, int flags, Context context) {
        boolean notifyDataRecovery;
        if (!this.isInitialized()) {
            return null;
        }
        BComponent comp = this.instance.asComponent();
        BDataRecoveryComponentRecorder dataRecoveryRecorder = Nre.getServiceManager().getDataRecoveryComponentRecorder(this.space);
        boolean bl = notifyDataRecovery = dataRecoveryRecorder != null;
        if (notifyDataRecovery) {
            notifyDataRecovery = dataRecoveryRecorder.isEventCritical(eventId, comp, slot, flags, context);
        }
        if (!notifyDataRecovery) {
            return null;
        }
        return dataRecoveryRecorder;
    }

    public final SlotKnobs getSlotKnobs(NSlot slot) {
        if (slot.isFrozen) {
            if (this.frozenKnobs == null) {
                return null;
            }
            return this.frozenKnobs[slot.index];
        }
        return slot.knobs;
    }

    public final Knob installKnob(BLink link) {
        return this.installKnob(new LocalKnob(link), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NKnob installKnob(NKnob knob, boolean checkForDuplicate) {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            NKnob dup;
            NSlot slot = (NSlot)knob.getSourceSlot();
            if (slot == null) {
                return knob;
            }
            SlotKnobs knobs = this.getSlotKnobs(slot);
            if (checkForDuplicate && knobs != null && (dup = knobs.get(knob.id)) != null) {
                dup.copyFrom(knob);
                return dup;
            }
            boolean oldState = this.isSubscribed();
            this.knobCount = (short)(this.knobCount + 1);
            boolean newState = this.isSubscribed();
            if (knob.isLocal() && oldState != newState) {
                this.subscribe(true);
            }
            if (knobs != null) {
                knobs.add(knob);
            } else {
                knobs = new SlotKnobs((BComponent)this.instance, slot, knob);
                if (slot.isFrozen) {
                    if (this.frozenKnobs == null) {
                        this.frozenKnobs = new SlotKnobs[this.getType().slots.length];
                    }
                    this.frozenKnobs[slot.index] = knobs;
                } else {
                    slot.knobs = knobs;
                }
            }
            this.fireComponentEvent(12, slot, knob, null, null);
            return knob;
        }
    }

    public final void uninstallKnob(BLink link) {
        this.uninstallKnob((NKnob)link.getKnob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void uninstallKnob(NKnob knob) {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            SlotKnobs knobs;
            NSlot slot;
            boolean oldState = this.isSubscribed();
            this.knobCount = (short)(this.knobCount - 1);
            boolean newState = this.isSubscribed();
            if (knob.isLocal() && oldState != newState) {
                this.unsubscribe(true);
            }
            if ((slot = (NSlot)knob.getSourceSlot()) != null && (knobs = this.getSlotKnobs(slot)) != null) {
                knobs.remove(knob);
            }
            this.fireComponentEvent(13, slot, knob, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mergeKnobs(List<NKnob> knobs) {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            int i;
            NKnob[] existing = this.getKnobs();
            NKnob[] actual = knobs.toArray(new NKnob[knobs.size()]);
            int existingLength = existing.length;
            int actualLength = actual.length;
            for (i = 0; i < existingLength; ++i) {
                boolean found = false;
                for (int j = 0; j < actualLength; ++j) {
                    if (actual[j] == null || existing[i].id != actual[j].id) continue;
                    existing[i].copyFrom(actual[j]);
                    found = true;
                    actual[j] = null;
                    break;
                }
                if (found) continue;
                this.uninstallKnob(existing[i]);
            }
            for (i = 0; i < actualLength; ++i) {
                if (actual[i] == null) continue;
                this.installKnob(actual[i], false);
            }
        }
    }

    @Override
    public int getKnobCount() {
        return this.knobCount;
    }

    @Override
    public NKnob[] getKnobs() {
        int i;
        if (this.knobCount == 0) {
            return noKnobs;
        }
        ArrayList<NKnob> list = new ArrayList<NKnob>();
        if (this.frozenKnobs != null) {
            for (i = 0; i < this.frozenKnobs.length; ++i) {
                if (this.frozenKnobs[i] == null) continue;
                this.frozenKnobs[i].appendTo(list);
            }
        }
        if (this.table != null) {
            for (i = 0; i < this.table.count; ++i) {
                NProperty slot = this.table.slots[i];
                if (slot.knobs == null) continue;
                slot.knobs.appendTo(list);
            }
        }
        return list.toArray(new NKnob[list.size()]);
    }

    @Override
    public NKnob[] getKnobs(Slot slot) {
        SlotKnobs knobs = this.getSlotKnobs((NSlot)slot);
        if (knobs == null) {
            return new NKnob[0];
        }
        return knobs.list();
    }

    public final RelationKnob installRelationKnob(BRelation relation) {
        return this.installRelationKnob(new LocalRelationKnob(relation), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NRelationKnob installRelationKnob(NRelationKnob relationKnob, boolean checkForDuplicate) {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            NRelationKnob dup;
            if (checkForDuplicate && this.componentKnobs != null && (dup = this.componentKnobs.get(relationKnob.id)) != null) {
                dup.copyFrom(relationKnob);
                return dup;
            }
            boolean oldState = this.isSubscribed();
            this.relationKnobCount = (short)(this.relationKnobCount + 1);
            boolean newState = this.isSubscribed();
            if (relationKnob.isLocal() && oldState != newState) {
                this.subscribe(true);
            }
            if (this.componentKnobs != null) {
                this.componentKnobs.add(relationKnob);
            } else {
                this.componentKnobs = new ComponentKnobs((BComponent)this.instance, relationKnob);
            }
            this.fireComponentEvent(16, null, relationKnob, null, null);
            return relationKnob;
        }
    }

    public final void uninstallRelationKnob(BRelation relation) {
        this.uninstallRelationKnob((NRelationKnob)relation.getRelationKnob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void uninstallRelationKnob(NRelationKnob knob) {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            boolean oldState = this.isSubscribed();
            this.relationKnobCount = (short)(this.relationKnobCount - 1);
            boolean newState = this.isSubscribed();
            if (knob.isLocal() && oldState != newState) {
                this.unsubscribe(true);
            }
            this.componentKnobs.remove(knob);
            this.fireComponentEvent(17, null, knob, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mergeRelationKnobs(List<NRelationKnob> knobs) {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            int i;
            NRelationKnob[] existing = this.getRelationKnobs();
            NRelationKnob[] actual = knobs.toArray(new NRelationKnob[knobs.size()]);
            int existingLength = existing.length;
            int actualLength = actual.length;
            for (i = 0; i < existingLength; ++i) {
                boolean found = false;
                for (int j = 0; j < actualLength; ++j) {
                    if (actual[j] == null || existing[i].id != actual[j].id) continue;
                    existing[i].copyFrom(actual[j]);
                    found = true;
                    actual[j] = null;
                    break;
                }
                if (found) continue;
                this.uninstallRelationKnob(existing[i]);
            }
            for (i = 0; i < actualLength; ++i) {
                if (actual[i] == null) continue;
                this.installRelationKnob(actual[i], false);
            }
        }
    }

    @Override
    public int getRelationKnobCount() {
        return this.relationKnobCount;
    }

    @Override
    public NRelationKnob[] getRelationKnobs() {
        if (this.componentKnobs == null) {
            return noRelationKnobs;
        }
        return this.componentKnobs.list();
    }

    @Override
    public NRelationKnob getRelationKnob(String id) {
        if (this.componentKnobs == null) {
            return null;
        }
        return this.componentKnobs.get(id);
    }

    @Override
    public final BValue invoke(Action action, BValue arg, Context context) {
        return this.invoke(action, arg, context, false);
    }

    public final BValue invoke(Action action, BValue arg, Context context, boolean forceAsync) {
        BComponent instance = (BComponent)this.instance;
        instance.fw(34, action, arg, context, null);
        TrapCallbacks trap = this.getSpaceTrap();
        if (trap != null && trap.isTrapEnabled() && context != Context.commit) {
            return trap.invoke(instance, action, arg, context);
        }
        BUser user = null;
        if (context != null && context.getUser() != null) {
            user = context.getUser();
            user.checkInvoke(instance, action);
        }
        if (!Flags.isAsync(instance, action) || forceAsync) {
            BValue result = null;
            try {
                NSlot a;
                if (action.isFrozen()) {
                    a = (NAction)action;
                    result = this.invoke(a.index, instance, arg, context);
                } else {
                    a = (NActionProperty)action;
                    BAction handler = (BAction)((NActionProperty)a).value;
                    result = handler.invoke(instance, arg);
                }
            }
            catch (UnhandledSlotException e) {
                e.printStackTrace();
                throw new NoSuchSlotException(this.getType(), action);
            }
            catch (Throwable e) {
                throw new ActionInvokeException(e);
            }
            try {
                SlotKnobs knobs = this.getSlotKnobs((NSlot)((Object)action));
                if (knobs != null) {
                    knobs.propagate(arg);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.fireComponentEvent(7, action, arg, null, context);
            if (user != null && !Flags.isNoAudit(instance, action)) {
                this.audit(ComponentSlotMap.getAuditSlotPath(instance, context), user, "Invoked", action.getName(), null, ComponentSlotMap.toAuditString(instance, action, arg, context));
            }
            return result;
        }
        try {
            instance.post(action, arg, context);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public final void fire(Topic topic, BValue event, Context context) {
        SlotKnobs knobs = this.getSlotKnobs((NSlot)((Object)topic));
        if (knobs != null) {
            knobs.propagate(event);
        }
        this.fireComponentEvent(8, topic, event, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        if (this.propertyInParent != null && Flags.isNoRun(this.parent.instance, this.propertyInParent)) {
            return;
        }
        if (!this.isRunning()) {
            if (this.getParent() != null && this.instance.getType().is(BIRestrictedComponent.TYPE)) {
                try {
                    ((BIRestrictedComponent)((Object)this.instance)).checkParentForRestrictedComponent(this.getParent().asComponent(), null);
                }
                catch (Throwable t) {
                    serviceLog.log(Level.SEVERE, "Unable to start duplicate restricted component: " + this.instance.asComponent().toDisplayPathString(null) + ". This component will be removed.", t);
                    this.getParent().asComponent().remove(this.instance);
                    return;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                boolean oldState = this.isSubscribed();
                this.setRunning(true);
                BComponent instance = (BComponent)this.instance;
                Nre.getEngineManager().start(instance);
                boolean newState = this.isSubscribed();
                if (oldState != newState) {
                    this.subscribe(true);
                }
                this.fireComponentEvent(14, null, null, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        if (this.isRunning()) {
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                boolean oldState = this.isSubscribed();
                this.setRunning(false);
                BComponent instance = (BComponent)this.instance;
                Nre.getEngineManager().stop(instance);
                boolean newState = this.isSubscribed();
                if (oldState != newState) {
                    this.unsubscribe(true);
                }
                this.fireComponentEvent(15, null, null, null, null);
            }
        }
    }

    @Override
    public final BComplex getParent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.instance;
    }

    @Override
    public final Property getPropertyInParent() {
        return super.getPropertyInParent();
    }

    @Override
    final void parent(NProperty property, ComplexSlotMap map, Context context, TransferListener listener, BDataRecoveryComponentRecorder recorder, BDataRecoveryComponentEvent event) {
        super.parent(property, map, context, listener, null, null);
        if (this.space != null) {
            this.space.childParented((BComponent)this.instance, property, map.instance, context);
        }
        this.fireComponentEvent(5, property, map.instance, null, context);
        if (map.instance.isComponent()) {
            ComponentSlotMap compMap = (ComponentSlotMap)map;
            if (map.isRunning()) {
                throw new IllegalStateException("Child is running?");
            }
            try {
                if (this.space != null) {
                    compMap.mount(this.space, context, listener);
                }
            }
            catch (RuntimeException e) {
                super.unparent(property, map, context);
                if (this.space != null) {
                    this.space.childUnparented((BComponent)this.instance, property, map.instance, context);
                }
                this.fireComponentEvent(6, property, map.instance, null, context);
                throw e;
            }
            if (recorder != null && event != null) {
                recorder.record(event, context);
            }
            if (this.isRunning() && ComponentSlotMap.getContextFacet(context, "niagaraAutoStart", true)) {
                map.start();
            }
        } else if (map.instance instanceof BLink) {
            if (recorder != null && event != null) {
                recorder.record(event, context);
            }
            if (this.isRunning()) {
                BLink link = (BLink)map.instance;
                EngineUtil.activate(link);
            }
        } else if (map.instance instanceof BRelation) {
            if (recorder != null && event != null) {
                recorder.record(event, context);
            }
            if (this.isRunning()) {
                BRelation relation = (BRelation)map.instance;
                EngineUtil.activate(relation);
            }
        } else if (recorder != null && event != null) {
            recorder.record(event, context);
        }
    }

    @Override
    final void unparent(NProperty property, ComplexSlotMap map, Context context) {
        if (map.instance.isComponent()) {
            ComponentSlotMap compMap = (ComponentSlotMap)map;
            compMap.stop();
            if (this.space != null) {
                compMap.unmount(context);
            }
        } else if (map.instance instanceof BLink) {
            BLink link = (BLink)map.instance;
            EngineUtil.deactivate(link);
        } else if (map.instance instanceof BRelation) {
            BRelation relation = (BRelation)map.instance;
            EngineUtil.deactivate(relation);
        }
        super.unparent(property, map, context);
        if (this.space != null) {
            this.space.childUnparented((BComponent)this.instance, property, map.instance, context);
        }
        this.fireComponentEvent(6, property, map.instance, null, context);
    }

    public void deactivating(BLink link) {
        try {
            Slot targetSlot = link.getTargetSlot();
            if (targetSlot.isProperty() && targetSlot.isFrozen()) {
                Property prop = targetSlot.asProperty();
                BValue def = prop.getDefaultValue().newCopy();
                this.instance.set(prop, def);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public final void mount(BComponentSpace space, Context context, TransferListener listener) {
        if (context != null && context.getUser() != null) {
            if (PROG_CODE_TYPE_INFO == null) {
                PROG_CODE_TYPE_INFO = BTypeSpec.make("program", "Code").getTypeInfo();
            }
            if (PROG_OBJ_TYPE_INFO == null) {
                PROG_OBJ_TYPE_INFO = BTypeSpec.make("program", "Program").getTypeInfo();
            }
            if ((this.getType().is(PROG_CODE_TYPE_INFO) || this.getType().is(PROG_OBJ_TYPE_INFO)) && !context.getUser().getPermissions().isSuperUser()) {
                throw new IllegalChildException("baja", "RestrictedProgramObjException", null);
            }
            if ((this.getType().is(BUserService.TYPE) || this.getType().is(BCategoryService.TYPE)) && !context.getUser().getPermissions().isSuperUser()) {
                throw new IllegalChildException("baja", "RestrictedServiceException", new Object[]{this.getType()});
            }
            if (this.getType().is(BUser.TYPE)) {
                BPermissionsMap cxUserPermissions = context.getUser().getPermissions();
                BPermissionsMap newUserPermissions = ((BUser)this.instance).getPermissions();
                if (!newUserPermissions.equals(cxUserPermissions.and(newUserPermissions))) {
                    throw new IllegalChildException("baja", "RestrictedUserAddException", new Object[]{this.getType()});
                }
            }
        }
        if (this.parent != null) {
            ObjectUtil.checkForLegalChild(this.parent.instance.asComponent(), this.instance, context);
        }
        space.fw(101, this, null, null, null);
        this.space = space;
        if (this.instance instanceof BIService) {
            Nre.getServiceManager().register((BComponent)((Object)((BIService)((Object)((BComponent)this.instance)))));
        }
        if (!space.getLoadCallbacks().isLazyLoad() || this.isBrokerPropsLoaded()) {
            SlotCursor<Property> c = this.getProperties();
            int i = 0;
            while (c.nextComponent()) {
                try {
                    ComponentSlotMap.getComponentSlotMap(c.get()).mount(space, context, listener);
                }
                catch (RuntimeException e) {
                    this.unmount(context);
                    throw e;
                }
                if (listener != null && i % 8 == 0) {
                    listener.updateStatus("Mounting \"" + TransferStrategy.toString(this.instance) + "\"...");
                }
                ++i;
            }
        }
    }

    public final void unmount(Context context) {
        if (this.instance instanceof BIService) {
            Nre.getServiceManager().unregister((BComponent)((Object)((BIService)((Object)((BComponent)this.instance)))));
        }
        boolean niagaraRemoveLinks = ComponentSlotMap.getContextFacet(context, "niagaraRemoveLinks", true);
        NKnob[] knobs = this.getKnobs();
        for (int i = 0; i < knobs.length; ++i) {
            BLink link = knobs[i].getLink();
            if (link == null || !link.isIndirect()) continue;
            try {
                BComponent target = link.getTargetComponent();
                if (niagaraRemoveLinks) {
                    target.remove(link.getPropertyInParent(), Context.commit);
                    continue;
                }
                ComponentSlotMap targetMap = ComponentSlotMap.getComponentSlotMap(target);
                EngineUtil.deactivate(link);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        NRelationKnob[] rKnobs = this.getRelationKnobs();
        for (int i = 0; i < rKnobs.length; ++i) {
            BRelation relation = rKnobs[i].getRelation();
            if (relation == null || !relation.isIndirect()) continue;
            try {
                BComponent source = relation.getParent().asComponent();
                if (niagaraRemoveLinks) {
                    source.remove(relation.getPropertyInParent(), Context.commit);
                    continue;
                }
                ComponentSlotMap sourceMap = ComponentSlotMap.getComponentSlotMap(source);
                EngineUtil.deactivate(relation);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.unsubscribeAll();
        if (this.space != null) {
            this.space.fw(102, this, null, null, null);
        }
        this.space = null;
        SlotCursor<Property> c = this.getProperties();
        while (c.nextComponent()) {
            ComponentSlotMap.getComponentSlotMap(c.get()).unmount(context);
        }
    }

    public final void checkAdd(String name, int flags, BValue value, BFacets facets, Context context) {
        BComponent instance = (BComponent)this.instance;
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == instance) {
            throw new IllegalArgumentException("value == this");
        }
        instance.checkAdd(name, value, flags, facets, context);
        if (value.isComponent()) {
            BComponent me = instance;
            BComponent v = value.asComponent();
            boolean skipParentCheck = me instanceof BUnrestrictedFolder;
            if (!me.isChildLegal(v)) {
                throw new IllegalChildException("baja", "IllegalChildException.parentAndChild", new Object[]{this.getType(), value.getType()});
            }
            if (!skipParentCheck && !v.isParentLegal(me)) {
                throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{this.getType(), value.getType()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Property add(String name, int flags, BValue value, ComplexSlotMap valueSlotMap, BFacets facets, Context context, TransferListener listener) {
        NProperty slot;
        BComponent instance = (BComponent)this.instance;
        if (value.getType().equals(BPassword.TYPE)) {
            BPassword password = (BPassword)value;
            value = AccessController.doPrivileged(() -> PasswordUtil.assignPasswordOwner(password, instance, null));
        } else if (value instanceof BIDeferOwnership) {
            BIDeferOwnership defer = (BIDeferOwnership)((Object)value);
            AccessController.doPrivileged(() -> {
                PasswordUtil.assignChildPasswordOwner(defer, instance);
                return null;
            });
        }
        if (facets == null) {
            facets = BFacets.NULL;
        }
        this.checkAdd(name, flags, value, facets, context);
        if (context instanceof Transaction) {
            ((Transaction)context).add(instance, name, value, flags, facets, null);
            return null;
        }
        TrapCallbacks trap = this.getSpaceTrap();
        if (trap != null && trap.isTrapEnabled() && context != Context.commit) {
            return trap.add(instance, name, value, flags, facets, context);
        }
        BUser user = null;
        if (context != null && context.getUser() != null) {
            user = context.getUser();
            user.check(instance, BPermissions.adminWrite);
        }
        BComponent bComponent = instance;
        synchronized (bComponent) {
            if (name == null) {
                name = ObjectUtil.generateUniqueSlotName(EscUtil.slot.escape(value.getType().getTypeName()), this);
            } else if (name.endsWith("?")) {
                String defName = EscUtil.slot.escape(name.substring(0, name.length() - 1));
                SlotPath.verifyValidName(defName);
                name = ObjectUtil.generateUniqueSlotName(defName, this);
            }
            Slot dup = this.getSlot(name);
            if (dup != null) {
                throw new DuplicateSlotException(dup);
            }
            SlotPath.verifyValidName(name);
            if (!value.isSimple() && valueSlotMap.parent != null) {
                throw new AlreadyParentedException(name);
            }
            slot = value instanceof BAction ? new NActionProperty(name, flags, (BAction)value, facets) : (value instanceof BTopic ? new NTopicProperty(name, flags, (BTopic)value, facets) : new NProperty(name, flags, value, facets));
            slot.declaringType = instance.getType();
            BDataRecoveryComponentRecorder recorder = this.findRecoveryData(1, slot, flags, context);
            BDataRecoveryComponentEvent event = null;
            if (recorder != null) {
                event = BDataRecoveryComponentEvent.makeAddEvent(instance, name, value, flags, facets);
            }
            if (this.table == null) {
                this.table = new DynamicTable(this.getType().slots.length);
            }
            this.table.put(slot);
            if (!value.isSimple()) {
                try {
                    this.parent(slot, valueSlotMap, context, listener, recorder, event);
                }
                catch (RuntimeException e) {
                    this.table.remove(slot);
                    throw e;
                }
            } else if (recorder != null && event != null) {
                recorder.record(event, context);
            }
        }
        this.fireComponentEvent(1, slot, null, null, context);
        BOrd ord = this.checkNavEvent(value);
        if (ord != null) {
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded(instance, name, context));
        }
        if (user != null) {
            this.audit(ComponentSlotMap.getAuditSlotPath(instance, context), user, "Added", slot.name, null, ComponentSlotMap.toAuditString(instance, slot, value, context));
        }
        this.checkTagAdded(instance, slot, context);
        return slot;
    }

    @Override
    public boolean contains(String name) {
        this.loadSlots();
        return this.getSlot(name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BValue remove(Property slot, Context context) {
        BDataRecoveryComponentRecorder recorder;
        if (slot.isFrozen()) {
            throw new FrozenSlotException(slot);
        }
        if (this.table == null) {
            throw new NoSuchSlotException(this.getType(), slot);
        }
        BComponent instance = (BComponent)this.instance;
        if (!Context.skipRemoveCheck.equals(context)) {
            instance.checkRemove(slot, context);
        }
        NProperty prop = (NProperty)slot;
        BValue value = prop.value;
        int flags = this.getFlags(slot);
        if (context instanceof Transaction) {
            ((Transaction)context).remove(instance, prop, null);
            return null;
        }
        TrapCallbacks trap = this.getSpaceTrap();
        if (trap != null && trap.isTrapEnabled() && context != Context.commit) {
            trap.remove(instance, prop, context);
            return null;
        }
        BUser user = null;
        if (context != null && context.getUser() != null) {
            user = context.getUser();
            user.check(instance, BPermissions.adminWrite);
            if (value instanceof BIProtected) {
                user.check((BIProtected)((Object)value), BPermissions.adminWrite);
            }
        }
        if ((recorder = this.findRecoveryData(2, slot, context)) != null) {
            recorder.record(BDataRecoveryComponentEvent.makeRemoveEvent(instance, prop.getName()), context);
        }
        try {
            if (!(this.space == null || this.space.isProxyComponentSpace() || value instanceof BComponent || value instanceof BLink)) {
                NKnob[] knobs = this.getKnobs(prop);
                for (int i = 0; i < knobs.length; ++i) {
                    this.removeLink(knobs[i]);
                }
                BLink[] links = instance.getLinks(prop);
                for (int i = 0; i < links.length; ++i) {
                    this.removeLink(links[i]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BComponent e = instance;
        synchronized (e) {
            if (!value.isSimple()) {
                this.unparent(prop, ComponentSlotMap.getSlotMap(value), context);
            }
            this.table.remove(prop);
            prop.index = -1;
        }
        this.fireComponentEvent(2, prop, value, null, context);
        BOrd ord = this.checkNavEvent(value);
        if (ord != null) {
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved(instance, prop.name, context));
        }
        if (user != null) {
            this.audit(ComponentSlotMap.getAuditSlotPath(instance, context), user, "Removed", prop.name, ComponentSlotMap.toAuditString(instance, slot, value, context), null);
        }
        this.checkTagRemoved(instance, slot, context);
        return value;
    }

    private void removeLink(Knob knob) {
        BComponent target = knob.getTargetComponent();
        BLink link = knob.getLink();
        if (target != null && link != null) {
            target.remove(link);
        }
    }

    private void removeLink(BLink link) {
        this.remove(link.getPropertyInParent(), null);
    }

    private void removeRelation(RelationKnob knob) {
        BComponent relationSource = knob.getRelationComponent();
        BRelation relation = knob.getRelation();
        if (relationSource != null && relation != null) {
            relationSource.remove(relation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rename(Property slot, String newName, Context context) {
        NProperty prop = (NProperty)slot;
        if (newName.equals(prop.name)) {
            return;
        }
        Slot dup = this.getSlot(newName);
        SlotPath.verifyValidName(newName);
        if (slot.isFrozen()) {
            throw new FrozenSlotException(slot);
        }
        if (dup != null) {
            throw new DuplicateSlotException(dup);
        }
        if (this.table == null) {
            throw new NoSuchSlotException(this.getType(), slot);
        }
        BComponent instance = (BComponent)this.instance;
        instance.checkRename(slot, newName, context);
        if (context instanceof Transaction) {
            ((Transaction)context).rename(instance, slot, newName, null);
            return;
        }
        TrapCallbacks trap = this.getSpaceTrap();
        if (trap != null && trap.isTrapEnabled() && context != Context.commit) {
            trap.rename(instance, slot, newName, context);
            return;
        }
        BUser user = null;
        if (context != null && context.getUser() != null) {
            user = context.getUser();
            user.check(instance, BPermissions.adminWrite);
            if (prop.value instanceof BIProtected) {
                user.check((BIProtected)((Object)prop.value), BPermissions.adminWrite);
            }
        }
        BValue value = prop.value;
        String oldName = prop.name;
        BComponent bComponent = instance;
        synchronized (bComponent) {
            BDataRecoveryComponentRecorder recorder = this.findRecoveryData(3, prop, context);
            if (recorder != null) {
                recorder.record(BDataRecoveryComponentEvent.makeRenameEvent(instance, oldName, newName), context);
            }
            Property[] order = (Property[])this.table.slots.clone();
            this.table.remove(prop);
            prop.name = newName;
            prop.displayName = null;
            this.table.put(prop);
            this.table.reorder(order);
        }
        this.fireComponentEvent(3, prop, null, oldName, context);
        BOrd ord = this.checkNavEvent(value);
        if (ord != null) {
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRenamed(instance, oldName, newName, context));
        }
        if (user != null) {
            this.audit(ComponentSlotMap.getAuditSlotPath(instance, context), user, "Renamed", oldName, null, newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFacets(Slot s, BFacets facets, Context context) {
        BDataRecoveryComponentRecorder recorder;
        NSlot slot;
        if (facets == null) {
            facets = BFacets.NULL;
        }
        if ((slot = (NSlot)s).isFrozen()) {
            throw new FrozenSlotException(s);
        }
        if (facets.equals(slot.facets)) {
            return;
        }
        BComponent instance = (BComponent)this.instance;
        instance.checkSetFacets(s, facets, context);
        if (context instanceof Transaction) {
            ((Transaction)context).setFacets(instance, slot, facets, null);
            return;
        }
        TrapCallbacks trap = this.getSpaceTrap();
        if (trap != null && trap.isTrapEnabled() && context != Context.commit) {
            trap.setFacets(instance, slot, facets, context);
            return;
        }
        BUser user = null;
        String oldValue = null;
        if (context != null && context.getUser() != null) {
            BValue value;
            user = context.getUser();
            user.check(instance, BPermissions.adminWrite);
            if (slot instanceof NProperty && (value = ((NProperty)slot).value) instanceof BIProtected) {
                user.check((BIProtected)((Object)value), BPermissions.adminWrite);
            }
            oldValue = slot.facets.toString();
        }
        if ((recorder = this.findRecoveryData(7, slot, context)) != null) {
            recorder.record(BDataRecoveryComponentEvent.makeFacetsChangeEvent(instance, slot.getName(), facets), context);
        }
        BComponent bComponent = instance;
        synchronized (bComponent) {
            slot.facets = facets;
        }
        this.fireComponentEvent(10, slot, facets, null, context);
        if (user != null) {
            String value = facets.toString();
            this.audit(ComponentSlotMap.getAuditSlotPath(instance, context), user, "Facets Changed", slot.name, oldValue, value);
        }
    }

    @Override
    public void reorderToTop(Property prop, Context cx) {
        if (this.table == null || this.table.count == 0) {
            throw new IllegalArgumentException("No dynamic properties");
        }
        if (prop.isFrozen()) {
            throw new FrozenSlotException(prop);
        }
        Object[] array = new Property[this.table.count];
        this.table.copyInto(array, 0);
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (prop != array[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Property not in component");
        }
        if (index == 0) {
            return;
        }
        System.arraycopy(array, 0, array, 1, index);
        array[0] = prop;
        this.reorderImpl((Property[])array, cx);
    }

    @Override
    public void reorderToBottom(Property prop, Context cx) {
        if (this.table == null || this.table.count == 0) {
            throw new IllegalStateException("No dynamic properties");
        }
        if (prop.isFrozen()) {
            throw new FrozenSlotException(prop);
        }
        Object[] array = new Property[this.table.count];
        this.table.copyInto(array, 0);
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (prop != array[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Property not in component");
        }
        if (index == array.length - 1) {
            return;
        }
        System.arraycopy(array, index + 1, array, index, array.length - index - 1);
        array[array.length - 1] = prop;
        this.reorderImpl((Property[])array, cx);
    }

    @Override
    public void reorder(Property[] props, Context cx) {
        if (this.table == null) {
            throw new ArrayIndexOutOfBoundsException("no dynamic props");
        }
        if (this.table.count != props.length) {
            throw new ArrayIndexOutOfBoundsException("actual count " + this.table.count + " != param count " + props.length);
        }
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].isFrozen()) continue;
            throw new FrozenSlotException(props[i]);
        }
        this.reorderImpl(props, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorderImpl(Property[] props, Context context) {
        BDataRecoveryComponentRecorder recorder;
        BComponent instance = (BComponent)this.instance;
        instance.checkReorder(props, context);
        if (context instanceof Transaction) {
            ((Transaction)context).reorder(instance, props, null);
            return;
        }
        TrapCallbacks trap = this.getSpaceTrap();
        if (trap != null && trap.isTrapEnabled() && context != Context.commit) {
            trap.reorder(instance, props, context);
            return;
        }
        BUser user = null;
        if (context != null && context.getUser() != null) {
            user = context.getUser();
            user.check(instance, BPermissions.adminWrite);
        }
        if ((recorder = this.findRecoveryData(4, null, -1, context)) != null) {
            recorder.record(BDataRecoveryComponentEvent.makeReorderEvent(instance, props), context);
        }
        BComponent bComponent = instance;
        synchronized (bComponent) {
            this.table.reorder(props);
        }
        this.fireComponentEvent(4, null, null, null, context);
        BOrd ord = instance.getNavOrd();
        if (ord != null) {
            String[] newOrder = new String[this.table.count];
            for (int i = 0; i < newOrder.length; ++i) {
                newOrder[i] = this.table.slots[i].name;
            }
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeReordered(instance, newOrder, context));
        }
        if (user != null) {
            this.audit(ComponentSlotMap.getAuditSlotPath(instance, context), user, "Reordered", null, null, null);
        }
    }

    @Override
    public final BCategoryMask getAppliedCategoryMask() {
        if (this.cat.isNull() && this.parent != null) {
            return this.parent.getAppliedCategoryMask();
        }
        return this.cat;
    }

    @Override
    public final BCategoryMask getCategoryMask() {
        return this.cat;
    }

    @Override
    public final void setCategoryMask(BCategoryMask cat, Context context) {
        BComponent instance = (BComponent)this.instance;
        if (cat == null) {
            throw new NullPointerException();
        }
        if (cat == this.cat) {
            return;
        }
        if (context instanceof Transaction) {
            ((Transaction)context).setCategoryMask(instance, cat, null);
            return;
        }
        TrapCallbacks trap = this.getSpaceTrap();
        if (trap != null && trap.isTrapEnabled() && context != Context.commit) {
            trap.setCategoryMask(instance, cat, context);
            return;
        }
        BUser user = null;
        if (context != null && context.getUser() != null) {
            user = context.getUser();
            user.check(instance, BPermissions.adminWrite);
            cat = CategoryValidator.adjustPendingCategoryMask(instance, cat, context);
        }
        BCategoryMask old = this.cat;
        BDataRecoveryComponentRecorder recorder = this.findRecoveryData(10, null, -1, context);
        if (recorder != null) {
            recorder.record(BDataRecoveryComponentEvent.makeRecategorizeEvent(instance, cat, old), context);
        }
        this.cat = cat;
        this.fireComponentEvent(11, null, old, null, context);
        BOrd ord = instance.getNavOrd();
        if (ord != null) {
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRecategorized(instance, old, cat, context));
        }
        if (user != null) {
            this.audit(ComponentSlotMap.getAuditSlotPath(instance, context), user, "Recategorized", null, old.encodeToString(), cat.encodeToString());
        }
    }

    public final BCategoryMask getDeepOrCategoryMask() {
        return this.catDeepOr;
    }

    public void updateDeepOr(BCategoryMask[] working, int depth) {
        working[depth + 1] = BCategoryMask.NULL;
        SlotCursor<Property> cursor = this.getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = (BComponent)cursor.get();
            ComponentSlotMap kidMap = (ComponentSlotMap)kid.fw(1, null, null, null, null);
            kidMap.updateDeepOr(working, depth + 1);
        }
        this.catDeepOr = working[depth + 1];
        working[depth] = BCategoryMask.or(BCategoryMask.or(working[depth], this.cat), this.catDeepOr);
    }

    public static boolean getContextFacet(Context c, String key, boolean def) {
        if (c == null) {
            return def;
        }
        BBoolean value = (BBoolean)c.getFacet(key);
        if (value == null) {
            return def;
        }
        return value.getBoolean();
    }

    final BOrd checkNavEvent(BValue value) {
        if (value instanceof BComponent && ((BComponent)value).isNavChild()) {
            return ((BComponent)this.instance).getNavOrd();
        }
        return null;
    }

    public static BOrd swizzle(BOrd ord, int serialNum) {
        try {
            if (ord.toString().startsWith("h:")) {
                OrdQuery[] q = ord.parse();
                q[0] = new BasicQuery("h", ComponentSlotMap.swizzle(q[0].getBody(), serialNum));
                return BOrd.make(q);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ord;
    }

    public static String swizzle(String handle, int serialNum) {
        String serialStr = Integer.toHexString(serialNum);
        return SWIZZLE_PREFIX + serialStr + "-" + handle;
    }

    public static String unswizzle(String handle) {
        if (!handle.startsWith(SWIZZLE_PREFIX)) {
            return handle;
        }
        int dash = handle.indexOf(45, SWIZZLE_PREFIX.length() + 1);
        if (dash < 0) {
            return handle;
        }
        return handle.substring(dash + 1);
    }

    public String generateUniqueSlotName(String base) {
        return ObjectUtil.generateUniqueSlotName(base, this);
    }

    private void checkTagAdded(BComponent comp, Property prop, Context cx) {
        TagDictionaryService tagDictionaryService;
        if (!comp.isRunning() || !Station.atSteadyState || cx != null && cx.equals(Context.decoding)) {
            return;
        }
        if ((comp.getFlags(prop) & 0x4000) != 0 && comp.get(prop) instanceof BIDataValue && (tagDictionaryService = comp.getComponentSpace().getTagDictionaryService()) != null) {
            tagDictionaryService.tagAdded(comp, Id.newId(prop.getName()));
        }
    }

    private void checkTagRemoved(BComponent comp, Property prop, Context cx) {
        TagDictionaryService tagDictionaryService;
        if (!comp.isRunning() || !Station.atSteadyState || cx != null && cx.equals(Context.decoding)) {
            return;
        }
        if ((comp.getFlags(prop) & 0x4000) != 0 && comp.get(prop) instanceof BIDataValue && (tagDictionaryService = comp.getComponentSpace().getTagDictionaryService()) != null) {
            tagDictionaryService.tagRemoved(comp, Id.newId(prop.getName()));
        }
    }

    public final boolean isInitialized() {
        return (this.mask & 1) != 0;
    }

    public final void setInitialized(boolean b) {
        this.mask = b ? (byte)(this.mask | 1) : (byte)(this.mask & 0xFFFFFFFE);
    }

    @Override
    public final boolean isRunning() {
        return (this.mask & 4) != 0;
    }

    public final void setRunning(boolean b) {
        this.mask = b ? (byte)(this.mask | 4) : (byte)(this.mask & 0xFFFFFFFB);
    }

    public final boolean isBrokerPropsLoaded() {
        return (this.mask & 8) != 0;
    }

    public final void setBrokerPropsLoaded(boolean b) {
        this.mask = b ? (byte)(this.mask | 8) : (byte)(this.mask & 0xFFFFFFF7);
    }

    @Override
    public final boolean isPendingMove() {
        return (this.mask & 0x10) != 0;
    }

    @Override
    public final void setPendingMove(boolean b) {
        this.mask = b ? (byte)(this.mask | 0x10) : (byte)(this.mask & 0xFFFFFFEF);
    }

    public final boolean isWidget() {
        return (this.mask & 0x40) != 0;
    }

    public final void setIsWidget(boolean b) {
        this.mask = b ? (byte)(this.mask | 0x40) : (byte)(this.mask & 0xFFFFFFBF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPendingSubscribe(Subscriber s) {
        if (this.space != null && this.space.isProxyComponentSpace()) {
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                int len = this.subscribers.length;
                boolean noMatch = true;
                for (int i = 0; i < len; ++i) {
                    Subscriber subscriber = this.subscribers[i];
                    if (!(subscriber instanceof PendingSubscriber) || ((PendingSubscriber)subscriber).subscriber != s) continue;
                    noMatch = false;
                    break;
                }
                if (noMatch) {
                    Subscriber[] temp = new Subscriber[this.subscribers.length + 1];
                    System.arraycopy(this.subscribers, 0, temp, 0, this.subscribers.length);
                    temp[this.subscribers.length] = new PendingSubscriber(s);
                    this.subscribers = temp;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearPendingSubscribe(Subscriber s) {
        BComplex bComplex = this.instance;
        synchronized (bComplex) {
            for (int i = 0; i < this.subscribers.length; ++i) {
                if (!(this.subscribers[i] instanceof PendingSubscriber) || ((PendingSubscriber)this.subscribers[i]).subscriber != s) continue;
                Subscriber[] temp = new Subscriber[this.subscribers.length - 1];
                System.arraycopy(this.subscribers, 0, temp, 0, i);
                if (i < this.subscribers.length) {
                    System.arraycopy(this.subscribers, i + 1, temp, i, this.subscribers.length - i - 1);
                }
                this.subscribers = temp;
                break;
            }
        }
    }

    static {
        noSubscribers = new Subscriber[0];
        noKnobs = new NKnob[0];
        noRelationKnobs = new NRelationKnob[0];
    }

    static class PendingSubscriber
    extends Subscriber {
        Subscriber subscriber;

        public PendingSubscriber(Subscriber s) {
            this.subscriber = s;
        }

        @Override
        public void event(BComponentEvent event) {
            this.subscriber.event(event);
        }
    }
}

