/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.dataRecovery.BDataRecoveryComponentEvent;
import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.sys.Nre;
import com.tridium.sys.engine.EngineUtil;
import com.tridium.sys.engine.NKnob;
import com.tridium.sys.engine.NRelationKnob;
import com.tridium.sys.schema.ActionCursor;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import com.tridium.sys.schema.NTopic;
import com.tridium.sys.schema.PropertyCursor;
import com.tridium.sys.schema.SlotsCursor;
import com.tridium.sys.schema.TopicCursor;
import com.tridium.sys.schema.UnhandledSlotException;
import com.tridium.sys.transfer.TransferListener;
import com.tridium.util.ObjectUtil;
import com.tridium.util.PasswordUtil;
import java.security.AccessController;
import java.util.ArrayList;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.naming.BasicQuery;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.BIDeferOwnership;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.security.PermissionException;
import javax.baja.space.BComponentSpace;
import javax.baja.space.TrapCallbacks;
import javax.baja.status.BStatusValue;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.AlreadyParentedException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.BatchSetException;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.Flags;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Topic;
import javax.baja.sys.Validatable;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.virtual.BVirtualComponent;

public abstract class ComplexSlotMap {
    static TypeInfo BOG_SPACE_TYPE_INFO = null;
    ComplexSlotMap parent;
    NProperty propertyInParent;
    BComplex instance;

    public void init(ComplexType type, BComplex instance) {
        this.instance = instance;
        NSlot[] slots = type.slots;
        block9: for (int i = 0; i < slots.length; ++i) {
            if (!slots[i].isProperty()) continue;
            NProperty prop = (NProperty)slots[i];
            switch (prop.typeAccess) {
                case 0: {
                    instance.setBoolean(prop, ((BBoolean)prop.value).getBoolean(), Context.skipValidate);
                    continue block9;
                }
                case 2: {
                    instance.setInt(prop, ((BInteger)prop.value).getInt(), Context.skipValidate);
                    continue block9;
                }
                case 3: {
                    instance.setLong(prop, ((BLong)prop.value).getLong(), Context.skipValidate);
                    continue block9;
                }
                case 4: {
                    instance.setFloat(prop, ((BFloat)prop.value).getFloat(), Context.skipValidate);
                    continue block9;
                }
                case 5: {
                    instance.setDouble(prop, ((BDouble)prop.value).getDouble(), Context.skipValidate);
                    continue block9;
                }
                case 6: {
                    instance.setString(prop, ((BString)prop.value).getString(), Context.skipValidate);
                    continue block9;
                }
                case 7: {
                    instance.set(prop, prop.value.newCopy(true), Context.skipValidate);
                    continue block9;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public final BComplex getInstance() {
        return this.instance;
    }

    public final ComplexType getType() {
        return (ComplexType)this.instance.getType();
    }

    public String getName() {
        if (this.propertyInParent == null) {
            return null;
        }
        return this.propertyInParent.getName();
    }

    public String getDisplayName(Context c) {
        if (this.propertyInParent == null) {
            return null;
        }
        return this.parent.instance.getDisplayName(this.propertyInParent, c);
    }

    public boolean equivalent(ComplexSlotMap x) {
        NSlot[] slots = this.getType().slots;
        block9: for (int i = 0; i < slots.length; ++i) {
            NSlot slot = slots[i];
            if (this.getFlags(slot) != x.getFlags(slot)) {
                return false;
            }
            if (!slot.isProperty()) continue;
            NProperty prop = (NProperty)slot;
            switch (prop.typeAccess) {
                case 0: {
                    if (this.gb(i) == x.gb(i)) continue block9;
                    return false;
                }
                case 2: {
                    if (this.gi(i) == x.gi(i)) continue block9;
                    return false;
                }
                case 3: {
                    if (this.gj(i) == x.gj(i)) continue block9;
                    return false;
                }
                case 4: {
                    if (BFloat.equals(this.gf(i), x.gf(i))) continue block9;
                    return false;
                }
                case 5: {
                    if (BDouble.equals(this.gd(i), x.gd(i))) continue block9;
                    return false;
                }
                case 6: {
                    if (this.gs(i).equals(x.gs(i))) continue block9;
                    return false;
                }
                case 7: {
                    if (this.g(i).equivalent(x.g(i))) continue block9;
                    return false;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return true;
    }

    public static BValue newCopy(BValue v, CopyHints hints, int serialNum) {
        if (v instanceof BComplex) {
            ComplexSlotMap slotMap = (ComplexSlotMap)v.fw(1, null, null, null, null);
            return slotMap.newCopy(hints, serialNum);
        }
        if (hints.swizzleHandles && v instanceof BOrd) {
            return ComponentSlotMap.swizzle((BOrd)v, serialNum);
        }
        return v.newCopy(hints);
    }

    public BComplex newCopy(CopyHints hints, int serialNum) {
        try {
            BComplex copy = this.newBComplexInstance();
            Context cx = Context.copying;
            boolean defaultOnClone = hints.defaultOnClone;
            boolean defaultStatus = hints.defaultStatus;
            boolean hasUser = hints.cx != null && (hints.cx.getUser() != null || hints.cx.getFacets() != null && hints.cx.getFacets().gets("username", null) != null);
            NProperty[] props = this.getType().properties;
            block11: for (int i = 0; i < props.length; ++i) {
                NProperty prop = props[i];
                boolean flaggedDefaultOnClone = Flags.isDefaultOnClone(this.instance, prop);
                if (flaggedDefaultOnClone && defaultOnClone || flaggedDefaultOnClone && Flags.isReadonly(this.instance, prop) && defaultStatus || hasUser && prop.getType().equals(BPassword.TYPE)) continue;
                switch (prop.typeAccess) {
                    case 0: {
                        copy.setBoolean(prop, this.gb(prop.index), cx);
                        continue block11;
                    }
                    case 2: {
                        copy.setInt(prop, this.gi(prop.index), cx);
                        continue block11;
                    }
                    case 3: {
                        copy.setLong(prop, this.gj(prop.index), cx);
                        continue block11;
                    }
                    case 4: {
                        copy.setFloat(prop, this.gf(prop.index), cx);
                        continue block11;
                    }
                    case 5: {
                        copy.setDouble(prop, this.gd(prop.index), cx);
                        continue block11;
                    }
                    case 6: {
                        copy.setString(prop, this.gs(prop.index), cx);
                        continue block11;
                    }
                    case 7: {
                        BValue v;
                        BValue obj = this.g(prop.index);
                        if (obj.isComponent() && hints.cx != null) {
                            if (!((BComponent)obj).getPermissions(hints.cx).hasOperatorRead()) continue block11;
                            v = ComplexSlotMap.newCopy(obj, hints, serialNum);
                            copy.set(prop, v, cx);
                            continue block11;
                        }
                        v = ComplexSlotMap.newCopy(obj, hints, serialNum);
                        copy.set(prop, v, cx);
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return copy;
        }
        catch (NoSuchMethodError nsme) {
            throw new UnsupportedOperationException("Default constructor not available for " + this);
        }
    }

    public void copyFrom(ComplexSlotMap x, Context context) {
        BComplex inst = this.instance;
        NProperty[] myProps = this.getType().properties;
        NProperty[] xProps = x.getType().properties;
        NProperty[] props = myProps;
        if (this.getClass() != x.getClass() && xProps.length < props.length) {
            props = xProps;
        }
        block9: for (int i = 0; i < props.length; ++i) {
            NProperty myProp = myProps[i];
            NProperty xProp = xProps[i];
            if (myProp.declaringType != xProp.declaringType) {
                throw new IllegalStateException("Unlike declaring types for property " + myProp.declaringType + " != " + xProp.declaringType);
            }
            switch (myProp.typeAccess) {
                case 0: {
                    inst.setBoolean(myProp, x.gb(xProp.index), context);
                    continue block9;
                }
                case 2: {
                    inst.setInt(myProp, x.gi(xProp.index), context);
                    continue block9;
                }
                case 3: {
                    inst.setLong(myProp, x.gj(xProp.index), context);
                    continue block9;
                }
                case 4: {
                    inst.setFloat(myProp, x.gf(xProp.index), context);
                    continue block9;
                }
                case 5: {
                    inst.setDouble(myProp, x.gd(xProp.index), context);
                    continue block9;
                }
                case 6: {
                    inst.setString(myProp, x.gs(xProp.index), context);
                    continue block9;
                }
                case 7: {
                    BValue myValue = this.g(myProp.index);
                    BValue xValue = x.g(xProp.index);
                    if (myValue.getClass() == xValue.getClass() && !myValue.isSimple()) {
                        myValue.asComplex().copyFrom(xValue.asComplex(), context);
                        continue block9;
                    }
                    inst.set(myProp, xValue.newCopy(), context);
                    continue block9;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public void loadSlots() {
    }

    public int getSlotCount() {
        return this.getType().slots.length;
    }

    public Slot getSlot(String name) {
        return this.getType().byName.get(name);
    }

    public Slot[] getSlotsArray() {
        NSlot[] slots = this.getType().slots;
        Slot[] copy = new Slot[slots.length];
        System.arraycopy(slots, 0, copy, 0, copy.length);
        return copy;
    }

    public int getPropertyCount() {
        return this.getType().properties.length;
    }

    public Property[] getPropertiesArray() {
        NProperty[] props = this.getType().properties;
        Property[] copy = new Property[props.length];
        System.arraycopy(props, 0, copy, 0, copy.length);
        return copy;
    }

    public Property[] getFrozenPropertiesArray() {
        return this.getPropertiesArray();
    }

    public Property[] getDynamicPropertiesArray() {
        return new Property[0];
    }

    public Action[] getActionsArray() {
        NAction[] actions = this.getType().actions;
        Action[] copy = new Action[actions.length];
        System.arraycopy(actions, 0, copy, 0, copy.length);
        return copy;
    }

    public Topic[] getTopicsArray() {
        NTopic[] topics = this.getType().topics;
        Topic[] copy = new Topic[topics.length];
        System.arraycopy(topics, 0, copy, 0, copy.length);
        return copy;
    }

    public SlotCursor<Slot> getSlots() {
        return new SlotsCursor(this.instance, this.getType().slots, null);
    }

    public SlotCursor<Property> getProperties() {
        return new PropertyCursor(this.instance, this.getType().properties, null);
    }

    public SlotCursor<Action> getActions() {
        return new ActionCursor(this.instance, this.getType().actions, null);
    }

    public SlotCursor<Topic> getTopics() {
        return new TopicCursor(this.instance, this.getType().topics, null);
    }

    public final BValue get(String name) {
        Property prop = (Property)this.getSlot(name);
        if (prop == null) {
            return null;
        }
        return this.get(prop);
    }

    public final BValue get(Property property) {
        try {
            NProperty prop = (NProperty)property;
            BValue override = this.getOverride(prop);
            if (override != null) {
                return override;
            }
            BValue v = prop.isFrozen ? this.g(prop.index) : prop.value;
            return v;
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final boolean getBoolean(Property property) {
        try {
            NProperty prop = (NProperty)property;
            BValue override = this.getOverride(prop);
            if (override != null) {
                return ((BBoolean)override).getBoolean();
            }
            if (prop.isFrozen) {
                return this.gb(prop.index);
            }
            return ((BBoolean)prop.value).getBoolean();
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final int getInt(Property property) {
        try {
            NProperty prop = (NProperty)property;
            BValue override = this.getOverride(prop);
            if (override != null) {
                return ((BInteger)override).getInt();
            }
            if (prop.isFrozen) {
                return this.gi(prop.index);
            }
            return ((BInteger)prop.value).getInt();
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final long getLong(Property property) {
        try {
            NProperty prop = (NProperty)property;
            BValue override = this.getOverride(prop);
            if (override != null) {
                return ((BLong)override).getLong();
            }
            if (prop.isFrozen) {
                return this.gj(prop.index);
            }
            return ((BLong)prop.value).getLong();
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final float getFloat(Property property) {
        try {
            NProperty prop = (NProperty)property;
            BValue override = this.getOverride(prop);
            if (override != null) {
                return ((BFloat)override).getFloat();
            }
            if (prop.isFrozen) {
                return this.gf(prop.index);
            }
            return ((BFloat)prop.value).getFloat();
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final double getDouble(Property property) {
        try {
            NProperty prop = (NProperty)property;
            BValue override = this.getOverride(prop);
            if (override != null) {
                return ((BDouble)override).getDouble();
            }
            if (prop.isFrozen) {
                return this.gd(prop.index);
            }
            return ((BDouble)prop.value).getDouble();
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final String getString(Property property) {
        try {
            NProperty prop = (NProperty)property;
            BValue override = this.getOverride(prop);
            if (override != null) {
                return override.toString();
            }
            if (prop.isFrozen) {
                return this.gs(prop.index);
            }
            return ((BString)prop.value).getString();
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    BValue getOverride(Property prop) {
        return null;
    }

    public final void set(Property[] properties, BValue[] values, Context context) {
        if (properties.length != values.length) {
            throw new IllegalArgumentException("Cannot call batch set() with property and value arrays of different lengths");
        }
        boolean validateIndividualSet = true;
        if (this.setRequiresValidation(context)) {
            IPropertyValidator validator = this.instance.getPropertyValidator(properties, context);
            if (validator != null) {
                validateIndividualSet = false;
                values = validator.adjustPendingSetValues(this.instance, properties, values, context);
                validator.validateSet(new Validatable(this.instance, properties, values), context);
            }
        } else {
            validateIndividualSet = false;
        }
        boolean isTx = context instanceof Transaction;
        Transaction proxyTx = null;
        TrapCallbacks trap = this.getSpaceTrap();
        if (trap != null && trap.isTrapEnabled() && trap.trapSets() && context != Context.commit && !isTx) {
            proxyTx = this.getSpace().newTransaction(context);
            context = proxyTx;
        }
        ArrayList<Property> successfulProps = null;
        ArrayList<Property> failedProps = null;
        ArrayList<BValue> failedValues = null;
        ArrayList<Throwable> failureCauses = null;
        for (int i = 0; i < properties.length; ++i) {
            Property prop = properties[i];
            BValue val = values[i];
            if (prop == null || val == null) {
                if (successfulProps != null) continue;
                successfulProps = new ArrayList<Property>(properties.length - 1);
                for (int j = 0; j < i; ++j) {
                    successfulProps.add(properties[j]);
                }
                continue;
            }
            try {
                this.setPropValue((NProperty)prop, val, context, validateIndividualSet);
                if (successfulProps == null) continue;
                successfulProps.add(prop);
                continue;
            }
            catch (Throwable t) {
                if (successfulProps == null) {
                    successfulProps = new ArrayList(properties.length - 1);
                    for (int j = 0; j < i; ++j) {
                        successfulProps.add(properties[j]);
                    }
                }
                if (failedProps == null) {
                    int initialCapacity = properties.length - i;
                    failedProps = new ArrayList<Property>(initialCapacity);
                    failedValues = new ArrayList<BValue>(initialCapacity);
                    failureCauses = new ArrayList<Throwable>(initialCapacity);
                }
                failedProps.add(prop);
                failedValues.add(val);
                failureCauses.add(t);
            }
        }
        if (proxyTx != null) {
            try {
                proxyTx.commit();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!isTx) {
            if (successfulProps != null) {
                this.batchModified(successfulProps.toArray(new Property[successfulProps.size()]), context);
            } else {
                this.batchModified(properties, context);
            }
        }
        if (failedProps != null) {
            throw new BatchSetException(this.instance, failedProps.toArray(new Property[failedProps.size()]), failedValues.toArray(new BValue[failedValues.size()]), failureCauses.toArray(new Throwable[failureCauses.size()]));
        }
    }

    private void setPropValue(NProperty property, BValue value, Context context, boolean validate) {
        block10: {
            block9: {
                if (!property.isFrozen()) break block9;
                switch (property.typeAccess) {
                    case 0: {
                        this.setBoolean(property, ((BBoolean)value).getBoolean(), context, validate);
                        break block10;
                    }
                    case 2: {
                        this.setInt(property, ((BInteger)value).getInt(), context, validate);
                        break block10;
                    }
                    case 3: {
                        this.setLong(property, ((BLong)value).getLong(), context, validate);
                        break block10;
                    }
                    case 4: {
                        this.setFloat(property, ((BFloat)value).getFloat(), context, validate);
                        break block10;
                    }
                    case 5: {
                        this.setDouble(property, ((BDouble)value).getDouble(), context, validate);
                        break block10;
                    }
                    case 6: {
                        this.setString(property, ((BString)value).getString(), context, validate);
                        break block10;
                    }
                    case 7: {
                        BValue oldValue = this.get(property);
                        ComplexSlotMap oldMap = oldValue == null ? null : (ComplexSlotMap)oldValue.fw(1, null, null, null, null);
                        this.set(property, oldValue, oldMap, value, (ComplexSlotMap)value.fw(1, null, null, null, null), context, validate);
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            BValue oldValue = this.get(property);
            ComplexSlotMap oldMap = oldValue == null ? null : (ComplexSlotMap)oldValue.fw(1, null, null, null, null);
            this.set(property, oldValue, oldMap, value, (ComplexSlotMap)value.fw(1, null, null, null, null), context, validate);
        }
    }

    public final void set(Property property, BValue oldValue, ComplexSlotMap oldValueSlotMap, BValue newValue, ComplexSlotMap newValueSlotMap, Context context) {
        this.set(property, oldValue, oldValueSlotMap, newValue, newValueSlotMap, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set(Property property, BValue oldValue, ComplexSlotMap oldValueSlotMap, BValue newValue, ComplexSlotMap newValueSlotMap, Context context, boolean validate) {
        this.checkForIllegalPropertyArgument(property);
        try {
            BRelation relation;
            BComponent parent;
            BLink link;
            BComplex parentComplex;
            BComplex source;
            boolean isRelation;
            NProperty prop = (NProperty)property;
            boolean fireNavReplaced = false;
            if (newValue.getType().equals(BPassword.TYPE)) {
                BPassword orig = oldValue != null && oldValue.getType().equals(BPassword.TYPE) ? (BPassword)oldValue : BPassword.DEFAULT;
                newValue = PasswordUtil.toAcceptableForm((BPassword)newValue, orig);
                BPassword password = (BPassword)newValue;
                newValue = AccessController.doPrivileged(() -> PasswordUtil.assignPasswordOwner(password, this.instance, property));
            } else if (newValue instanceof BIDeferOwnership) {
                BIDeferOwnership defer = (BIDeferOwnership)((Object)newValue);
                AccessController.doPrivileged(() -> {
                    PasswordUtil.assignChildPasswordOwner(defer, this.instance);
                    return null;
                });
            }
            if (oldValue == newValue || oldValue != null && oldValue.isSimple() && oldValue.equals(newValue)) {
                if (newValue.isComponent()) {
                    ComponentSlotMap thisMap = (ComponentSlotMap)this;
                    ComponentSlotMap valueMap = (ComponentSlotMap)newValueSlotMap;
                    if (thisMap.getSpace() != valueMap.getSpace()) {
                        valueMap.mount(thisMap.getSpace(), context, null);
                    }
                }
                return;
            }
            if (context instanceof Transaction) {
                this.setTransaction(prop, newValue, (Transaction)context);
                return;
            }
            TrapCallbacks trap = this.getSpaceTrap();
            if (trap != null && trap.isTrapEnabled() && trap.trapSets() && context != Context.commit) {
                if (validate) {
                    newValue = this.validate(prop, newValue, context);
                }
                if (!this.setSpace(trap, prop, newValue, context)) {
                    return;
                }
            }
            BUser user = null;
            ComponentBase base = null;
            String auditOldValueStr = null;
            boolean isLink = this.instance instanceof BLink;
            boolean bl = isRelation = !isLink && this.instance instanceof BRelation;
            if (context != null && context.getUser() != null) {
                BComponent target;
                BLink link2;
                BComplex parentComplex2;
                user = context.getUser();
                base = this.getComponentBase(prop, context);
                if (base != null) {
                    user.checkWrite(base.component, base.propertyPath[0]);
                    if (oldValue instanceof BIProtected) {
                        user.check((BIProtected)((Object)oldValue), Flags.isOperator(this.instance, prop) ? BPermissions.operatorWrite : BPermissions.adminWrite);
                    }
                    auditOldValueStr = ComplexSlotMap.toAuditString(base, oldValue, context);
                }
                if (!user.getPermissions().isSuperUser() && property.getType().is(BPermissionsMap.TYPE)) {
                    BPermissionsMap newMap = (BPermissionsMap)newValue;
                    BPermissionsMap oldMap = (BPermissionsMap)oldValue;
                    this.checkEscalation(user, oldMap, newMap);
                }
                if (isLink && (parentComplex2 = (link2 = (BLink)this.instance).getParent()) instanceof BComponent && (target = (BComponent)parentComplex2).isRunning()) {
                    if (property.equals(BLink.sourceOrd)) {
                        source = (BComponent)((BOrd)newValue).get(target);
                        if (source instanceof BUser) {
                            user.checkWrite((BComponent)source, source.getSlot(link2.getSourceSlotName()));
                        } else {
                            user.checkRead((BComponent)source, source.getSlot(link2.getSourceSlotName()));
                        }
                    } else if (property.equals(BLink.sourceSlotName)) {
                        source = (BComponent)link2.getSourceOrd().get(target);
                        if (source instanceof BUser) {
                            user.checkWrite((BComponent)source, source.getSlot(newValue.toString(null)));
                        } else {
                            user.checkRead((BComponent)source, source.getSlot(newValue.toString(null)));
                        }
                    } else if (property.equals(BLink.targetSlotName)) {
                        user.checkWrite(target, target.getSlot(newValue.toString(null)));
                    }
                }
            }
            if (validate) {
                newValue = this.validate(prop, newValue, context);
            }
            this.serverCheckMinMaxFacetsOnNewPropValue(prop, newValue, context);
            boolean recordForComplex = false;
            BDataRecoveryComponentRecorder recorder = this.findRecoveryData(0, prop, context);
            BDataRecoveryComponentEvent event = null;
            if (recorder != null) {
                if (this.instance.isComponent()) {
                    event = BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), prop, newValue);
                } else {
                    recordForComplex = true;
                }
            }
            source = this.instance;
            synchronized (source) {
                try {
                    if (prop.isFrozen) {
                        this.s(prop.index, newValue);
                    } else {
                        prop.value = newValue;
                    }
                    if (!newValue.isSimple()) {
                        this.parent(prop, newValueSlotMap, context, null, recorder, event);
                        if (newValue.isComponent()) {
                            fireNavReplaced = true;
                        }
                    } else if (event != null) {
                        recorder.record(event, context);
                    }
                    if (oldValue != null && !oldValue.isSimple()) {
                        this.unparent(prop, oldValueSlotMap, context);
                        if (oldValue.isComponent()) {
                            fireNavReplaced = true;
                        }
                    }
                }
                catch (RuntimeException t) {
                    if (prop.isFrozen) {
                        this.s(prop.index, oldValue);
                    } else {
                        prop.value = oldValue;
                    }
                    throw t;
                }
            }
            if (recordForComplex) {
                this.modified(prop, context, recorder);
            } else {
                this.modified(prop, context, null);
            }
            if (isLink && (parentComplex = (link = (BLink)this.instance).getParent()) instanceof BComponent && (parent = (BComponent)parentComplex).isRunning()) {
                EngineUtil.deactivate(link);
                EngineUtil.activate(link);
            }
            if (isRelation && (parentComplex = (relation = (BRelation)this.instance).getParent()) instanceof BComponent && (parent = (BComponent)parentComplex).isRunning()) {
                EngineUtil.deactivate(relation);
                EngineUtil.activate(relation);
            }
            if (fireNavReplaced) {
                BComponent instance = this.instance.asComponent();
                BOrd ord = instance.getNavOrd();
                String name = prop.getName();
                if (ord != null) {
                    BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeReplaced(instance, name, null));
                }
            }
            if (auditOldValueStr != null) {
                this.audit(base, user, "Changed", auditOldValueStr, ComplexSlotMap.toAuditString(base, newValue, context));
            }
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    private final void checkEscalation(BUser user, BPermissionsMap oldMap, BPermissionsMap newMap) {
        if (newMap.isSuperUser() && !oldMap.isSuperUser()) {
            throw new PermissionException("SuperUser required");
        }
        for (int i = 1; i <= newMap.size(); ++i) {
            int changed = oldMap.getPermissions(i).getMask() ^ newMap.getPermissions(i).getMask();
            if ((~user.getPermissions().getPermissions(i).getMask() & changed) == 0) continue;
            throw new PermissionException(user.getPermissions().getPermissions(i) + " < " + newMap.getPermissions(i));
        }
    }

    public final void setBoolean(Property property, boolean newValue, Context context) {
        this.setBoolean(property, newValue, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBoolean(Property property, boolean newValue, Context context, boolean validate) {
        this.checkForIllegalPropertyArgument(property);
        try {
            IPropertyValidator validator;
            NProperty prop = (NProperty)property;
            boolean oldValue = prop.isFrozen ? this.gb(prop.index) : this.getBoolean(prop);
            if (oldValue == newValue) {
                return;
            }
            if (context instanceof Transaction) {
                this.setTransaction(prop, BBoolean.make(newValue), (Transaction)context);
                return;
            }
            TrapCallbacks trap = this.getSpaceTrap();
            if (trap != null && trap.isTrapEnabled() && trap.trapSets() && context != Context.commit) {
                BBoolean bv = BBoolean.make(newValue);
                if (validate) {
                    bv = this.validate(prop, bv, context).as(BBoolean.class);
                    newValue = bv.getBoolean();
                }
                if (!this.setSpace(trap, prop, bv, context)) {
                    return;
                }
            }
            BUser user = null;
            ComponentBase base = null;
            String auditOldValueStr = null;
            if (context != null && context.getUser() != null) {
                user = context.getUser();
                base = this.getComponentBase(prop, context);
                if (base != null) {
                    user.checkWrite(base.component, base.propertyPath[0]);
                    auditOldValueStr = ComplexSlotMap.toAuditString(base, BBoolean.make(oldValue), context);
                }
            }
            if (validate && this.setRequiresValidation(context) && (validator = this.instance.getPropertyValidator(prop, context)) != null) {
                BBoolean newBoxedVal = validator.adjustPendingSetValue(this.instance, prop, BBoolean.make(newValue), context).as(BBoolean.class);
                newValue = newBoxedVal.getBoolean();
                validator.validateSet(this.instance, prop, newBoxedVal, context);
            }
            boolean recordForComplex = false;
            BDataRecoveryComponentRecorder recorder = this.findRecoveryData(0, prop, context);
            if (recorder != null) {
                if (this.instance.isComponent()) {
                    recorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), prop, BBoolean.make(newValue)), context);
                } else {
                    recordForComplex = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (prop.isFrozen) {
                    this.sb(prop.index, newValue);
                } else {
                    prop.value = BBoolean.make(newValue);
                }
            }
            if (recordForComplex) {
                this.modified(prop, context, recorder);
            } else {
                this.modified(prop, context, null);
            }
            if (auditOldValueStr != null) {
                this.audit(base, user, "Changed", auditOldValueStr, ComplexSlotMap.toAuditString(base, BBoolean.make(newValue), context));
            }
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final void setInt(Property property, int newValue, Context context) {
        this.setInt(property, newValue, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInt(Property property, int newValue, Context context, boolean validate) {
        this.checkForIllegalPropertyArgument(property);
        try {
            IPropertyValidator validator;
            NProperty prop = (NProperty)property;
            int oldValue = prop.isFrozen ? this.gi(prop.index) : this.getInt(prop);
            if (oldValue == newValue) {
                return;
            }
            BInteger newIntVal = BInteger.make(newValue);
            if (context instanceof Transaction) {
                this.setTransaction(prop, newIntVal, (Transaction)context);
                return;
            }
            TrapCallbacks trap = this.getSpaceTrap();
            if (trap != null && trap.isTrapEnabled() && trap.trapSets() && context != Context.commit) {
                if (validate) {
                    newIntVal = this.validate(prop, newIntVal, context).as(BInteger.class);
                    newValue = newIntVal.getInt();
                }
                if (!this.setSpace(trap, prop, newIntVal, context)) {
                    return;
                }
            }
            BUser user = null;
            ComponentBase base = null;
            String auditOldValueStr = null;
            if (context != null && context.getUser() != null) {
                user = context.getUser();
                base = this.getComponentBase(prop, context);
                if (base != null) {
                    user.checkWrite(base.component, base.propertyPath[0]);
                    auditOldValueStr = ComplexSlotMap.toAuditString(base, BInteger.make(oldValue), context);
                }
            }
            if (validate && this.setRequiresValidation(context) && (validator = this.instance.getPropertyValidator(prop, context)) != null) {
                newIntVal = validator.adjustPendingSetValue(this.instance, prop, newIntVal, context).as(BInteger.class);
                newValue = newIntVal.getInt();
                validator.validateSet(this.instance, prop, newIntVal, context);
            }
            this.serverCheckMinMaxFacetsOnNewPropValue(prop, newIntVal, context);
            boolean recordForComplex = false;
            BDataRecoveryComponentRecorder recorder = this.findRecoveryData(0, prop, context);
            if (recorder != null) {
                if (this.instance.isComponent()) {
                    recorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), prop, newIntVal), context);
                } else {
                    recordForComplex = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (prop.isFrozen) {
                    this.si(prop.index, newValue);
                } else {
                    prop.value = newIntVal;
                }
            }
            if (recordForComplex) {
                this.modified(prop, context, recorder);
            } else {
                this.modified(prop, context, null);
            }
            if (auditOldValueStr != null) {
                this.audit(base, user, "Changed", auditOldValueStr, ComplexSlotMap.toAuditString(base, newIntVal, context));
            }
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final void setLong(Property property, long newValue, Context context) {
        this.setLong(property, newValue, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLong(Property property, long newValue, Context context, boolean validate) {
        this.checkForIllegalPropertyArgument(property);
        try {
            IPropertyValidator validator;
            NProperty prop = (NProperty)property;
            long oldValue = prop.isFrozen ? this.gj(prop.index) : this.getLong(prop);
            if (oldValue == newValue) {
                return;
            }
            BLong newLongVal = BLong.make(newValue);
            if (context instanceof Transaction) {
                this.setTransaction(prop, newLongVal, (Transaction)context);
                return;
            }
            TrapCallbacks trap = this.getSpaceTrap();
            if (trap != null && trap.isTrapEnabled() && trap.trapSets() && context != Context.commit) {
                if (validate) {
                    newLongVal = this.validate(prop, newLongVal, context).as(BLong.class);
                    newValue = newLongVal.getLong();
                }
                if (!this.setSpace(trap, prop, newLongVal, context)) {
                    return;
                }
            }
            BUser user = null;
            ComponentBase base = null;
            String auditOldValueStr = null;
            if (context != null && context.getUser() != null) {
                user = context.getUser();
                base = this.getComponentBase(prop, context);
                if (base != null) {
                    user.checkWrite(base.component, base.propertyPath[0]);
                    auditOldValueStr = ComplexSlotMap.toAuditString(base, BLong.make(oldValue), context);
                }
            }
            if (validate && this.setRequiresValidation(context) && (validator = this.instance.getPropertyValidator(prop, context)) != null) {
                newLongVal = validator.adjustPendingSetValue(this.instance, prop, newLongVal, context).as(BLong.class);
                newValue = newLongVal.getLong();
                validator.validateSet(this.instance, prop, newLongVal, context);
            }
            this.serverCheckMinMaxFacetsOnNewPropValue(prop, newLongVal, context);
            boolean recordForComplex = false;
            BDataRecoveryComponentRecorder recorder = this.findRecoveryData(0, prop, context);
            if (recorder != null) {
                if (this.instance.isComponent()) {
                    recorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), prop, newLongVal), context);
                } else {
                    recordForComplex = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (prop.isFrozen) {
                    this.sj(prop.index, newValue);
                } else {
                    prop.value = newLongVal;
                }
            }
            if (recordForComplex) {
                this.modified(prop, context, recorder);
            } else {
                this.modified(prop, context, null);
            }
            if (auditOldValueStr != null) {
                this.audit(base, user, "Changed", auditOldValueStr, ComplexSlotMap.toAuditString(base, newLongVal, context));
            }
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final void setFloat(Property property, float newValue, Context context) {
        this.setFloat(property, newValue, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFloat(Property property, float newValue, Context context, boolean validate) {
        this.checkForIllegalPropertyArgument(property);
        try {
            IPropertyValidator validator;
            NProperty prop = (NProperty)property;
            float oldValue = prop.isFrozen ? this.gf(prop.index) : this.getFloat(prop);
            if (BFloat.equals(oldValue, newValue)) {
                return;
            }
            BFloat newFloatVal = BFloat.make(newValue);
            if (context instanceof Transaction) {
                this.setTransaction(prop, newFloatVal, (Transaction)context);
                return;
            }
            TrapCallbacks trap = this.getSpaceTrap();
            if (trap != null && trap.isTrapEnabled() && trap.trapSets() && context != Context.commit) {
                if (validate) {
                    newFloatVal = this.validate(prop, newFloatVal, context).as(BFloat.class);
                    newValue = newFloatVal.getFloat();
                }
                if (!this.setSpace(trap, prop, newFloatVal, context)) {
                    return;
                }
            }
            BUser user = null;
            ComponentBase base = null;
            String auditOldValueStr = null;
            if (context != null && context.getUser() != null) {
                user = context.getUser();
                base = this.getComponentBase(prop, context);
                if (base != null) {
                    user.checkWrite(base.component, base.propertyPath[0]);
                    auditOldValueStr = ComplexSlotMap.toAuditString(base, BFloat.make(oldValue), context);
                }
            }
            if (validate && this.setRequiresValidation(context) && (validator = this.instance.getPropertyValidator(prop, context)) != null) {
                newFloatVal = validator.adjustPendingSetValue(this.instance, prop, newFloatVal, context).as(BFloat.class);
                newValue = newFloatVal.getFloat();
                validator.validateSet(this.instance, prop, newFloatVal, context);
            }
            this.serverCheckMinMaxFacetsOnNewPropValue(prop, newFloatVal, context);
            boolean recordForComplex = false;
            BDataRecoveryComponentRecorder recorder = this.findRecoveryData(0, prop, context);
            if (recorder != null) {
                if (this.instance.isComponent()) {
                    recorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), prop, newFloatVal), context);
                } else {
                    recordForComplex = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (prop.isFrozen) {
                    this.sf(prop.index, newValue);
                } else {
                    prop.value = newFloatVal;
                }
            }
            if (recordForComplex) {
                this.modified(prop, context, recorder);
            } else {
                this.modified(prop, context, null);
            }
            if (auditOldValueStr != null) {
                this.audit(base, user, "Changed", auditOldValueStr, ComplexSlotMap.toAuditString(base, newFloatVal, context));
            }
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final void setDouble(Property property, double newValue, Context context) {
        this.setDouble(property, newValue, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDouble(Property property, double newValue, Context context, boolean validate) {
        this.checkForIllegalPropertyArgument(property);
        try {
            IPropertyValidator validator;
            NProperty prop = (NProperty)property;
            double oldValue = prop.isFrozen ? this.gd(prop.index) : this.getDouble(prop);
            if (BDouble.equals(oldValue, newValue)) {
                return;
            }
            BDouble newDoubleVal = BDouble.make(newValue);
            if (context instanceof Transaction) {
                this.setTransaction(prop, newDoubleVal, (Transaction)context);
                return;
            }
            TrapCallbacks trap = this.getSpaceTrap();
            if (trap != null && trap.isTrapEnabled() && trap.trapSets() && context != Context.commit) {
                if (validate) {
                    newDoubleVal = this.validate(prop, newDoubleVal, context).as(BDouble.class);
                    newValue = newDoubleVal.getDouble();
                }
                if (!this.setSpace(trap, prop, newDoubleVal, context)) {
                    return;
                }
            }
            BUser user = null;
            ComponentBase base = null;
            String auditOldValueStr = null;
            if (context != null && context.getUser() != null) {
                user = context.getUser();
                base = this.getComponentBase(prop, context);
                if (base != null) {
                    user.checkWrite(base.component, base.propertyPath[0]);
                    auditOldValueStr = ComplexSlotMap.toAuditString(base, BDouble.make(oldValue), context);
                }
            }
            if (validate && this.setRequiresValidation(context) && (validator = this.instance.getPropertyValidator(prop, context)) != null) {
                newDoubleVal = validator.adjustPendingSetValue(this.instance, prop, newDoubleVal, context).as(BDouble.class);
                newValue = newDoubleVal.getDouble();
                validator.validateSet(this.instance, prop, newDoubleVal, context);
            }
            this.serverCheckMinMaxFacetsOnNewPropValue(prop, newDoubleVal, context);
            boolean recordForComplex = false;
            BDataRecoveryComponentRecorder recorder = this.findRecoveryData(0, prop, context);
            if (recorder != null) {
                if (this.instance.isComponent()) {
                    recorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), prop, newDoubleVal), context);
                } else {
                    recordForComplex = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (prop.isFrozen) {
                    this.sd(prop.index, newValue);
                } else {
                    prop.value = newDoubleVal;
                }
            }
            if (recordForComplex) {
                this.modified(prop, context, recorder);
            } else {
                this.modified(prop, context, null);
            }
            if (auditOldValueStr != null) {
                this.audit(base, user, "Changed", auditOldValueStr, ComplexSlotMap.toAuditString(base, newDoubleVal, context));
            }
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    public final void setString(Property property, String newValue, Context context) {
        this.setString(property, newValue, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setString(Property property, String newValue, Context context, boolean validate) {
        this.checkForIllegalPropertyArgument(property);
        try {
            IPropertyValidator validator;
            NProperty prop = (NProperty)property;
            String oldValue = prop.isFrozen ? this.gs(prop.index) : this.getString(prop);
            if (newValue.equals(oldValue)) {
                return;
            }
            BString newStringVal = BString.make(newValue);
            if (context instanceof Transaction) {
                this.setTransaction(prop, newStringVal, (Transaction)context);
                return;
            }
            TrapCallbacks trap = this.getSpaceTrap();
            if (trap != null && trap.isTrapEnabled() && trap.trapSets() && context != Context.commit) {
                if (validate) {
                    newStringVal = this.validate(prop, newStringVal, context).as(BString.class);
                    newValue = newStringVal.getString();
                }
                if (!this.setSpace(trap, prop, newStringVal, context)) {
                    return;
                }
            }
            BUser user = null;
            ComponentBase base = null;
            String auditOldValueStr = null;
            if (context != null && context.getUser() != null) {
                user = context.getUser();
                base = this.getComponentBase(prop, context);
                if (base != null) {
                    user.checkWrite(base.component, base.propertyPath[0]);
                    auditOldValueStr = oldValue;
                }
            }
            if (validate && this.setRequiresValidation(context) && (validator = this.instance.getPropertyValidator(prop, context)) != null) {
                newStringVal = validator.adjustPendingSetValue(this.instance, prop, newStringVal, context).as(BString.class);
                newValue = newStringVal.getString();
                validator.validateSet(this.instance, prop, newStringVal, context);
            }
            this.serverCheckMinMaxFacetsOnNewPropValue(prop, newStringVal, context);
            boolean recordForComplex = false;
            BDataRecoveryComponentRecorder recorder = this.findRecoveryData(0, prop, context);
            if (recorder != null) {
                if (this.instance.isComponent()) {
                    recorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance.asComponent(), prop, newStringVal), context);
                } else {
                    recordForComplex = true;
                }
            }
            BComplex bComplex = this.instance;
            synchronized (bComplex) {
                if (prop.isFrozen) {
                    this.ss(prop.index, newValue);
                } else {
                    prop.value = newStringVal;
                }
            }
            if (recordForComplex) {
                this.modified(prop, context, recorder);
            } else {
                this.modified(prop, context, null);
            }
            if (auditOldValueStr != null) {
                this.audit(base, user, "Changed", auditOldValueStr, newValue);
            }
        }
        catch (UnhandledSlotException e) {
            throw new NoSuchSlotException(this.getType(), property);
        }
    }

    final void setTransaction(NProperty prop, BValue value, Transaction tx) {
        ComponentBase b = this.getComponentBase(prop, tx);
        if (b == null) {
            throw new IllegalStateException("Cannot call set() on unmounted struct using transaction: " + this.instance.toDebugString());
        }
        tx.set(b.component, b.propertyPath, value, null);
    }

    final boolean setSpace(TrapCallbacks trap, NProperty prop, BValue value, Context context) {
        ComponentBase b = this.getComponentBase(prop, context);
        return trap.set(b.component, b.propertyPath, value, context);
    }

    public static ComponentBase getComponentBase(BComplex complex, Property prop) {
        return ComplexSlotMap.getSlotMap(complex).getComponentBase(prop);
    }

    final ComponentBase getComponentBase(Property prop) {
        Property[] paths = new Property[32];
        int x = paths.length - 1;
        paths[x--] = prop;
        ComplexSlotMap p = this;
        while (!(p instanceof ComponentSlotMap)) {
            if (p == null) {
                return null;
            }
            paths[x--] = p.propertyInParent;
            p = p.parent;
        }
        Property[] propPath = new Property[paths.length - x - 1];
        System.arraycopy(paths, x + 1, propPath, 0, propPath.length);
        ComponentBase base = new ComponentBase();
        base.component = p.instance.asComponent();
        base.propertyPath = propPath;
        return base;
    }

    final ComponentBase getComponentBase(Property prop, Context cx) {
        ComponentBase base = this.getComponentBase(prop);
        if (base != null) {
            base.cx = cx;
        }
        return base;
    }

    void modified(NProperty property, Context context, BDataRecoveryComponentRecorder recorder) {
        if (this.parent != null) {
            BDataRecoveryComponentRecorder myRecorder = recorder;
            if (recorder != null) {
                int[] slotIndexes = null;
                boolean propFrozen = property.isFrozen();
                boolean parentPropFrozen = this.propertyInParent.isFrozen();
                boolean allFrozen = propFrozen && parentPropFrozen;
                StringBuffer sb = null;
                if (allFrozen) {
                    try {
                        int idx1 = this.propertyInParent.index;
                        int idx2 = property.index;
                        slotIndexes = new int[]{idx1, idx2};
                    }
                    catch (Throwable t) {
                        allFrozen = false;
                        sb = new StringBuffer("slot:");
                        sb.append(this.propertyInParent.getName());
                    }
                } else if (propFrozen) {
                    allFrozen = false;
                    try {
                        int idx = property.index;
                        slotIndexes = new int[]{idx};
                    }
                    catch (Throwable t) {
                        propFrozen = false;
                        allFrozen = false;
                    }
                    sb = new StringBuffer("slot:");
                    sb.append(this.propertyInParent.getName());
                }
                ComplexSlotMap ancestor = this.parent;
                while (ancestor != null && !(ancestor.instance instanceof BComponent)) {
                    boolean bl = allFrozen = allFrozen && ancestor.propertyInParent.isFrozen();
                    if (allFrozen) {
                        try {
                            int idx = ancestor.propertyInParent.index;
                            int currentSize = slotIndexes.length;
                            int newSize = currentSize + 1;
                            int[] temp = new int[newSize];
                            System.arraycopy(slotIndexes, 0, temp, 1, currentSize);
                            temp[0] = idx;
                            slotIndexes = temp;
                        }
                        catch (Throwable t) {
                            allFrozen = false;
                        }
                    }
                    if (!allFrozen) {
                        if (sb == null) {
                            sb = new StringBuffer("slot:");
                            sb.append(ancestor.propertyInParent.getName());
                        } else {
                            StringBuffer sb2 = new StringBuffer(ancestor.propertyInParent.getName());
                            sb2.append('/');
                            sb.insert(5, sb2.toString());
                        }
                    }
                    ancestor = ancestor.parent;
                }
                if (ancestor != null) {
                    BOrd ordInSpace = ((BComponent)ancestor.instance).getOrdInSpace();
                    BOrd ord = sb != null ? BOrd.make(ordInSpace, sb.toString()) : ordInSpace;
                    recorder.record(BDataRecoveryComponentEvent.makeChangeEvent(this.instance, ord, slotIndexes, property, this.instance.get(property)), context);
                    myRecorder = null;
                }
            }
            this.parent.modified(this.propertyInParent, context, myRecorder);
        }
    }

    void batchModified(Property[] properties, Context context) {
    }

    BDataRecoveryComponentRecorder findRecoveryData(int eventId, Slot slot, Context context) {
        int flags;
        BDataRecoveryComponentRecorder recorder = null;
        if (this.parent != null) {
            recorder = this.parent.findRecoveryData(eventId, this.propertyInParent, context);
        }
        if (recorder != null && slot != null && !recorder.isEventCritical(eventId, this.instance, slot, flags = this.getFlags(slot), context)) {
            recorder = null;
        }
        return recorder;
    }

    BDataRecoveryComponentRecorder findRecoveryData(int eventId, Slot slot, int flags, Context context) {
        BDataRecoveryComponentRecorder recorder = null;
        if (this.parent != null) {
            recorder = this.parent.findRecoveryData(eventId, this.propertyInParent, this.parent.getFlags(this.propertyInParent), context);
        }
        if (recorder != null && slot != null && !recorder.isEventCritical(eventId, this.instance, slot, flags, context)) {
            recorder = null;
        }
        return recorder;
    }

    public int getFlags(Slot slot) {
        return ((NSlot)slot).flags;
    }

    public void setFlags(Slot s, int f, Context c) {
        throw new UnsupportedOperationException("setFlags() not supported on BStruct");
    }

    public BComplex getParent() {
        return this.parent == null ? null : this.parent.instance;
    }

    public Property getPropertyInParent() {
        return this.propertyInParent;
    }

    void parent(NProperty property, ComplexSlotMap newValueMap, Context context, TransferListener listener, BDataRecoveryComponentRecorder recorder, BDataRecoveryComponentEvent event) {
        if (newValueMap.parent != null) {
            throw new AlreadyParentedException(property + " <- " + newValueMap.instance);
        }
        newValueMap.parent = this;
        newValueMap.propertyInParent = property;
        if (recorder != null && event != null) {
            recorder.record(event, context);
        }
    }

    void unparent(NProperty property, ComplexSlotMap map, Context context) {
        map.parent = null;
        map.propertyInParent = null;
    }

    public TrapCallbacks getSpaceTrap() {
        return this.parent == null ? null : this.parent.getSpaceTrap();
    }

    public BComponentSpace getSpace() {
        return this.parent == null ? null : this.parent.getSpace();
    }

    static SlotPath getSlotPathFromContext(Context cx) {
        try {
            BString slotPathScheme = (BString)cx.getFacet("auditTargetSlotPathScheme");
            BString slotPathBody = (BString)cx.getFacet("auditTargetSlotPathBody");
            if (slotPathBody != null) {
                if (slotPathScheme != null) {
                    return new SlotPath(slotPathScheme.getString(), slotPathBody.getString());
                }
                return new SlotPath(slotPathBody.getString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static OrdQuery getAuditSlotPath(BComponent comp, Context cx) {
        String navOrdStr;
        BOrd navOrd;
        if (comp instanceof BVirtualComponent && (navOrd = comp.getNavOrd()) != null && (navOrdStr = navOrd.relativizeToSession().toString()).startsWith("station:|slot:")) {
            String navOrdPathStr = navOrdStr.substring(14);
            return new BasicQuery("slot", navOrdPathStr);
        }
        SlotPath slotPath = comp.getSlotPath();
        if (slotPath == null && cx != null) {
            slotPath = ComplexSlotMap.getSlotPathFromContext(cx);
        }
        return slotPath;
    }

    public void audit(ComponentBase base, BUser user, String op, String oldValue, String value) {
        String slotName;
        BComponent component = base.component;
        OrdQuery targetPath = ComplexSlotMap.getAuditSlotPath(component, base.cx);
        if (targetPath == null) {
            return;
        }
        Property[] path = base.propertyPath;
        if (Flags.isNoAudit(component, path[0])) {
            return;
        }
        if (path.length == 1) {
            slotName = path[0].getName();
        } else {
            StringBuilder s = new StringBuilder();
            for (Property prop : path) {
                s.append(prop.getName()).append('/');
            }
            s.setLength(s.length() - 1);
            slotName = s.toString();
        }
        this.audit(targetPath, user, op, slotName, oldValue, value);
    }

    public void audit(OrdQuery targetPath, BUser user, String op, String slotName, String oldValue, String value) {
        try {
            Auditor auditor = Nre.auditor;
            if (auditor != null && targetPath != null) {
                if (targetPath.getScheme().equals("slot")) {
                    auditor.audit(new AuditEvent(op, targetPath.getBody(), slotName, oldValue, value, user.getUsername()));
                } else {
                    auditor.audit(new AuditEvent(op, targetPath.toString(), slotName, oldValue, value, user.getUsername()));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static String toAuditString(ComponentBase base, BValue v, Context cx) {
        try {
            return ComplexSlotMap.toAuditString(base.component, base.propertyPath[0], v, cx);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public static String toAuditString(BComponent c, Slot slot, BValue v, Context cx) {
        try {
            BFacets facets;
            if (v == null) {
                return null;
            }
            if (c != null && slot != null && (facets = c.getSlotFacets(slot)) != null && !facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            return v.toString(cx);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public static ComplexSlotMap getSlotMap(BObject v) {
        return (ComplexSlotMap)v.fw(1, null, null, null, null);
    }

    public static ComponentSlotMap getComponentSlotMap(BObject v) {
        return (ComponentSlotMap)v.fw(1, null, null, null, null);
    }

    boolean setRequiresValidation(Context context) {
        BComponentSpace space;
        if (context != null) {
            if (context == Context.commit || context == Context.decoding || context == Context.copying || context == Context.skipValidate) {
                return false;
            }
            if (context == Context.forceValidate || context.getUser() != null || context.getFacets() != null && context.getFacets().gets("username", null) != null) {
                return true;
            }
        }
        if ((space = this.getSpace()) != null) {
            if (space.isProxyComponentSpace()) {
                return true;
            }
            if (BOG_SPACE_TYPE_INFO == null) {
                BOG_SPACE_TYPE_INFO = BTypeSpec.make("file", "BogSpace").getTypeInfo();
            }
            return space.getType().is(BOG_SPACE_TYPE_INFO);
        }
        return false;
    }

    BValue validate(Property property, BValue value, Context context) {
        IPropertyValidator validator;
        if (this.setRequiresValidation(context) && (validator = this.instance.getPropertyValidator(property, context)) != null) {
            BValue val = validator.adjustPendingSetValue(this.instance, property, value, context);
            validator.validateSet(this.instance, property, val, context);
            return val;
        }
        return value;
    }

    private void checkForIllegalPropertyArgument(Property prop) {
        if (prop != null && prop.isDynamic() && prop != this.getSlot(prop.getName())) {
            SlotPath path;
            Property p;
            BComplex comp;
            StringBuilder sb = new StringBuilder();
            for (comp = this.instance; comp != null && !comp.isComponent() && (p = comp.getPropertyInParent()) != null; comp = comp.getParent()) {
                sb.insert(0, p.getName()).insert(0, '/');
            }
            SlotPath slotPath = path = comp instanceof BComponent ? comp.asComponent().getSlotPath() : null;
            if (path != null) {
                sb.insert(0, path.getBody());
            } else {
                sb.setLength(0);
                sb.append(this.instance.toDebugString());
            }
            throw new IllegalArgumentException("Illegal dynamic property argument. Submitted property instance named '" + prop.getName() + "' does not belong to the following complex instance: " + sb.toString());
        }
    }

    private void serverCheckMinMaxFacetsOnNewPropValue(Property prop, BValue newValue, Context cx) {
        if (!ObjectUtil.SERVER_MIN_MAX_CHECK_DISABLED && prop != null && cx != null && cx.getUser() != null) {
            BFacets propFacets = this.instance instanceof BStatusValue ? BFacets.make(((BStatusValue)this.instance).getStatusValueFacets(), this.instance.getSlotFacets(prop)) : this.instance.getSlotFacets(prop);
            ObjectUtil.checkMinMaxFacetsOnValue(newValue, propFacets, cx);
        }
    }

    public Object getHandle() {
        throw this.notComponent();
    }

    public SlotPath getSlotPath() {
        throw this.notComponent();
    }

    public BValue invoke(Action a, BValue arg, Context context) {
        throw this.notComponent();
    }

    public void fire(Topic t, BValue evt, Context context) {
        throw this.notComponent();
    }

    public Property add(String n, int f, BValue v, ComplexSlotMap sm, BFacets facets, Context c, TransferListener l) {
        throw this.notComponent();
    }

    public BValue remove(Property s, Context c) {
        throw this.notComponent();
    }

    public void rename(Property s, String n, Context c) {
        throw this.notComponent();
    }

    public void setFacets(Slot s, BFacets f, Context c) {
        throw this.notComponent();
    }

    public void reorderToTop(Property prop, Context c) {
        throw this.notComponent();
    }

    public void reorderToBottom(Property prop, Context c) {
        throw this.notComponent();
    }

    public void reorder(Property[] props, Context c) {
        throw this.notComponent();
    }

    public void start() {
        throw this.notComponent();
    }

    public void stop() {
        throw this.notComponent();
    }

    public boolean isRunning() {
        throw this.notComponent();
    }

    public int getKnobCount() {
        throw this.notComponent();
    }

    public NKnob[] getKnobs() {
        throw this.notComponent();
    }

    public int getRelationKnobCount() {
        throw this.notComponent();
    }

    public NRelationKnob[] getRelationKnobs() {
        throw this.notComponent();
    }

    public NRelationKnob getRelationKnob(String id) {
        throw this.notComponent();
    }

    public NKnob[] getKnobs(Slot slot) {
        throw this.notComponent();
    }

    public boolean isSubscribed() {
        throw this.notComponent();
    }

    public Subscriber[] getSubscribers() {
        throw this.notComponent();
    }

    public boolean isPermanentlySubscribed() {
        throw this.notComponent();
    }

    public void setPermanentlySubscribed(boolean subscribed) {
        throw this.notComponent();
    }

    public boolean isPendingMove() {
        throw this.notComponent();
    }

    public void setPendingMove(boolean pm) {
        throw this.notComponent();
    }

    public BPermissions getCachedPermissions() {
        throw this.notComponent();
    }

    public BCategoryMask getAppliedCategoryMask() {
        throw this.notComponent();
    }

    public BCategoryMask getCategoryMask() {
        throw this.notComponent();
    }

    public void setCategoryMask(BCategoryMask mask, Context cx) {
        throw this.notComponent();
    }

    private IllegalStateException notComponent() {
        return new IllegalStateException("Not a BComponent");
    }

    public abstract BComplex newBComplexInstance() throws NoSuchMethodError;

    public abstract ComplexSlotMap newSlotMapInstance();

    public BValue g(int index) {
        throw new UnhandledSlotException();
    }

    public boolean gb(int index) {
        throw new UnhandledSlotException();
    }

    public int gi(int index) {
        throw new UnhandledSlotException();
    }

    public long gj(int index) {
        throw new UnhandledSlotException();
    }

    public float gf(int index) {
        throw new UnhandledSlotException();
    }

    public double gd(int index) {
        throw new UnhandledSlotException();
    }

    public String gs(int index) {
        throw new UnhandledSlotException();
    }

    public void s(int index, BValue value) {
        throw new UnhandledSlotException();
    }

    public void sb(int index, boolean value) {
        throw new UnhandledSlotException();
    }

    public void si(int index, int value) {
        throw new UnhandledSlotException();
    }

    public void sj(int index, long value) {
        throw new UnhandledSlotException();
    }

    public void sf(int index, float value) {
        throw new UnhandledSlotException();
    }

    public void sd(int index, double value) {
        throw new UnhandledSlotException();
    }

    public void ss(int index, String value) {
        throw new UnhandledSlotException();
    }

    public BValue invoke(int index, BComponent target, BValue arg, Context cx) {
        throw new UnhandledSlotException();
    }

    public static final class ComponentBase {
        public BComponent component;
        public Property[] propertyPath;
        Context cx;
    }
}

