/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.asm.Assembler;
import com.tridium.asm.AttributeInfo;
import com.tridium.asm.Buffer;
import com.tridium.asm.Code;
import com.tridium.asm.ConstantPool;
import com.tridium.asm.FieldInfo;
import com.tridium.asm.Jvm;
import com.tridium.asm.MethodInfo;
import com.tridium.asm.OpCodes;
import com.tridium.sys.schema.NAction;
import com.tridium.sys.schema.NProperty;
import com.tridium.sys.schema.NSlot;
import javax.baja.nre.util.TextUtil;

class Compiler
implements OpCodes {
    int init;
    int exceptionCls;
    int exceptionCtor;
    int npropCls;
    int npropGetDef;
    int bbooleanCls;
    int bintegerCls;
    int blongCls;
    int bfloatCls;
    int bdoubleCls;
    int bstringCls;
    int bbooleanMake;
    int bintegerMake;
    int blongMake;
    int bfloatMake;
    int bdoubleMake;
    int bstringMake;
    int getBoolean;
    int getInt;
    int getLong;
    int getFloat;
    int getDouble;
    int getString;
    SwitchCode g = null;
    SwitchCode s = null;
    SwitchCode gb = null;
    SwitchCode sb = null;
    SwitchCode gi = null;
    SwitchCode si = null;
    SwitchCode gj = null;
    SwitchCode sj = null;
    SwitchCode gf = null;
    SwitchCode sf = null;
    SwitchCode gd = null;
    SwitchCode sd = null;
    SwitchCode gs = null;
    SwitchCode ss = null;
    SwitchCode invoke = null;
    Assembler asm;
    ConstantPool cp;
    int complexClass;
    NSlot[] slots;
    int[] propFields;

    Compiler(String superClass, String className, Class<?> complexClass, NSlot[] slots) {
        int flags = 33;
        this.asm = new Assembler(className, superClass, flags, null);
        this.cp = this.asm.cp;
        this.slots = slots;
        this.complexClass = this.cp.cls(complexClass);
    }

    Buffer compile() {
        this.genFields();
        this.genConstructor();
        this.genNewSlotMapInstance();
        this.genNewBComplexInstance();
        this.genAccessors();
        this.addAccessors();
        this.asm.addAttribute(new AttributeInfo(this.asm, "SourceFile", "AutoGenerated"));
        return this.asm.compile();
    }

    private void genFields() {
        int flags = 2;
        this.propFields = new int[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            if (!this.slots[i].isProperty()) continue;
            NProperty prop = (NProperty)this.slots[i];
            String name = "p" + i;
            String descr = null;
            switch (prop.typeAccess) {
                case 0: {
                    descr = "Z";
                    break;
                }
                case 2: {
                    descr = "I";
                    break;
                }
                case 3: {
                    descr = "J";
                    break;
                }
                case 4: {
                    descr = "F";
                    break;
                }
                case 5: {
                    descr = "D";
                    break;
                }
                case 6: {
                    descr = "Ljava/lang/String;";
                    break;
                }
                case 7: {
                    descr = "Ljavax/baja/sys/BValue;";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            FieldInfo fi = new FieldInfo(this.asm, "p" + i, descr, flags);
            this.asm.addField(fi);
            this.propFields[i] = this.cp.field(fi);
        }
    }

    private void genConstructor() {
        Code c = new Code(this.asm);
        c.add(42);
        c.add(183, c.cp.method(this.asm.superClass, this.init(), "()V"));
        c.add(177);
        this.asm.addMethod(new MethodInfo(this.asm, this.init(), "()V", 1, c));
    }

    private void genNewSlotMapInstance() {
        int ctor = this.cp.method(this.asm.thisClass, this.init(), "()V");
        Code c = new Code(this.asm);
        c.add(187, this.asm.thisClass);
        c.add(89);
        c.add(183, ctor);
        c.add(176);
        this.asm.addMethod(new MethodInfo(this.asm, "newSlotMapInstance", "()Lcom/tridium/sys/schema/ComplexSlotMap;", 1, c));
    }

    private void genNewBComplexInstance() {
        int ctor = this.cp.method(this.complexClass, this.init(), "()V");
        Code c = new Code(this.asm);
        c.add(187, this.complexClass);
        c.add(89);
        c.add(183, ctor);
        c.add(176);
        this.asm.addMethod(new MethodInfo(this.asm, "newBComplexInstance", "()Ljavax/baja/sys/BComplex;", 1, c));
    }

    private void genAccessors() {
        block9: for (int i = 0; i < this.slots.length; ++i) {
            NSlot slot = this.slots[i];
            if (slot.isTopic()) continue;
            if (slot.isAction()) {
                if (this.invoke == null) {
                    this.invoke = this.beginAccessorMethod();
                }
                this.genInvoke((NAction)slot, this.invoke);
                continue;
            }
            NProperty prop = (NProperty)slot;
            if (this.g == null) {
                this.g = this.beginAccessorMethod();
                this.s = this.beginAccessorMethod();
            }
            switch (prop.getTypeAccess()) {
                case 0: {
                    if (this.gb == null) {
                        this.gb = this.beginAccessorMethod();
                        this.sb = this.beginAccessorMethod();
                    }
                    this.genGetBoolean(prop, this.g, this.gb);
                    this.genSetBoolean(prop, this.s, this.sb);
                    continue block9;
                }
                case 2: {
                    if (this.gi == null) {
                        this.gi = this.beginAccessorMethod();
                        this.si = this.beginAccessorMethod();
                    }
                    this.genGetInt(prop, this.g, this.gi);
                    this.genSetInt(prop, this.s, this.si);
                    continue block9;
                }
                case 3: {
                    if (this.gj == null) {
                        this.gj = this.beginAccessorMethod();
                        this.sj = this.beginAccessorMethod();
                    }
                    this.genGetLong(prop, this.g, this.gj);
                    this.genSetLong(prop, this.s, this.sj);
                    continue block9;
                }
                case 4: {
                    if (this.gf == null) {
                        this.gf = this.beginAccessorMethod();
                        this.sf = this.beginAccessorMethod();
                    }
                    this.genGetFloat(prop, this.g, this.gf);
                    this.genSetFloat(prop, this.s, this.sf);
                    continue block9;
                }
                case 5: {
                    if (this.gd == null) {
                        this.gd = this.beginAccessorMethod();
                        this.sd = this.beginAccessorMethod();
                    }
                    this.genGetDouble(prop, this.g, this.gd);
                    this.genSetDouble(prop, this.s, this.sd);
                    continue block9;
                }
                case 6: {
                    if (this.gs == null) {
                        this.gs = this.beginAccessorMethod();
                        this.ss = this.beginAccessorMethod();
                    }
                    this.genGetString(prop, this.g, this.gs);
                    this.genSetString(prop, this.s, this.ss);
                    continue block9;
                }
                case 7: {
                    this.genGetGeneric(prop, this.g);
                    this.genSetGeneric(prop, this.s);
                }
            }
        }
    }

    private void addAccessors() {
        int flags = 17;
        if (this.g != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "g", "(I)Ljavax/baja/sys/BValue;", 17, this.g.code));
            this.asm.addMethod(new MethodInfo(this.asm, "s", "(ILjavax/baja/sys/BValue;)V", 17, this.s.code));
        }
        if (this.gb != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gb", "(I)Z", 17, this.gb.code));
            this.asm.addMethod(new MethodInfo(this.asm, "sb", "(IZ)V", 17, this.sb.code));
        }
        if (this.gi != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gi", "(I)I", 17, this.gi.code));
            this.asm.addMethod(new MethodInfo(this.asm, "si", "(II)V", 17, this.si.code));
        }
        if (this.gj != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gj", "(I)J", 17, this.gj.code));
            this.asm.addMethod(new MethodInfo(this.asm, "sj", "(IJ)V", 17, this.sj.code));
        }
        if (this.gf != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gf", "(I)F", 17, this.gf.code));
            this.asm.addMethod(new MethodInfo(this.asm, "sf", "(IF)V", 17, this.sf.code));
        }
        if (this.gd != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gd", "(I)D", 17, this.gd.code));
            this.asm.addMethod(new MethodInfo(this.asm, "sd", "(ID)V", 17, this.sd.code));
        }
        if (this.gs != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "gs", "(I)Ljava/lang/String;", 17, this.gs.code));
            this.asm.addMethod(new MethodInfo(this.asm, "ss", "(ILjava/lang/String;)V", 17, this.ss.code));
        }
        if (this.invoke != null) {
            this.asm.addMethod(new MethodInfo(this.asm, "invoke", "(ILjavax/baja/sys/BComponent;Ljavax/baja/sys/BValue;Ljavax/baja/sys/Context;)Ljavax/baja/sys/BValue;", 17, this.invoke.code));
        }
    }

    private void genGetGeneric(NProperty prop, SwitchCode c) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(180, field);
        x.add(176);
        this.backpatch(c, prop.index, t);
    }

    private void genGetBoolean(NProperty prop, SwitchCode c, SwitchCode cb) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(180, field);
        x.add(184, this.bbooleanMake());
        x.add(176);
        this.backpatch(c, prop.index, t);
        x = cb.code;
        t = x.add(42);
        x.add(180, field);
        x.add(172);
        this.backpatch(cb, prop.index, t);
    }

    private void genGetInt(NProperty prop, SwitchCode c, SwitchCode ci) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(180, field);
        x.add(184, this.bintegerMake());
        x.add(176);
        this.backpatch(c, prop.index, t);
        x = ci.code;
        t = x.add(42);
        x.add(180, field);
        x.add(172);
        this.backpatch(ci, prop.index, t);
    }

    private void genGetLong(NProperty prop, SwitchCode c, SwitchCode cj) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(180, field);
        x.add(184, this.blongMake());
        x.add(176);
        this.backpatch(c, prop.index, t);
        x = cj.code;
        t = x.add(42);
        x.add(180, field);
        x.add(173);
        this.backpatch(cj, prop.index, t);
    }

    private void genGetFloat(NProperty prop, SwitchCode c, SwitchCode cf) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(180, field);
        x.add(184, this.bfloatMake());
        x.add(176);
        this.backpatch(c, prop.index, t);
        x = cf.code;
        t = x.add(42);
        x.add(180, field);
        x.add(174);
        this.backpatch(cf, prop.index, t);
    }

    private void genGetDouble(NProperty prop, SwitchCode c, SwitchCode cd) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(180, field);
        x.add(184, this.bdoubleMake());
        x.add(176);
        this.backpatch(c, prop.index, t);
        x = cd.code;
        t = x.add(42);
        x.add(180, field);
        x.add(175);
        this.backpatch(cd, prop.index, t);
    }

    private void genGetString(NProperty prop, SwitchCode c, SwitchCode cs) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(180, field);
        x.add(184, this.bstringMake());
        x.add(176);
        this.backpatch(c, prop.index, t);
        x = cs.code;
        t = x.add(42);
        x.add(180, field);
        x.add(176);
        this.backpatch(cs, prop.index, t);
    }

    private void genSetGeneric(NProperty prop, SwitchCode c) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int propCls = this.cp.cls(prop.typeClass);
        int t = x.add(42);
        x.add(44);
        x.add(192, propCls);
        x.add(181, field);
        x.add(177);
        this.backpatch(c, prop.index, t);
    }

    private void genSetBoolean(NProperty prop, SwitchCode c, SwitchCode cb) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(44);
        x.add(192, this.bbooleanCls());
        x.add(182, this.getBoolean());
        x.add(181, field);
        x.add(177);
        this.backpatch(c, prop.index, t);
        x = cb.code;
        t = x.add(42);
        x.add(28);
        x.add(181, field);
        x.add(177);
        this.backpatch(cb, prop.index, t);
    }

    private void genSetInt(NProperty prop, SwitchCode c, SwitchCode ci) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(44);
        x.add(192, this.bintegerCls());
        x.add(182, this.getInt());
        x.add(181, field);
        x.add(177);
        this.backpatch(c, prop.index, t);
        x = ci.code;
        t = x.add(42);
        x.add(28);
        x.add(181, field);
        x.add(177);
        this.backpatch(ci, prop.index, t);
    }

    private void genSetLong(NProperty prop, SwitchCode c, SwitchCode cj) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(44);
        x.add(192, this.blongCls());
        x.add(182, this.getLong());
        x.add(181, field);
        x.add(177);
        this.backpatch(c, prop.index, t);
        x = cj.code;
        t = x.add(42);
        x.add(32);
        x.add(181, field);
        x.add(177);
        this.backpatch(cj, prop.index, t);
    }

    private void genSetFloat(NProperty prop, SwitchCode c, SwitchCode cf) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(44);
        x.add(192, this.bfloatCls());
        x.add(182, this.getFloat());
        x.add(181, field);
        x.add(177);
        this.backpatch(c, prop.index, t);
        x = cf.code;
        t = x.add(42);
        x.add(36);
        x.add(181, field);
        x.add(177);
        this.backpatch(cf, prop.index, t);
    }

    private void genSetDouble(NProperty prop, SwitchCode c, SwitchCode cd) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(44);
        x.add(192, this.bdoubleCls());
        x.add(182, this.getDouble());
        x.add(181, field);
        x.add(177);
        this.backpatch(c, prop.index, t);
        x = cd.code;
        t = x.add(42);
        x.add(40);
        x.add(181, field);
        x.add(177);
        this.backpatch(cd, prop.index, t);
    }

    private void genSetString(NProperty prop, SwitchCode c, SwitchCode cs) {
        Code x = c.code;
        int field = this.propFields[prop.index];
        int t = x.add(42);
        x.add(44);
        x.add(192, this.bstringCls());
        x.add(182, this.getString());
        x.add(181, field);
        x.add(177);
        this.backpatch(c, prop.index, t);
        x = cs.code;
        t = x.add(42);
        x.add(44);
        x.add(181, field);
        x.add(177);
        this.backpatch(cs, prop.index, t);
    }

    private void genInvoke(NAction action, SwitchCode c) {
        Code x = c.code;
        Class<?> paramType = action.parameterClass;
        Class<?> returnType = action.returnClass;
        int t = x.add(44);
        x.add(192, this.complexClass);
        if (paramType != null) {
            int paramCls = this.cp.cls(paramType);
            x.add(45);
            x.add(192, paramCls);
        }
        if (action.doTakesContext) {
            x.add(25, 4);
        }
        String methodName = "do" + TextUtil.capitalize((String)action.name);
        StringBuffer methodSig = new StringBuffer("(");
        if (paramType != null) {
            methodSig.append(Jvm.fieldDescriptor(paramType));
        }
        if (action.doTakesContext) {
            methodSig.append("Ljavax/baja/sys/Context;");
        }
        methodSig.append(")");
        if (returnType == null) {
            methodSig.append("V");
        } else {
            methodSig.append(Jvm.fieldDescriptor(returnType));
        }
        int doMethod = this.cp.method(this.complexClass, methodName, methodSig.toString());
        x.add(182, doMethod);
        if (returnType == null) {
            x.add(1);
        }
        x.add(176);
        this.backpatch(c, action.index, t);
    }

    private SwitchCode beginAccessorMethod() {
        Code c = new Code(this.asm);
        int count = this.slots.length;
        c.add(27);
        int switchOffset = c.addPad(170);
        int defaultOffset = c.code.u4(0);
        int defaultTarget = defaultOffset + 12 + count * 4;
        int jump = defaultTarget - switchOffset;
        c.code.u4(defaultOffset, jump);
        c.code.u4(0);
        c.code.u4(count - 1);
        int firstJumpOffset = defaultOffset + 12;
        for (int i = 0; i < count; ++i) {
            c.code.u4(jump);
        }
        c.add(187, this.exceptionCls());
        c.add(89);
        c.add(183, this.exceptionCtor());
        c.add(191);
        return new SwitchCode(c, switchOffset, firstJumpOffset);
    }

    private void backpatch(SwitchCode c, int index, int target) {
        c.code.code.u4(c.firstJumpOffset + index * 4, target - c.switchOffset);
    }

    int init() {
        if (this.init == 0) {
            this.init = this.cp.utf("<init>");
        }
        return this.init;
    }

    int exceptionCls() {
        if (this.exceptionCls == 0) {
            this.exceptionCls = this.cp.cls("com/tridium/sys/schema/UnhandledSlotException");
        }
        return this.exceptionCls;
    }

    int exceptionCtor() {
        if (this.exceptionCtor == 0) {
            this.exceptionCtor = this.cp.method(this.exceptionCls(), this.init(), "()V");
        }
        return this.exceptionCtor;
    }

    int npropCls() {
        if (this.npropCls == 0) {
            this.npropCls = this.cp.cls("com/tridium/sys/schema/NProperty");
        }
        return this.npropCls;
    }

    int npropGetDef() {
        if (this.npropGetDef == 0) {
            this.npropGetDef = this.cp.method(this.npropCls(), "getDefaultValue", "()Ljavax/baja/sys/BValue;");
        }
        return this.npropGetDef;
    }

    int bbooleanCls() {
        if (this.bbooleanCls == 0) {
            this.bbooleanCls = this.cp.cls("javax/baja/sys/BBoolean");
        }
        return this.bbooleanCls;
    }

    int bintegerCls() {
        if (this.bintegerCls == 0) {
            this.bintegerCls = this.cp.cls("javax/baja/sys/BInteger");
        }
        return this.bintegerCls;
    }

    int blongCls() {
        if (this.blongCls == 0) {
            this.blongCls = this.cp.cls("javax/baja/sys/BLong");
        }
        return this.blongCls;
    }

    int bfloatCls() {
        if (this.bfloatCls == 0) {
            this.bfloatCls = this.cp.cls("javax/baja/sys/BFloat");
        }
        return this.bfloatCls;
    }

    int bdoubleCls() {
        if (this.bdoubleCls == 0) {
            this.bdoubleCls = this.cp.cls("javax/baja/sys/BDouble");
        }
        return this.bdoubleCls;
    }

    int bstringCls() {
        if (this.bstringCls == 0) {
            this.bstringCls = this.cp.cls("javax/baja/sys/BString");
        }
        return this.bstringCls;
    }

    int bbooleanMake() {
        if (this.bbooleanMake == 0) {
            this.bbooleanMake = this.cp.method(this.bbooleanCls(), "make", "(Z)Ljavax/baja/sys/BBoolean;");
        }
        return this.bbooleanMake;
    }

    int bintegerMake() {
        if (this.bintegerMake == 0) {
            this.bintegerMake = this.cp.method(this.bintegerCls(), "make", "(I)Ljavax/baja/sys/BInteger;");
        }
        return this.bintegerMake;
    }

    int blongMake() {
        if (this.blongMake == 0) {
            this.blongMake = this.cp.method(this.blongCls(), "make", "(J)Ljavax/baja/sys/BLong;");
        }
        return this.blongMake;
    }

    int bfloatMake() {
        if (this.bfloatMake == 0) {
            this.bfloatMake = this.cp.method(this.bfloatCls(), "make", "(F)Ljavax/baja/sys/BFloat;");
        }
        return this.bfloatMake;
    }

    int bdoubleMake() {
        if (this.bdoubleMake == 0) {
            this.bdoubleMake = this.cp.method(this.bdoubleCls(), "make", "(D)Ljavax/baja/sys/BDouble;");
        }
        return this.bdoubleMake;
    }

    int bstringMake() {
        if (this.bstringMake == 0) {
            this.bstringMake = this.cp.method(this.bstringCls(), "make", "(Ljava/lang/String;)Ljavax/baja/sys/BString;");
        }
        return this.bstringMake;
    }

    int getBoolean() {
        if (this.getBoolean == 0) {
            this.getBoolean = this.cp.method(this.bbooleanCls(), "getBoolean", "()Z");
        }
        return this.getBoolean;
    }

    int getInt() {
        if (this.getInt == 0) {
            this.getInt = this.cp.method(this.bintegerCls(), "getInt", "()I");
        }
        return this.getInt;
    }

    int getLong() {
        if (this.getLong == 0) {
            this.getLong = this.cp.method(this.blongCls(), "getLong", "()J");
        }
        return this.getLong;
    }

    int getFloat() {
        if (this.getFloat == 0) {
            this.getFloat = this.cp.method(this.bfloatCls(), "getFloat", "()F");
        }
        return this.getFloat;
    }

    int getDouble() {
        if (this.getDouble == 0) {
            this.getDouble = this.cp.method(this.bdoubleCls(), "getDouble", "()D");
        }
        return this.getDouble;
    }

    int getString() {
        if (this.getString == 0) {
            this.getString = this.cp.method(this.bstringCls(), "getString", "()Ljava/lang/String;");
        }
        return this.getString;
    }

    static class SwitchCode {
        Code code;
        int switchOffset;
        int firstJumpOffset;

        SwitchCode(Code c, int so, int fjo) {
            this.code = c;
            this.switchOffset = so;
            this.firstJumpOffset = fjo;
        }
    }
}

