/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.resource;

import com.tridium.sys.BIPlatform;
import com.tridium.sys.Nre;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceManager;
import java.io.IOException;
import java.security.AccessController;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;

public class ResourceReport
implements Cloneable {
    static DecimalFormat ruFormat = new DecimalFormat("#,##0.000 kRU");
    int[] cpu;
    int[] mem;
    private int totalMem;
    private int ruLimit;
    private int ruTotal;
    private int ruDefault;
    private HashMap<String, Category> ru = new HashMap();
    private HashMap<String, String> props = new HashMap();
    private int numComps;
    private String platStationFault;

    public int[] cpu() {
        return this.cpu;
    }

    public int[] mem() {
        return this.mem;
    }

    public int totalMem() {
        return this.totalMem;
    }

    public String platStationFault() {
        return this.platStationFault;
    }

    public int ruLimit() {
        return this.ruLimit;
    }

    public int ruTotal() {
        return this.ruTotal;
    }

    public int ruDefault() {
        return this.ruDefault;
    }

    public String[] ruCategories() {
        return this.ru.keySet().toArray(new String[this.ru.size()]);
    }

    public int ru(String category) {
        Category c = this.ru.get(category);
        return c == null ? 0 : c.usage;
    }

    public String[] props() {
        return this.props.keySet().toArray(new String[this.props.size()]);
    }

    public String prop(String key) {
        return this.props.get(key);
    }

    public final void add(int n) {
        this.ruTotal += n;
        this.ruDefault += n;
    }

    public final void add(String category, int n) {
        this.ruTotal += n;
        Category c = this.ru.get(category);
        if (c == null) {
            c = new Category(category);
            this.ru.put(category, c);
        }
        c.usage += n;
    }

    public final void put(String key, String value) {
        this.props.put(key, value);
    }

    void generate(ResourceManager mgr) {
        BIPlatform platform = Nre.getPlatform();
        this.totalMem = platform.getTotalMemory();
        this.ruLimit = mgr.ruLimit;
        this.computeResourceUnits(Sys.getStation());
        this.put("resources.total", ResourceReport.rustr(this.ruTotal));
        this.put("resources.limit", this.ruLimit < 0 ? "none" : ResourceReport.rustr(this.ruLimit));
        this.put("resources.category.component", ResourceReport.rustr(this.ruDefault));
        String[] cats = this.ruCategories();
        for (int i = 0; i < cats.length; ++i) {
            this.put("resources.category." + cats[i], ResourceReport.rustr(this.ru(cats[i])));
        }
        this.put("mem.used", ResourceReport.memstr(platform.getMemoryUsage()));
        this.put("mem.total", ResourceReport.memstr(this.totalMem));
        long heapTotal = Runtime.getRuntime().totalMemory() / 1024L;
        long heapFree = Runtime.getRuntime().freeMemory() / 1024L;
        long heapMax = Runtime.getRuntime().maxMemory() / 1024L;
        this.put("heap.total", ResourceReport.memstr(heapTotal));
        this.put("heap.free", ResourceReport.memstr(heapFree));
        this.put("heap.max", ResourceReport.memstr(heapMax));
        this.put("component.count", "" + Sys.getStation().getComponentSpace().getComponentCount());
        AccessController.doPrivileged(() -> {
            this.put("version.niagara", "" + Sys.getBajaVersion());
            this.put("version.java", "" + System.getProperty("java.vm.name") + ' ' + System.getProperty("java.vm.version"));
            this.put("version.os", "" + System.getProperty("os.arch") + ' ' + System.getProperty("os.name") + ' ' + System.getProperty("os.version"));
            return null;
        });
        if (Metrics.isUsingCapacityLicensing()) {
            Metrics.writeToResourceReport(this);
        }
        this.platStationFault = platform.checkForStationFault();
        platform.queryResources(this);
    }

    private void computeResourceUnits(BObject v) {
        this.add(1);
        try {
            v.fw(21, this, null, null, null);
        }
        catch (Exception e) {
            System.out.println("ERROR: ResourceReport on " + v.getType() + ": " + e);
        }
        if (!(v instanceof BComplex)) {
            return;
        }
        BComplex complex = (BComplex)v;
        if (complex instanceof BComponent) {
            this.add(20);
        }
        SlotCursor<Property> c = complex.getProperties();
        while (c.next()) {
            try {
                Property prop = c.property();
                if (prop.getTypeAccess() != 7) {
                    this.add(1);
                    continue;
                }
                this.computeResourceUnits(c.get());
            }
            catch (Exception e) {
                System.out.println("ERROR: ResourceReport: " + e);
            }
        }
    }

    public static String memstr(long kb) {
        if (kb < 1024L) {
            return kb + " KB";
        }
        return kb / 1024L + " MB";
    }

    public static String rustr(int ru) {
        return ruFormat.format((double)ru / 1000.0);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    public byte[] encode() throws Exception {
        int i;
        ByteBuffer buf = new ByteBuffer(1024);
        int numReadings = this.cpu.length;
        buf.writeUTF("startReport");
        buf.writeInt(1);
        buf.writeUTF("");
        buf.writeInt(this.totalMem);
        buf.writeInt(this.ruLimit);
        buf.writeInt(this.ruTotal);
        buf.writeInt(this.ruDefault);
        String[] cats = this.ruCategories();
        buf.writeInt(this.ru.size());
        for (i = 0; i < cats.length; ++i) {
            buf.writeUTF(cats[i]);
            buf.writeInt(this.ru(cats[i]));
        }
        buf.writeInt(numReadings);
        for (i = 0; i < numReadings; ++i) {
            buf.writeByte(this.cpu[i]);
            buf.writeInt(this.mem[i]);
        }
        String[] props = this.props();
        buf.writeInt(props.length);
        for (int i2 = 0; i2 < props.length; ++i2) {
            buf.writeUTF(props[i2]);
            buf.writeUTF(this.prop(props[i2]));
        }
        buf.writeUTF("endReport");
        return buf.toByteArray();
    }

    public static ResourceReport decode(byte[] bytes) throws Exception {
        ByteBuffer buf = new ByteBuffer(bytes);
        ResourceReport r = new ResourceReport();
        if (!buf.readUTF().equals("startReport")) {
            throw new IOException();
        }
        if (buf.readInt() != 1) {
            throw new IOException();
        }
        buf.readUTF();
        r.totalMem = buf.readInt();
        r.ruLimit = buf.readInt();
        r.ruTotal = buf.readInt();
        r.ruDefault = buf.readInt();
        int numCats = buf.readInt();
        for (int i = 0; i < numCats; ++i) {
            String cat = buf.readUTF();
            int usage = buf.readInt();
            r.ru.put(cat, new Category(cat, usage));
        }
        int numReadings = buf.readInt();
        r.cpu = new int[numReadings];
        r.mem = new int[numReadings];
        for (int i = 0; i < numReadings; ++i) {
            r.cpu[i] = buf.readByte();
            r.mem[i] = buf.readInt();
        }
        int numProps = buf.readInt();
        for (int i = 0; i < numProps; ++i) {
            String key = buf.readUTF();
            String val = buf.readUTF();
            r.props.put(key, val);
        }
        if (!buf.readUTF().equals("endReport")) {
            throw new IOException();
        }
        return r;
    }

    static class Category {
        String key;
        int usage;

        Category(String key) {
            this.key = key;
        }

        Category(String key, int usage) {
            this.key = key;
            this.usage = usage;
        }
    }
}

