/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.LexiconInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.xml.XElem;

public class NLexiconInfo
implements LexiconInfo {
    private String brandPattern;
    private String moduleName;
    private String resourcePath;
    private String language;
    private String containerModuleName;
    private RuntimeProfile containerRuntimeProfile;
    private BAbsTime lastModified;
    private boolean defaultLexicon = false;

    public NLexiconInfo() {
    }

    public NLexiconInfo(XElem elem, String brandPattern, String containerModuleName, RuntimeProfile containerRuntimeProfile) {
        this.moduleName = elem.get("module");
        this.brandPattern = brandPattern;
        this.resourcePath = elem.get("resource");
        this.language = elem.get("language", "");
        this.containerModuleName = containerModuleName;
        this.containerRuntimeProfile = containerRuntimeProfile;
        this.defaultLexicon = elem.getb("default", false);
        this.lastModified = BAbsTime.NULL;
    }

    @Override
    public String getBrandPattern() {
        return this.brandPattern;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getContainerModuleName() {
        return this.containerModuleName;
    }

    @Override
    public RuntimeProfile getContainerRuntimeProfile() {
        return this.containerRuntimeProfile;
    }

    @Override
    public BAbsTime getLastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isDefault() {
        return this.defaultLexicon;
    }

    @Override
    public void setLastModified(long l) {
        this.lastModified = BAbsTime.make(l);
    }

    @Override
    public void setLastModified(BAbsTime t) {
        this.lastModified = t;
    }

    public void read(DataInputStream in) throws Exception {
        this.moduleName = in.readUTF();
        this.brandPattern = in.readUTF();
        this.resourcePath = in.readUTF();
        this.language = in.readUTF();
        this.containerModuleName = in.readUTF();
        this.defaultLexicon = in.readBoolean();
        this.containerRuntimeProfile = RuntimeProfile.valueOf((String)in.readUTF());
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeUTF(this.moduleName);
        out.writeUTF(this.brandPattern);
        out.writeUTF(this.resourcePath);
        out.writeUTF(this.language);
        out.writeUTF(this.containerModuleName);
        out.writeBoolean(this.defaultLexicon);
        out.writeUTF(this.containerRuntimeProfile.name());
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.moduleName);
        if (this.language != null) {
            s.append('-').append(this.language);
        }
        if (this.brandPattern != null) {
            s.append('-').append(this.brandPattern);
        }
        if (this.containerModuleName != null) {
            s.append('-').append(this.containerModuleName);
        }
        if (this.resourcePath != null) {
            s.append('-').append(this.resourcePath);
        }
        if (this.defaultLexicon) {
            s.append('-').append("true");
        } else {
            s.append('-').append("false");
        }
        s.append('-').append(this.containerRuntimeProfile.name());
        return s.toString();
    }

    public String key() {
        return NLexiconInfo.keyFor(this.moduleName, this.language, this.containerModuleName, this.containerRuntimeProfile.name());
    }

    public static String keyFor(String moduleName, String language, String container, String containerProfile) {
        StringBuilder sb = new StringBuilder(moduleName);
        if (language != null && !language.isEmpty()) {
            sb.append('-').append(language);
        }
        sb.append('-').append(container);
        sb.append('-').append(containerProfile);
        return sb.toString();
    }
}

