/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.nre.util.ByteBuffer;

public class ClassScanner {
    private static final String[] noInterfaces = new String[0];
    public int modifiers;
    public String thisClass;
    public String superClass;
    public String[] interfaces;
    public boolean hasLoadType;
    private int[] cpClass;
    private byte[][] cpUtf;

    public void scan(InputStream inputStream) throws IOException {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(inputStream));){
            int magic = in.readInt();
            int minor = in.readUnsignedShort();
            int major = in.readUnsignedShort();
            int count = in.readUnsignedShort();
            if (magic != -889275714) {
                throw new IOException("Invalid magic");
            }
            this.cpClass = new int[count];
            this.cpUtf = new byte[count][];
            for (int i = 1; i < count; ++i) {
                boolean doubleWidth = this.readCpInfo(in, i);
                if (!doubleWidth) continue;
                ++i;
            }
            this.modifiers = in.readUnsignedShort();
            this.thisClass = this.toClass(in.readUnsignedShort());
            this.superClass = this.toClass(in.readUnsignedShort());
            int interfaceCount = in.readUnsignedShort();
            if (interfaceCount == 0) {
                this.interfaces = noInterfaces;
            } else {
                this.interfaces = new String[interfaceCount];
                for (int i = 0; i < interfaceCount; ++i) {
                    this.interfaces[i] = this.toClass(in.readUnsignedShort());
                }
            }
        }
    }

    private boolean readCpInfo(DataInputStream in, int index) throws IOException {
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 1: {
                int len = in.readUnsignedShort();
                byte[] utf = new byte[len];
                in.readFully(utf, 0, len);
                this.cpUtf[index] = utf;
                this.checkLoadType(utf);
                return false;
            }
            case 3: {
                ClassScanner.skip(in, 4);
                return false;
            }
            case 4: {
                ClassScanner.skip(in, 4);
                return false;
            }
            case 5: {
                ClassScanner.skip(in, 8);
                return true;
            }
            case 6: {
                ClassScanner.skip(in, 8);
                return true;
            }
            case 7: {
                this.cpClass[index] = in.readUnsignedShort();
                return false;
            }
            case 8: {
                ClassScanner.skip(in, 2);
                return false;
            }
            case 9: {
                ClassScanner.skip(in, 4);
                return false;
            }
            case 10: {
                ClassScanner.skip(in, 4);
                return false;
            }
            case 11: {
                ClassScanner.skip(in, 4);
                return false;
            }
            case 12: {
                ClassScanner.skip(in, 4);
                return false;
            }
            case 15: {
                ClassScanner.skip(in, 3);
                return false;
            }
            case 16: {
                ClassScanner.skip(in, 2);
                return false;
            }
            case 18: {
                ClassScanner.skip(in, 4);
                return false;
            }
        }
        throw new IOException("Invalid cp tag 0x" + Integer.toHexString(tag));
    }

    private String toClass(int clsIndex) throws IOException {
        byte[] utf = this.cpUtf[this.cpClass[clsIndex]];
        ByteBuffer buf = new ByteBuffer(utf.length + 4);
        buf.writeShort(utf.length);
        buf.write(utf, 0, utf.length);
        return buf.readUTF().replace('/', '.');
    }

    private void checkLoadType(byte[] utf) {
        if (this.hasLoadType) {
            return;
        }
        if (utf.length != "loadType".length()) {
            return;
        }
        this.hasLoadType = utf[0] == 108 && utf[1] == 111 && utf[2] == 97 && utf[3] == 100 && utf[4] == 84 && utf[5] == 121 && utf[6] == 112 && utf[7] == 101;
    }

    private static void skip(InputStream in, int num) throws IOException {
        int n = 0;
        while (n < num) {
            if (n < 0) {
                throw new EOFException();
            }
            n = (int)((long)n + in.skip(num - n));
        }
    }
}

