/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.DefaultBootEnv;
import com.tridium.sys.Nre;
import com.tridium.sys.module.DefaultModulesFileManager;
import com.tridium.sys.module.ManagedModuleFile;
import com.tridium.sys.module.ModuleManager;
import com.tridium.sys.registry.ClassScanner;
import com.tridium.sys.registry.NAdapterInfo;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.sys.registry.NDependencyInfo;
import com.tridium.sys.registry.NLexiconInfo;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NRegistry;
import com.tridium.sys.registry.NTypeInfo;
import com.tridium.sys.registry.RegistryChecksum;
import com.tridium.sys.registry.RegistryDatabase;
import com.tridium.sys.registry.TopologicalSort;
import com.tridium.util.ArrayUtil;
import com.tridium.util.MapUtil;
import com.tridium.util.jar.ModuleEntry;
import com.tridium.util.jar.ModuleFile;
import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.file.BajaFileUtil;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

class Builder {
    static final Logger LOGGER = Logger.getLogger("sys.registry");
    private static DefaultModulesFileManager.ModuleFileSet LOADED_FILES = null;
    private static final Object REG_MONITOR = "Registry Monitor";
    ModuleBuild[] moduleBuilds;
    List<TypeBuild> typeBuilds = new ArrayList<TypeBuild>();
    List<AdapterBuild> adapterBuilds = new ArrayList<AdapterBuild>();
    Map<String, TypeBuild> typeBuildsBySpecString = new HashMap<String, TypeBuild>();
    Map<String, NTypeInfo> typesByFileExt = new HashMap<String, NTypeInfo>();
    Map<String, NTypeInfo> typesByOrdScheme = new HashMap<String, NTypeInfo>();
    Map<String, NTypeInfo> typesBySpecString = new HashMap<String, NTypeInfo>();
    Map<String, NTypeInfo> typesByClass = new HashMap<String, NTypeInfo>();
    Map<String, String[]> defs = new HashMap<String, String[]>();
    Map<String, NLexiconInfo> lexicons = new HashMap<String, NLexiconInfo>();

    private Builder() {
    }

    static int rebuild(NRegistry registry) throws Exception {
        Builder.clean(registry);
        ModuleBuild[] moduleBuilds = Builder.load();
        Builder b = new Builder();
        b.init(moduleBuilds, 0);
        b.resolveSuperAndInterfaces();
        b.resolveIsTypes();
        b.resolveAdapters();
        b.agentize();
        b.write(registry);
        return b.typeBuilds.size();
    }

    static DefaultModulesFileManager fileManager() {
        if (!(Nre.bootEnv instanceof DefaultBootEnv)) {
            throw new IllegalStateException("Can't call syncFiles on a remote boot env");
        }
        return (DefaultModulesFileManager)((DefaultBootEnv)Nre.bootEnv).getModulesFileManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static void syncFiles(NRegistry registry) {
        Object object = REG_MONITOR;
        synchronized (object) {
            HashMap<String, ModuleBuild> moduleBuildsByName = new HashMap<String, ModuleBuild>();
            HashMap<String, List<ModuleBuild>> depModuleBuildsByTargetModulePartName = new HashMap<String, List<ModuleBuild>>();
            HashMap moduleReloadsByName = new HashMap();
            Builder b = new Builder();
            Builder.fileManager().update(true);
            DefaultModulesFileManager.ModuleFileSet updatedFileSet = Builder.fileManager().init(true);
            try {
                void var13_25;
                MapUtil.ComparisonResults<ManagedModuleFile> comparisonResults = Builder.fileManager().compareModuleFiles(LOADED_FILES);
                HashSet keptFiles = new HashSet(comparisonResults.added);
                keptFiles.addAll(comparisonResults.updated);
                for (ManagedModuleFile newFile : keptFiles) {
                    ModuleBuild mb;
                    NModuleInfo moduleInfo = registry.db.minfoByModulePartName.get(newFile.getModulePartName());
                    if (moduleInfo == null) {
                        if (registry.db.moduleMapByModuleName.containsKey(newFile.getModuleName()) && registry.db.moduleMapByModuleName.get(newFile.getModuleName()).containsKey(newFile.getRuntimeProfile())) {
                            NModuleInfo nModuleInfo = registry.db.moduleMapByModuleName.get(newFile.getModuleName()).get(newFile.getRuntimeProfile());
                            LOGGER.log(Level.SEVERE, String.format("%s not registered, %s already provides module %s, profile %s", newFile.getModulePartName(), nModuleInfo.modulePartName, newFile.getModuleName(), newFile.getRuntimeProfile()));
                        }
                        try {
                            mb = Builder.readModule(newFile, true);
                            if (mb == null) continue;
                            moduleBuildsByName.put(mb.info.modulePartName, mb);
                            for (DependencyInfo dep : mb.info.depends) {
                                ArrayList<ModuleBuild> depModuleBuilds = (ArrayList<ModuleBuild>)depModuleBuildsByTargetModulePartName.get(dep.getModulePartName());
                                if (depModuleBuilds == null) {
                                    depModuleBuilds = new ArrayList<ModuleBuild>();
                                    depModuleBuildsByTargetModulePartName.put(dep.getModulePartName(), depModuleBuilds);
                                }
                                depModuleBuilds.add(mb);
                            }
                            continue;
                        }
                        catch (Throwable throwable) {
                            LOGGER.log(Level.SEVERE, String.format("Cannot read module %s", newFile.getFileName()), throwable);
                            continue;
                        }
                    }
                    if (!moduleInfo.isReloadable()) continue;
                    try {
                        void var13_20;
                        mb = Builder.readModule(newFile, true);
                        if (mb.info.getBuildTime() == moduleInfo.getBuildTime()) continue;
                        Set set = (Set)moduleReloadsByName.get(mb.info.moduleName);
                        if (set == null) {
                            HashSet hashSet = new HashSet();
                            moduleReloadsByName.put(mb.info.moduleName, hashSet);
                        }
                        var13_20.add(mb.info.runtimeProfile);
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.SEVERE, String.format("Cannot read module %s", newFile.getFileName()), throwable);
                    }
                }
                if (moduleBuildsByName.isEmpty() && moduleReloadsByName.isEmpty()) {
                    LOADED_FILES = updatedFileSet;
                    return;
                }
                for (String reloadModuleName : moduleReloadsByName.keySet()) {
                    try {
                        for (RuntimeProfile runtimeProfile : (Set)moduleReloadsByName.get(reloadModuleName)) {
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Reload module " + reloadModuleName + "-" + runtimeProfile);
                            }
                            Builder.reloadModule(registry, reloadModuleName, runtimeProfile);
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.SEVERE, "Cannot reload module " + reloadModuleName, e);
                    }
                }
                for (String targetModulePartName : depModuleBuildsByTargetModulePartName.keySet()) {
                    Builder.checkDependencies(targetModulePartName, registry, depModuleBuildsByTargetModulePartName, moduleBuildsByName);
                }
                b.init(moduleBuildsByName.values().toArray(new ModuleBuild[moduleBuildsByName.size()]), registry);
                b.resolveSuperAndInterfaces();
                b.resolveIsTypes();
                b.resolveAdapters();
                b.agentize();
                NModuleInfo[] newModules = b.sortModules();
                Object[] allModules = ArrayUtil.add(registry.db.modules, newModules);
                Object[] keys = new String[allModules.length];
                boolean bl = false;
                while (var13_25 < allModules.length) {
                    keys[var13_25] = ((NModuleInfo)allModules[var13_25]).getModulePartName();
                    ++var13_25;
                }
                SortUtil.sort((Object[])keys, (Object[])allModules);
                HashMap<String, NTypeInfo> hashMap = new HashMap<String, NTypeInfo>();
                for (NTypeInfo t : b.typesByClass.values()) {
                    hashMap.put(t.typeSpec.toString(), t);
                }
                NAdapterInfo[] allAdapters = new NAdapterInfo[registry.db.adapters.length + b.adapterBuilds.size()];
                System.arraycopy(registry.db.adapters, 0, allAdapters, 0, registry.db.adapters.length);
                for (int i = 0; i < b.adapterBuilds.size(); ++i) {
                    allAdapters[i + registry.db.adapters.length] = b.adapterBuilds.get((int)i).info;
                }
                String[] allOrdSchemes = b.sortOrdSchemes();
                String[] allFileExts = b.sortFileExts();
                HashMap<String, NModuleInfo> allModulesByName = new HashMap<String, NModuleInfo>();
                allModulesByName.putAll(registry.db.minfoByModulePartName);
                HashMap<String, Map<RuntimeProfile, NModuleInfo>> allModuleMapByModuleName = new HashMap<String, Map<RuntimeProfile, NModuleInfo>>();
                allModuleMapByModuleName.putAll(registry.db.moduleMapByModuleName);
                for (NModuleInfo newModule : newModules) {
                    allModulesByName.put(newModule.getModulePartName(), newModule);
                    HashMap<RuntimeProfile, NModuleInfo> byContent = (HashMap<RuntimeProfile, NModuleInfo>)allModuleMapByModuleName.get(newModule.moduleName);
                    if (byContent == null) {
                        byContent = new HashMap<RuntimeProfile, NModuleInfo>();
                        allModuleMapByModuleName.put(newModule.moduleName, byContent);
                    }
                    byContent.put(newModule.runtimeProfile, newModule);
                }
                for (ModuleBuild moduleBuild : b.moduleBuilds) {
                    for (String targetSpec : moduleBuild.agentTypesByTargetSpec.keySet()) {
                        NTypeInfo targetType = (NTypeInfo)hashMap.get(targetSpec);
                        NTypeInfo.NAgentOnInfo[] agentTypes = moduleBuild.agentTypesByTargetSpec.get(targetSpec);
                        targetType.agents = ArrayUtil.add(targetType.agents, agentTypes);
                    }
                }
                registry.db.modules = allModules;
                registry.db.minfoByModulePartName = allModulesByName;
                registry.db.moduleMapByModuleName = allModuleMapByModuleName;
                registry.db.types = b.typesByClass.values().toArray(new NTypeInfo[b.typesByClass.size()]);
                registry.db.typesBySpec = hashMap;
                registry.db.defs = b.defs;
                registry.db.fileExts = allFileExts;
                registry.db.typesByFileExt = b.typesByFileExt;
                registry.db.ordSchemes = allOrdSchemes;
                registry.db.lexicons = b.lexicons;
                registry.db.typesByOrdScheme = b.typesByOrdScheme;
                registry.db.adapters = allAdapters;
            }
            finally {
                Builder.fileManager().clearCachedManifests();
            }
            LOADED_FILES = updatedFileSet;
        }
    }

    private static boolean shouldCheckDependencies(ModuleInfo info) {
        return !info.getModuleName().endsWith("Test");
    }

    private static void checkDependencies(String targetModulePartName, NRegistry registry, Map<String, List<ModuleBuild>> depModuleBuildsByTargetModulePartName, Map<String, ModuleBuild> moduleBuildsByModulePartName) {
        List<ModuleBuild> depModuleBuilds = depModuleBuildsByTargetModulePartName.get(targetModulePartName);
        if (depModuleBuilds == null) {
            return;
        }
        ModuleBuild targetModuleBuild = moduleBuildsByModulePartName.get(targetModulePartName);
        NModuleInfo targetModule = targetModuleBuild == null ? registry.db.minfoByModulePartName.get(targetModulePartName) : targetModuleBuild.info;
        block0: for (ModuleBuild depModuleBuild : depModuleBuilds) {
            if (!Builder.shouldCheckDependencies(depModuleBuild.info)) {
                return;
            }
            String depModulePartName = depModuleBuild.info.getModulePartName();
            if (!moduleBuildsByModulePartName.containsKey(depModulePartName)) continue;
            for (DependencyInfo dep : depModuleBuild.info.depends) {
                if (!dep.getModulePartName().equals(targetModulePartName)) continue;
                if (targetModule != null && targetModule.runtimeProfile.supportsDependency(depModuleBuild.info.runtimeProfile) && (dep.getVendorVersion() == null || targetModule.getVendorVersion().compareTo(dep.getVendorVersion()) >= 0) || moduleBuildsByModulePartName.remove(depModulePartName) == null) continue block0;
                LOGGER.log(Level.SEVERE, "Cannot load module " + depModulePartName + ", dependency failed: " + dep);
                Builder.checkDependencies(depModulePartName, registry, depModuleBuildsByTargetModulePartName, moduleBuildsByModulePartName);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadModule(NRegistry registry, ModuleInfo info) throws ModuleNotFoundException {
        String mName = info.getModuleName();
        String mPartName = info.getModulePartName();
        Object object = REG_MONITOR;
        synchronized (object) {
            HashMap<String, ModuleBuild> moduleBuildsByModulePartName = new HashMap<String, ModuleBuild>();
            HashMap<String, ArrayList<ModuleBuild>> depModuleBuildByTargetModulePartName = new HashMap<String, ArrayList<ModuleBuild>>();
            ManagedModuleFile managedModuleFile = Builder.fileManager().init(false).getByModulePartName(mPartName);
            NModuleInfo module = registry.db.minfoByModulePartName.get(mPartName);
            NModuleInfo newMInfo = null;
            if (module == null || !module.isAutoload() || module.isReloadable()) {
                if (registry.db.moduleMapByModuleName.containsKey(mName) && registry.db.moduleMapByModuleName.get(mName).containsKey(managedModuleFile.getRuntimeProfile())) {
                    NModuleInfo nModuleInfo = registry.db.moduleMapByModuleName.get(mName).get(managedModuleFile.getRuntimeProfile());
                    LOGGER.log(Level.SEVERE, String.format("%s not registered, %s already provides module %s, profile %s", managedModuleFile.getModulePartName(), nModuleInfo.modulePartName, mName, managedModuleFile.getRuntimeProfile()));
                } else {
                    try {
                        ModuleBuild mb = Builder.readModule(managedModuleFile, true, true);
                        moduleBuildsByModulePartName.put(mb.info.modulePartName, mb);
                        newMInfo = mb.info;
                        for (DependencyInfo dep : mb.info.depends) {
                            ArrayList<ModuleBuild> depModuleBuilds = (ArrayList<ModuleBuild>)depModuleBuildByTargetModulePartName.get(dep.getModulePartName());
                            if (depModuleBuilds == null) {
                                depModuleBuilds = new ArrayList<ModuleBuild>();
                                depModuleBuildByTargetModulePartName.put(dep.getModulePartName(), depModuleBuilds);
                            }
                            depModuleBuilds.add(mb);
                        }
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.SEVERE, "Cannot read module " + managedModuleFile.getFileName(), throwable);
                    }
                }
            }
            depModuleBuildByTargetModulePartName.keySet().forEach(targetModulePartName -> Builder.checkDependencies(targetModulePartName, registry, depModuleBuildByTargetModulePartName, moduleBuildsByModulePartName));
            Builder builder = new Builder();
            builder.init(moduleBuildsByModulePartName.values().toArray(new ModuleBuild[moduleBuildsByModulePartName.size()]), registry);
            builder.resolveSuperAndInterfaces();
            builder.resolveIsTypes();
            builder.resolveAdapters();
            builder.agentize();
            List<NModuleInfo> allModulesArr = registry.db.minfoByModulePartName.entrySet().stream().filter(entry -> !mPartName.equals(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            if (newMInfo != null) {
                allModulesArr.add(newMInfo);
            }
            allModulesArr.sort((m1, m2) -> m1.modulePartName.compareTo(m2.modulePartName));
            NModuleInfo[] allModules = allModulesArr.toArray(new NModuleInfo[allModulesArr.size()]);
            HashMap<String, NTypeInfo> allTypesBySpec = new HashMap<String, NTypeInfo>();
            builder.typesByClass.values().forEach(ti -> allTypesBySpec.put(ti.typeSpec.toString(), (NTypeInfo)ti));
            NAdapterInfo[] allAdapters = new NAdapterInfo[registry.db.adapters.length + builder.adapterBuilds.size()];
            System.arraycopy(registry.db.adapters, 0, allAdapters, 0, registry.db.adapters.length);
            for (int i = 0; i < builder.adapterBuilds.size(); ++i) {
                allAdapters[i + registry.db.adapters.length] = builder.adapterBuilds.get((int)i).info;
            }
            String[] allOrdSchemes = builder.sortOrdSchemes();
            String[] allFileExts = builder.sortFileExts();
            HashMap<String, NModuleInfo> allMinfoByModulePartName = new HashMap<String, NModuleInfo>();
            allMinfoByModulePartName.putAll(registry.db.minfoByModulePartName);
            HashMap<String, Map<RuntimeProfile, NModuleInfo>> allModuleMapByModuleName = new HashMap<String, Map<RuntimeProfile, NModuleInfo>>();
            allModuleMapByModuleName.putAll(registry.db.moduleMapByModuleName);
            if (newMInfo != null) {
                allMinfoByModulePartName.put(newMInfo.modulePartName, newMInfo);
                HashMap<RuntimeProfile, NModuleInfo> byContent = (HashMap<RuntimeProfile, NModuleInfo>)allModuleMapByModuleName.get(newMInfo.moduleName);
                if (byContent == null) {
                    byContent = new HashMap<RuntimeProfile, NModuleInfo>();
                    allModuleMapByModuleName.put(newMInfo.moduleName, byContent);
                }
                byContent.put(newMInfo.runtimeProfile, newMInfo);
            }
            for (ModuleBuild moduleBuild : builder.moduleBuilds) {
                for (String targetSpec : moduleBuild.agentTypesByTargetSpec.keySet()) {
                    NTypeInfo targetType = (NTypeInfo)allTypesBySpec.get(targetSpec);
                    NTypeInfo.NAgentOnInfo[] agentTypes = moduleBuild.agentTypesByTargetSpec.get(targetSpec);
                    targetType.agents = ArrayUtil.add(targetType.agents, agentTypes);
                }
            }
            registry.db.modules = allModules;
            registry.db.minfoByModulePartName = allMinfoByModulePartName;
            registry.db.moduleMapByModuleName = allModuleMapByModuleName;
            registry.db.types = builder.typesByClass.values().toArray(new NTypeInfo[builder.typesByClass.size()]);
            registry.db.typesBySpec = allTypesBySpec;
            registry.db.defs = builder.defs;
            registry.db.fileExts = allFileExts;
            registry.db.typesByFileExt = builder.typesByFileExt;
            registry.db.ordSchemes = allOrdSchemes;
            registry.db.lexicons = builder.lexicons;
            registry.db.typesByOrdScheme = builder.typesByOrdScheme;
            registry.db.adapters = allAdapters;
            if (newMInfo != null) {
                AccessController.doPrivileged(() -> Nre.getModuleManager()).loadModule(newMInfo.moduleName, newMInfo.runtimeProfile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unloadModule(NRegistry registry, ModuleInfo info) throws Exception {
        String mName = info.getModuleName();
        String mPartName = info.getModulePartName();
        RuntimeProfile profile = info.getRuntimeProfile();
        if (!registry.db.minfoByModulePartName.containsKey(mPartName)) {
            throw new Exception("Module not loaded.");
        }
        NModuleInfo module = registry.db.minfoByModulePartName.get(mPartName);
        if (module.isAutoload() && !module.isReloadable()) {
            throw new Exception("Module must not be autoload or must be reloadable");
        }
        Object object = REG_MONITOR;
        synchronized (object) {
            Map<String, NTypeInfo> allTypesBySpec = registry.db.typesBySpec;
            AccessController.doPrivileged(() -> Nre.getModuleManager()).unloadModuleTypes(mPartName);
            ArrayList<NTypeInfo> a = new ArrayList<NTypeInfo>();
            TypeInfo[] moduleTypes = module.getTypes();
            for (NTypeInfo t : registry.db.types) {
                boolean remove = false;
                for (TypeInfo typeInfo : moduleTypes) {
                    if (!t.equals(typeInfo)) continue;
                    remove = true;
                    allTypesBySpec.remove(t.getTypeSpec().toString());
                    break;
                }
                if (remove) continue;
                a.add(t);
            }
            NTypeInfo[] allTypes = a.toArray(new NTypeInfo[a.size()]);
            Map<String, String[]> allDefs = registry.db.defs;
            Map<String, NTypeInfo> allTypesByFileExt = registry.db.typesByFileExt;
            ArrayList<String> extsToKeep = new ArrayList<String>();
            Map<String, NTypeInfo> typesByOrdScheme = registry.db.typesByOrdScheme;
            ArrayList<String> schemesToKeep = new ArrayList<String>();
            NModuleInfo[] allModules = registry.db.modules;
            for (String ext : registry.db.fileExts) {
                NTypeInfo extInfo = registry.db.typesByFileExt.get(ext);
                if (extInfo != null && extInfo.getModuleName().equals(mName) && extInfo.getRuntimeProfile().equals((Object)profile)) {
                    allTypesByFileExt.remove(ext);
                    continue;
                }
                extsToKeep.add(ext);
            }
            for (String scheme : registry.db.ordSchemes) {
                NTypeInfo ordInfo = typesByOrdScheme.get(scheme);
                if (ordInfo != null && ordInfo.getModuleName().equals(mName) && ordInfo.getRuntimeProfile().equals((Object)profile)) {
                    typesByOrdScheme.remove(scheme);
                    continue;
                }
                schemesToKeep.add(scheme);
            }
            HashMap<String, NLexiconInfo> hashMap = new HashMap<String, NLexiconInfo>();
            for (Map.Entry<String, NLexiconInfo> entry : registry.db.lexicons.entrySet()) {
                String lexName = entry.getKey();
                NLexiconInfo lexInfo = entry.getValue();
                if (lexInfo.getModuleName().equals(mName) && lexInfo.getContainerRuntimeProfile().equals((Object)profile)) continue;
                hashMap.put(lexName, lexInfo);
            }
            NAdapterInfo[] newAdapters = (NAdapterInfo[])Arrays.stream(registry.db.adapters).filter(adapterInfo -> {
                NTypeInfo typeInfo = adapterInfo.type;
                return !typeInfo.getModuleName().equals(mName) || !typeInfo.getRuntimeProfile().equals((Object)profile);
            }).toArray(NAdapterInfo[]::new);
            String[] allExts = extsToKeep.toArray(new String[extsToKeep.size()]);
            String[] allOrdSchemes = schemesToKeep.toArray(new String[schemesToKeep.size()]);
            registry.db.modules = allModules;
            registry.db.types = allTypes;
            registry.db.typesBySpec = allTypesBySpec;
            registry.db.defs = allDefs;
            registry.db.fileExts = allExts;
            registry.db.typesByFileExt = allTypesByFileExt;
            registry.db.ordSchemes = allOrdSchemes;
            registry.db.typesByOrdScheme = typesByOrdScheme;
            registry.db.lexicons = hashMap;
            registry.db.adapters = newAdapters;
            Map<RuntimeProfile, NModuleInfo> map = registry.db.moduleMapByModuleName.get(mName);
            if (map != null) {
                map.remove(info.getRuntimeProfile());
                if (map.isEmpty()) {
                    registry.db.moduleMapByModuleName.remove(mName);
                }
            }
            registry.db.minfoByModulePartName.remove(mPartName);
            module.types = NTypeInfo.noTypes;
            AccessController.doPrivileged(() -> Nre.getModuleManager()).unloadModule(info);
        }
    }

    static void reloadModule(NRegistry registry, String moduleName, RuntimeProfile profile) throws Exception {
        ModuleInfo module = registry.getModule(moduleName, profile);
        List<String> list = TopologicalSort.getSortedDependents(module);
        String[] sortedPartNames = list.toArray(new String[list.size()]);
        ModuleInfo myInfo = Sys.getRegistry().moduleForDependency(sortedPartNames[0]);
        Builder.doReloadModule(registry, myInfo);
        ModuleManager moduleManager = AccessController.doPrivileged(() -> Nre.getModuleManager());
        for (int i = 1; i < sortedPartNames.length; ++i) {
            moduleManager.unloadModuleClasses(Sys.getRegistry().moduleForDependency(sortedPartNames[i]));
        }
        moduleManager.updateReloadedModule(myInfo);
    }

    static void doReloadModule(NRegistry registry, ModuleInfo info) throws Exception {
        String moduleName = info.getModuleName();
        Map<RuntimeProfile, NModuleInfo> map = registry.db.moduleMapByModuleName.get(info.getModuleName());
        if (map == null) {
            throw new BajaRuntimeException(String.format("Module %s not loaded", moduleName));
        }
        if (!map.values().stream().filter(NModuleInfo::isReloadable).findAny().isPresent()) {
            throw new BajaRuntimeException(String.format("Cannot reload module %s", info));
        }
        Builder.unloadModule(registry, info);
        Builder.loadModule(registry, info);
    }

    private static void clean(NRegistry registry) throws Exception {
        BajaFileUtil.delete((File)registry.dir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ModuleBuild[] load() throws Exception {
        LOGGER.fine("Builder.read");
        HashMap accum = new HashMap();
        ArrayList<ModuleBuild> modules = new ArrayList<ModuleBuild>();
        DefaultModulesFileManager.ModuleFileSet updatedFileSet = Builder.fileManager().init(true);
        try {
            for (ManagedModuleFile mf : updatedFileSet) {
                try {
                    ModuleBuild mb = Builder.readModule(mf, false);
                    if (mb == null) continue;
                    if (!accum.containsKey(mb.info.getModuleName())) {
                        accum.put(mb.info.getModuleName(), new HashMap());
                    }
                    if (((Map)accum.get(mb.info.getModuleName())).containsKey(mb.info.getRuntimeProfile())) {
                        ModuleBuild dup = (ModuleBuild)((Map)accum.get(mb.info.getModuleName())).get(mb.info.getRuntimeProfile());
                        LOGGER.severe(String.format("%s not registered, %s already provides module %s, profile %s", mb.info.getModulePartName(), dup.info.getModulePartName(), mb.info.getModuleName(), mb.info.getRuntimeProfile()));
                        continue;
                    }
                    ((Map)accum.get(mb.info.getModuleName())).put(mb.info.getRuntimeProfile(), mb);
                    modules.add(mb);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Cannot read module " + mf.getFileName(), e);
                }
            }
        }
        finally {
            Builder.fileManager().clearCachedManifests();
        }
        LOADED_FILES = updatedFileSet;
        return modules.toArray(new ModuleBuild[modules.size()]);
    }

    private static ModuleBuild readModule(ManagedModuleFile file, boolean loadDepends) throws Exception {
        return Builder.readModule(file, loadDepends, false);
    }

    private static ModuleBuild readModule(ManagedModuleFile managedModuleFile, boolean loadDepends, boolean forceLoad) throws Exception {
        ModuleBuild m;
        File file = managedModuleFile.getFile();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Builder.read \"" + file.getName() + "\"...");
        }
        try (ModuleFile jar = new ModuleFile(file);){
            m = Builder.readManifest(managedModuleFile, loadDepends, forceLoad);
            if (m == null) {
                ModuleBuild moduleBuild = null;
                return moduleBuild;
            }
            m.info.hasPalette = jar.getJarEntry("module.palette") != null;
            boolean bl = m.info.isWar = jar.getJarEntry("WEB-INF/web.xml") != null;
            if (!m.info.isWar) {
                m.info.isWar = jar.getJarEntry("web-inf/web.xml") != null;
            }
        }
        m.snapshot.size = file.length();
        m.snapshot.timestamp = file.lastModified();
        return m;
    }

    private static ModuleBuild readManifest(ManagedModuleFile managedModuleFile, boolean loadDepends, boolean forceLoad) {
        if (!Nre.supportsProfile(managedModuleFile.getRuntimeProfile())) {
            return null;
        }
        ModuleBuild m = new ModuleBuild();
        m.info.moduleName = managedModuleFile.getModuleName();
        m.info.runtimeProfile = managedModuleFile.getRuntimeProfile();
        m.info.modulePartName = managedModuleFile.getModulePartName();
        m.info.bajaVersion = managedModuleFile.getBajaVersion();
        m.info.vendor = managedModuleFile.getVendor();
        m.info.vendorVersion = managedModuleFile.getVendorVersion();
        m.info.description = managedModuleFile.getDescription();
        m.info.buildTime = managedModuleFile.getBuildTime();
        m.info.isAutoloadModule = managedModuleFile.isAutoloadModule();
        m.info.isReloadableModule = managedModuleFile.isReloadableModule();
        m.snapshot.name = m.info.modulePartName;
        XElem manifest = managedModuleFile.getManifest();
        if (m.info.isAutoload() || forceLoad || m.info.isReloadable()) {
            XElem typeElems;
            XElem lexElem;
            XElem defElems = manifest.elem("defs");
            if (defElems != null) {
                int n = defElems.contentSize();
                for (int i = 0; i < n; ++i) {
                    try {
                        XElem elem = defElems.elem(i);
                        if (!elem.name().equals("def")) continue;
                        String name = elem.get("name");
                        String value = elem.get("value");
                        String[] values = m.defs.get(name);
                        values = values != null ? ArrayUtil.addOne(values, value) : new String[]{value};
                        m.defs.put(name, values);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error on def in \"" + m.info.moduleName + '\"', e);
                    }
                }
            }
            if ((lexElem = manifest.elem("lexicons")) != null) {
                String brandPattern = lexElem.get("brand", "");
                for (XElem elem : lexElem.elems("lexicon")) {
                    try {
                        NLexiconInfo li = new NLexiconInfo(elem, brandPattern, m.info.moduleName, m.info.runtimeProfile);
                        String key = li.key();
                        li.setLastModified(managedModuleFile.getFile().lastModified());
                        m.lexicons.put(key, li);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error on lexicon in \"" + m.info.moduleName + '\"', e);
                    }
                }
            }
            if ((typeElems = manifest.elem("types")) != null) {
                XElem[] elems = typeElems.elems("type");
                m.info.types = new NTypeInfo[elems.length];
                for (int i = 0; i < elems.length; ++i) {
                    try {
                        TypeBuild b;
                        try (ModuleFile moduleFile = new ModuleFile(managedModuleFile.getFile(), false);){
                            b = Builder.readType(moduleFile, m, elems[i]);
                        }
                        m.typeBuilds.add(b);
                        m.info.types[i] = b.info;
                        continue;
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.SEVERE, "Error on type \"" + m.info.moduleName + ':' + elems[i].get("name", "???") + '\"', e);
                    }
                }
            }
        }
        if (loadDepends) {
            XElem dependsElem = manifest.elem("dependencies");
            if (dependsElem == null) {
                m.info.depends = new NDependencyInfo[0];
            } else {
                XElem[] dependsElems = dependsElem.elems("dependency");
                m.info.depends = new NDependencyInfo[dependsElems.length];
                for (int i = 0; i < dependsElems.length; ++i) {
                    m.info.depends[i] = new NDependencyInfo(dependsElems[i]);
                    ((NDependencyInfo)m.info.depends[i]).module = m.info;
                }
            }
        }
        return m;
    }

    private static TypeBuild readType(ModuleFile moduleFile, ModuleBuild m, XElem elem) throws Exception {
        XElem adapterElem;
        XElem agentElem;
        XElem fileElem;
        String typeName = elem.get("name");
        TypeBuild t = new TypeBuild(m, BTypeSpec.make(m.info.moduleName, typeName));
        String ordScheme = elem.get("ordScheme", null);
        if (ordScheme != null) {
            t.ordScheme = ordScheme = TextUtil.toLowerCase((String)ordScheme);
            if (m.typesByOrdScheme.get(ordScheme) != null) {
                LOGGER.warning("Multiple types registered for ordScheme \"" + ordScheme + '\"');
            } else {
                m.typesByOrdScheme.put(ordScheme, t.info);
            }
        }
        if ((fileElem = elem.elem("file")) != null) {
            Builder.readFile(t, fileElem);
        }
        if ((agentElem = elem.elem("agent")) != null) {
            Builder.readAgent(t, agentElem);
        }
        if ((adapterElem = elem.elem("adapter")) != null) {
            Builder.readAdapter(t, adapterElem);
        }
        t.info.className = elem.get("class");
        if (moduleFile.getFile().getName().endsWith(".jar")) {
            ModuleEntry entry = moduleFile.getJarEntry(t.info.className.replace('.', '/') + ".class");
            if (entry == null) {
                LOGGER.log(Level.SEVERE, "Missing class for \"" + t + '\"');
                return t;
            }
            ClassScanner scanner = new ClassScanner();
            scanner.scan(entry.getInputStream());
            t.info.modifiers = scanner.modifiers;
            t.superClass = scanner.superClass;
            t.interfaceClasses = scanner.interfaces;
            if (!scanner.hasLoadType) {
                LOGGER.log(Level.SEVERE, "Missing Sys.loadType() " + t);
            }
        } else if (moduleFile.getFile().getName().endsWith(".sjar")) {
            t.superClass = elem.get("extends", BComponent.class.getName());
            Builder.readInterfaces(t, elem);
            t.info.modifiers = 1;
            if (elem.get("abstract", "false").equalsIgnoreCase("true")) {
                t.info.modifiers |= 0x400;
            }
            if (elem.get("final", "false").equalsIgnoreCase("true")) {
                t.info.modifiers |= 0x10;
            }
        } else {
            throw new IllegalStateException();
        }
        NTypeInfo dup = m.typesBySpec.get(t.toString());
        if (dup != null) {
            LOGGER.log(Level.SEVERE, "Duplicate typespec " + dup + " & " + t);
        } else {
            m.typesBySpec.put(t.toString(), t.info);
        }
        dup = m.typesByClass.get(t.info.className);
        if (dup != null) {
            LOGGER.log(Level.SEVERE, "Duplicate classes " + dup + " & " + t);
        } else {
            m.typesByClass.put(t.info.className, t.info);
        }
        return t;
    }

    private static void readFile(TypeBuild t, XElem elem) {
        try {
            for (int i = 0; i < elem.contentSize(); ++i) {
                XElem child = elem.elem(i);
                if (!child.name().equals("ext")) continue;
                String ext = TextUtil.toLowerCase((String)child.get("name"));
                NTypeInfo dup = t.moduleBuild.typesByFileExt.get(ext);
                if (dup != null) {
                    LOGGER.warning("Duplicate files for ext \"" + ext + "\": " + dup + " & " + t);
                    continue;
                }
                t.moduleBuild.typesByFileExt.put(ext, t.info);
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Cannot map type as file \"" + t + '\"', e);
        }
    }

    private static void readAgent(TypeBuild t, XElem elem) {
        try {
            t.info.agentInfo = new NAgentInfo(t.info);
            String permissionsStr = elem.get("requiredPermissions", null);
            t.info.agentInfo.permissions = permissionsStr != null ? BPermissions.make(permissionsStr) : BPermissions.adminWrite;
            t.info.agentInfo.appName = elem.get("app", null);
            String preferredDefault = elem.get("default", null);
            if ("true".equalsIgnoreCase(preferredDefault)) {
                t.info.agentInfo.defaultPreferrence = 1;
            } else if ("false".equalsIgnoreCase(preferredDefault)) {
                t.info.agentInfo.defaultPreferrence = 2;
            }
            for (int i = 0; i < elem.contentSize(); ++i) {
                XElem child = elem.elem(i);
                if (!child.name().equals("on")) continue;
                t.addAgentOn(child.get("type", "baja:Object"), child.get("match", ""));
            }
        }
        catch (XException e) {
            LOGGER.log(Level.SEVERE, "Cannot map type as agent \"" + t + "\": " + (Object)((Object)e));
            t.info.agentInfo = null;
            t.agentsOn = null;
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Cannot map type as agent \"" + t + '\"', e);
            t.info.agentInfo = null;
            t.agentsOn = null;
        }
    }

    private static void readAdapter(TypeBuild t, XElem elem) {
        try {
            AdapterBuild c = new AdapterBuild(t);
            c.fromSpec = elem.get("from");
            c.toSpec = elem.get("to");
            t.moduleBuild.adapterBuilds.add(c);
        }
        catch (XException e) {
            LOGGER.log(Level.SEVERE, "Cannot map type as adapter \"" + t + "\": " + (Object)((Object)e));
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Cannot map type as adapter \"" + t + '\"', e);
        }
    }

    private static void readInterfaces(TypeBuild t, XElem elem) {
        XElem interfacesElem = elem.elem("interfaces");
        if (interfacesElem != null) {
            XElem[] interfacesElems = interfacesElem.elems("interface");
            String[] interfaceClasses = new String[interfacesElems.length];
            for (int k = 0; k < interfacesElems.length; ++k) {
                interfaceClasses[k] = interfacesElems[k].get("class");
            }
            t.interfaceClasses = interfaceClasses;
        } else {
            t.interfaceClasses = new String[0];
        }
    }

    private void init(ModuleBuild[] moduleBuilds, NRegistry registry) {
        this.typesByFileExt.putAll(registry.db.typesByFileExt);
        this.typesByOrdScheme.putAll(registry.db.typesByOrdScheme);
        this.typesBySpecString.putAll(registry.db.typesBySpec);
        this.defs.putAll(registry.db.defs);
        this.lexicons.putAll(registry.db.lexicons);
        for (int i = 0; i < registry.db.types.length; ++i) {
            this.typesByClass.put(registry.db.types[i].className, registry.db.types[i]);
        }
        this.init(moduleBuilds, registry.db.modules.length);
    }

    private void init(ModuleBuild[] moduleBuilds, int initialModuleId) {
        this.moduleBuilds = moduleBuilds;
        for (int ixModule = 0; ixModule < moduleBuilds.length; ++ixModule) {
            ModuleBuild m = moduleBuilds[ixModule];
            m.info.id = ixModule + initialModuleId;
            for (int ixType = 0; ixType < m.info.types.length; ++ixType) {
                NTypeInfo t = m.info.types[ixType];
                TypeBuild tb = m.typeBuilds.get(ixType);
                t.id = this.typeBuilds.size();
                this.typeBuilds.add(tb);
                this.typesBySpecString.put(t.typeSpec.toString(), tb.info);
                this.typeBuildsBySpecString.put(t.typeSpec.toString(), tb);
            }
            for (String scheme : m.typesByOrdScheme.keySet()) {
                if (this.typesByOrdScheme.containsKey(scheme)) {
                    LOGGER.warning("Multiple types registered for ordScheme \"" + scheme + '\"');
                    continue;
                }
                this.typesByOrdScheme.put(scheme, m.typesByOrdScheme.get(scheme));
            }
            for (String ext : m.typesByFileExt.keySet()) {
                NTypeInfo dup = this.typesByFileExt.get(ext);
                NTypeInfo t = m.typesByFileExt.get(ext);
                if (dup != null) {
                    LOGGER.warning("Duplicate files for ext \"" + ext + "\": " + dup + " & " + t);
                    continue;
                }
                this.typesByFileExt.put(ext, t);
            }
            for (String c : m.typesByClass.keySet()) {
                NTypeInfo t = m.typesByClass.get(c);
                NTypeInfo dup = this.typesByClass.get(c);
                if (dup != null) {
                    LOGGER.log(Level.SEVERE, "Duplicate classes " + dup + " & " + t);
                    continue;
                }
                this.typesByClass.put(c, t);
            }
            for (String name : m.defs.keySet()) {
                String[] toAdd = m.defs.get(name);
                String[] values = this.defs.get(name);
                if (values == null) {
                    this.defs.put(name, toAdd);
                    continue;
                }
                this.defs.put(name, ArrayUtil.add(values, toAdd));
            }
            m.lexicons.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> this.lexicons.put((String)entry.getKey(), (NLexiconInfo)entry.getValue()));
            this.adapterBuilds.addAll(m.adapterBuilds);
        }
    }

    private void resolveSuperAndInterfaces() {
        this.typeBuilds.forEach(t -> {
            try {
                this.resolveSuperAndInterfaces((TypeBuild)t);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Cannot resolve type \"" + t + '\"', e);
            }
        });
    }

    private void resolveSuperAndInterfaces(TypeBuild t) throws Exception {
        boolean isInterface = t.info.isInterface();
        if (!isInterface && t.superClass != null) {
            t.info.superType = this.typesByClass.get(t.superClass);
            if (t.info.superType == null && !t.info.className.equals("javax.baja.sys.BObject")) {
                LOGGER.log(Level.SEVERE, "Missing super type \"" + t.superClass + "\" for \"" + t + '\"');
            }
        }
        ArrayList<NTypeInfo> interfaces = null;
        if (t.interfaceClasses != null) {
            for (String interfaceClass : t.interfaceClasses) {
                NTypeInfo interfaceType = this.typesByClass.get(interfaceClass);
                if (interfaceType == null) {
                    int dot = interfaceClass.lastIndexOf(36);
                    if (dot < 0) {
                        dot = interfaceClass.lastIndexOf(46);
                    }
                    if (dot <= 0 || dot >= interfaceClass.length() - 3 || interfaceClass.charAt(dot + 1) != 'B' || interfaceClass.charAt(dot + 2) != 'I') continue;
                    LOGGER.log(Level.SEVERE, "Missing interface type \"" + interfaceClass + "\" for \"" + t + '\"');
                    continue;
                }
                if (interfaces == null) {
                    interfaces = new ArrayList<NTypeInfo>();
                }
                interfaces.add(interfaceType);
            }
        }
        if (interfaces != null) {
            t.info.interfaces = interfaces.toArray(new NTypeInfo[interfaces.size()]);
        }
    }

    private void resolveIsTypes() {
        this.typeBuilds.forEach(t -> {
            try {
                this.resolveIsTypes((TypeBuild)t);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Cannot resolve type \"" + t + '\"', e);
            }
        });
    }

    private void resolveIsTypes(TypeBuild t) throws Exception {
        IsMap map = new IsMap();
        NTypeInfo x = t.info;
        while (x != null) {
            map.add(x);
            x = x.superType;
        }
        x = t.info;
        while (x != null) {
            this.mapInterfaces(map, x);
            x = x.superType;
        }
        t.info.is = map.toArray();
    }

    private void mapInterfaces(IsMap map, NTypeInfo t) {
        if (t.isInterface()) {
            map.add(t);
        }
        for (int i = 0; i < t.interfaces.length; ++i) {
            this.mapInterfaces(map, t.interfaces[i]);
        }
    }

    private void resolveAdapters() {
        ArrayList<AdapterBuild> validAdapters = new ArrayList<AdapterBuild>(this.adapterBuilds.size());
        this.adapterBuilds.forEach(a -> {
            try {
                if (this.resolveAdapter((AdapterBuild)a)) {
                    validAdapters.add((AdapterBuild)a);
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Cannot resolver adapter \"" + a.info.type + '\"', e);
            }
        });
        this.adapterBuilds = validAdapters;
    }

    private boolean resolveAdapter(AdapterBuild a) {
        NTypeInfo t = this.typesBySpecString.get(a.fromSpec);
        if (t == null) {
            LOGGER.log(Level.SEVERE, "Cannot find from type \"" + a.fromSpec + "\" for \"" + a.info.type + '\"');
            return false;
        }
        a.info.from = t;
        t = this.typesBySpecString.get(a.toSpec);
        if (t == null) {
            LOGGER.log(Level.SEVERE, "Cannot find to type \"" + a.toSpec + "\" for \"" + a.info.type + '\"');
            return false;
        }
        a.info.to = t;
        return true;
    }

    private void agentize() {
        this.agentsToTarget();
        this.agentsToArray();
    }

    private void agentsToTarget() {
        this.typeBuilds.forEach(t -> {
            try {
                this.agentToTarget((TypeBuild)t);
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Cannot agentize \"" + t + '\"', e);
            }
        });
    }

    private void agentToTarget(TypeBuild t) throws Exception {
        List<AgentTargetBuild> on = t.agentsOn;
        if (on == null) {
            return;
        }
        for (AgentTargetBuild agentTarget : t.agentsOn) {
            String spec = agentTarget.on;
            String match = agentTarget.match;
            NTypeInfo target = this.typesBySpecString.get(spec);
            if (target == null) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Cannot find agent target type \"" + spec + "\" for \"" + t + "\"");
                continue;
            }
            TypeBuild tb = this.typeBuildsBySpecString.get(spec);
            if (tb == null) {
                t.moduleBuild.addAgent(t.info, match, target);
                continue;
            }
            tb.addAgent(t.info, match);
        }
    }

    private void agentsToArray() {
        this.typeBuilds.forEach(t -> {
            try {
                if (t.agentsList != null && !t.agentsList.isEmpty()) {
                    t.info.agents = t.agentsList.toArray(new NTypeInfo.NAgentOnInfo[t.agentsList.size()]);
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Cannot map agent to array \"" + t + '\"', e);
            }
        });
    }

    private void write(NRegistry registry) throws Exception {
        if (!registry.dir().exists() && !registry.dir().mkdirs()) {
            throw new BajaRuntimeException(String.format("Failed to create directory %s", registry.dir().getPath()));
        }
        this.writeChecksum(registry);
        this.writeDatabase(registry);
    }

    private void writeChecksum(NRegistry registry) throws Exception {
        int len = this.moduleBuilds.length;
        HashMap<String, RegistryChecksum.ModuleSnapshot> map = new HashMap<String, RegistryChecksum.ModuleSnapshot>(len * 3);
        for (ModuleBuild build : this.moduleBuilds) {
            map.put(build.snapshot.name, build.snapshot);
        }
        RegistryChecksum r = new RegistryChecksum();
        r.modules = map;
        r.enabledRuntimeProfiles = Arrays.asList(Nre.getSupportedProfiles());
        r.enabledRuntimeProfiles.sort(Comparator.naturalOrder());
        r.write(registry.chkFile());
    }

    private void writeDatabase(NRegistry registry) throws Exception {
        int i;
        RegistryDatabase db = new RegistryDatabase();
        db.modules = this.sortModules();
        db.minfoByModulePartName = new HashMap<String, NModuleInfo>(db.modules.length * 2);
        db.moduleMapByModuleName = new HashMap<String, Map<RuntimeProfile, NModuleInfo>>(db.modules.length * 2);
        for (NModuleInfo module : db.modules) {
            db.minfoByModulePartName.put(module.modulePartName, module);
            Map<RuntimeProfile, NModuleInfo> byContent = db.moduleMapByModuleName.get(module.moduleName);
            if (byContent == null) {
                byContent = new HashMap<RuntimeProfile, NModuleInfo>();
                db.moduleMapByModuleName.put(module.moduleName, byContent);
            }
            byContent.put(module.runtimeProfile, module);
        }
        db.types = new NTypeInfo[this.typeBuilds.size()];
        for (i = 0; i < this.typeBuilds.size(); ++i) {
            db.types[i] = this.typeBuilds.get((int)i).info;
        }
        db.typesBySpec = this.typesBySpecString;
        db.defs = this.defs;
        db.fileExts = this.sortFileExts();
        db.typesByFileExt = this.typesByFileExt;
        db.ordSchemes = this.sortOrdSchemes();
        db.typesByOrdScheme = this.typesByOrdScheme;
        db.lexicons = this.lexicons;
        db.adapters = new NAdapterInfo[this.adapterBuilds.size()];
        for (i = 0; i < this.adapterBuilds.size(); ++i) {
            db.adapters[i] = this.adapterBuilds.get((int)i).info;
        }
        db.write(registry.dbFile());
    }

    private NModuleInfo[] sortModules() {
        return (NModuleInfo[])Arrays.stream(this.moduleBuilds).sorted((b1, b2) -> b1.info.modulePartName.compareTo(b2.info.modulePartName)).map(b -> b.info).toArray(NModuleInfo[]::new);
    }

    private String[] sortFileExts() {
        return (String[])this.typesByFileExt.keySet().stream().sorted().toArray(String[]::new);
    }

    private String[] sortOrdSchemes() {
        return (String[])this.typesByOrdScheme.keySet().stream().sorted().toArray(String[]::new);
    }

    static class AdapterBuild {
        TypeBuild typeBuild;
        NAdapterInfo info;
        String fromSpec;
        String toSpec;

        AdapterBuild(TypeBuild typeBuild) {
            this.typeBuild = typeBuild;
            this.info = new NAdapterInfo();
            this.info.type = typeBuild.info;
        }

        public String toString() {
            return this.info.toString();
        }

        public int hashCode() {
            return this.typeBuild.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AdapterBuild)) {
                return false;
            }
            AdapterBuild ab = (AdapterBuild)o;
            return this.typeBuild.equals(ab.typeBuild) && this.fromSpec.equals(ab.fromSpec) && this.toSpec.equals(ab.toSpec);
        }
    }

    static class AgentTargetBuild {
        String on;
        String match;

        public AgentTargetBuild(String on, String match) {
            this.on = on;
            this.match = match;
        }
    }

    static class TypeBuild {
        ModuleBuild moduleBuild;
        NTypeInfo info;
        String superClass;
        String[] interfaceClasses;
        String ordScheme;
        List<AgentTargetBuild> agentsOn;
        List<NTypeInfo.NAgentOnInfo> agentsList;

        TypeBuild(ModuleBuild module, BTypeSpec typeSpec) {
            this.moduleBuild = module;
            this.info = new NTypeInfo(-1, typeSpec, module.info.runtimeProfile);
        }

        public void addAgentOn(String on, String match) {
            if (this.agentsOn == null) {
                this.agentsOn = new ArrayList<AgentTargetBuild>();
            }
            this.agentsOn.add(new AgentTargetBuild(on, match));
        }

        public void addAgent(NTypeInfo agentType, String match) {
            if (this.agentsList == null) {
                this.agentsList = new ArrayList<NTypeInfo.NAgentOnInfo>();
            }
            this.agentsList.add(new NTypeInfo.NAgentOnInfo(agentType, match));
        }

        public int hashCode() {
            return this.moduleBuild.hashCode() * this.info.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof TypeBuild)) {
                return false;
            }
            TypeBuild tb = (TypeBuild)o;
            return this.moduleBuild.equals(tb.moduleBuild) && this.info.equals(tb.info);
        }

        public String toString() {
            return this.info.toString();
        }
    }

    static class ModuleBuild {
        NModuleInfo info;
        RegistryChecksum.ModuleSnapshot snapshot;
        Map<String, String[]> defs = new HashMap<String, String[]>();
        Map<String, NLexiconInfo> lexicons = new HashMap<String, NLexiconInfo>();
        List<TypeBuild> typeBuilds = new ArrayList<TypeBuild>();
        Map<String, NTypeInfo> typesByOrdScheme = new HashMap<String, NTypeInfo>();
        Map<String, NTypeInfo> typesBySpec = new HashMap<String, NTypeInfo>();
        Map<String, NTypeInfo> typesByClass = new HashMap<String, NTypeInfo>();
        Map<String, NTypeInfo> typesByFileExt = new HashMap<String, NTypeInfo>();
        List<AdapterBuild> adapterBuilds = new ArrayList<AdapterBuild>();
        Map<String, NTypeInfo.NAgentOnInfo[]> agentTypesByTargetSpec = new HashMap<String, NTypeInfo.NAgentOnInfo[]>();

        ModuleBuild() {
            this.info = new NModuleInfo(-1);
            this.snapshot = new RegistryChecksum.ModuleSnapshot();
        }

        public void addAgent(NTypeInfo agentType, String match, NTypeInfo targetType) {
            NTypeInfo.NAgentOnInfo[] agents = this.agentTypesByTargetSpec.get(targetType.typeSpec.toString());
            agents = agents == null ? new NTypeInfo.NAgentOnInfo[]{new NTypeInfo.NAgentOnInfo(agentType, match)} : ArrayUtil.addOne(agents, new NTypeInfo.NAgentOnInfo(agentType, match));
            this.agentTypesByTargetSpec.put(targetType.typeSpec.toString(), agents);
        }

        public int hashCode() {
            return this.info.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ModuleBuild)) {
                return false;
            }
            ModuleBuild mb = (ModuleBuild)o;
            return this.info.equals(mb.info);
        }

        public String toString() {
            return this.info.toString();
        }
    }

    static class IsMap {
        private final ArrayList<NTypeInfo> list = new ArrayList();
        private final IntHashMap byId = new IntHashMap();

        IsMap() {
        }

        void add(NTypeInfo t) {
            if (this.byId.get(t.id) != null) {
                return;
            }
            this.list.add(t);
            this.byId.put(t.id, (Object)t);
        }

        NTypeInfo[] toArray() {
            return this.list.toArray(new NTypeInfo[this.list.size()]);
        }
    }
}

