/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.metrics;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public interface BISubLicenseable
extends BInterface {
    public static final Type TYPE = Sys.loadType(BISubLicenseable.class);
    public static final Set<BTypeSpec> WHITELIST = Collections.unmodifiableSet(Stream.of(BTypeSpec.make("niagaraDriver:NiagaraEdgeLiteStation"), BTypeSpec.make("niagaraDriver:NiagaraProxyExt"), BTypeSpec.make("niagaraDriver:NiagaraHistoryImport"), BTypeSpec.make("niagaraDriver:NiagaraHistoryExport"), BTypeSpec.make("niagaraDriver:NiagaraSystemHistoryImport"), BTypeSpec.make("niagaraDriver:NiagaraSystemHistoryExport"), BTypeSpec.make("niagaraDriver:NiagaraScheduleExport"), BTypeSpec.make("niagaraDriver:NiagaraScheduleImportExt"), BTypeSpec.make("niagaraSystemIndex:NiagaraSystemIndexDeviceExt")).collect(Collectors.toSet()));
    public static final Set<BTypeSpec> LIMIT_INCREMENT_WHITELIST = Collections.unmodifiableSet(Stream.of(BTypeSpec.make("niagaraDriver:NiagaraEdgeLiteStation")).collect(Collectors.toSet()));

    public String getLicenseKeyPrefix();

    default public double getLicenseLimitIncrement() {
        return 1.0;
    }

    public static String getLicenseKey(BObject obj, String baseLicenseKey) {
        String licensePrefix;
        String base;
        String string = base = baseLicenseKey != null ? baseLicenseKey : obj.getType().getModule().getModuleName();
        if (BISubLicenseable.isSubLicenseable(obj) && (licensePrefix = ((BISubLicenseable)((Object)obj)).getLicenseKeyPrefix()) != null && !licensePrefix.isEmpty()) {
            return licensePrefix + '_' + base;
        }
        return base;
    }

    public static double getLicenseLimitIncrement(BObject obj) {
        if (BISubLicenseable.allowSubLicenseLimitIncrement(obj)) {
            return ((BISubLicenseable)((Object)obj)).getLicenseLimitIncrement();
        }
        return 1.0;
    }

    public static boolean isSubLicenseable(BObject obj) {
        if (obj == null) {
            return false;
        }
        Type objType = obj.getType();
        return objType.is(TYPE) && WHITELIST.contains(objType.getTypeSpec());
    }

    public static boolean allowSubLicenseLimitIncrement(BObject obj) {
        if (obj == null) {
            return false;
        }
        Type objType = obj.getType();
        return objType.is(TYPE) && LIMIT_INCREMENT_WHITELIST.contains(objType.getTypeSpec());
    }
}

