/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.Brand;
import com.tridium.sys.license.dom.HostLicenseSet;
import com.tridium.sys.license.dom.LicenseSet;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.util.LexiconModule;
import javax.baja.xml.XWriter;

public class LicenseDatabase
extends LicenseSet {
    public static final LicenseDatabase LOCAL_INSTANCE = new LocalLicenseDatabase();
    protected BDirectory licenseDbRoot;
    private static final Logger LOG = Logger.getLogger("sys.license");
    private static final LexiconModule lex = LexiconModule.make("baja");
    public static final FilePath LICENSES_DIR_PATH = new FilePath("!security/licenses");

    public LicenseDatabase(BDirectory licenseDbRoot) {
        this.licenseDbRoot = licenseDbRoot;
    }

    protected LicenseDatabase() {
    }

    @Override
    public Iterator<VendorLicense> iterator() throws Exception {
        return new LicenseDatabaseIterator();
    }

    @Override
    public boolean add(VendorLicense license) throws Exception {
        if (license.getHostId().equals("*")) {
            return false;
        }
        VendorLicense existing = this.getLicense(license.getHostId(), license.getVendor(), license.getBrandId());
        if (existing == null || license.getGenerated() >= existing.getGenerated()) {
            BDirectory hostDir = this.makeHostDirectory(license.getHostId());
            BIFile file = this.getSpace().makeFile(hostDir.getFilePath().merge(license.getLicenseName() + ".license"));
            OutputStream out = file.getOutputStream();
            this.writeLicense(license, out);
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(VendorLicense license) throws Exception {
        return this.removeLicense(license.getHostId(), license.getVendor(), license.getBrandId());
    }

    @Override
    public void clear() throws Exception {
        BDirectory dir = this.getSpace().makeDir(this.getRootPath(), null);
        for (BIFile hostDir : dir.listFiles()) {
            if (!(hostDir instanceof BDirectory)) continue;
            boolean deleteDir = true;
            for (BIFile hostFile : ((BDirectory)hostDir).listFiles()) {
                if ("license".equals(hostFile.getExtension())) {
                    hostFile.delete();
                    continue;
                }
                deleteDir = false;
            }
            if (!deleteDir) continue;
            hostDir.delete();
        }
    }

    @Override
    public HostLicenseSet toHostLicenseSet(String hostId, String brandId) throws Exception {
        this.init();
        HostLicenseSet r = null;
        BDirectory dir = this.getHostDirectory(hostId);
        if (dir != null) {
            for (BIFile kid : dir.listFiles()) {
                if (!"license".equals(kid.getExtension())) continue;
                VendorLicense lic = VendorLicense.make(kid);
                if (brandId != null && lic.getBrandId() != null && !lic.getBrandId().equals(brandId)) continue;
                if (r == null) {
                    r = new HostLicenseSet();
                }
                if (r.getVendorLicense(lic.getVendor()) != null) {
                    throw new RuntimeException("Duplicate licenses for same hostId and vendor: " + lic.getVendor());
                }
                r.add(lic);
            }
        }
        return null;
    }

    public String[] getHostIds() {
        this.init();
        ArrayList<String> result = new ArrayList<String>();
        BDirectory rootDir = (BDirectory)this.getSpace().findFile(this.getRootPath());
        if (rootDir != null) {
            block0: for (BIFile rootKid : rootDir.listFiles()) {
                if (!(rootKid instanceof BDirectory)) continue;
                for (BIFile hostKid : ((BDirectory)rootKid).listFiles()) {
                    if (!"license".equals(hostKid.getExtension())) continue;
                    result.add(rootKid.getFileName());
                    continue block0;
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public VendorLicense[] getLicensesForAllBrands(String hostId) {
        this.init();
        ArrayList<VendorLicense> result = new ArrayList<VendorLicense>();
        BDirectory dir = this.getHostDirectory(hostId);
        if (dir != null) {
            for (BIFile kid : dir.listFiles()) {
                if (!"license".equals(kid.getExtension())) continue;
                try {
                    VendorLicense lic = VendorLicense.make(kid);
                    result.add(lic);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, lex.getText("licenseDatabase.errorFindingLicense", null, hostId), e);
                }
            }
        }
        return result.toArray(new VendorLicense[result.size()]);
    }

    public VendorLicense[] getLicenses(String hostId) {
        return this.getLicenses(hostId, null);
    }

    public VendorLicense[] getLicenses(String hostId, String brandId) {
        this.init();
        ArrayList<VendorLicense> result = new ArrayList<VendorLicense>();
        String b = brandId;
        BDirectory dir = this.getHostDirectory(hostId);
        if (dir != null) {
            for (BIFile kid : dir.listFiles()) {
                if (!"license".equals(kid.getExtension())) continue;
                try {
                    VendorLicense lic = VendorLicense.make(kid);
                    if (b != null && lic.getBrandId() != null && !b.equals(lic.getBrandId())) continue;
                    result.add(lic);
                    if (b != null) continue;
                    b = lic.getBrandId();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, lex.getText("licenseDatabase.errorFindingLicense", null, hostId), e);
                }
            }
        }
        return result.toArray(new VendorLicense[result.size()]);
    }

    public VendorLicense getLicense(String hostId, String vendor, String brandId) {
        this.init();
        BDirectory dir = this.getHostDirectory(hostId);
        if (dir != null) {
            String licenseName = "tridium".equalsIgnoreCase(vendor) && brandId != null ? brandId : vendor;
            BIFile result = (BIFile)dir.getNavChild(licenseName + ".license");
            try {
                return result == null ? null : VendorLicense.make(result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean removeLicense(String hostId, String vendor, String brandId) throws Exception {
        String licenseName;
        BIFile result;
        BDirectory dir = this.getHostDirectory(hostId);
        if (dir != null && (result = (BIFile)dir.getNavChild((licenseName = "tridium".equalsIgnoreCase(vendor) && brandId != null ? brandId : vendor) + ".license")) != null) {
            result.delete();
            if (dir.listFiles().length == 0) {
                dir.delete();
            }
            return true;
        }
        return false;
    }

    public void importFile(BIFile file) throws Exception {
        if ("lar".equals(file.getExtension())) {
            this.importLicenses(file);
        } else if ("license".equals(file.getExtension())) {
            this.add(VendorLicense.make(file));
        } else {
            throw new IllegalArgumentException("importFile argument must be a license file or license archive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLicenses(BIFile file) throws Exception {
        InputStream in = file.getInputStream();
        try {
            this.importLicenses(in);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLicenses(InputStream rawIn) throws Exception {
        ZipInputStream zipIn = rawIn instanceof ZipInputStream ? (ZipInputStream)rawIn : new ZipInputStream(rawIn);
        try {
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (entry.getName().endsWith(".license")) {
                    this.add(VendorLicense.make("lar", zipIn, false));
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        finally {
            if (!(rawIn instanceof ZipInputStream)) {
                try {
                    zipIn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLicenses(OutputStream rawOut) throws Exception {
        this.init();
        ZipOutputStream zipOut = rawOut instanceof ZipOutputStream ? (ZipOutputStream)rawOut : new ZipOutputStream(rawOut);
        try {
            BDirectory root = (BDirectory)this.getSpace().findFile(this.getRootPath());
            if (root == null) {
                return;
            }
            for (BIFile hostDir : root.listFiles()) {
                if (!(hostDir instanceof BDirectory)) continue;
                for (BIFile file : ((BDirectory)hostDir).listFiles()) {
                    if (!"license".equals(file.getExtension())) continue;
                    VendorLicense license = VendorLicense.make(file);
                    ZipEntry entry = new ZipEntry("licenses/" + license.getHostId() + "/" + license.getLicenseName() + ".license");
                    zipOut.putNextEntry(entry);
                    this.writeLicense(license, zipOut);
                    zipOut.closeEntry();
                }
            }
        }
        finally {
            if (!(rawOut instanceof ZipOutputStream)) {
                try {
                    zipOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLicenses(String[] hostIds, OutputStream rawOut) throws Exception {
        this.init();
        ZipOutputStream zipOut = rawOut instanceof ZipOutputStream ? (ZipOutputStream)rawOut : new ZipOutputStream(rawOut);
        try {
            BDirectory root = (BDirectory)this.getSpace().findFile(this.getRootPath());
            if (root == null) {
                return;
            }
            for (String hostId : hostIds) {
                BDirectory hostDir = (BDirectory)root.getNavChild(hostId);
                if (hostDir == null) continue;
                for (BIFile file : hostDir.listFiles()) {
                    if (!"license".equals(file.getExtension())) continue;
                    VendorLicense license = VendorLicense.make(file);
                    ZipEntry entry = new ZipEntry("licenses/" + license.getHostId() + "/" + license.getLicenseName() + ".license");
                    zipOut.putNextEntry(entry);
                    this.writeLicense(license, zipOut);
                    zipOut.closeEntry();
                }
            }
        }
        finally {
            if (!(rawOut instanceof ZipOutputStream)) {
                try {
                    zipOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected BDirectory getHostDirectory(String hostId) {
        return (BDirectory)this.getSpace().findFile(this.getRootPath().merge(hostId));
    }

    protected BDirectory makeHostDirectory(String hostId) throws Exception {
        return this.getSpace().makeDir(this.getRootPath().merge(hostId));
    }

    protected BFileSpace getSpace() {
        return this.licenseDbRoot.getFileSpace();
    }

    protected FilePath getRootPath() {
        return this.licenseDbRoot.getFilePath();
    }

    protected void init() {
    }

    protected void writeLicense(VendorLicense license, OutputStream outStream) throws Exception {
        XWriter writer = new XWriter(outStream);
        license.save(writer);
        writer.flush();
    }

    private class LicenseDatabaseIterator
    implements Iterator<VendorLicense> {
        private final String[] hostIds;
        private int hostIdx;
        private VendorLicense[] licensesForHost;
        private int licenseIdx;

        public LicenseDatabaseIterator() throws Exception {
            this.hostIds = LicenseDatabase.this.getHostIds();
            this.hostIdx = -1;
            this.licensesForHost = null;
            this.licenseIdx = -1;
        }

        @Override
        public boolean hasNext() {
            try {
                while (true) {
                    if (this.licensesForHost == null) {
                        if (this.hostIdx + 1 < this.hostIds.length) {
                            ++this.hostIdx;
                            this.licensesForHost = LicenseDatabase.this.getLicenses(this.hostIds[this.hostIdx]);
                            this.licenseIdx = 0;
                            continue;
                        }
                        this.licensesForHost = null;
                        this.licenseIdx = -1;
                        return false;
                    }
                    if (this.licenseIdx < this.licensesForHost.length) {
                        return true;
                    }
                    this.licensesForHost = null;
                    this.licenseIdx = -1;
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e);
            }
        }

        @Override
        public VendorLicense next() {
            if (this.hasNext()) {
                VendorLicense result = this.licensesForHost[this.licenseIdx];
                ++this.licenseIdx;
                return result;
            }
            throw new IllegalStateException("Called next() when hasNext==false");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class LocalLicenseDatabase
    extends LicenseDatabase {
        private boolean initialized = false;
        private String brandId;
        private final List<VendorLicense> copyList = new ArrayList<VendorLicense>();

        public LocalLicenseDatabase() {
            try {
                this.licenseDbRoot = BFileSystem.INSTANCE.makeDir(new FilePath("!security/licenses/db"));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e);
            }
        }

        @Override
        protected void init() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            try {
                this.brandId = this.getBrand();
                this.importDir(BFileSystem.INSTANCE.makeDir(LICENSES_DIR_PATH), false);
                this.importDir(BFileSystem.INSTANCE.makeDir(LICENSES_DIR_PATH.merge("inbox")), true);
                this.exportNewLicenses();
            }
            catch (Exception e) {
                Logger.getLogger("sys.license").log(Level.SEVERE, "Error initializing local license database", e);
                e.printStackTrace();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getBrand() {
            BIFile licDir;
            Object object;
            BIFile brandProps = BFileSystem.INSTANCE.findFile(Brand.BRAND_PROPS_PATH);
            if (brandProps != null) {
                Properties props = new Properties();
                try {
                    InputStream in222 = brandProps.getInputStream();
                    object = null;
                    try {
                        props.load(in222);
                        if (props.containsKey("brand.id")) {
                            String string = props.getProperty("brand.id");
                            return string;
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (in222 != null) {
                            if (object != null) {
                                try {
                                    in222.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                in222.close();
                            }
                        }
                    }
                }
                catch (Exception in222) {
                    // empty catch block
                }
            }
            BIFile[] files = (licDir = BFileSystem.INSTANCE.findFile(LICENSES_DIR_PATH)) == null ? new BIFile[]{} : BFileSystem.INSTANCE.getChildren(licDir);
            object = files;
            int n = ((BIFile[])object).length;
            int n2 = 0;
            while (n2 < n) {
                Object file = object[n2];
                if ("license".equals(file.getExtension())) {
                    VendorLicense lic = new VendorLicense();
                    try {
                        lic.load((BIFile)file);
                        String licHostId = lic.getHostId();
                        if (licHostId.equals(Sys.getHostId()) && lic.getBrandId() != null) {
                            return lic.getBrandId();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            return null;
        }

        protected void importDir(BDirectory dir, boolean moveAllFiles) throws Exception {
            Logger log = Logger.getLogger("sys.license");
            for (BIFile file : dir.listFiles()) {
                if ("license".equals(file.getExtension())) {
                    VendorLicense license = VendorLicense.make(file);
                    this.add(license);
                    if (!moveAllFiles && license.getHostId().equals(Sys.getHostId())) continue;
                    try {
                        file.delete();
                        log.info("moved " + file);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "error deleting " + file, e);
                    }
                    continue;
                }
                if (!"lar".equals(file.getExtension())) continue;
                this.importFile(file);
                try {
                    file.delete();
                    log.info("imported and removed license archive " + file);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "error deleting " + file, e);
                }
            }
        }

        @Override
        public boolean add(VendorLicense license) throws Exception {
            boolean added = super.add(license);
            if (!added) {
                return added;
            }
            String source = license.getSource();
            if (Sys.getHostId().equals(license.getHostId()) && ("lar".equals(source) || source.indexOf("licenses/inbox/") > 0)) {
                this.copyList.add(license);
            }
            if (this.brandId == null && Sys.getHostId().equals(license.getHostId()) && license.getBrandId() != null) {
                this.brandId = license.getBrandId();
            }
            return added;
        }

        private void exportNewLicenses() {
            Logger log = Logger.getLogger("sys.license");
            if (this.brandId == null) {
                log.severe("Could not determine brand");
                return;
            }
            for (VendorLicense lic : this.copyList) {
                if (lic.getBrandId() != null && !lic.getBrandId().equals(this.brandId)) continue;
                try {
                    FilePath exportPath = new FilePath("!security/licenses/" + lic.getLicenseName() + ".license");
                    BIFile exportFile = BFileSystem.INSTANCE.makeFile(exportPath);
                    log.info("LicenseDatabase is exporting new license to " + exportFile);
                    lic.save(exportFile);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, String.format("LicenseDatabase could not copy license file to %s", LICENSES_DIR_PATH.getBody()), e);
                }
            }
            this.copyList.clear();
        }
    }
}

