/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.dom.VendorCertificate;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.nre.util.TextUtil;

public class CertificateSet {
    private List<VendorCertificate> list = new ArrayList<VendorCertificate>();

    public VendorCertificate[] getCertificates() throws Exception {
        VendorCertificate[] result = new VendorCertificate[this.list.size()];
        this.list.toArray(result);
        return result;
    }

    public boolean add(VendorCertificate cert) throws Exception {
        this.list.add(cert);
        return false;
    }

    public boolean remove(VendorCertificate cert) throws Exception {
        return this.list.remove(cert);
    }

    public void clear() throws Exception {
        this.list.clear();
    }

    public void load(BDirectory dir) {
        BIFile[] files = dir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            BIFile f = files[i];
            if (f.isDirectory() || !"certificate".equals(f.getExtension())) continue;
            try {
                this.add(VendorCertificate.make(f));
                continue;
            }
            catch (Exception e) {
                System.out.println("ERROR: Cannot read \"" + f + "\"");
                e.printStackTrace();
            }
        }
    }

    public void dump() throws Exception {
        this.dump(new PrintWriter(System.out));
    }

    public void dump(PrintWriter out) throws Exception {
        out.println(TextUtil.getClassName(this.getClass()));
        Iterator<VendorCertificate> i = this.list.iterator();
        while (i.hasNext()) {
            i.next().dump(out);
        }
    }
}

