/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import com.tridium.sys.Nre;
import com.tridium.sys.license.LicenseFile;
import com.tridium.sys.license.NLicenseManager;
import com.tridium.sys.license.dom.LicenseDatabase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.sys.Sys;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class NodeLockedLicenseManager
extends NLicenseManager {
    @Override
    protected LicenseFile[] loadLicenses() {
        LicenseDatabase.LOCAL_INSTANCE.getHostIds();
        ArrayList<NodeLockedLicense> v = new ArrayList<NodeLockedLicense>();
        File dir = new File(Sys.getNiagaraHome(), "security" + File.separator + "licenses");
        File[] list = dir.listFiles();
        for (int i = 0; list != null && i < list.length; ++i) {
            if (!list[i].getName().toLowerCase().endsWith(".license")) continue;
            NodeLockedLicense lic = new NodeLockedLicense(list[i]);
            lic.load(this);
            v.add(lic);
        }
        return v.toArray(new LicenseFile[v.size()]);
    }

    private static class NodeLockedLicense
    extends LicenseFile {
        File file;

        public NodeLockedLicense(File file) {
            this.file = file;
        }

        @Override
        protected String getLicenseName() {
            return this.file.getName();
        }

        @Override
        protected XElem getRoot() throws Exception {
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));){
                XElem xElem = XParser.make((InputStream)bufferedInputStream).parse(false);
                return xElem;
            }
        }

        @Override
        protected boolean isLicenseHostIdValid() {
            return this.hostId.equals(Nre.getHostId());
        }
    }
}

