/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import com.tridium.sys.license.LicenseUtil;
import java.util.Properties;
import javax.baja.license.Feature;
import javax.baja.license.FeatureLicenseExpiredException;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Clock;

public class NFeature
implements Feature {
    static Properties noProps = new Properties();
    final String key;
    final String vendorName;
    final String featureName;
    long expiration;
    Properties props = noProps;

    NFeature(String vendorName, String featureName, long expiration) {
        this.key = LicenseUtil.toKey(vendorName, featureName);
        this.vendorName = vendorName;
        this.featureName = featureName;
        this.expiration = expiration;
    }

    @Override
    public String getVendorName() {
        return this.vendorName;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public boolean isExpired() {
        return this.expiration < Clock.millis();
    }

    @Override
    public void check() throws FeatureNotLicensedException {
        if (this.isExpired()) {
            throw new FeatureLicenseExpiredException(this.toString());
        }
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public String[] list() {
        return this.props.keySet().toArray(new String[this.props.size()]);
    }

    @Override
    public String get(String key) {
        return this.props.getProperty(key);
    }

    @Override
    public String get(String key, String def) {
        return this.props.getProperty(key, def);
    }

    @Override
    public boolean getb(String key, boolean def) {
        String v = this.props.getProperty(key);
        if (v == null) {
            return def;
        }
        if ((v = TextUtil.toLowerCase((String)v)).equals("true")) {
            return true;
        }
        if (v.equals("false")) {
            return false;
        }
        throw new IllegalStateException("Invalid boolean " + v);
    }

    @Override
    public int geti(String key, int def) {
        String v = this.props.getProperty(key);
        if (v == null) {
            return def;
        }
        return Integer.parseInt(v);
    }

    public String toString() {
        String exp = this.expiration == Long.MAX_VALUE ? "never" : LicenseUtil.formatDate(this.expiration);
        if (this.isExpired()) {
            return this.key + " [EXPIRED: " + exp + "]";
        }
        return this.key + " [expires: " + exp + "]";
    }

    void merge(NFeature x) {
        this.expiration = Math.max(this.expiration, x.expiration);
    }
}

