/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.nre.util.TextUtil;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XText;

public final class LicenseUtil {
    static final long INVALID_LICENSE_TIME_MILLIS_FLOOR = 1420070400000L;
    static final String INVALID_LICENSE_TIME_DATE_FLOOR = "2015-01-01";
    public static final String WORKBENCH_FEATURE = "workbenchAzul";
    private static PublicKey masterPublicKey;
    private static final byte[] masterPublicKeyData;

    private LicenseUtil() {
    }

    public static String toKey(String vendor, String feature) {
        return TextUtil.toLowerCase((String)vendor) + ':' + TextUtil.toLowerCase((String)feature);
    }

    public static String[] parseList(String value) throws LicenseException {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, ";");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        return list.toArray(new String[0]);
    }

    public static int parseLimit(Feature feature, String key) {
        String val = feature.get(key);
        int limit = 0;
        if (val != null) {
            limit = "none".equals(TextUtil.toLowerCase((String)val)) ? Integer.MAX_VALUE : Integer.parseInt(val);
        }
        return limit;
    }

    public static String formatDate(long millis) {
        if (millis == Long.MAX_VALUE) {
            return "never";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date(millis));
    }

    @Deprecated
    public static long parseDate(String date) {
        return LicenseUtil.parseDate(date, false);
    }

    public static long parseDate(String date, boolean startOfDay) {
        if (date.equalsIgnoreCase("never")) {
            return Long.MAX_VALUE;
        }
        try {
            StringTokenizer st = new StringTokenizer(date, "- ");
            int year = Integer.parseInt(st.nextToken()) - 1900;
            int month = Integer.parseInt(st.nextToken()) - 1;
            int dayOfMonth = Integer.parseInt(st.nextToken());
            int hourOfDay = startOfDay ? 0 : 23;
            int minute = startOfDay ? 0 : 59;
            int second = startOfDay ? 0 : 59;
            Date d = new GregorianCalendar(year + 1900, month, dayOfMonth, hourOfDay, minute, second).getTime();
            return d.getTime();
        }
        catch (Exception e) {
            throw new LicenseException("Invalid license date format yyyy-MM-dd: " + date);
        }
    }

    @Deprecated
    public static Optional<Long> getDateAttributeValue(XElem elem, String dateAttrName) {
        return LicenseUtil.getDateAttributeValue(elem, dateAttrName, false);
    }

    public static Optional<Long> getDateAttributeValue(XElem elem, String dateAttrName, boolean startOfDay) {
        Objects.requireNonNull(elem);
        Objects.requireNonNull(dateAttrName);
        String toParse = elem.get(dateAttrName, null);
        return toParse == null ? Optional.empty() : Optional.of(LicenseUtil.parseDate(toParse, startOfDay));
    }

    public static byte[] encode(XElem elem) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            LicenseUtil.encode((OutputStream)out, elem);
            out.flush();
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    private static void encode(OutputStream out, XElem elem) throws IOException {
        int i;
        LicenseUtil.encode(out, "<");
        LicenseUtil.encode(out, elem.qname());
        for (i = 0; i < elem.attrSize(); ++i) {
            LicenseUtil.encode(out, " ");
            LicenseUtil.encode(out, elem.attrName(i));
            LicenseUtil.encode(out, "=\"");
            LicenseUtil.encode(out, elem.attrValue(i));
            LicenseUtil.encode(out, "\"");
        }
        LicenseUtil.encode(out, ">\n");
        for (i = 0; i < elem.contentSize(); ++i) {
            XContent node = elem.content(i);
            if (node instanceof XElem) {
                LicenseUtil.encode(out, (XElem)node);
                continue;
            }
            LicenseUtil.encode(out, ((XText)node).string());
            LicenseUtil.encode(out, "\n");
        }
        LicenseUtil.encode(out, "</");
        LicenseUtil.encode(out, elem.qname());
        LicenseUtil.encode(out, ">\n");
    }

    private static void encode(OutputStream out, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            out.write(s.charAt(i));
        }
    }

    @Deprecated
    public static boolean verify(byte[] data, byte[] sig, byte[] publicKeyData) throws Exception {
        return LicenseUtil.verify(data, sig, publicKeyData, "DSA");
    }

    public static boolean verify(byte[] data, byte[] sig, byte[] publicKeyData, String algorithm) throws Exception {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(publicKeyData);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        PublicKey publicKey = keyFactory.generatePublic(spec);
        return LicenseUtil.verify(data, sig, publicKey);
    }

    public static boolean verify(byte[] data, byte[] sig, PublicKey publicKey) throws Exception {
        Signature s = Signature.getInstance(publicKey.getAlgorithm());
        s.initVerify(publicKey);
        s.update(data);
        return s.verify(sig);
    }

    public static boolean verify(byte[] data, byte[] sig) throws Exception {
        return LicenseUtil.verify(data, sig, LicenseUtil.getMasterPublicKey());
    }

    @Deprecated
    static PublicKey toPublicKey(byte[] data) throws Exception {
        return LicenseUtil.toPublicKey(data, "DSA");
    }

    static PublicKey toPublicKey(byte[] data, String algorithm) throws Exception {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(data);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePublic(spec);
    }

    static PublicKey getMasterPublicKey() throws Exception {
        if (masterPublicKey == null) {
            masterPublicKey = LicenseUtil.toPublicKey(masterPublicKeyData, "DSA");
        }
        return masterPublicKey;
    }

    static {
        masterPublicKeyData = new byte[]{48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -117, -24, 19, 70, 80, -13, -91, 91, 33, -33, 99, -67, 97, -80, 1, -34, -33, 25, -80, 27, 121, -11, 71, 26, -70, -126, -85, -95, -106, -84, 45, -73, -9, 71, -87, -43, 113, 70, -59, -24, -122, 31, 58, 100, 3, -95, 91, -27, -104, -99, -119, 16, -42, 85, -36, -67, -102, -52, 78, -93, -95, 94, 67, 53, -34, 13, -13, 72, -57, -115, 82, 56, 82, 60, -23, 98, 113, -128, -56, -105, 81, -4, 63, -75, 81, 3, 38, 38, 103, -48, -33, -108, -128, -1, 25, 83, -112, -61, 57, 84, 68, -94, -24, 15, -80, -44, -106, -19, 55, 5, 14, 40, 75, 35, 42, -17, 47, 53, -15, 77, 56, -106, -63, 100, -11, -96, -114, -106};
    }
}

