/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.NLicenseManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.Base64;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

public class CertificateFile {
    File file;
    String error;
    String vendor;
    long expiration;
    PublicKey publicKey;

    CertificateFile(File file) {
        this.file = file;
    }

    public void load(NLicenseManager licMan) {
        try (BufferedInputStream certificateInputStream = new BufferedInputStream(new FileInputStream(this.file));){
            XElem root = XParser.make((InputStream)certificateInputStream).parse(false);
            if (root == null) {
                this.error = "Could not parse certificate file as an xml document";
                return;
            }
            if (!root.qname().equals("certificate")) {
                throw new XException("Root name must be certificate", root);
            }
            this.vendor = root.get("vendor");
            XElem keyElem = root.elem("publicKey");
            if (keyElem == null || keyElem.string() == null) {
                this.error = "Missing certificate public key";
                return;
            }
            String algorithm = keyElem.get("algorithm", null);
            if (algorithm == null) {
                algorithm = keyElem.get("algorthm", "DSA");
            }
            if (algorithm == null) {
                this.error = "Missing certificate public key algorithm";
                return;
            }
            byte[] data = Base64.getMimeDecoder().decode(keyElem.string());
            this.publicKey = LicenseUtil.toPublicKey(data, algorithm);
            long now = System.currentTimeMillis();
            String expirationString = root.get("expiration", null);
            if (expirationString == null) {
                this.error = "Missing certificate expiration date";
                return;
            }
            this.expiration = LicenseUtil.parseDate(expirationString, false);
            if (this.expiration < 0L) {
                this.error = "Invalid certificate expiration date";
                return;
            }
            if (now > this.expiration) {
                this.error = "Certificate file is expired";
                return;
            }
            XElem sigElem = root.elem("signature");
            if (sigElem == null || sigElem.string() == null) {
                this.error = "Missing certificate signature";
                return;
            }
            byte[] sig = Base64.getMimeDecoder().decode(sigElem.string());
            root.removeContent((XContent)sigElem);
            byte[] xml = LicenseUtil.encode(root);
            if (!LicenseUtil.verify(xml, sig, LicenseUtil.getMasterPublicKey())) {
                this.error = "Invalid signature";
            }
        }
        catch (XException e) {
            this.error = "Invalid XML: " + e.getMessage();
        }
        catch (Throwable e) {
            this.error = e.toString();
        }
    }

    public boolean isValid() {
        return this.error == null;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String toString() {
        if (this.isValid()) {
            return this.file.getName() + " <" + this.vendor + "> [expires: " + LicenseUtil.formatDate(this.expiration) + "] {valid}";
        }
        return this.file.getName() + " {invalid: " + this.error + "}";
    }
}

