/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.session;

import com.tridium.authn.LoginFailureCause;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.session.MutableNiagaraSession;
import com.tridium.session.NiagaraSession;
import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.Ntoken;
import com.tridium.session.SuperSessionPrincipal;
import java.security.AccessController;
import java.security.Permission;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Clock;
import javax.baja.user.BUser;
import javax.security.auth.Subject;

public final class SessionManager {
    public static final int DEFAULT_SESS_ID_LEN = 25;
    public static final Logger logger = Logger.getLogger("security.sessionManager");
    private static Map<String, NiagaraSuperSession> sessions = new HashMap<String, NiagaraSuperSession>();
    private static SecureRandom rand = new SecureRandom();
    private static Map<String, Map<String, String>> sessionIds = new HashMap<String, Map<String, String>>();
    private static Map<BUser, NiagaraSuperSession> byUser = new HashMap<BUser, NiagaraSuperSession>();
    private static Map<String, Ntoken> ntokens = new HashMap<String, Ntoken>();
    private static Map<String, LoginFailureCause> closeCause = new WeakHashMap<String, LoginFailureCause>();
    private static Map<String, Set<SessionAuthenticationInfo>> cachedAuthenticationInfo = new HashMap<String, Set<SessionAuthenticationInfo>>();
    private static long FIVE_MINUTES_IN_NANOS = TimeUnit.MINUTES.toNanos(5L);

    private SessionManager() {
    }

    public static synchronized NiagaraSuperSession createSession(String remoteHost) {
        String sessionId = SessionManager.generateSuperSessionId(25);
        NiagaraSuperSession superSession = new NiagaraSuperSession(sessionId, remoteHost);
        sessions.put(superSession.getId(), superSession);
        return superSession;
    }

    public static synchronized void addSession(NiagaraSession session) {
        SessionManager.addSession(session, session.getClass());
    }

    public static synchronized void addSession(NiagaraSession session, Class<? extends NiagaraSession> sessionType) {
        NiagaraSuperSession superSession;
        String superId = session.getSuperId();
        Map<String, String> sessionIdsForType = sessionIds.get(sessionType.getName());
        if (superId == null && sessionIdsForType != null) {
            superId = sessionIdsForType.get(session.getId());
        }
        if (superId != null && !SessionManager.idInUse(superId)) {
            sessionIdsForType.remove(session.getId());
            throw new IllegalArgumentException("Cannot create new NiagaraSuperSession: requested sessionId is not valid.");
        }
        if (superId != null && sessions.containsKey(superId) && sessions.get(superId) != null) {
            superSession = sessions.get(superId);
        } else {
            superId = SessionManager.generateSuperSessionId(25);
            superSession = new NiagaraSuperSession(superId, session.getRemoteHost());
            sessions.put(superId, superSession);
        }
        String privSuperId = superId;
        AccessController.doPrivileged(() -> {
            session.setSuperId(privSuperId);
            return null;
        });
        if (!SessionManager.isSessionValid(session, superSession)) {
            throw new SecurityException("Could not add NiagaraSession to SessionManager");
        }
        superSession.addSession(session);
        if (sessionIdsForType == null) {
            sessionIdsForType = new HashMap<String, String>();
            sessionIds.put(sessionType.getName(), sessionIdsForType);
        }
        sessionIdsForType.put(session.getId(), superSession.getId());
    }

    private static boolean isSessionValid(NiagaraSession session, NiagaraSuperSession superSession) {
        return true;
    }

    public static synchronized boolean removeSession(NiagaraSession session) {
        return SessionManager.removeSession(session, session.getClass());
    }

    public static synchronized boolean removeSession(NiagaraSession session, Class<? extends NiagaraSession> sessionType) {
        if (session == null) {
            return false;
        }
        String superId = session.getSuperId();
        Map<String, String> ids = sessionIds.get(sessionType.getName());
        String sessionId = session.getId();
        if (!sessions.containsKey(superId) || !ids.containsKey(sessionId)) {
            return false;
        }
        ids.remove(session.getId());
        SessionManager.removeNtokens(session.getId());
        NiagaraSuperSession superSession = sessions.get(superId);
        return superSession.removeSession(session);
    }

    protected static synchronized void removeSession(NiagaraSuperSession superSession) {
        BUser user;
        String sessionId = superSession.getId();
        Subject sub = superSession.getAuthenticatedSubject();
        if (sub != null && (user = BUser.getUserFromSubject(sub)) != null) {
            byUser.remove(user);
        }
        sessions.remove(sessionId);
    }

    protected static synchronized String generateSuperSessionId(int numBytes) {
        byte[] sessionBytes;
        String sessionId;
        do {
            sessionBytes = new byte[numBytes];
            rand.nextBytes(sessionBytes);
        } while (sessions.containsKey(sessionId = TextUtil.bytesToHexString((byte[])sessionBytes)));
        sessions.put(sessionId, null);
        return sessionId;
    }

    public static synchronized <T extends NiagaraSession> String generateSessionId(Class<T> cls, int numBytes) {
        String sessionId;
        Map<String, String> ids = sessionIds.get(cls.getName());
        if (ids == null) {
            ids = new HashMap<String, String>();
            byte[] sessionBytes = new byte[numBytes];
            rand.nextBytes(sessionBytes);
            sessionId = TextUtil.bytesToHexString((byte[])sessionBytes);
            sessionIds.put(cls.getName(), ids);
        } else {
            byte[] sessionBytes;
            do {
                sessionBytes = new byte[numBytes];
                rand.nextBytes(sessionBytes);
            } while (ids.containsKey(sessionId = TextUtil.bytesToHexString((byte[])sessionBytes)));
        }
        ids.put(sessionId, null);
        return sessionId;
    }

    public static synchronized boolean idReserved(String sessionId) {
        return sessions.containsKey(sessionId) && sessions.get(sessionId) == null;
    }

    public static synchronized boolean idInUse(String sessionId) {
        return sessions.containsKey(sessionId);
    }

    public static synchronized boolean sessionIdInUse(String sessionId, Class<? extends NiagaraSession> sessionType) {
        Map<String, String> ids = sessionIds.get(sessionType.getName());
        return ids != null && ids.containsKey(sessionId);
    }

    public static synchronized <T extends NiagaraSession> boolean releaseSessionId(Class<T> cls, String sessionId) {
        Map<String, String> ids = sessionIds.get(cls.getName());
        if (ids.containsKey(sessionId) && ids.get(sessionId) == null) {
            ids.remove(sessionId);
            return true;
        }
        return false;
    }

    public static synchronized boolean changeSessionId(MutableNiagaraSession session, Class<? extends MutableNiagaraSession> sessionType, String newId) {
        if (session == null) {
            return false;
        }
        String superId = session.getSuperId();
        Map<String, String> ids = sessionIds.get(sessionType.getName());
        String sessionId = session.getId();
        if (!sessions.containsKey(superId) || !ids.containsKey(sessionId)) {
            return false;
        }
        ids.remove(session.getId());
        SessionManager.removeNtokens(session.getId());
        session.setId(newId);
        ids.put(newId, superId);
        return true;
    }

    public static synchronized void changeSuperSessionId(NiagaraSession session, String superSessionId) {
        if (!SessionManager.idInUse(superSessionId)) {
            throw new IllegalArgumentException("Requested session ID MUST already be in use.");
        }
        NiagaraSuperSession superSession = sessions.get(superSessionId);
        if (!SessionManager.isSessionValid(session, superSession)) {
            throw new SecurityException("Could not change session ID - mismatched hosts");
        }
        SessionManager.removeSession(session);
        AccessController.doPrivileged(() -> {
            session.setSuperId(superSessionId);
            return null;
        });
        SessionManager.addSession(session);
    }

    private static synchronized void checkConcurrentSession(NiagaraSuperSession session) {
        BUser user = BUser.getUserFromSubject(session.getAuthenticatedSubject());
        if (user.getAllowConcurrentSessions()) {
            return;
        }
        NiagaraSuperSession concurrent = byUser.get(user);
        if (concurrent != null) {
            if (concurrent == session) {
                return;
            }
            concurrent.invalidate(LoginFailureCause.CONCURRENT_SESSION);
        }
        byUser.put(user, session);
    }

    static synchronized void setAuthenticated(String sessionId, Subject subject) {
        NiagaraSuperSession session = sessions.get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("Requested session ID is not in use.");
        }
        session.setAuthentication(subject);
        SessionManager.checkConcurrentSession(session);
    }

    public static synchronized boolean isAuthenticated(String sessionId) {
        NiagaraSuperSession session = sessions.get(sessionId);
        if (session == null) {
            return false;
        }
        return session.isAuthenticated();
    }

    public static synchronized BUser getAuthenticatedUserFromSession(String sessionId) {
        Subject subject = SessionManager.getAuthenticatedSubjectFromSession(sessionId);
        if (subject != null) {
            return BUser.getUserFromSubject(subject);
        }
        return null;
    }

    public static synchronized Subject getAuthenticatedSubjectFromSession(String sessionId) {
        NiagaraSuperSession session;
        NiagaraBasicPermission authnPermission = new NiagaraBasicPermission("GET_AUTHENTICATED_USER");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)authnPermission);
        }
        if ((session = sessions.get(sessionId)) != null && session.isAuthenticated()) {
            return session.getAuthenticatedSubject();
        }
        return null;
    }

    public static synchronized Collection<NiagaraSuperSession> getSessions() {
        HashSet<NiagaraSuperSession> nonNullSuperSessions = new HashSet<NiagaraSuperSession>();
        if (sessions != null) {
            Collection<NiagaraSuperSession> superSessions = sessions.values();
            for (NiagaraSuperSession session : superSessions) {
                if (session == null) continue;
                nonNullSuperSessions.add(session);
            }
        }
        return nonNullSuperSessions;
    }

    public static <T extends NiagaraSession> T getNiagaraSession(String sessionId, Class<T> t) {
        String superId;
        NiagaraSuperSession superSession;
        Map<String, String> ids = sessionIds.get(t.getName());
        if (ids != null && (superSession = sessions.get(superId = ids.get(sessionId))) != null) {
            return superSession.getSession(t);
        }
        return null;
    }

    public static NiagaraSuperSession getNiagaraSuperSession(NiagaraSession session) {
        return sessions.get(session.getSuperId());
    }

    public static NiagaraSuperSession getCurrentNiagaraSuperSession() {
        Set<SuperSessionPrincipal> set;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject != null && !(set = subject.getPrincipals(SuperSessionPrincipal.class)).isEmpty()) {
            for (SuperSessionPrincipal principal : set) {
                if (principal == null) continue;
                return principal.getSuperSession();
            }
        }
        return null;
    }

    public static synchronized <T extends NiagaraSession> Set<T> getNiagaraSessions(Class<T> t) {
        HashSet<T> niagaraSessions = new HashSet<T>();
        for (NiagaraSuperSession superSession : sessions.values()) {
            T niagaraSession;
            if (superSession == null || (niagaraSession = superSession.getSession(t)) == null) continue;
            niagaraSessions.add(niagaraSession);
        }
        return niagaraSessions;
    }

    public static synchronized <T extends NiagaraSession> int countNiagaraSessions(Class<T> t, Predicate<T> filter) {
        return Math.toIntExact(sessions.values().stream().filter(Objects::nonNull).map(s -> s.getSession(t)).filter(Objects::nonNull).filter(filter).count());
    }

    public static synchronized <T extends NiagaraSession> void cacheSessionAuthenticationInfo(Class<T> t) {
        Set<NiagaraSession> activeSessions = SessionManager.getNiagaraSessions(t);
        HashSet<SessionAuthenticationInfo> authenticationInfoSet = new HashSet<SessionAuthenticationInfo>();
        for (NiagaraSession session : activeSessions) {
            if (!SessionManager.isAuthenticated(session.getSuperId())) continue;
            authenticationInfoSet.add(new SessionAuthenticationInfo(session.getId(), SessionManager.getAuthenticatedSubjectFromSession(session.getSuperId())));
        }
        cachedAuthenticationInfo.put(t.getName(), authenticationInfoSet);
    }

    public static synchronized <T extends NiagaraSession> void restoreSessionAuthentication(Class<T> t) {
        Set<SessionAuthenticationInfo> authenticationInfoSet = cachedAuthenticationInfo.get(t.getName());
        for (SessionAuthenticationInfo authenticationInfo : authenticationInfoSet) {
            Object session = SessionManager.getNiagaraSession(authenticationInfo.sessionId, t);
            if (session == null) continue;
            if (authenticationInfo.isValid()) {
                AccessController.doPrivileged(() -> {
                    SessionManager.setAuthenticated(session.getSuperId(), authenticationInfo.authenticatedSubject);
                    return null;
                });
                continue;
            }
            session.invalidate();
        }
        cachedAuthenticationInfo.remove(t.getName());
    }

    public static synchronized void printSessions() {
        if (sessions == null) {
            return;
        }
        StringBuffer sessionInfo = new StringBuffer();
        sessionInfo.append("\n***** CURRENT SESSIONS *****\n");
        for (NiagaraSuperSession superSession : sessions.values()) {
            if (superSession == null) continue;
            sessionInfo.append("SuperSession ID: " + superSession.getId() + "\n");
            sessionInfo.append("\tCreation Time: " + superSession.getCreationTime() + "\n");
            sessionInfo.append("\tRemote Host: " + superSession.getRemoteHost() + "\n");
            BUser user = SessionManager.getAuthenticatedUserFromSession(superSession.getId());
            sessionInfo.append("\tUser Id: " + (user == null ? "" : user.getUsername()) + "\n");
            sessionInfo.append("\tUser Full Name: " + (user == null ? "" : user.getFullName()) + "\n");
            sessionInfo.append("\tSub-sessions:\n");
            Set<NiagaraSession> niagaraSessions = superSession.getSessions();
            for (NiagaraSession session : niagaraSessions) {
                sessionInfo.append("\t\t" + session.getClass().getName() + "\n");
                sessionInfo.append("\t\t\tCreation Time: " + session.getCreationTime() + "\n");
                sessionInfo.append("\t\t\tSession ID: " + session.getId() + "\n");
                sessionInfo.append("\t\t\tSuper Session ID: " + session.getSuperId() + "\n");
            }
            sessionInfo.append("\n");
        }
        sessionInfo.append("Reserved IDs:\n");
        for (String sessionId : sessions.keySet()) {
            if (sessions.get(sessionId) != null) continue;
            sessionInfo.append("\t" + sessionId + ": " + sessions.get(sessionId) + "\n");
        }
        sessionInfo.append("\n");
        sessionInfo.append("\n");
        sessionInfo.append("IDs in use (NiagaraSuperSessions):\n");
        for (String sessionId : sessions.keySet()) {
            sessionInfo.append("\t" + sessionId + "\n");
        }
        sessionInfo.append("\n");
        for (String className : sessionIds.keySet()) {
            sessionInfo.append("IDs in use (" + className + "):\n");
            Map<String, String> ids = sessionIds.get(className);
            for (String sessionId : ids.keySet()) {
                sessionInfo.append("\t" + sessionId + "\n");
            }
        }
        sessionInfo.append("****************************\n");
        System.err.println(sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeNtoken(String sessionID) {
        Map<String, Ntoken> map = ntokens;
        synchronized (map) {
            byte[] sessionBytes;
            String tokenId;
            do {
                sessionBytes = new byte[25];
                rand.nextBytes(sessionBytes);
            } while (ntokens.containsKey(tokenId = TextUtil.bytesToHexString((byte[])sessionBytes)));
            Ntoken ntoken = new Ntoken(sessionID);
            ntokens.put(tokenId, ntoken);
            return tokenId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends NiagaraSession> String getSessionFromNtoken(String ntokenId, Class<T> cls, String uri) {
        Map<String, Ntoken> map = ntokens;
        synchronized (map) {
            Ntoken token = ntokens.get(ntokenId);
            if (token == null) {
                return null;
            }
            String session = token.getSessionId();
            if (!token.isValid()) {
                T invalidSess = SessionManager.getNiagaraSession(session, cls);
                if (invalidSess != null) {
                    invalidSess.invalidate();
                }
                ntokens.remove(ntokenId);
                return null;
            }
            token.use(uri);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidateNtokens(String sessId) {
        Map<String, Ntoken> map = ntokens;
        synchronized (map) {
            Set<Map.Entry<String, Ntoken>> entries = ntokens.entrySet();
            for (Map.Entry<String, Ntoken> entry : entries) {
                if (!entry.getValue().getSessionId().equals(sessId)) continue;
                entry.getValue().invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNtokens(String sessId) {
        Map<String, Ntoken> map = ntokens;
        synchronized (map) {
            ArrayList<String> invalid = new ArrayList<String>();
            Set<Map.Entry<String, Ntoken>> entries = ntokens.entrySet();
            for (Map.Entry<String, Ntoken> entry : entries) {
                if (!entry.getValue().getSessionId().equals(sessId)) continue;
                String key = entry.getKey();
                invalid.add(key);
            }
            for (String key : invalid) {
                ntokens.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginFailureCause getCloseCause(String sessionId) {
        Map<String, LoginFailureCause> map = closeCause;
        synchronized (map) {
            return closeCause.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putCloseCause(String sessionId, LoginFailureCause cause) {
        Map<String, LoginFailureCause> map = closeCause;
        synchronized (map) {
            closeCause.put(sessionId, cause);
        }
    }

    public static void invalidateSuperSessions(BUser user) {
        SessionManager.invalidateSuperSessions(user, null, null);
    }

    public static void invalidateSuperSessions(BUser user, LoginFailureCause cause) {
        SessionManager.invalidateSuperSessions(user, null, cause);
    }

    public static void invalidateSuperSessions(BUser user, Set<String> excludedIds) {
        SessionManager.invalidateSuperSessions(user, excludedIds, null);
    }

    public static void invalidateSuperSessions(BUser user, Set<String> excludedIds, LoginFailureCause cause) {
        SessionManager.getSessions().stream().filter(p -> {
            BUser sessionUser;
            boolean result = false;
            if (p.isAuthenticated() && (sessionUser = SessionManager.getAuthenticatedUserFromSession(p.getId())) != null && sessionUser.equals(user) && (excludedIds == null || !excludedIds.contains(p.getId()))) {
                result = true;
            }
            return result;
        }).forEach(session -> session.invalidate(cause));
    }

    public static void updateSessionTimeout(BUser user) {
        SessionManager.getSessions().stream().filter(p -> {
            if (p.isAuthenticated()) {
                if (user == null) {
                    return true;
                }
                BUser sessionUser = SessionManager.getAuthenticatedUserFromSession(p.getId());
                if (sessionUser != null && sessionUser.equals(user)) {
                    return true;
                }
            }
            return false;
        }).forEach(session -> session.updateSessionTimeout());
    }

    private static class SessionAuthenticationInfo {
        private String sessionId;
        private Subject authenticatedSubject;
        private long timestamp;

        SessionAuthenticationInfo(String sessionId, Subject authenticatedSubject) {
            this.sessionId = sessionId;
            this.authenticatedSubject = authenticatedSubject;
            this.timestamp = Clock.nanoTicks();
        }

        private boolean isValid() {
            return Clock.nanoTicks() - this.timestamp < FIVE_MINUTES_IN_NANOS;
        }
    }
}

