/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.session;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.sys.BRelTime;

public final class Ntoken {
    private String sessionID;
    private volatile boolean valid = true;
    private final long created = System.currentTimeMillis();
    private static final long NTOKEN_TIME;
    private static final long DEFAULT_NTOKEN_TIME;
    private static final long MAX_NTOKEN_TIME;
    private static final long MIN_NTOKEN_TIME;
    private volatile int used;
    private static final int NTOKEN_USAGE;
    private static final int DEFAULT_NTOKEN_USAGE = 22;
    private static final int MAX_NTOKEN_USAGE = 32;
    private static final int MIN_NTOKEN_USAGE = 18;
    private static final List<Pattern> validUris;
    private static final Logger log;

    public Ntoken(String sessionID) {
        Objects.requireNonNull(sessionID);
        this.sessionID = sessionID;
    }

    public void invalidate() {
        this.valid = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ntoken invalidated");
        }
    }

    public boolean isValid() {
        if (this.valid && System.currentTimeMillis() - this.created > NTOKEN_TIME) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Ntoken time expired");
            }
            this.invalidate();
        }
        return this.valid;
    }

    public String getSessionId() {
        return this.sessionID;
    }

    public void use(String uri) {
        ++this.used;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Ntoken use (%d) -> %s", this.used, uri));
        }
        if (this.used >= NTOKEN_USAGE) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Ntoken exceeded usage count");
            }
            this.invalidate();
        } else if (!validUris.stream().filter(pattern -> pattern.matcher(uri).find()).findFirst().isPresent()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Ntoken URL mismatch");
            }
            this.invalidate();
        }
    }

    static {
        DEFAULT_NTOKEN_TIME = BRelTime.makeMinutes(10).getMillis();
        MAX_NTOKEN_TIME = DEFAULT_NTOKEN_TIME * 2L;
        MIN_NTOKEN_TIME = BRelTime.makeMinutes(1).getMillis();
        long time = Math.max(AccessController.doPrivileged(() -> Long.getLong("niagara.ntoken.time", DEFAULT_NTOKEN_TIME)), MIN_NTOKEN_TIME);
        NTOKEN_TIME = time > MAX_NTOKEN_TIME ? MAX_NTOKEN_TIME : time;
        int u = Math.max(AccessController.doPrivileged(() -> Integer.getInteger("niagara.ntoken.usage", 22)), 18);
        NTOKEN_USAGE = u > 32 ? 32 : u;
        validUris = new ArrayList<Pattern>();
        validUris.add(Pattern.compile("^/wb/"));
        validUris.add(Pattern.compile("^/ord([/]|[?])"));
        validUris.add(Pattern.compile("^/module/"));
        log = Logger.getLogger("niagara.ntoken");
    }
}

