/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.session;

import com.tridium.authn.LoginFailureCause;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.session.AuditInfo;
import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import java.security.AccessController;
import java.security.Permission;
import java.util.Map;
import javax.baja.user.BUser;
import javax.security.auth.Subject;

public interface NiagaraSession
extends AuditInfo {
    public Map<String, String> getSessionInfo();

    public String getRemoteHost();

    public long getCreationTime();

    public String getId();

    public String getSuperId();

    public void setSuperId(String var1);

    default public void setAuthenticated(Subject subject) {
        NiagaraBasicPermission authnPermissions = new NiagaraBasicPermission("SET_SESSION_AUTHENTICATED");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)authnPermissions);
        }
        SessionManager.setAuthenticated(this.getSuperId(), subject);
        AccessController.doPrivileged(() -> {
            this.doSetAuthenticated(SessionManager.getAuthenticatedUserFromSession(this.getSuperId()));
            return null;
        });
    }

    public void doSetAuthenticated(BUser var1);

    default public boolean isLegacyConnection() {
        return false;
    }

    public void invalidate();

    public void invalidate(LoginFailureCause var1);

    @Override
    default public String getAuditSlotName() {
        return this.getRemoteHost();
    }

    default public boolean getAutoLogoffDisabled() {
        return false;
    }

    default public long getSessionTimeRemaining() {
        NiagaraSuperSession superSession = SessionManager.getNiagaraSuperSession(this);
        if (superSession != null) {
            return superSession.getSessionTimeRemaining();
        }
        return -1L;
    }

    default public void resetSessionTimeout() {
        NiagaraSuperSession superSession = SessionManager.getNiagaraSuperSession(this);
        if (superSession != null) {
            superSession.resetSessionTimeout();
        }
    }

    default public void resetSessionTimeout(long offset) {
        NiagaraSuperSession superSession = SessionManager.getNiagaraSuperSession(this);
        if (superSession != null) {
            superSession.resetSessionTimeout(offset);
        }
    }

    default public Object pauseSessionTimeout() {
        NiagaraSuperSession superSession = SessionManager.getNiagaraSuperSession(this);
        if (superSession != null) {
            return superSession.pauseSessionTimeout();
        }
        return null;
    }

    default public void resumeSessionTimeout(Object token) {
        NiagaraSuperSession superSession = SessionManager.getNiagaraSuperSession(this);
        if (superSession != null) {
            superSession.resumeSessionTimeout(token);
        }
    }

    default public long getLastActivity() {
        NiagaraSuperSession superSession = SessionManager.getNiagaraSuperSession(this);
        if (superSession != null) {
            return superSession.getLastActivity();
        }
        return Long.MIN_VALUE;
    }
}

