/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ThirdPartyPermissionGroup
extends BasePermissionGroup {
    protected static final ThirdPartyPermissionGroup DUMMY = new ThirdPartyPermissionGroup();
    public static final String TYPE = "THIRD_PARTY_PERMISSION";
    private static final String CLASS_NAME_XML = "className";
    private static final String TARGET_NAME_XML = "targetName";
    private static final String ACTIONS_XML = "actions";
    private static final String CLASS_NAME_KEY = "permissions.thirdParty.className";
    private static final String TARGET_NAME_KEY = "permissions.thirdParty.targetName";
    private static final String ACTIONS_KEY = "permissions.thirdParty.actions";
    private static final String RISK_KEY = "permissions.thirdParty.riskDescription";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private static final Set<String> BLACKLISTED_PERMISSION_CLASS_PREFIXES;
    private final Set<Permission> permissions;

    private ThirdPartyPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected ThirdPartyPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, flags, purposeKey, parameters, RISK_KEY);
        String className = parameters.get(CLASS_NAME_XML);
        if (className == null) {
            throw new ParsingException("Missing parameter <className> for <THIRD_PARTY_PERMISSION> permission group");
        }
        if (ThirdPartyPermissionGroup.isPermissionBlacklisted(className)) {
            throw new ParsingException("Specified permission class <" + className + "> is blacklisted. Try requesting an existing Niagara Permission Group that contains the permission instead.");
        }
        String targetName = parameters.get(TARGET_NAME_XML);
        String actions = parameters.get(ACTIONS_XML);
        this.permissions = new HashSet<Permission>();
        this.permissions.add(new UnresolvedPermission(className, targetName, actions, null));
    }

    private static boolean isPermissionBlacklisted(String permissionClassName) {
        return BLACKLISTED_PERMISSION_CLASS_PREFIXES.stream().anyMatch(prefix -> permissionClassName.startsWith((String)prefix));
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new ThirdPartyPermissionGroup(this.requestingModuleName + ':' + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    public boolean requiresSignature() {
        return true;
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(CLASS_NAME_XML, CLASS_NAME_KEY, "Class Name"));
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(TARGET_NAME_XML, TARGET_NAME_KEY, "Target Name"));
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(ACTIONS_XML, ACTIONS_KEY, "Actions"));
        BLACKLISTED_PERMISSION_CLASS_PREFIXES = Collections.unmodifiableSet(Stream.of("com.tridium.", "com.sun.", "java.", "javax.baja.", "javax.management.", "javax.net.", "javax.security.", "javax.sound.", "javax.xml.", "jdk.", "org.bouncycastle.").collect(Collectors.toSet()));
    }
}

