/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LoadLibraryPermissionGroup
extends BasePermissionGroup {
    protected static final LoadLibraryPermissionGroup DUMMY = new LoadLibraryPermissionGroup();
    public static final String TYPE = "LOAD_LIBRARIES";
    private static final String LIBRARIES_XML = "libraries";
    private static final String LIBRARIES_KEY = "permissions.loadLibrary.libraries";
    private static final String RISK_KEY = "permissions.loadLibrary.riskDescription";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private final Set<Permission> permissions;

    private LoadLibraryPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected LoadLibraryPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, flags, purposeKey, parameters, RISK_KEY);
        String librariesString = parameters.get(LIBRARIES_XML);
        if (librariesString == null) {
            throw new ParsingException("Missing parameter <libraries> for <LOAD_LIBRARIES> permission group");
        }
        String[] libraries = librariesString.split(",");
        this.permissions = new HashSet<Permission>();
        for (String library : libraries) {
            this.permissions.add(new RuntimePermission("loadLibrary." + library.trim()));
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new LoadLibraryPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(LIBRARIES_XML, LIBRARIES_KEY, "Libraries"));
    }
}

