/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.io.File;
import java.io.FilePermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import javax.baja.sys.Sys;

public class BackupsPermissionGroup
extends BasePermissionGroup {
    protected static final BackupsPermissionGroup DUMMY = new BackupsPermissionGroup();
    public static final String TYPE = "BACKUPS";
    private static final String ACTIONS_XML = "actions";
    private static final String ACTIONS_KEY = "permissions.backups.actions";
    private static final String RISK_KEY = "permissions.backups.riskDescription";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    private final Set<Permission> permissions;

    private BackupsPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected BackupsPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.SEVERE, flags, purposeKey, parameters, RISK_KEY);
        String actions = parameters.get(ACTIONS_XML);
        if (actions == null) {
            throw new ParsingException("Missing parameter <actions> for <BACKUPS> permission group");
        }
        boolean allowRestore = false;
        HashSet<String> validActionsSet = new HashSet<String>();
        StringTokenizer actionsTok = new StringTokenizer(actions, ",");
        while (actionsTok.hasMoreTokens()) {
            String requestedAction;
            switch (requestedAction = actionsTok.nextToken().trim().toLowerCase()) {
                case "read": 
                case "write": 
                case "delete": {
                    validActionsSet.add(requestedAction);
                    break;
                }
                case "restore": {
                    allowRestore = true;
                    break;
                }
            }
        }
        this.permissions = new HashSet<Permission>();
        if (allowRestore) {
            this.permissions.add((Permission)new NiagaraBasicPermission("RESTORE_BACKUP"));
        }
        if (validActionsSet.size() > 0) {
            StringJoiner backupsActionsArg = new StringJoiner(", ");
            StringJoiner backupsSubFoldersActionsArg = new StringJoiner(", ");
            for (String validAction : validActionsSet) {
                if (!"delete".equals(validAction)) {
                    backupsActionsArg.add(validAction);
                }
                backupsSubFoldersActionsArg.add(validAction);
            }
            if (backupsActionsArg.length() > 0) {
                this.permissions.add(new FilePermission(Sys.getNiagaraUserHome() + File.separator + "backups", backupsActionsArg.toString()));
            }
            if (backupsSubFoldersActionsArg.length() > 0) {
                this.permissions.add(new FilePermission(Sys.getNiagaraUserHome() + File.separator + "backups" + File.separator + "-", backupsSubFoldersActionsArg.toString()));
            }
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new BackupsPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(ACTIONS_XML, ACTIONS_KEY, "Actions"));
    }
}

