/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="groupType", type="String", defaultValue="LOGGING"), @NiagaraProperty(name="purpose", type="String", defaultValue="<Why this permission is required>"), @NiagaraProperty(name="parameters", type="String", defaultValue="N/A"), @NiagaraProperty(name="required", type="boolean", defaultValue="true"), @NiagaraProperty(name="policyType", type="String", defaultValue="ALL")})
public class BPermissionGroupInfo
extends BStruct {
    public static final Property groupType = BPermissionGroupInfo.newProperty(0, "LOGGING", null);
    public static final Property purpose = BPermissionGroupInfo.newProperty(0, "<Why this permission is required>", null);
    public static final Property parameters = BPermissionGroupInfo.newProperty(0, "N/A", null);
    public static final Property required = BPermissionGroupInfo.newProperty(0, true, null);
    public static final Property policyType = BPermissionGroupInfo.newProperty(0, "ALL", null);
    public static final Type TYPE = Sys.loadType(BPermissionGroupInfo.class);
    public static final String NO_PARAMETERS = "N/A";

    public String getGroupType() {
        return this.getString(groupType);
    }

    public void setGroupType(String v) {
        this.setString(groupType, v, null);
    }

    public String getPurpose() {
        return this.getString(purpose);
    }

    public void setPurpose(String v) {
        this.setString(purpose, v, null);
    }

    public String getParameters() {
        return this.getString(parameters);
    }

    public void setParameters(String v) {
        this.setString(parameters, v, null);
    }

    public boolean getRequired() {
        return this.getBoolean(required);
    }

    public void setRequired(boolean v) {
        this.setBoolean(required, v, null);
    }

    public String getPolicyType() {
        return this.getString(policyType);
    }

    public void setPolicyType(String v) {
        this.setString(policyType, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BPermissionGroupInfo() {
    }

    public BPermissionGroupInfo(String groupType, String purpose, String parameters, boolean required, String policyType) {
        this.setGroupType(groupType);
        this.setPurpose(purpose);
        this.setParameters(parameters);
        this.setRequired(required);
        this.setPolicyType(policyType);
    }

    public XElem generatePermissionGroupXElem() {
        XElem permission = this.getRequired() ? new XElem("req-permission") : new XElem("opt-permission");
        XElem nameElem = new XElem("name");
        nameElem.addText(this.getGroupType());
        permission.addContent((XContent)nameElem);
        XElem purposeElem = new XElem("purposeKey");
        purposeElem.addText(this.getPurpose());
        permission.addContent((XContent)purposeElem);
        if (this.getParameters() != null && !this.getParameters().equals(NO_PARAMETERS)) {
            String[] parameters;
            XElem parametersElem = new XElem("parameters");
            for (String parameter : parameters = this.getParameters().split("\\|")) {
                String[] parameterPair = parameter.split("=");
                XElem parameterElem = new XElem("parameter");
                parameterElem.addAttr("name", parameterPair[0]);
                parameterElem.addAttr("value", parameterPair[1]);
                parametersElem.addContent((XContent)parameterElem);
            }
            permission.addContent((XContent)parametersElem);
        }
        return permission;
    }
}

