/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.AuthPermission;

public final class AuthenticationPermissionGroup
extends BasePermissionGroup {
    protected static final AuthenticationPermissionGroup DUMMY = new AuthenticationPermissionGroup();
    public static final String TYPE = "AUTHENTICATION";
    private static final String RISK_KEY = "permissions.authentication.riskDescription";
    private static final Set<Permission> permissions = new HashSet<Permission>();

    private AuthenticationPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.MILD, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
    }

    protected AuthenticationPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags) {
        super(NiagaraPermissionGroup.RiskLevel.MILD, flags, purposeKey, null, RISK_KEY);
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return permissions;
    }

    protected NiagaraPermissionGroup copy() {
        return new AuthenticationPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, this.getFlags());
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return null;
    }

    static {
        permissions.add(new AuthPermission("modifyPrincipals"));
        permissions.add((Permission)new NiagaraBasicPermission("MODIFY_SESSION_IDS"));
        permissions.add((Permission)new NiagaraBasicPermission("GET_AUTHENTICATED_USER"));
    }
}

