/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dataRecovery;

import com.tridium.dataRecovery.BDataRecoveryComponentEvent;
import com.tridium.sys.Nre;
import com.tridium.util.ValueByteBuffer;
import java.io.DataInput;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.BIAgent;
import javax.baja.category.BCategoryMask;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.SortUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BDataRecoveryComponentRecorder
extends BObject
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BDataRecoveryComponentRecorder.class);
    private BIDataRecoveryService service;
    public static final Context SKIP_CRITICAL_CX = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public String toString() {
            return "Context.skipDataRecovery";
        }
    };
    protected static final byte[] EMPTY_DATA = new byte[0];
    public static final Logger LOG = Logger.getLogger("sys.dataRecovery");
    protected static final Logger[] RECORD_LOGS = new Logger[]{Logger.getLogger("sys.dataRecovery.save.change"), Logger.getLogger("sys.dataRecovery.save.add"), Logger.getLogger("sys.dataRecovery.save.remove"), Logger.getLogger("sys.dataRecovery.save.rename"), Logger.getLogger("sys.dataRecovery.save.reorder"), LOG, Logger.getLogger("sys.dataRecovery.save.flagsChange"), Logger.getLogger("sys.dataRecovery.save.facetsChange"), LOG, LOG, Logger.getLogger("sys.dataRecovery.save.recategorize")};
    protected static final Logger[] RESTORE_LOGS = new Logger[]{Logger.getLogger("sys.dataRecovery.load.change"), Logger.getLogger("sys.dataRecovery.load.add"), Logger.getLogger("sys.dataRecovery.load.remove"), Logger.getLogger("sys.dataRecovery.load.rename"), Logger.getLogger("sys.dataRecovery.load.reorder"), LOG, Logger.getLogger("sys.dataRecovery.load.flagsChange"), Logger.getLogger("sys.dataRecovery.load.facetsChange"), LOG, LOG, Logger.getLogger("sys.dataRecovery.load.recategorize")};
    public static final int SPY_EVENT_LIMIT = AccessController.doPrivileged(() -> Integer.getInteger("sys.dataRecovery.spy.limit", 200));
    public static final boolean PROG_OBJ_STATS = AccessController.doPrivileged(() -> Boolean.getBoolean("sys.dataRecovery.progObjStats"));
    protected static final Logger PROG_OBJ_LOG = Logger.getLogger("sys.dataRecovery.progObj");
    private static TypeInfo PROG_OBJ_TYPE_INFO = null;
    public long totalProgObjEvents = 0L;
    public long progObjChangedEvents = 0L;
    public long totalProgObjDataSize = 0L;
    public long progObjChangedEventDataSize = 0L;

    @Override
    public Type getType() {
        return TYPE;
    }

    public final void setDataRecoveryService(BIDataRecoveryService service) {
        this.service = service;
    }

    public final BIDataRecoveryService getDataRecoveryService() {
        return this.service;
    }

    public boolean isEventCritical(int eventId, BComplex comp, Slot slot, int flags, Context cx) {
        BPassword pwdValue;
        int pflags;
        if (this.service == null) {
            return false;
        }
        if (!this.service.isEnabled()) {
            return false;
        }
        if (cx == SKIP_CRITICAL_CX) {
            return false;
        }
        if (eventId == 5 || eventId == 8 || eventId == 9) {
            return false;
        }
        BComponent component = comp.getParentComponent();
        if (component == null) {
            return false;
        }
        BComponentSpace space = component.getComponentSpace();
        if (space == null) {
            return false;
        }
        if (slot != null && ((flags & 2) != 0 || (flags & 0x10000) != 0 || (flags & 0x8000) != 0 && eventId == 0)) {
            return false;
        }
        BComplex parent = comp.getParent();
        Property prop = comp.getPropertyInParent();
        if (parent != null && prop != null && (((pflags = parent.getFlags(prop)) & 2) != 0 || (pflags & 0x10000) != 0)) {
            return false;
        }
        return eventId != 0 && eventId != 1 && eventId != 2 && eventId != 3 && eventId != 6 && eventId != 7 || slot == null || !slot.isProperty() || !slot.asProperty().getType().is(BPassword.TYPE) || !(pwdValue = (BPassword)comp.get(slot.asProperty())).getPasswordEncoder().isReversible();
    }

    public void record(BDataRecoveryComponentEvent event, Context cx) {
        Logger log = LOG;
        try {
            int eventId = event.getId();
            BComplex complex = event.getComplex((BObject)((Object)this.service));
            BComponent comp = complex.getParentComponent();
            assert (comp != null);
            BComponentSpace space = comp.getComponentSpace();
            log = RECORD_LOGS[eventId];
            boolean trace = log.isLoggable(Level.FINE);
            boolean updateProgObjStats = false;
            if (PROG_OBJ_STATS || PROG_OBJ_LOG.isLoggable(Level.FINE)) {
                try {
                    if (PROG_OBJ_TYPE_INFO == null) {
                        PROG_OBJ_TYPE_INFO = BTypeSpec.make("program", "Program").getTypeInfo();
                    }
                    if (complex.getType().is(PROG_OBJ_TYPE_INFO)) {
                        updateProgObjStats = PROG_OBJ_STATS;
                        if (PROG_OBJ_LOG.isLoggable(Level.FINE)) {
                            log = PROG_OBJ_LOG;
                            trace = true;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (eventId) {
                case 0: {
                    if (trace) {
                        log.fine("Recording component event '" + event + "'");
                    }
                    ByteBuffer data = BDataRecoveryComponentRecorder.encodeValue(event.getValue());
                    int dLen = data.getLength();
                    this.service.append(space, event, data.getBytes(), 0, dLen);
                    if (!updateProgObjStats) break;
                    ++this.totalProgObjEvents;
                    ++this.progObjChangedEvents;
                    int bLen = dLen + event.getEncodingLen();
                    this.totalProgObjDataSize += (long)bLen;
                    this.progObjChangedEventDataSize += (long)bLen;
                    break;
                }
                case 1: {
                    if (trace) {
                        log.fine("Recording component event '" + event + "'");
                    }
                    ValueByteBuffer vbb = ValueByteBuffer.make();
                    vbb.writeInt(event.getFlags());
                    vbb.encode(event.getFacets());
                    vbb.encode(event.getValue());
                    int dLen = vbb.getLength();
                    this.service.append(space, event, vbb.getBytes(), 0, dLen);
                    if (!updateProgObjStats) break;
                    ++this.totalProgObjEvents;
                    this.totalProgObjDataSize += (long)(dLen + event.getEncodingLen());
                    break;
                }
                case 2: {
                    if (trace) {
                        log.fine("Recording component event '" + event + "'");
                    }
                    this.service.append(space, event, EMPTY_DATA);
                    if (!updateProgObjStats) break;
                    ++this.totalProgObjEvents;
                    this.totalProgObjDataSize += (long)event.getEncodingLen();
                    break;
                }
                case 3: {
                    if (trace) {
                        log.fine("Recording component event '" + event + "'");
                    }
                    ByteBuffer data = BDataRecoveryComponentRecorder.encodeValue(BString.make(event.getOldSlotName()));
                    int dLen = data.getLength();
                    this.service.append(space, event, data.getBytes(), 0, dLen);
                    if (!updateProgObjStats) break;
                    ++this.totalProgObjEvents;
                    this.totalProgObjDataSize += (long)(dLen + event.getEncodingLen());
                    break;
                }
                case 4: {
                    if (trace) {
                        log.fine("Recording component event '" + event + "'");
                    }
                    Property[] properties = event.getDynamicProperties();
                    int countNonTransients = 0;
                    for (Property prop : properties) {
                        if (Flags.isTransient(complex, prop)) continue;
                        ++countNonTransients;
                    }
                    if (countNonTransients == 0) {
                        return;
                    }
                    ByteBuffer data = new ByteBuffer();
                    data.writeInt(countNonTransients);
                    for (Property prop : properties) {
                        if (Flags.isTransient(complex, prop)) continue;
                        data.writeUTF(prop.getName());
                    }
                    int dLen = data.getLength();
                    this.service.append(space, event, data.getBytes(), 0, dLen);
                    if (!updateProgObjStats) break;
                    ++this.totalProgObjEvents;
                    this.totalProgObjDataSize += (long)(dLen + event.getEncodingLen());
                    break;
                }
                case 6: {
                    if (trace) {
                        log.fine("Recording component event '" + event + "'");
                    }
                    ByteBuffer data = new ByteBuffer();
                    data.writeInt(event.getFlags());
                    int dLen = data.getLength();
                    this.service.append(space, event, data.getBytes(), 0, dLen);
                    if (!updateProgObjStats) break;
                    ++this.totalProgObjEvents;
                    this.totalProgObjDataSize += (long)(dLen + event.getEncodingLen());
                    break;
                }
                case 7: {
                    if (trace) {
                        log.fine("Recording component event '" + event + "'");
                    }
                    ByteBuffer data = BDataRecoveryComponentRecorder.encodeValue(event.getFacets());
                    int dLen = data.getLength();
                    this.service.append(space, event, data.getBytes(), 0, dLen);
                    if (!updateProgObjStats) break;
                    ++this.totalProgObjEvents;
                    this.totalProgObjDataSize += (long)(dLen + event.getEncodingLen());
                    break;
                }
                case 10: {
                    BCategoryMask mask = event.getCategoryMask();
                    if (trace) {
                        log.fine("Recording component event '" + event + "'");
                    }
                    ByteBuffer data = BDataRecoveryComponentRecorder.encodeValue(mask);
                    int dLen = data.getLength();
                    this.service.append(space, event, data.getBytes(), 0, dLen);
                    if (!updateProgObjStats) break;
                    ++this.totalProgObjEvents;
                    this.totalProgObjDataSize += (long)(dLen + event.getEncodingLen());
                }
            }
        }
        catch (DataRecoveryServiceInFaultException drsife) {
            try {
                AccessController.doPrivileged(() -> Nre.getServiceManager()).addDataRecoveryComponentRecorder(this.service, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            log.log(Level.WARNING, "DataRecoveryService in fault, could not append component event " + event + ". Stopped data recovery component recording.", drsife);
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "DataRecoveryService could not record component event '" + event + "'", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean restore(BComponentSpace space, IDataRecoveryRecord rec) throws Exception {
        event = null;
        log = BDataRecoveryComponentRecorder.LOG;
        try {
            key = rec.getKey();
            buf = new ByteBuffer(key);
            event = (BDataRecoveryComponentEvent)BDataRecoveryComponentEvent.DEFAULT.decode((DataInput)buf);
            data = rec.getData();
            complex = event.getComplex(space);
            eventId = event.getId();
            log = BDataRecoveryComponentRecorder.RESTORE_LOGS[eventId];
            if (BDataRecoveryComponentRecorder.PROG_OBJ_LOG.isLoggable(Level.FINE)) {
                try {
                    if (BDataRecoveryComponentRecorder.PROG_OBJ_TYPE_INFO == null) {
                        BDataRecoveryComponentRecorder.PROG_OBJ_TYPE_INFO = BTypeSpec.make("program", "Program").getTypeInfo();
                    }
                    if (complex.getType().is(BDataRecoveryComponentRecorder.PROG_OBJ_TYPE_INFO)) {
                        log = BDataRecoveryComponentRecorder.PROG_OBJ_LOG;
                    }
                }
                catch (Exception var10_12) {
                    // empty catch block
                }
            }
            switch (event.getId()) {
                case 0: {
                    value = BDataRecoveryComponentRecorder.decodeValue(data);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Restoring component event '" + event.toString(null) + " val=" + value.toString(null) + "'");
                    }
                    complex.set(event.getSlotName(), value);
                    break;
                }
                case 1: {
                    vbb = ValueByteBuffer.make(data);
                    flags = vbb.readInt();
                    facets = (BFacets)vbb.decode();
                    value = (BValue)vbb.decode();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Restoring component event '" + event.toString(null) + " val=" + value.toString(null) + " flags=" + Flags.toDisplayString(flags, null) + " facets=" + facets.toString(null) + "'");
                    }
                    complex.asComponent().add(event.getSlotName(), value, flags, facets, null);
                    break;
                }
                case 2: {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Restoring component event '" + event.toString(null) + "'");
                    }
                    complex.asComponent().remove(event.getSlotName());
                    break;
                }
                case 3: {
                    oldSlotName = ((BString)BDataRecoveryComponentRecorder.decodeValue(data)).getString();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Restoring component event '" + event.toString(null) + " oldSlotName=" + oldSlotName + "'");
                    }
                    complex.asComponent().rename(complex.getProperty(oldSlotName), event.getSlotName());
                    break;
                }
                case 4: {
                    dIn = new ByteBuffer(data);
                    len = dIn.readInt();
                    props = new Property[len];
                    for (i = 0; i < len; ++i) {
                        props[i] = complex.getProperty(dIn.readUTF());
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Restoring component event '" + event.toString(null) + " props=" + new Array(props).toString() + "'");
                    }
                    complex.asComponent().reorder((Property[])props);
                    break;
                }
                case 6: {
                    dIn = new ByteBuffer(data);
                    flags = dIn.readInt();
                    slot = complex.getSlot(event.getSlotName());
                    if ((flags & 32768) == 0) ** GOTO lbl77
                    activeLinkFound = false;
                    try {
                        links = complex.asComponent().getLinks(slot);
                        num = links != null ? links.length : 0;
                        for (i = 0; i < num; ++i) {
                            if (!links[i].isActive()) continue;
                            activeLinkFound = true;
                            break;
                        }
                    }
                    catch (Throwable var20_30) {
                        // empty catch block
                    }
                    if (!activeLinkFound) {
                        flags &= -32769;
                    }
lbl77:
                    // 4 sources

                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Restoring component event '" + event.toString(null) + " flags=" + Flags.toDisplayString(flags, null) + "'");
                    }
                    complex.setFlags(slot, flags);
                    break;
                }
                case 7: {
                    facets = (BFacets)BDataRecoveryComponentRecorder.decodeValue(data);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Restoring component event '" + event.toString(null) + " facets=" + facets.toString(null) + "'");
                    }
                    complex.asComponent().setFacets(complex.getSlot(event.getSlotName()), facets);
                    break;
                }
                case 10: {
                    mask = (BCategoryMask)BDataRecoveryComponentRecorder.decodeValue(data);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Restoring component event '" + event.toString(null) + " mask=" + mask.toString(null) + "'");
                    }
                    complex.asComponent().setCategoryMask(mask, null);
                    break;
                }
                default: {
                    log.severe("DataRecoveryService could not restore unexpected component event '" + event + "'");
                    return false;
                }
            }
        }
        catch (UnresolvedException | DuplicateSlotException ue) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "DataRecoveryService could not restore component event '" + event + "'", ue);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "DataRecoveryService could not restore component event '" + event + "'", ex);
            throw ex;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRecoverySpy(BComponentSpace space, SpyWriter out, Iterator<IDataRecoveryRecord> iterator) throws Exception {
        if (PROG_OBJ_STATS) {
            out.startProps("Program Object Data Recovery Statistics");
            out.prop((Object)"Records Generated", (Object)this.totalProgObjEvents);
            out.prop((Object)"Data Generated", (Object)this.totalProgObjDataSize);
            double avg = this.totalProgObjEvents > 0L ? (double)this.totalProgObjDataSize / (double)this.totalProgObjEvents : 0.0;
            out.prop((Object)"Average Record Size", new Double(avg));
            out.prop((Object)"Change Events Generated", (Object)this.progObjChangedEvents);
            out.prop((Object)"Change Data Generated", (Object)this.progObjChangedEventDataSize);
            avg = this.progObjChangedEvents > 0L ? (double)this.progObjChangedEventDataSize / (double)this.progObjChangedEvents : 0.0;
            out.prop((Object)"Average Change Event Size", new Double(avg));
            out.endProps();
        }
        HashMap<BDataRecoveryComponentEvent, DataRecoverySpyStat> map = new HashMap<BDataRecoveryComponentEvent, DataRecoverySpyStat>();
        int totalEvents = 0;
        int count = 0;
        while (iterator.hasNext()) {
            IDataRecoveryRecord rec = null;
            try {
                rec = iterator.next();
                byte[] key = rec.getKey();
                ByteBuffer buf = new ByteBuffer(key);
                BDataRecoveryComponentEvent event = (BDataRecoveryComponentEvent)BDataRecoveryComponentEvent.DEFAULT.decode((DataInput)buf);
                event.getComplex(space);
                byte[] data = rec.getData();
                int len = data != null ? key.length + data.length : key.length;
                DataRecoverySpyStat stat = (DataRecoverySpyStat)map.get(event);
                if (stat == null) {
                    stat = new DataRecoverySpyStat();
                    map.put(event, stat);
                    ++count;
                }
                stat.event = event;
                ++stat.occurrences;
                stat.totalSize += len;
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "DataRecoverySpy could not spy component record '" + rec + "'", e);
            }
            finally {
                ++totalEvents;
            }
        }
        if (count > 0) {
            Object[] sorted = new DataRecoverySpyStat[count];
            sorted = map.values().toArray(sorted);
            SortUtil.rsort((Object[])sorted);
            int len = sorted.length;
            String title = totalEvents + " Component Events Recently Recorded in Data Recovery";
            if (len > SPY_EVENT_LIMIT) {
                len = SPY_EVENT_LIMIT;
                title = title + " (truncated to " + len + " rows)";
            }
            out.startTable(true);
            out.trTitle(title, 4);
            out.w("<tr><th>Occurrences</th><th>Total Bytes</th><th>Avg Bytes</th><th>Component Event</th></tr>\n");
            for (int i = 0; i < len; ++i) {
                double avg = (double)((DataRecoverySpyStat)sorted[i]).totalSize / (double)((DataRecoverySpyStat)sorted[i]).occurrences;
                out.tr("" + ((DataRecoverySpyStat)sorted[i]).occurrences, "" + ((DataRecoverySpyStat)sorted[i]).totalSize, "" + avg, ((DataRecoverySpyStat)sorted[i]).event.toString(null));
            }
            out.endTable();
        }
    }

    static ByteBuffer encodeValue(BValue value) throws Exception {
        ValueByteBuffer vbb = ValueByteBuffer.make();
        vbb.encode(value);
        return vbb;
    }

    static BValue decodeValue(byte[] data) throws Exception {
        ValueByteBuffer decoder = ValueByteBuffer.make(data);
        return (BValue)decoder.decode();
    }

    static class DataRecoverySpyStat
    implements Comparable<DataRecoverySpyStat> {
        BDataRecoveryComponentEvent event;
        int occurrences = 0;
        int totalSize = 0;

        DataRecoverySpyStat() {
        }

        @Override
        public int compareTo(DataRecoverySpyStat cdss) {
            int delta = this.occurrences - cdss.occurrences;
            if (delta == 0) {
                return 0;
            }
            if (delta < 0) {
                return -1;
            }
            return 1;
        }
    }
}

