/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.collection;

import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.IterableCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BCellScheme
extends BOrdScheme {
    public static final BCellScheme INSTANCE = new BCellScheme();
    public static final Type TYPE = Sys.loadType(BCellScheme.class);
    private static final Lexicon lex = Lexicon.make(BCellScheme.class);
    private static final String KEY_PARAM_EXCEPTION = "cellscheme.incorrectparameters";
    private static final String KEY_UNDEFINED_COL = "cellscheme.undefinedcolumn";
    private static final String CELL_SCHEME = "cell";

    @Override
    public Type getType() {
        return TYPE;
    }

    public BCellScheme() {
        super(CELL_SCHEME);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        String body = query.getBody();
        BObject bObject = base.get();
        if (bObject instanceof BITable) {
            String[] split = TextUtil.split((String)body, (char)',');
            if (split.length == 2) {
                BITable table = (BITable)((Object)bObject);
                ColumnList columns = table.getColumns();
                Column col = null;
                int rowIndex = 0;
                try {
                    int colIndex = Integer.parseInt(split[0]);
                    col = columns.get(colIndex);
                }
                catch (NumberFormatException nfe) {
                    col = columns.get(split[0]);
                }
                if (null == col) {
                    throw new UnresolvedException(lex.getText(KEY_UNDEFINED_COL, split[0]));
                }
                try {
                    rowIndex = Integer.parseInt(split[1]);
                    bObject = Tables.get(table, rowIndex, col).as(BObject.class);
                }
                catch (NumberFormatException nfe) {
                    IterableCursor cursor = table.cursor();
                    bObject = null;
                    while (cursor.next()) {
                        bObject = cursor.cell(col).as(BObject.class);
                    }
                }
                return new OrdTarget(base, bObject);
            }
            throw new SyntaxException(lex.getText(KEY_PARAM_EXCEPTION, body));
        }
        return new OrdTarget(base, bObject);
    }
}

