/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.authn;

import com.tridium.authn.BAuthenticationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraSlots
public class BAuthenticationSchemeFolder
extends BFolder {
    public static final Type TYPE = Sys.loadType(BAuthenticationSchemeFolder.class);
    private static final BIcon icon = BIcon.make(BIcon.std("folder.png"), BIcon.std("badges/lock.png"));

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        return child.getType().is(BAuthenticationScheme.TYPE);
    }

    @Override
    public void checkRemove(Property property, Context context) {
        BAuthenticationScheme[] schemes = this.getChildren(BAuthenticationScheme.class);
        if (schemes.length == 1) {
            Object[] args = new Object[]{property.getName()};
            throw new LocalizableRuntimeException("baja", "authn.folder.error.empty", args);
        }
    }

    @Override
    public void added(Property property, Context context) {
        Optional<BIService> service = Sys.findService(BAuthenticationService.TYPE);
        service.ifPresent(authnService -> ((BAuthenticationService)authnService).setAutoSSO());
    }

    @Override
    public void removed(Property property, BValue oldValue, Context context) {
        Optional<BIService> service = Sys.findService(BAuthenticationService.TYPE);
        service.ifPresent(authnService -> ((BAuthenticationService)authnService).setAutoSSO());
    }

    List<BAuthenticationScheme> getAuthenticationSchemes() {
        BAuthenticationScheme[] schemes = this.getChildren(BAuthenticationScheme.class);
        return new ArrayList<BAuthenticationScheme>(Arrays.asList(schemes));
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

