/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.IOException;
import java.io.PrintWriter;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;

class StringElement
extends Element {
    private String value = null;

    public StringElement(char c) {
        this(String.valueOf(c));
    }

    public StringElement(String str) {
        this.value = str;
    }

    public String getString() {
        return this.value;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public int match(Matcher m, ReaderBuffer buffer, int start, int skip) throws IOException {
        if (skip != 0) {
            return -1;
        }
        for (int i = 0; i < this.value.length(); ++i) {
            int c = buffer.peek(start + i);
            if (c < 0) {
                m.setReadEndOfString();
                return -1;
            }
            if (m.isCaseInsensitive()) {
                c = Character.toLowerCase((char)c);
            }
            if (c == this.value.charAt(i)) continue;
            return -1;
        }
        return this.value.length();
    }

    @Override
    public void printTo(PrintWriter output, String indent) {
        output.println(indent + "'" + this.value + "'");
    }
}

