/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.re.AlternativeElement;
import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.CharacterSetElement;
import net.percederberg.grammatica.parser.re.CombineElement;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.RegExpException;
import net.percederberg.grammatica.parser.re.RepeatElement;
import net.percederberg.grammatica.parser.re.StringElement;

public class RegExp {
    private Element element;
    private String pattern;
    private boolean ignoreCase;
    private int pos;

    public RegExp(String pattern) throws RegExpException {
        this(pattern, false);
    }

    public RegExp(String pattern, boolean ignoreCase) throws RegExpException {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
        this.pos = 0;
        this.element = this.parseExpr();
        if (this.pos < pattern.length()) {
            throw new RegExpException(1, this.pos, pattern);
        }
    }

    @Deprecated
    public Matcher matcher(CharBuffer str) {
        return this.matcher(str.toString());
    }

    public Matcher matcher(String str) {
        return this.matcher(new ReaderBuffer(new StringReader(str)));
    }

    public Matcher matcher(ReaderBuffer buffer) {
        return new Matcher((Element)this.element.clone(), buffer, this.ignoreCase);
    }

    public String toString() {
        StringWriter str = new StringWriter();
        str.write("Regular Expression\n");
        str.write("  Pattern: " + this.pattern + "\n");
        str.write("  Flags:");
        if (this.ignoreCase) {
            str.write(" caseignore");
        }
        str.write("\n");
        str.write("  Compiled:\n");
        this.element.printTo(new PrintWriter(str), "    ");
        return str.toString();
    }

    private Element parseExpr() throws RegExpException {
        Element first = this.parseTerm();
        if (this.peekChar(0) != 124) {
            return first;
        }
        this.readChar('|');
        Element second = this.parseExpr();
        return new AlternativeElement(first, second);
    }

    private Element parseTerm() throws RegExpException {
        ArrayList<Element> list = new ArrayList<Element>();
        list.add(this.parseFact());
        while (true) {
            switch (this.peekChar(0)) {
                case -1: 
                case 41: 
                case 43: 
                case 63: 
                case 93: 
                case 123: 
                case 124: 
                case 125: {
                    return this.combineElements(list);
                }
            }
            list.add(this.parseFact());
        }
    }

    private Element parseFact() throws RegExpException {
        Element elem = this.parseAtom();
        switch (this.peekChar(0)) {
            case 42: 
            case 43: 
            case 63: 
            case 123: {
                return this.parseAtomModifier(elem);
            }
        }
        return elem;
    }

    private Element parseAtom() throws RegExpException {
        switch (this.peekChar(0)) {
            case 46: {
                this.readChar('.');
                return CharacterSetElement.DOT;
            }
            case 40: {
                this.readChar('(');
                Element elem = this.parseExpr();
                this.readChar(')');
                return elem;
            }
            case 91: {
                this.readChar('[');
                Element elem = this.parseCharSet();
                this.readChar(']');
                return elem;
            }
            case -1: 
            case 41: 
            case 42: 
            case 43: 
            case 63: 
            case 93: 
            case 123: 
            case 124: 
            case 125: {
                throw new RegExpException(1, this.pos, this.pattern);
            }
        }
        return this.parseChar();
    }

    private Element parseAtomModifier(Element elem) throws RegExpException {
        int min = 0;
        int max = -1;
        int type = 1;
        switch (this.readChar()) {
            case '?': {
                min = 0;
                max = 1;
                break;
            }
            case '*': {
                min = 0;
                max = -1;
                break;
            }
            case '+': {
                min = 1;
                max = -1;
                break;
            }
            case '{': {
                int firstPos = this.pos - 1;
                max = min = this.readNumber();
                if (this.peekChar(0) == 44) {
                    this.readChar(',');
                    max = -1;
                    if (this.peekChar(0) != 125) {
                        max = this.readNumber();
                    }
                }
                this.readChar('}');
                if (max != 0 && (max <= 0 || min <= max)) break;
                throw new RegExpException(5, firstPos, this.pattern);
            }
            default: {
                throw new RegExpException(1, this.pos - 1, this.pattern);
            }
        }
        if (this.peekChar(0) == 63) {
            this.readChar('?');
            type = 2;
        } else if (this.peekChar(0) == 43) {
            this.readChar('+');
            type = 3;
        }
        return new RepeatElement(elem, min, max, type);
    }

    private Element parseCharSet() throws RegExpException {
        CharacterSetElement charset;
        boolean repeat = true;
        if (this.peekChar(0) == 94) {
            this.readChar('^');
            charset = new CharacterSetElement(true);
        } else {
            charset = new CharacterSetElement(false);
        }
        block4: while (this.peekChar(0) > 0 && repeat) {
            char start = (char)this.peekChar(0);
            switch (start) {
                case ']': {
                    repeat = false;
                    continue block4;
                }
                case '\\': {
                    Element elem = this.parseEscapeChar();
                    if (elem instanceof StringElement) {
                        charset.addCharacters((StringElement)elem);
                        continue block4;
                    }
                    charset.addCharacterSet((CharacterSetElement)elem);
                    continue block4;
                }
            }
            this.readChar(start);
            if (this.peekChar(0) == 45 && this.peekChar(1) > 0 && this.peekChar(1) != 93) {
                this.readChar('-');
                char end = this.readChar();
                charset.addRange(this.fixChar(start), this.fixChar(end));
                continue;
            }
            charset.addCharacter(this.fixChar(start));
        }
        return charset;
    }

    private Element parseChar() throws RegExpException {
        switch (this.peekChar(0)) {
            case 92: {
                return this.parseEscapeChar();
            }
            case 36: 
            case 94: {
                throw new RegExpException(3, this.pos, this.pattern);
            }
        }
        return new StringElement(this.fixChar(this.readChar()));
    }

    private Element parseEscapeChar() throws RegExpException {
        this.readChar('\\');
        char c = this.readChar();
        switch (c) {
            case '0': {
                c = this.readChar();
                if (c < '0' || c > '3') {
                    throw new RegExpException(4, this.pos - 3, this.pattern);
                }
                String str = String.valueOf(c);
                c = (char)this.peekChar(0);
                if ('0' <= c && c <= '7') {
                    str = str + String.valueOf(this.readChar());
                    c = (char)this.peekChar(0);
                    if ('0' <= c && c <= '7') {
                        str = str + String.valueOf(this.readChar());
                    }
                }
                try {
                    c = (char)Integer.parseInt(str, 8);
                    return new StringElement(this.fixChar(c));
                }
                catch (NumberFormatException e) {
                    throw new RegExpException(4, this.pos - str.length() - 2, this.pattern);
                }
            }
            case 'x': {
                String str = String.valueOf(this.readChar()) + String.valueOf(this.readChar());
                try {
                    c = (char)Integer.parseInt(str, 16);
                    return new StringElement(this.fixChar(c));
                }
                catch (NumberFormatException e) {
                    throw new RegExpException(4, this.pos - str.length() - 2, this.pattern);
                }
            }
            case 'u': {
                String str = String.valueOf(this.readChar()) + String.valueOf(this.readChar()) + String.valueOf(this.readChar()) + String.valueOf(this.readChar());
                try {
                    c = (char)Integer.parseInt(str, 16);
                    return new StringElement(this.fixChar(c));
                }
                catch (NumberFormatException e) {
                    throw new RegExpException(4, this.pos - str.length() - 2, this.pattern);
                }
            }
            case 't': {
                return new StringElement('\t');
            }
            case 'n': {
                return new StringElement('\n');
            }
            case 'r': {
                return new StringElement('\r');
            }
            case 'f': {
                return new StringElement('\f');
            }
            case 'a': {
                return new StringElement('\u0007');
            }
            case 'e': {
                return new StringElement('\u001b');
            }
            case 'd': {
                return CharacterSetElement.DIGIT;
            }
            case 'D': {
                return CharacterSetElement.NON_DIGIT;
            }
            case 's': {
                return CharacterSetElement.WHITESPACE;
            }
            case 'S': {
                return CharacterSetElement.NON_WHITESPACE;
            }
            case 'w': {
                return CharacterSetElement.WORD;
            }
            case 'W': {
                return CharacterSetElement.NON_WORD;
            }
        }
        if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
            throw new RegExpException(4, this.pos - 2, this.pattern);
        }
        return new StringElement(this.fixChar(c));
    }

    private char fixChar(char c) {
        return this.ignoreCase ? Character.toLowerCase(c) : c;
    }

    private int readNumber() throws RegExpException {
        StringBuffer buf = new StringBuffer();
        int c = this.peekChar(0);
        while (48 <= c && c <= 57) {
            buf.append(this.readChar());
            c = this.peekChar(0);
        }
        if (buf.length() <= 0) {
            throw new RegExpException(1, this.pos, this.pattern);
        }
        return Integer.parseInt(buf.toString());
    }

    private char readChar() throws RegExpException {
        int c = this.peekChar(0);
        if (c < 0) {
            throw new RegExpException(2, this.pos, this.pattern);
        }
        ++this.pos;
        return (char)c;
    }

    private char readChar(char c) throws RegExpException {
        if (c != this.readChar()) {
            throw new RegExpException(1, this.pos - 1, this.pattern);
        }
        return c;
    }

    private int peekChar(int count) {
        if (this.pos + count < this.pattern.length()) {
            return this.pattern.charAt(this.pos + count);
        }
        return -1;
    }

    private Element combineElements(ArrayList list) {
        Element elem;
        int i;
        Element prev = (Element)list.get(0);
        for (i = 1; i < list.size(); ++i) {
            elem = (Element)list.get(i);
            if (prev instanceof StringElement && elem instanceof StringElement) {
                String str = ((StringElement)prev).getString() + ((StringElement)elem).getString();
                elem = new StringElement(str);
                list.remove(i);
                list.set(i - 1, elem);
                --i;
            }
            prev = elem;
        }
        elem = (Element)list.get(list.size() - 1);
        for (i = list.size() - 2; i >= 0; --i) {
            prev = (Element)list.get(i);
            elem = new CombineElement(prev, elem);
        }
        return elem;
    }
}

