/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.visualbasic;

import java.io.PrintWriter;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.visualbasic.VisualBasicClass;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicModifier;

public class VisualBasicConstructor
extends CodeElement {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_FRIEND = 2;
    public static final int PROTECTED = 3;
    public static final int FRIEND = 4;
    public static final int PRIVATE = 5;
    public static final int SHARED = 32;
    private int modifiers;
    private VisualBasicClass cls;
    private String args;
    private LinkedList code;
    private VisualBasicComment comment;

    public VisualBasicConstructor() {
        this("");
    }

    public VisualBasicConstructor(String args) {
        this(1, args);
    }

    public VisualBasicConstructor(int modifiers, String args) {
        this.modifiers = modifiers;
        this.cls = null;
        this.args = args;
        this.code = new LinkedList();
        this.comment = null;
    }

    public VisualBasicClass getVisualBasicClass() {
        return this.cls;
    }

    void setVisualBasicClass(VisualBasicClass cls) {
        this.cls = cls;
    }

    public void addCode(String codeLines) {
        int pos = codeLines.indexOf(10);
        while (pos >= 0) {
            this.code.add(codeLines.substring(0, pos));
            codeLines = codeLines.substring(pos + 1);
            pos = codeLines.indexOf(10);
        }
        this.code.add(codeLines);
    }

    public void addComment(VisualBasicComment comment) {
        this.comment = comment;
    }

    @Override
    public int category() {
        return 7;
    }

    @Override
    public void print(PrintWriter out, CodeStyle style, int indent) {
        String indentStr = style.getIndent(indent);
        String codeIndentStr = style.getIndent(indent + 1);
        StringBuffer res = new StringBuffer();
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        res.append(indentStr);
        res.append(VisualBasicModifier.createModifierDecl(this.modifiers));
        res.append("Sub New(");
        res.append(this.args);
        res.append(")");
        for (int i = 0; i < this.code.size(); ++i) {
            if (this.code.get(i).toString().length() > 0) {
                res.append(codeIndentStr);
                res.append(this.code.get(i).toString());
                res.append("\n");
                continue;
            }
            res.append("\n");
        }
        res.append(indentStr);
        res.append("End Sub");
        out.println(res.toString());
    }
}

