/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.ui;

import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.alarm.BSnmpAlarmDeviceExt;
import com.tridium.nSnmp.alarm.BTrapType;
import com.tridium.nSnmp.datatypes.BMibListEntry;
import com.tridium.nSnmp.datatypes.BStringArray;
import com.tridium.nSnmp.enums.BSnmpMibEntryTypeEnum;
import com.tridium.nSnmp.mib.OidElement;
import com.tridium.nSnmp.mib.OidEntry;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.ui.BMibPathDialog;
import com.tridium.nSnmp.ui.BSnmpPointManager;
import com.tridium.nSnmp.ui.OidUtil;
import com.tridium.nSnmp.util.SnmpUtil;
import java.util.HashMap;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import net.percederberg.mibble.Mib;

public class BSnmpTrapManager
extends BAbstractManager {
    public static final Type TYPE = Sys.loadType(BSnmpTrapManager.class);
    static BImage snmpTrapIcon = BImage.make((String)"module://icons/x16/shapes/rectBlue.png");
    static Lexicon lexicon = Lexicon.make(BSnmpTrapManager.class);
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colTrapName = new MgrColumn.Prop(BTrapType.trapName, 3);
    MgrColumn colOid = new MgrColumn.Prop(BTrapType.trapOid, 3);
    MgrColumn colGeneric = new MgrColumn.Prop(BTrapType.genericType, 3);
    MgrColumn colSpecific = new MgrColumn.Prop(BTrapType.specificType, 3);
    MgrColumn colVariables = new MgrColumn.Prop(BTrapType.variablesArray, 3);
    MgrColumn colReference = new MgrColumn.Prop(BTrapType.reference, 3);
    MgrColumn colDesc = new MgrColumn.Prop(BTrapType.description, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colPath, this.colName, this.colTrapName, this.colOid, this.colGeneric, this.colSpecific, this.colVariables, this.colReference, this.colDesc};
    MgrColumn dcolName = new MgrColumn.Prop(lexicon.getText("table.columnTitle.name"), BMibListEntry.entryName, 0);
    MgrColumn dcolOid = new MgrColumn.Prop(lexicon.getText("table.columnTitle.oid"), BMibListEntry.oid, 0);
    MgrColumn dcolType = new MgrColumn.Prop(lexicon.getText("table.columnTitle.type"), BMibListEntry.variableType, 2);
    MgrColumn dcolValue = new MgrColumn.Prop(lexicon.getText("table.columnTitle.value"), BMibListEntry.value, 0);
    MgrColumn dcolAccess = new MgrColumn.Prop(lexicon.getText("table.columnTitle.access"), BMibListEntry.access, 2);
    MgrColumn dcolStatus = new MgrColumn.Prop(lexicon.getText("table.columnTitle.status"), BMibListEntry.status, 2);
    MgrColumn dcolElementType = new MgrColumn.Prop(lexicon.getText("table.columnTitle.elementType"), BMibListEntry.elementType, 2);
    MgrColumn dcolDesc = new MgrColumn.Prop(lexicon.getText("table.columnTitle.description"), BMibListEntry.desc, 0);
    MgrColumn[] dcols = new MgrColumn[]{this.dcolName, this.dcolOid, this.dcolType, this.dcolValue, this.dcolAccess, this.dcolStatus, this.dcolElementType, this.dcolDesc};
    BSnmpAlarmDeviceExt storedTraps;
    BSnmpDevice device;
    boolean isCheckingExistence = false;
    boolean discoveryInProcess = false;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new SnmpTrapModel(this);
    }

    protected MgrController makeController() {
        return new SnmpTrapController(this);
    }

    protected MgrLearn makeLearn() {
        return new SnmpTrapLearn(this);
    }

    protected MgrState makeState() {
        return new SnmpTrapState();
    }

    private static String parseDescription(String description) {
        String retValue = "";
        int startIndex = description.lastIndexOf("; DESCRIPTION=") + 14;
        int finishIndex = description.lastIndexOf("; REFERENCE=");
        if (startIndex > -1 && startIndex < finishIndex) {
            retValue = description.substring(startIndex, finishIndex);
        }
        return retValue;
    }

    private static String parseReference(String description) {
        String retValue = "";
        int startIndex = description.lastIndexOf("; REFERENCE=") + 12;
        int finishIndex = description.length();
        if (startIndex > -1 && startIndex < finishIndex) {
            retValue = description.substring(startIndex, finishIndex);
        }
        return retValue;
    }

    private static int parseGenericType(String description) {
        int retValue = -1;
        int startIndex = description.indexOf("GENERIC=") + 8;
        int finishIndex = description.indexOf("; SPECIFIC=");
        if (startIndex > -1 && startIndex < finishIndex) {
            retValue = Integer.parseInt(description.substring(startIndex, finishIndex));
        }
        return retValue;
    }

    private static int parseSpecificType(String description) {
        int retValue = -1;
        int startIndex = description.indexOf("; SPECIFIC=") + 11;
        int finishIndex = description.indexOf(";", startIndex);
        if (startIndex > -1 && startIndex < finishIndex) {
            retValue = Integer.parseInt(description.substring(startIndex, finishIndex));
        }
        return retValue;
    }

    private static String[] parseVariables(String description) {
        int startIndex = description.lastIndexOf("; VARIABLES=") + 12;
        int finishIndex = description.lastIndexOf("; DESCRIPTION=");
        return SnmpUtil.getStringArray((String)description.substring(startIndex, finishIndex));
    }

    private static String[] parseObjects(String description) {
        int startIndex = description.lastIndexOf("OBJECTS=") + 8;
        int finishIndex = description.lastIndexOf("; DESCRIPTION=");
        return SnmpUtil.getStringArray((String)description.substring(startIndex, finishIndex));
    }

    public void doLoadValue(BObject value, Context cx) {
        this.storedTraps = (BSnmpAlarmDeviceExt)value;
        this.device = (BSnmpDevice)this.storedTraps.getDevice();
        super.doLoadValue(value, cx);
    }

    private BMibListEntry[] buildEntries(Mib mib) {
        OidElement oidBase = OidUtil.createOidEntries(mib, this.device.snmpNet());
        OidEntry[] oidEntries = oidBase.getOidEntries();
        if (oidEntries == null) {
            return new BMibListEntry[0];
        }
        HashMap<String, OidEntry> map = new HashMap<String, OidEntry>();
        Array a = new Array(BMibListEntry.class, oidEntries.length);
        for (int i = 0; i < oidEntries.length; ++i) {
            try {
                OidEntry e = oidEntries[i];
                BSnmpMibEntryTypeEnum t = e.getElementType();
                if (!t.equals((Object)BSnmpMibEntryTypeEnum.trap) && !t.equals((Object)BSnmpMibEntryTypeEnum.notification) || map.get(e.getOid()) != null) continue;
                map.put(e.getOid(), e);
                BMibListEntry mibEntry = new BMibListEntry();
                String oidValue = e.getOid();
                mibEntry.setOid(oidValue);
                mibEntry.setAccess(e.getAccess());
                mibEntry.setEntryName(e.getName());
                mibEntry.setStatus(e.getStatus());
                mibEntry.setDesc(e.getDesc());
                mibEntry.setObjectSyntax(e.getObjSyntax());
                if (e.getVariableType() != null) {
                    mibEntry.setVariableType(e.getVariableType());
                }
                mibEntry.setElementType(e.getElementType());
                a.add((Object)mibEntry);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (BMibListEntry[])a.trim();
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (this.isCheckingExistence) {
            return;
        }
        super.handleComponentEvent(event);
    }

    class ConfigAutoMibs
    extends MgrController.MgrCommand {
        private BSnmpTrapManager manager;

        ConfigAutoMibs(BSnmpTrapManager owner) {
            super((BWidget)owner, lexicon.getText("mibPathDialog.command.label"));
            this.manager = owner;
        }

        public CommandArtifact doInvoke() throws Exception {
            BMibPathDialog dlg = new BMibPathDialog(this.manager);
            dlg.open();
            return null;
        }
    }

    class SnmpTrapController
    extends MgrController {
        private MgrController.MgrCommand configAutoMibs;

        SnmpTrapController(BSnmpTrapManager mgr) {
            super((BAbstractManager)mgr);
            this.configAutoMibs = new ConfigAutoMibs(mgr);
            if (mgr.isLearnable()) {
                this.configAutoMibs.setFlags(1);
            }
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            MgrController.IMgrCommand[] cmds = super.makeCommands();
            int count = 0;
            if (cmds != null) {
                count = cmds.length;
            }
            MgrController.IMgrCommand[] retVal = new MgrController.IMgrCommand[count + 1];
            for (int i = 0; i < count; ++i) {
                retVal[i] = cmds[i];
            }
            retVal[count] = this.configAutoMibs;
            return retVal;
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
            if (command == this.discover) {
                return new MgrController.IMgrCommand[]{this.configAutoMibs};
            }
            return super.getDropDownCommands(command);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            BSnmpTrapManager mgr = (BSnmpTrapManager)this.getManager();
            if (!BSnmpPointManager.loadMibCompiler(mgr, BSnmpTrapManager.this.device)) {
                return null;
            }
            Mib mib = BSnmpPointManager.createMib(mgr, BSnmpTrapManager.this.device);
            if (mib != null) {
                BMibListEntry[] mibCells = BSnmpTrapManager.this.buildEntries(mib);
                ((SnmpTrapLearn)BSnmpTrapManager.this.getLearn()).updateTable(mibCells);
            }
            return super.doDiscover(cx);
        }
    }

    class SnmpTrapState
    extends MgrState {
        BMibListEntry[] lastLearn;

        SnmpTrapState() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BSnmpTrapManager manager = (BSnmpTrapManager)m;
            SnmpTrapLearn learn = (SnmpTrapLearn)manager.getLearn();
            this.lastLearn = learn.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BSnmpTrapManager manager = (BSnmpTrapManager)m;
            SnmpTrapLearn learn = (SnmpTrapLearn)manager.getLearn();
            if (this.lastLearn != null) {
                learn.updateTable(this.lastLearn);
            }
        }
    }

    class SnmpTrapLearn
    extends MgrLearn {
        BMibListEntry[] lastLearn;

        SnmpTrapLearn(BSnmpTrapManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpTrapManager.this.dcols;
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return true;
        }

        public BImage getIcon(Object dis) {
            return snmpTrapIcon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            MgrTypeInfo[] retVal = new MgrTypeInfo[]{MgrTypeInfo.make((Type)BTrapType.TYPE)};
            return retVal;
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            String[] variables;
            BMibListEntry entry = (BMibListEntry)discovery;
            String name = entry.getEntryName();
            String desc = BSnmpTrapManager.parseDescription(entry.getDesc());
            String reference = BSnmpTrapManager.parseReference(entry.getDesc());
            int generic = BSnmpTrapManager.parseGenericType(entry.getDesc());
            int specific = BSnmpTrapManager.parseSpecificType(entry.getDesc());
            if (entry.getElementType().equals((Object)BSnmpMibEntryTypeEnum.trap)) {
                variables = BSnmpTrapManager.parseVariables(entry.getDesc());
            } else if (entry.getElementType().equals((Object)BSnmpMibEntryTypeEnum.notification)) {
                variables = BSnmpTrapManager.parseObjects(entry.getDesc());
            } else {
                return;
            }
            row.setDefaultName(SlotPath.escape((String)name));
            row.setCell(BSnmpTrapManager.this.colTrapName, (BValue)BString.make((String)name));
            row.setCell(BSnmpTrapManager.this.colOid, (BValue)BString.make((String)entry.getOid()));
            row.setCell(BSnmpTrapManager.this.colGeneric, (BValue)BInteger.make((int)generic));
            row.setCell(BSnmpTrapManager.this.colSpecific, (BValue)BInteger.make((int)specific));
            row.setCell(BSnmpTrapManager.this.colVariables, (BValue)new BStringArray(variables));
            row.setCell(BSnmpTrapManager.this.colReference, (BValue)BString.make((String)reference));
            row.setCell(BSnmpTrapManager.this.colDesc, (BValue)BString.make((String)desc));
        }

        public boolean isExisting(Object dis, BComponent comp) {
            BTrapType comparison;
            String name;
            BMibListEntry entry = (BMibListEntry)dis;
            BTrapType trap = (BTrapType)comp;
            if (entry.getElementType().equals((Object)BSnmpMibEntryTypeEnum.trap)) {
                name = entry.getEntryName();
                String desc = BSnmpTrapManager.parseDescription(entry.getDesc());
                String reference = BSnmpTrapManager.parseReference(entry.getDesc());
                SnmpOID oid = new SnmpOID(entry.getOid());
                String[] variables = BSnmpTrapManager.parseVariables(entry.getDesc());
                int generic = BSnmpTrapManager.parseGenericType(entry.getDesc());
                int specific = BSnmpTrapManager.parseSpecificType(entry.getDesc());
                comparison = new BTrapType(name, desc, reference, variables, oid.toValue(), generic, specific);
            } else if (entry.getElementType().equals((Object)BSnmpMibEntryTypeEnum.notification)) {
                name = entry.getEntryName();
                String desc = BSnmpTrapManager.parseDescription(entry.getDesc());
                String reference = BSnmpTrapManager.parseReference(entry.getDesc());
                SnmpOID oid = new SnmpOID(entry.getOid());
                String[] variables = BSnmpTrapManager.parseObjects(entry.getDesc());
                comparison = new BTrapType(name, desc, reference, variables, oid.toValue());
            } else {
                return false;
            }
            BSnmpTrapManager.this.isCheckingExistence = true;
            boolean retVal = trap.compareTraps(comparison);
            BSnmpTrapManager.this.isCheckingExistence = false;
            return retVal;
        }

        public void updateTable(BMibListEntry[] table) {
            this.lastLearn = table;
            this.updateRoots(table);
        }
    }

    class SnmpTrapModel
    extends MgrModel {
        SnmpTrapModel(BSnmpTrapManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BSnmpTrapManager.this.cols;
        }

        public MgrTypeInfo[] getNewTypes() {
            MgrTypeInfo[] retVal = new MgrTypeInfo[]{MgrTypeInfo.make((Type)BTrapType.TYPE)};
            return retVal;
        }
    }
}

