/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.ui;

import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="storageSize", type="double", defaultValue="1024", facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS }, new BIDataValue[] { BUnit.getUnit(\"byte\") })")}), @NiagaraProperty(name="textFont", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="usedBarBrush", type="BBrush", defaultValue="BColor.cadetBlue.toBrush()"), @NiagaraProperty(name="overheadBarBrush", type="BBrush", defaultValue="BColor.gray.toBrush()"), @NiagaraProperty(name="freeBarBrush", type="BBrush", defaultValue="BColor.white.toBrush()"), @NiagaraProperty(name="flushing", type="boolean", defaultValue="BBoolean.FALSE")})
@NiagaraTopic(name="valueChanged", eventType="BWidgetEvent")
public class BDataRecoveryStorageBar
extends BWidget {
    public static final Property storageSize = BDataRecoveryStorageBar.newProperty((int)0, (int)1024, (BFacets)BFacets.make((String[])new String[]{"units"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"byte")}));
    public static final Property textFont = BDataRecoveryStorageBar.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property usedBarBrush = BDataRecoveryStorageBar.newProperty((int)0, (BValue)BColor.cadetBlue.toBrush(), null);
    public static final Property overheadBarBrush = BDataRecoveryStorageBar.newProperty((int)0, (BValue)BColor.gray.toBrush(), null);
    public static final Property freeBarBrush = BDataRecoveryStorageBar.newProperty((int)0, (BValue)BColor.white.toBrush(), null);
    public static final Property flushing = BDataRecoveryStorageBar.newProperty((int)0, (BValue)BBoolean.FALSE, null);
    public static final Topic valueChanged = BDataRecoveryStorageBar.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BDataRecoveryStorageBar.class);
    private final Object valuesMonitor = new Object();
    private double usedValue = 0.0;
    private double freeValue = 0.0;
    private double overheadValue = 0.0;
    private int inOff = 0;

    public double getStorageSize() {
        return this.getDouble(storageSize);
    }

    public void setStorageSize(double v) {
        this.setDouble(storageSize, v, null);
    }

    public BFont getTextFont() {
        return (BFont)this.get(textFont);
    }

    public void setTextFont(BFont v) {
        this.set(textFont, (BValue)v, null);
    }

    public BBrush getUsedBarBrush() {
        return (BBrush)this.get(usedBarBrush);
    }

    public void setUsedBarBrush(BBrush v) {
        this.set(usedBarBrush, (BValue)v, null);
    }

    public BBrush getOverheadBarBrush() {
        return (BBrush)this.get(overheadBarBrush);
    }

    public void setOverheadBarBrush(BBrush v) {
        this.set(overheadBarBrush, (BValue)v, null);
    }

    public BBrush getFreeBarBrush() {
        return (BBrush)this.get(freeBarBrush);
    }

    public void setFreeBarBrush(BBrush v) {
        this.set(freeBarBrush, (BValue)v, null);
    }

    public boolean getFlushing() {
        return this.getBoolean(flushing);
    }

    public void setFlushing(boolean v) {
        this.setBoolean(flushing, v, null);
    }

    public void fireValueChanged(BWidgetEvent event) {
        this.fire(valueChanged, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDataRecoveryStorageBar() {
    }

    public BDataRecoveryStorageBar(int max) {
        this();
        this.setStorageSize(max);
    }

    public void computePreferredSize() {
        this.setPreferredSize(375.0, 30.0);
    }

    public void animate() {
        if (this.getFlushing()) {
            this.inOff += 4;
            if (this.inOff >= 16) {
                this.inOff = 0;
            }
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        BBrush usedBrush = this.getUsedBarBrush();
        BBrush freeBrush = this.getFreeBarBrush();
        BBrush overheadBrush = this.getOverheadBarBrush();
        if (this.getFlushing()) {
            g.setBrush(overheadBrush);
            g.fillRect(0.0, 0.0, w, h);
            g.setBrush(usedBrush);
            int i = -((int)(h + 16.0));
            while ((double)i < w) {
                int x = i + this.inOff;
                g.strokeLine((double)x, h, (double)x + h, 0.0);
                g.strokeLine((double)(x + 1), h, (double)x + h + 1.0, 0.0);
                g.strokeLine((double)(x + 2), h, (double)x + h + 2.0, 0.0);
                g.strokeLine((double)(x + 3), h, (double)x + h + 3.0, 0.0);
                g.strokeLine((double)(x + 4), h, (double)x + h + 4.0, 0.0);
                g.strokeLine((double)(x + 5), h, (double)x + h + 5.0, 0.0);
                g.strokeLine((double)(x + 6), h, (double)x + h + 6.0, 0.0);
                g.strokeLine((double)(x + 7), h, (double)x + h + 7.0, 0.0);
                g.strokeLine((double)(x + 8), h, (double)x + h + 8.0, 0.0);
                i += 16;
            }
            g.setBrush(BColor.black);
            g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        } else {
            g.setBrush(freeBrush);
            g.fillRect(0.0, 0.0, w, h);
            int usedWidth = (int)(this.getPercentUsed() * w);
            int overHeadWidth = (int)(this.getPercentOverhead() * w);
            g.setBrush(usedBrush);
            g.fillRect(0.0, 0.0, (double)usedWidth, h);
            g.setBrush(overheadBrush);
            g.fillRect((double)usedWidth, 0.0, (double)overHeadWidth, h);
            g.setBrush(BColor.black);
            g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
            g.strokeLine((double)usedWidth, 0.0, (double)usedWidth, h);
            g.strokeLine((double)(usedWidth + overHeadWidth), 0.0, (double)(usedWidth + overHeadWidth), h);
        }
    }

    public int getFreeValue() {
        return (int)this.freeValue;
    }

    public int getUsedValue() {
        return (int)this.usedValue;
    }

    public int getOverheadValue() {
        return (int)this.overheadValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsedValue(int v) {
        Object object = this.valuesMonitor;
        synchronized (object) {
            if (v < 0) {
                v = 0;
            } else if ((double)v > this.getStorageSize()) {
                v = (int)this.getStorageSize();
            }
            this.usedValue = v;
            this.fireValueChanged(null);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreeValue(int v) {
        Object object = this.valuesMonitor;
        synchronized (object) {
            if (v < 0) {
                v = 0;
            } else if ((double)v > this.getStorageSize()) {
                v = (int)this.getStorageSize();
            }
            this.freeValue = v;
            this.fireValueChanged(null);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverheadValue(int v) {
        Object object = this.valuesMonitor;
        synchronized (object) {
            if (v < 0) {
                v = 0;
            } else if ((double)v > this.getStorageSize()) {
                v = (int)this.getStorageSize();
            }
            this.overheadValue = v;
            this.fireValueChanged(null);
            this.repaint();
        }
    }

    public double getPercentFree() {
        return this.freeValue / this.getStorageSize();
    }

    public double getPercentUsed() {
        return this.usedValue / this.getStorageSize();
    }

    public double getPercentOverhead() {
        return this.overheadValue / this.getStorageSize();
    }

    public double getPercentFull() {
        return (this.overheadValue + this.usedValue) / this.getStorageSize();
    }
}

