/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.platDataRecovery.BDataRecoveryService;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManager;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManagerStatus;
import com.tridium.platDataRecovery.config.BDataRecoveryConfig;
import com.tridium.platDataRecovery.ui.BDataRecoveryBlockManagerView;
import com.tridium.platDataRecovery.ui.BDataRecoveryConfigEditor;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.alarm.BPlatformAlarmSupport;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.util.ObjectUtil;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BFloatFE;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.BPen;
import javax.baja.gx.BRectGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.shape.BRect;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platDataRecovery:DataRecoveryService"})})
@NiagaraActions(value={@NiagaraAction(name="updateDataRecoveryBlocks", parameterType="BDataRecoveryService", defaultValue="new BDataRecoveryService()", flags=4), @NiagaraAction(name="stationSaveLimitModified", flags=4)})
public class BDataRecoveryServiceEditor
extends BWbComponentView {
    public static final Action updateDataRecoveryBlocks = BDataRecoveryServiceEditor.newAction((int)4, (BValue)new BDataRecoveryService(), null);
    public static final Action stationSaveLimitModified = BDataRecoveryServiceEditor.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BDataRecoveryServiceEditor.class);
    private static final BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();
    private static final Lexicon lex = Lexicon.make((String)"platDataRecovery");
    BGridPane blocksPane = new BGridPane();
    Version remoteDataRecoveryVersion = Version.NULL;
    private BLabel serviceStatusLabel = null;
    private BAbsTimeFE lastStationSave = null;
    private BBooleanFE serviceEnabled = null;
    private BBooleanFE lastStationSaveSuccessful = null;
    private BFloatFE persistentStorageSizeFE = null;
    private BBooleanFE alertOnReplayFE = null;
    private BWbFieldEditor dataRecoveryAlarmSupportFE = null;
    private BWbFieldEditor stationSaveLimitFE;
    private BWbFieldEditor stationSaveLimitPeriodFE;
    private boolean isStationSaveLimitModified = false;
    private BDataRecoveryConfigEditor configurationEditor = null;
    private static final String freeBrushString = lex.get("DataRecoveryServiceEditor.freeBrush", "whiteSmoke");
    private static final String usedBrushString = lex.get("DataRecoveryServiceEditor.usedBrush", "maroon");
    private static final String overheadBrushString = lex.get("DataRecoveryServiceEditor.overheadBrush", "darkOrange");
    public static final BBrush freeBrush = BBrush.make((String)freeBrushString);
    public static final BBrush usedBrush = BBrush.make((String)usedBrushString);
    public static final BBrush overheadBrush = BBrush.make((String)overheadBrushString);
    private final BRect freeLegendRect = new BRect((IRectGeom)BRectGeom.make((double)0.0, (double)0.0, (double)15.0, (double)15.0), freeBrush, BBrush.makeSolid((BColor)BColor.black), BPen.make((double)1.0));
    private final BRect usedLegendRect = new BRect((IRectGeom)BRectGeom.make((double)0.0, (double)0.0, (double)15.0, (double)15.0), usedBrush, BBrush.makeSolid((BColor)BColor.black), BPen.make((double)1.0));
    private final BRect overheadLegendRect = new BRect((IRectGeom)BRectGeom.make((double)0.0, (double)0.0, (double)15.0, (double)15.0), overheadBrush, BBrush.makeSolid((BColor)BColor.black), BPen.make((double)1.0));
    private final BLabel freeLabel = BDataRecoveryServiceEditor.makeLabel(BDataRecoveryServiceEditor.text("blocks.free"), false);
    private final BLabel usedLabel = BDataRecoveryServiceEditor.makeLabel(BDataRecoveryServiceEditor.text("blocks.used"), false);
    private final BLabel overheadLabel = BDataRecoveryServiceEditor.makeLabel(BDataRecoveryServiceEditor.text("blocks.overhead"), false);

    public void updateDataRecoveryBlocks(BDataRecoveryService parameter) {
        this.invoke(updateDataRecoveryBlocks, (BValue)parameter, null);
    }

    public void stationSaveLimitModified() {
        this.invoke(stationSaveLimitModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDataRecoveryServiceEditor() {
        this.autoRegisterForComponentEvents = false;
    }

    public void deactivated() {
        super.deactivated();
        this.blocksPane = null;
        this.serviceStatusLabel = null;
        this.lastStationSave = null;
        this.lastStationSaveSuccessful = null;
        this.serviceEnabled = null;
        this.persistentStorageSizeFE = null;
        this.alertOnReplayFE = null;
        this.dataRecoveryAlarmSupportFE = null;
        this.stationSaveLimitFE = null;
        this.stationSaveLimitPeriodFE = null;
        this.configurationEditor = null;
    }

    protected final void doLoadValue(BObject value, Context cx) throws Exception {
        BDataRecoveryService dataRecoveryService = (BDataRecoveryService)value;
        dataRecoveryService.lease(3);
        BGridPane settingsPane = new BGridPane(2);
        settingsPane.setValign(BValign.top);
        settingsPane.setHalign(BHalign.left);
        settingsPane.setColumnAlign(BHalign.fill);
        settingsPane.setStretchColumn(1);
        settingsPane.setColumnGap(10.0);
        settingsPane.setRowGap(6.0);
        settingsPane.setColorRows(false);
        this.serviceEnabled = new BBooleanFE();
        BDataRecoveryServiceEditor.addLabelWidgetPair(settingsPane, BDataRecoveryServiceEditor.text("settings.serviceEnabled.label"), BDataRecoveryServiceEditor.left((BWidget)this.serviceEnabled), true);
        this.serviceEnabled.loadValue((BObject)BBoolean.make((boolean)dataRecoveryService.getEnabled()), cx);
        this.serviceEnabled.setReadonly(true);
        this.serviceEnabled.setEnabled(false);
        this.linkTo(null, (BComponent)this.serviceEnabled, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.serviceStatusLabel = new BLabel();
        BDataRecoveryServiceEditor.addLabelWidgetPair(settingsPane, BDataRecoveryServiceEditor.text("settings.status.label"), BDataRecoveryServiceEditor.left((BWidget)this.serviceStatusLabel), true);
        this.serviceStatusLabel.setText(dataRecoveryService.getDataRecoveryStatus().toString(cx));
        this.lastStationSave = new BAbsTimeFE();
        BDataRecoveryServiceEditor.addLabelWidgetPair(settingsPane, BDataRecoveryServiceEditor.text("settings.lastSave.label"), BDataRecoveryServiceEditor.left((BWidget)this.lastStationSave), true);
        this.lastStationSave.loadValue((BObject)dataRecoveryService.getLastStationSave(), cx);
        this.lastStationSave.setReadonly(true);
        this.lastStationSave.setEnabled(false);
        this.lastStationSaveSuccessful = new BBooleanFE();
        BDataRecoveryServiceEditor.addLabelWidgetPair(settingsPane, BDataRecoveryServiceEditor.text("settings.lastSaveSuccessful.label"), BDataRecoveryServiceEditor.left((BWidget)this.lastStationSaveSuccessful), true);
        this.lastStationSaveSuccessful.loadValue((BObject)BBoolean.make((boolean)dataRecoveryService.getLastStationSaveSuccessful()), cx);
        this.lastStationSaveSuccessful.setReadonly(true);
        this.lastStationSaveSuccessful.setEnabled(false);
        if (dataRecoveryService.getSession() instanceof BFoxSession) {
            this.remoteDataRecoveryVersion = (Version)((BFoxSession)dataRecoveryService.getSession()).fw(404, (Object)"platDataRecovery", (Object)BDataRecoveryService.TYPE.getRuntimeProfile().name(), null, null);
        }
        if (this.remoteDataRecoveryVersion != null && !this.remoteDataRecoveryVersion.isNull() && this.remoteDataRecoveryVersion.compareTo(new Version("3.8.19")) > 0) {
            this.stationSaveLimitFE = BWbFieldEditor.makeFor((BObject)BInteger.make((int)1), (Context)BDataRecoveryService.stationSaveLimit.getFacets());
            LabelUtil.addLabelWidgetPair((BPane)settingsPane, (String)BDataRecoveryServiceEditor.text("settings.stationSaveLimit"), (BWidget)BDataRecoveryServiceEditor.left((BWidget)this.stationSaveLimitFE), (boolean)true);
            this.stationSaveLimitFE.loadValue((BObject)BInteger.make((int)dataRecoveryService.getStationSaveLimit()), (Context)BDataRecoveryService.stationSaveLimit.getFacets());
            this.stationSaveLimitFE.setReadonly(true);
            this.stationSaveLimitFE.setEnabled(false);
            this.linkTo(null, (BComponent)this.stationSaveLimitFE, (Slot)BWbPlugin.pluginModified, (Slot)stationSaveLimitModified);
            this.stationSaveLimitPeriodFE = BWbFieldEditor.makeFor((BObject)BRelTime.HOUR, (Context)BDataRecoveryService.stationSaveLimitPeriod.getFacets());
            LabelUtil.addLabelWidgetPair((BPane)settingsPane, (String)BDataRecoveryServiceEditor.text("settings.stationSaveLimitPeriod"), (BWidget)BDataRecoveryServiceEditor.left((BWidget)this.stationSaveLimitPeriodFE), (boolean)true);
            this.stationSaveLimitPeriodFE.loadValue((BObject)dataRecoveryService.getStationSaveLimitPeriod(), (Context)BDataRecoveryService.stationSaveLimitPeriod.getFacets());
            this.stationSaveLimitPeriodFE.setReadonly(true);
            this.stationSaveLimitPeriodFE.setEnabled(false);
            this.linkTo(null, (BComponent)this.stationSaveLimitPeriodFE, (Slot)BWbPlugin.pluginModified, (Slot)stationSaveLimitModified);
        } else {
            this.stationSaveLimitFE = null;
            this.stationSaveLimitPeriodFE = null;
        }
        this.persistentStorageSizeFE = new BFloatFE();
        BDataRecoveryServiceEditor.addLabelWidgetPair(settingsPane, BDataRecoveryServiceEditor.text("settings.persistentStorageSize.label"), BDataRecoveryServiceEditor.left((BWidget)this.persistentStorageSizeFE), true);
        this.persistentStorageSizeFE.loadValue((BObject)BDouble.make((double)dataRecoveryService.getPersistentStorageSize()), (Context)dataRecoveryService.getSlotFacets((Slot)BDataRecoveryService.persistentStorageSize));
        this.persistentStorageSizeFE.setReadonly(true);
        this.persistentStorageSizeFE.setEnabled(false);
        this.alertOnReplayFE = new BBooleanFE();
        BDataRecoveryServiceEditor.addLabelWidgetPair(settingsPane, BDataRecoveryServiceEditor.text("settings.alertOnReplay.label"), BDataRecoveryServiceEditor.left((BWidget)this.alertOnReplayFE), true);
        this.alertOnReplayFE.loadValue((BObject)BBoolean.make((boolean)dataRecoveryService.getAlertOnReplay()), cx);
        this.alertOnReplayFE.setReadonly(true);
        this.alertOnReplayFE.setEnabled(false);
        this.linkTo(null, (BComponent)this.alertOnReplayFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.dataRecoveryAlarmSupportFE = BWbFieldEditor.makeFor((BObject)new BPlatformAlarmSupport(), (Context)BDataRecoveryService.dataRecoveryAlarmSupport.getFacets());
        BDataRecoveryServiceEditor.addLabelWidgetPair(settingsPane, BDataRecoveryServiceEditor.text("settings.platformAlarmSupport.label"), BDataRecoveryServiceEditor.left((BWidget)new BExpandablePane((BWidget)new BNullWidget(), (BWidget)this.dataRecoveryAlarmSupportFE)), true);
        BEdgePane mainPane = new BEdgePane();
        mainPane.setTop((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)settingsPane), BDataRecoveryServiceEditor.makeLabel(BDataRecoveryServiceEditor.text("settings.border.label"), true), BBorder.solid));
        this.configurationEditor = new BDataRecoveryConfigEditor();
        this.configurationEditor.loadValue((BObject)dataRecoveryService.getDataRecoveryConfiguration(), (Context)dataRecoveryService.getSlotFacets((Slot)BDataRecoveryService.dataRecoveryConfiguration));
        this.configurationEditor.setReadonly(true);
        this.configurationEditor.setEnabled(false);
        BBorderPane configBorder = new BBorderPane((BWidget)new BScrollPane((BWidget)this.configurationEditor), BDataRecoveryServiceEditor.makeLabel(BDataRecoveryServiceEditor.text("config.border.label"), true), BBorder.solid);
        configBorder.setMargin(BInsets.make((double)5.0, (double)0.0, (double)0.0, (double)0.0));
        this.blocksPane = new BGridPane(1);
        this.blocksPane.setValign(BValign.top);
        this.blocksPane.setHalign(BHalign.left);
        this.blocksPane.setColumnAlign(BHalign.fill);
        this.blocksPane.setStretchColumn(0);
        this.blocksPane.setColorRows(false);
        int blockCount = 0;
        BExpandablePane firstExpandable = null;
        SlotCursor c = dataRecoveryService.getDataRecoveryBlocks().loadSlots().getProperties();
        while (c.next()) {
            ++blockCount;
            BDataRecoveryBlockManager block = (BDataRecoveryBlockManager)c.get();
            BDataRecoveryBlockManagerView blockView = new BDataRecoveryBlockManagerView();
            this.attach(blockView);
            blockView.loadValue((BObject)block, cx);
            BBorderPane borderedBlock = new BBorderPane((BWidget)blockView, 0.0, 0.0, 0.0, 0.0);
            borderedBlock.setBorder(BBorder.inset);
            BExpandablePane expandable = new BExpandablePane((BWidget)BDataRecoveryServiceEditor.makeLabel(BDataRecoveryServiceEditor.text("blocks.prefix") + " " + blockCount, true), (BWidget)borderedBlock);
            if (firstExpandable == null && (block.getCurrentManagerStatus() == BDataRecoveryBlockManagerStatus.active || block.getCurrentManagerStatus() == BDataRecoveryBlockManagerStatus.reserved)) {
                firstExpandable = expandable;
            }
            this.blocksPane.add("block" + blockCount, (BValue)expandable, null);
        }
        this.blocksPane.relayout();
        if (firstExpandable != null) {
            firstExpandable.setExpanded(true);
        }
        BScrollPane scrollBlocksPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.blocksPane));
        scrollBlocksPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BFlowPane legendPane = new BFlowPane();
        BGridPane usedLegendItem = new BGridPane(2);
        BGridPane overheadLegendItem = new BGridPane(2);
        BGridPane freeLegendItem = new BGridPane(2);
        BWidget previousParent = this.usedLegendRect.getParentWidget();
        if (previousParent != null) {
            previousParent.remove("usedRect");
            previousParent.remove("usedLabel");
        }
        usedLegendItem.add("usedRect", (BValue)this.usedLegendRect);
        usedLegendItem.add("usedLabel", (BValue)this.usedLabel);
        previousParent = this.overheadLegendRect.getParentWidget();
        if (previousParent != null) {
            previousParent.remove("overheadRect");
            previousParent.remove("overheadLabel");
        }
        overheadLegendItem.add("overheadRect", (BValue)this.overheadLegendRect);
        overheadLegendItem.add("overheadLabel", (BValue)this.overheadLabel);
        previousParent = this.freeLegendRect.getParentWidget();
        if (previousParent != null) {
            previousParent.remove("freeRect");
            previousParent.remove("freeLabel");
        }
        freeLegendItem.add("freeRect", (BValue)this.freeLegendRect);
        freeLegendItem.add("freeLabel", (BValue)this.freeLabel);
        legendPane.add("usedItem", (BValue)usedLegendItem);
        legendPane.add("overheadItem", (BValue)overheadLegendItem);
        legendPane.add("freeItem", (BValue)freeLegendItem);
        BBorderPane legendBorderPane = new BBorderPane((BWidget)legendPane, BDataRecoveryServiceEditor.makeLabel(BDataRecoveryServiceEditor.text("blocks.legend.border.label"), true));
        BEdgePane edgeBlockPane = new BEdgePane();
        edgeBlockPane.setBottom((BWidget)legendBorderPane);
        edgeBlockPane.setCenter((BWidget)scrollBlocksPane);
        BBorderPane blocksBorder = new BBorderPane((BWidget)edgeBlockPane, BDataRecoveryServiceEditor.makeLabel(BDataRecoveryServiceEditor.text("blocks.border.label"), true), BBorder.solid);
        blocksBorder.setMargin(BInsets.make((double)5.0, (double)0.0, (double)0.0, (double)0.0));
        BSplitPane configBlocksPane = new BSplitPane((BWidget)configBorder, (BWidget)blocksBorder);
        configBlocksPane.setOrientation(BOrientation.horizontal);
        mainPane.setCenter((BWidget)configBlocksPane);
        BButtonPane buttonPane = new BButtonPane();
        buttonPane.addWorkbenchButtons((BWidget)this);
        this.registerForComponentEvents((BComponent)dataRecoveryService, 2);
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttonPane, 5.0, 5.0, 0.0, 5.0), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)mainPane)))));
        this.dataRecoveryAlarmSupportFE.loadValue((BObject)dataRecoveryService.getDataRecoveryAlarmSupport(), (Context)(cx == null ? BDataRecoveryService.dataRecoveryAlarmSupport.getFacets() : BFacets.make((BFacets)cx.getFacets(), (BFacets)BDataRecoveryService.dataRecoveryAlarmSupport.getFacets())));
        this.dataRecoveryAlarmSupportFE.setReadonly(true);
        this.dataRecoveryAlarmSupportFE.setEnabled(false);
        this.linkTo(null, (BComponent)this.dataRecoveryAlarmSupportFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.doSetReadonly(false);
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        BDataRecoveryService dataRecoveryService = (BDataRecoveryService)value;
        boolean enabledState = ((BBoolean)this.serviceEnabled.saveValue(cx)).getBoolean();
        boolean rebootRequired = false;
        if (enabledState != dataRecoveryService.getEnabled()) {
            dataRecoveryService.setEnabled(((BBoolean)this.serviceEnabled.saveValue(cx)).getBoolean());
            rebootRequired = true;
        }
        dataRecoveryService.setLastStationSave((BAbsTime)this.lastStationSave.saveValue(cx));
        dataRecoveryService.setLastStationSaveSuccessful(((BBoolean)this.lastStationSaveSuccessful.saveValue(cx)).getBoolean());
        dataRecoveryService.setPersistentStorageSize(((BDouble)this.persistentStorageSizeFE.saveValue(cx)).getDouble());
        dataRecoveryService.setAlertOnReplay(((BBoolean)this.alertOnReplayFE.saveValue(cx)).getBoolean());
        dataRecoveryService.setDataRecoveryAlarmSupport((BPlatformAlarmSupport)this.dataRecoveryAlarmSupportFE.saveValue(cx));
        this.alertOnReplayFE.loadValue((BObject)BBoolean.make((boolean)dataRecoveryService.getAlertOnReplay()));
        this.dataRecoveryAlarmSupportFE.loadValue((BObject)dataRecoveryService.getDataRecoveryAlarmSupport());
        if (this.isStationSaveLimitModified) {
            if (this.stationSaveLimitFE != null) {
                dataRecoveryService.setStationSaveLimit(((BInteger)this.stationSaveLimitFE.saveValue(cx)).getInt());
            }
            if (this.stationSaveLimitPeriodFE != null) {
                dataRecoveryService.setStationSaveLimitPeriod((BRelTime)this.stationSaveLimitPeriodFE.saveValue(cx));
            }
            this.isStationSaveLimitModified = false;
        }
        dataRecoveryService.setDataRecoveryConfiguration((BDataRecoveryConfig)this.configurationEditor.saveValue(cx));
        dataRecoveryService.savePlatformServiceProperties();
        if (rebootRequired && 4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("DataRecoveryService.rebootNow.title"), (Object)this.getLexicon().getText("DataRecoveryService.rebootNow.message"))) {
            BSystemPlatformService sys = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)dataRecoveryService);
            sys.reboot();
        }
        return dataRecoveryService;
    }

    public void doStationSaveLimitModified() {
        if (!this.isModifiedStateLocked()) {
            this.isStationSaveLimitModified = true;
            this.invoke(setModified, null, null);
        }
    }

    public final void doSetReadonly(boolean readonly) {
        boolean enabled;
        boolean bl = enabled = !readonly;
        if (this.serviceEnabled != null) {
            this.serviceEnabled.setReadonly(readonly);
            this.serviceEnabled.setEnabled(enabled);
        }
        if (this.lastStationSave != null) {
            this.lastStationSave.setEnabled(true);
        }
        if (this.stationSaveLimitFE != null) {
            this.stationSaveLimitFE.setReadonly(readonly);
            this.stationSaveLimitFE.setEnabled(enabled);
        }
        if (this.stationSaveLimitPeriodFE != null) {
            this.stationSaveLimitPeriodFE.setReadonly(readonly);
            this.stationSaveLimitPeriodFE.setEnabled(enabled);
        }
        if (this.alertOnReplayFE != null) {
            this.alertOnReplayFE.setReadonly(readonly);
            this.alertOnReplayFE.setEnabled(enabled);
        }
        if (this.dataRecoveryAlarmSupportFE != null) {
            this.dataRecoveryAlarmSupportFE.setReadonly(readonly);
            this.dataRecoveryAlarmSupportFE.setEnabled(enabled);
        }
    }

    public void doUpdateDataRecoveryBlocks(BDataRecoveryService service) {
        if (this.blocksPane != null) {
            Array toRemove = new Array(BExpandablePane.class);
            SlotCursor c = this.blocksPane.loadSlots().getProperties();
            while (c.next(BExpandablePane.class)) {
                BExpandablePane current = (BExpandablePane)c.get();
                BBorderPane currentBorder = (BBorderPane)current.getExpansion();
                BDataRecoveryBlockManagerView oldView = (BDataRecoveryBlockManagerView)currentBorder.getContent();
                this.unattach(oldView);
                toRemove.add((Object)current);
            }
            for (int i = 0; i < toRemove.size(); ++i) {
                this.blocksPane.remove((BComplex)toRemove.get(i));
            }
            this.blocksPane.relayout();
            int blockCount = 0;
            BExpandablePane firstExpandable = null;
            BVector dataRecoveryBlocks = service.getDataRecoveryBlocks();
            dataRecoveryBlocks.lease();
            SlotCursor c2 = dataRecoveryBlocks.loadSlots().getProperties();
            while (c2.next(BDataRecoveryBlockManager.class)) {
                ++blockCount;
                BDataRecoveryBlockManager block = (BDataRecoveryBlockManager)c2.get();
                BDataRecoveryBlockManagerView blockView = new BDataRecoveryBlockManagerView();
                this.attach(blockView);
                blockView.loadValue((BObject)block, this.getCurrentContext());
                BBorderPane borderedBlock = new BBorderPane((BWidget)blockView, 0.0, 0.0, 0.0, 0.0);
                borderedBlock.setBorder(BBorder.inset);
                BExpandablePane expandable = new BExpandablePane((BWidget)BDataRecoveryServiceEditor.makeLabel(BDataRecoveryServiceEditor.text("blocks.prefix") + " " + blockCount, true), (BWidget)borderedBlock);
                if (firstExpandable == null && block.getCurrentManagerStatus() == BDataRecoveryBlockManagerStatus.active) {
                    firstExpandable = expandable;
                }
                this.blocksPane.add("block" + blockCount, (BValue)expandable, null);
            }
            this.blocksPane.relayout();
            if (firstExpandable != null) {
                firstExpandable.setExpanded(true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSlot().isProperty()) {
            if (evt.getSourceComponent() instanceof BDataRecoveryService) {
                BDataRecoveryService service = (BDataRecoveryService)evt.getSourceComponent();
                Property property = evt.getSlot().asProperty();
                BValue propertyValue = service.get(property);
                if (property == BDataRecoveryService.enabled) {
                    if (this.serviceEnabled == null) return;
                    this.serviceEnabled.loadValue((BObject)((BBoolean)propertyValue));
                    return;
                }
                if (property == BDataRecoveryService.dataRecoveryStatus) {
                    if (this.serviceStatusLabel == null) return;
                    this.serviceStatusLabel.setText(propertyValue.toString().trim());
                    return;
                }
                if (property == BDataRecoveryService.lastStationSave) {
                    if (this.lastStationSave == null) return;
                    this.lastStationSave.loadValue((BObject)((BAbsTime)propertyValue));
                    return;
                }
                if (property == BDataRecoveryService.lastStationSaveSuccessful) {
                    if (this.lastStationSaveSuccessful == null) return;
                    this.lastStationSaveSuccessful.loadValue((BObject)((BBoolean)propertyValue));
                    return;
                }
                if (property == BDataRecoveryService.stationSaveLimit) {
                    if (this.isStationSaveLimitModified) return;
                    if (this.stationSaveLimitFE == null) return;
                    this.stationSaveLimitFE.loadValue((BObject)((BInteger)propertyValue));
                    return;
                }
                if (property == BDataRecoveryService.stationSaveLimitPeriod) {
                    if (this.isStationSaveLimitModified) return;
                    if (this.stationSaveLimitPeriodFE == null) return;
                    this.stationSaveLimitPeriodFE.loadValue((BObject)((BRelTime)propertyValue));
                    return;
                }
                if (property == BDataRecoveryService.persistentStorageSize) {
                    if (this.persistentStorageSizeFE == null) return;
                    this.persistentStorageSizeFE.loadValue((BObject)((BDouble)propertyValue), (Context)service.getSlotFacets((Slot)BDataRecoveryService.persistentStorageSize));
                    return;
                }
                if (property == BDataRecoveryService.dataRecoveryAlarmSupport) {
                    if (this.dataRecoveryAlarmSupportFE == null) return;
                    this.dataRecoveryAlarmSupportFE.loadValue((BObject)((BPlatformAlarmSupport)propertyValue));
                    return;
                }
                if (property == BDataRecoveryService.alertOnReplay) {
                    if (this.alertOnReplayFE == null) return;
                    this.alertOnReplayFE.loadValue((BObject)((BBoolean)propertyValue));
                    return;
                }
                if (property == BDataRecoveryService.dataRecoveryConfiguration) return;
                if (property != BDataRecoveryService.dataRecoveryBlocks) return;
                return;
            } else {
                if (evt.getSourceComponent() instanceof BDataRecoveryConfig) {
                    this.configurationEditor.handleComponentEvent(evt);
                    return;
                }
                super.handleComponentEvent(evt);
                return;
            }
        }
        if (evt.getSlot().isAction()) {
            super.handleComponentEvent(evt);
            return;
        }
        if (evt.getSlot().isTopic()) {
            if (evt.getSourceComponent() instanceof BDataRecoveryService) {
                BDataRecoveryService service = (BDataRecoveryService)evt.getSourceComponent();
                Topic topic = evt.getSlot().asTopic();
                if (topic != BDataRecoveryService.blocksWritten) return;
                this.doUpdateDataRecoveryBlocks(service);
                return;
            }
            super.handleComponentEvent(evt);
            return;
        }
        super.handleComponentEvent(evt);
    }

    private static String text(String key) {
        return lex.getText("DataRecoveryService." + key);
    }

    private static BWidget left(BWidget content) {
        BGridPane result = new BGridPane(1);
        result.setHalign(BHalign.left);
        result.setColumnAlign(BHalign.left);
        result.add(null, (BValue)content);
        return result;
    }

    private static void addLabelWidgetPair(BGridPane grid, String text, BWidget widget2, boolean bold) {
        String fieldName = text.trim();
        if (fieldName.length() > 10) {
            fieldName = fieldName.substring(0, 10);
        }
        fieldName = ObjectUtil.generateUniqueName((String)SlotPath.escape((String)fieldName), (ObjectUtil.NameContainer)new NameContainerDRS((BComplex)grid));
        grid.add(fieldName, (BValue)BDataRecoveryServiceEditor.makeLabel(text, bold));
        grid.add(null, (BValue)widget2);
    }

    public static BLabel makeLabel(String text, boolean bold) {
        return BDataRecoveryServiceEditor.makeLabel(text, bold, BHalign.left);
    }

    public static BLabel makeLabel(String text, boolean bold, BHalign align) {
        BLabel result = new BLabel(text == null ? "" : text, align);
        if (bold) {
            result.setFont(BOLD_TEXT_FONT);
        }
        return result;
    }

    private static final class NameContainerDRS
    implements ObjectUtil.NameContainer {
        BComplex complex = null;

        public NameContainerDRS(BComplex pComplex) {
            this.complex = pComplex;
        }

        public boolean contains(String name) {
            return this.complex.getSlot(name) != null;
        }
    }
}

