/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.ui;

import com.tridium.platDataRecovery.config.BDataRecoveryPersistenceCapacity;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"platDataRecovery:DataRecoveryPersistenceCapacity"})})
@NiagaraAction(name="updateState", flags=4)
public class BDataRecoveryPersistenceCapacityFE
extends BWbFieldEditor {
    public static final Action updateState = BDataRecoveryPersistenceCapacityFE.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BDataRecoveryPersistenceCapacityFE.class);
    private static final Lexicon lex = Lexicon.make((String)"platDataRecovery");
    private static final int UNLIMITED = 0;
    private static final int BY_STORAGE_SIZE = 1;
    private final BListDropDown typeChoice = new BListDropDown();
    private final BWbFieldEditor maxField;
    private final BLabel unitLabel;
    private int typeIndex = 0;
    private int lastKb = 500;

    public void updateState() {
        this.invoke(updateState, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDataRecoveryPersistenceCapacityFE() {
        this.typeChoice.getList().addItem((Object)lex.getText("unlimited"));
        this.typeChoice.getList().addItem((Object)lex.getText("storageSize"));
        this.maxField = BWbFieldEditor.makeFor((BObject)BInteger.DEFAULT);
        this.maxField.loadValue((BObject)BInteger.make((int)this.lastKb));
        this.unitLabel = new BLabel("KB");
        BGridPane outer = new BGridPane(3);
        outer.add("typeChoice", (BValue)this.typeChoice);
        outer.add("maxField", (BValue)this.maxField);
        outer.add("unitLabel", (BValue)this.unitLabel);
        this.setContent((BWidget)outer);
        this.add("typeModified", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BDropDown.valueModified, (Slot)setModified));
        this.add("typeUpdate", (BValue)new BLink((BComponent)this.typeChoice, (Slot)BDropDown.valueModified, (Slot)updateState));
        this.add("maxModified", (BValue)new BLink((BComponent)this.maxField, (Slot)BWbPlugin.pluginModified, (Slot)setModified));
        this.add("maxAction", (BValue)new BLink((BComponent)this.maxField, (Slot)BWbPlugin.actionPerformed, (Slot)actionPerformed));
    }

    protected void doLoadValue(BObject value, Context cx) {
        BDataRecoveryPersistenceCapacity c = (BDataRecoveryPersistenceCapacity)value;
        if (c.isUnlimited()) {
            this.typeChoice.setSelectedIndex(0);
            this.typeIndex = 0;
        } else if (c.isByStorageSize()) {
            this.typeChoice.setSelectedIndex(1);
            this.typeIndex = 1;
            this.maxField.loadValue((BObject)BInteger.make((int)((int)c.getMaxStorage() / 1024)));
            this.lastKb = (int)c.getMaxStorage() / 1024;
        }
        this.updateState();
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        int typeIndex = this.typeChoice.getSelectedIndex();
        if (typeIndex == 0) {
            return BDataRecoveryPersistenceCapacity.UNLIMITED;
        }
        return BDataRecoveryPersistenceCapacity.makeByStorageSize((long)(((BInteger)this.maxField.saveValue()).getInt() * 1024));
    }

    public void doUpdateState() {
        int newTypeIndex = this.typeChoice.getList().getSelectedIndex();
        try {
            if (this.typeIndex == 1) {
                this.lastKb = ((BInteger)this.maxField.saveValue()).getInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newTypeIndex == 0) {
            this.maxField.setVisible(false);
            this.unitLabel.setVisible(false);
        } else if (newTypeIndex == 1) {
            this.maxField.loadValue((BObject)BInteger.make((int)this.lastKb));
            this.maxField.setVisible(true);
            this.unitLabel.setText("KB");
            this.unitLabel.setVisible(true);
        }
        this.typeIndex = newTypeIndex;
        this.getContent().relayout();
    }

    public void doSetReadonly(boolean readonly) {
        boolean enabled = !readonly;
        this.typeChoice.setEnabled(enabled);
        this.typeChoice.setDropDownEnabled(enabled);
        this.maxField.setReadonly(readonly);
        this.maxField.setEnabled(enabled);
    }
}

