/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.ui;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManager;
import com.tridium.platDataRecovery.block.BDataRecoveryBlockManagerStatus;
import com.tridium.platDataRecovery.ui.BDataRecoveryServiceEditor;
import com.tridium.platDataRecovery.ui.BDataRecoveryStorageBar;
import com.tridium.ui.theme.Theme;
import com.tridium.util.ObjectUtil;
import javax.baja.gx.BFont;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platDataRecovery:DataRecoveryBlockAppendManager"})})
public class BDataRecoveryBlockManagerView
extends BWbComponentView
implements BWbComponentView.Attachable {
    public static final Type TYPE = Sys.loadType(BDataRecoveryBlockManagerView.class);
    private static final BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();
    private static final Lexicon lex = Lexicon.make((String)"platDataRecovery");
    BLabel usedLabel = null;
    BLabel freeLabel = null;
    BLabel overheadLabel = null;
    BLabel statusLabel = null;
    BLabel capacityLabel = null;
    BDataRecoveryStorageBar myBar = null;

    public Type getType() {
        return TYPE;
    }

    public BDataRecoveryBlockManagerView() {
        this.autoRegisterForComponentEvents = false;
    }

    public void deactivated() {
        super.deactivated();
        this.usedLabel = null;
        this.freeLabel = null;
        this.overheadLabel = null;
        this.statusLabel = null;
        this.capacityLabel = null;
        this.myBar = null;
    }

    protected final void doLoadValue(BObject value, Context ctx) throws Exception {
        BDataRecoveryBlockManager dataRecoveryBlockManager = (BDataRecoveryBlockManager)value;
        dataRecoveryBlockManager.lease(Integer.MAX_VALUE);
        BGridPane upperTextPane = new BGridPane();
        upperTextPane.setColumnCount(2);
        this.statusLabel = new BLabel();
        BDataRecoveryBlockManagerView.addLabelWidgetPair(upperTextPane, BDataRecoveryBlockManagerView.text("status"), BDataRecoveryBlockManagerView.left((BWidget)this.statusLabel), true);
        BGridPane lowerTextPane = new BGridPane();
        lowerTextPane.setColumnCount(8);
        this.capacityLabel = new BLabel();
        BDataRecoveryBlockManagerView.addLabelWidgetPair(lowerTextPane, BDataRecoveryBlockManagerView.text("capacity"), BDataRecoveryBlockManagerView.left((BWidget)this.capacityLabel), true);
        this.usedLabel = new BLabel();
        BDataRecoveryBlockManagerView.addLabelWidgetPair(lowerTextPane, BDataRecoveryBlockManagerView.text("used"), BDataRecoveryBlockManagerView.left((BWidget)this.usedLabel), true);
        this.overheadLabel = new BLabel();
        BDataRecoveryBlockManagerView.addLabelWidgetPair(lowerTextPane, BDataRecoveryBlockManagerView.text("overhead"), BDataRecoveryBlockManagerView.left((BWidget)this.overheadLabel), true);
        this.freeLabel = new BLabel();
        BDataRecoveryBlockManagerView.addLabelWidgetPair(lowerTextPane, BDataRecoveryBlockManagerView.text("free"), BDataRecoveryBlockManagerView.left((BWidget)this.freeLabel), true);
        this.capacityLabel.setText(dataRecoveryBlockManager.getMaxCapacity() + " B");
        this.statusLabel.setText(dataRecoveryBlockManager.getCurrentManagerStatus().toString(ctx));
        this.myBar = new BDataRecoveryStorageBar(dataRecoveryBlockManager.getMaxCapacity());
        this.myBar.setFreeBarBrush(BDataRecoveryServiceEditor.freeBrush);
        this.myBar.setUsedBarBrush(BDataRecoveryServiceEditor.usedBrush);
        this.myBar.setOverheadBarBrush(BDataRecoveryServiceEditor.overheadBrush);
        int freeSpace = dataRecoveryBlockManager.getFreeSpace();
        int usedSpace = dataRecoveryBlockManager.getUsedSpace();
        int overheadSpace = dataRecoveryBlockManager.getOverheadSpace();
        BVector remoteSpace = FoxRpcUtil.doSilentRpc((BISpaceNode)dataRecoveryBlockManager, (String)"getSpaceRemote", (Object[])new Object[]{new BVector()}).orElseGet(BVector::new);
        if (remoteSpace != null && remoteSpace.getSlotCount() > 0) {
            freeSpace = ((BInteger)remoteSpace.get("freespace")).getInt();
            usedSpace = ((BInteger)remoteSpace.get("usedspace")).getInt();
            overheadSpace = ((BInteger)remoteSpace.get("overheadspace")).getInt();
        }
        this.myBar.setFreeValue(freeSpace);
        this.myBar.setUsedValue(usedSpace);
        this.myBar.setOverheadValue(overheadSpace);
        this.usedLabel.setText(usedSpace + " B");
        this.overheadLabel.setText(overheadSpace + " B");
        this.freeLabel.setText(freeSpace + " B");
        BGridPane mainPane = new BGridPane();
        mainPane.setColumnCount(1);
        mainPane.setRowGap(5.0);
        mainPane.add("uppertext", (BValue)upperTextPane);
        mainPane.add("bar", (BValue)BDataRecoveryBlockManagerView.left(this.myBar));
        mainPane.add("lowertext", (BValue)lowerTextPane);
        this.registerForComponentEvents((BComponent)dataRecoveryBlockManager, Integer.MAX_VALUE);
        this.setContent((BWidget)new BBorderPane(BDataRecoveryBlockManagerView.left((BWidget)mainPane)));
    }

    public final void doSetReadonly(boolean readonly) {
    }

    public void attached(BWbComponentView editor) {
    }

    public void detached(BWbComponentView editor) {
        this.usedLabel = null;
        this.freeLabel = null;
        this.overheadLabel = null;
        this.statusLabel = null;
        this.capacityLabel = null;
        this.myBar = null;
    }

    public final void handleComponentEvent(BComponentEvent evt) {
        try {
            if (evt.getSourceComponent() != this.saveValue()) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        if (evt.getSlot().isProperty()) {
            if (evt.getSourceComponent() instanceof BDataRecoveryBlockManager) {
                BDataRecoveryBlockManager block = (BDataRecoveryBlockManager)evt.getSourceComponent();
                Property property = evt.getSlot().asProperty();
                BValue propertyValue = block.get(property);
                if (property == BDataRecoveryBlockManager.maxCapacity) {
                    if (this.myBar != null) {
                        this.myBar.setStorageSize(((BInteger)propertyValue).getInt());
                    }
                    if (this.capacityLabel != null) {
                        BFacets slotFacets = block.getSlotFacets((Slot)BDataRecoveryBlockManager.maxCapacity);
                        BUnit u = (BUnit)slotFacets.getFacet("units");
                        String meta = u != null && !u.isNull() ? " " + u.getSymbol() : "";
                        this.capacityLabel.setText(((BInteger)propertyValue).getInt() + meta);
                    }
                } else if (property == BDataRecoveryBlockManager.currentManagerStatus) {
                    if (this.myBar != null) {
                        if (propertyValue == BDataRecoveryBlockManagerStatus.flushing) {
                            this.myBar.setFlushing(true);
                        } else {
                            this.myBar.setFlushing(false);
                        }
                    }
                    if (this.statusLabel != null) {
                        this.statusLabel.setText(((BDataRecoveryBlockManagerStatus)propertyValue).toString(this.getCurrentContext()));
                    }
                }
            } else {
                super.handleComponentEvent(evt);
            }
        } else if (evt.getSlot().isTopic()) {
            if (evt.getSourceComponent() instanceof BDataRecoveryBlockManager) {
                BDataRecoveryBlockManager block = (BDataRecoveryBlockManager)evt.getSourceComponent();
                Topic topic = evt.getSlot().asTopic();
                if (topic == BDataRecoveryBlockManager.sizesUpdated) {
                    int freeSpace = block.getFreeSpace();
                    int usedSpace = block.getUsedSpace();
                    int overheadSpace = block.getOverheadSpace();
                    BVector remoteSpace = FoxRpcUtil.doSilentRpc((BISpaceNode)evt.getSourceComponent(), (String)"getSpaceRemote", (Object[])new Object[]{new BVector()}).orElseGet(BVector::new);
                    if (remoteSpace != null && remoteSpace.getSlotCount() > 0) {
                        freeSpace = ((BInteger)remoteSpace.get("freespace")).getInt();
                        usedSpace = ((BInteger)remoteSpace.get("usedspace")).getInt();
                        overheadSpace = ((BInteger)remoteSpace.get("overheadspace")).getInt();
                    }
                    if (this.myBar != null) {
                        this.myBar.setFreeValue(freeSpace);
                        this.myBar.setUsedValue(usedSpace);
                        this.myBar.setOverheadValue(overheadSpace);
                    }
                    if (this.freeLabel != null) {
                        this.freeLabel.setText(freeSpace + " B");
                    }
                    if (this.usedLabel != null) {
                        this.usedLabel.setText(usedSpace + " B");
                    }
                    if (this.overheadLabel != null) {
                        this.overheadLabel.setText(overheadSpace + " B");
                    }
                } else {
                    super.handleComponentEvent(evt);
                }
            } else {
                super.handleComponentEvent(evt);
            }
        } else {
            super.handleComponentEvent(evt);
        }
    }

    private static String text(String key) {
        return lex.getText("DataRecoveryService." + key);
    }

    private static void addLabelWidgetPair(BGridPane grid, String text, BWidget widget2, boolean bold) {
        String fieldName = text.trim();
        if (fieldName.length() > 10) {
            fieldName = fieldName.substring(0, 10);
        }
        fieldName = ObjectUtil.generateUniqueName((String)SlotPath.escape((String)fieldName), (ObjectUtil.NameContainer)new NameContainerDRS((BComplex)grid));
        grid.add(fieldName, (BValue)BDataRecoveryBlockManagerView.makeLabel(text, bold));
        grid.add(null, (BValue)widget2);
    }

    public static BLabel makeLabel(String text, boolean bold) {
        return BDataRecoveryBlockManagerView.makeLabel(text, bold, BHalign.left);
    }

    public static BLabel makeLabel(String text, boolean bold, BHalign align) {
        BLabel result = new BLabel(text == null ? "" : text, align);
        if (bold) {
            result.setFont(BOLD_TEXT_FONT);
        }
        return result;
    }

    private static BWidget left(BWidget content) {
        BGridPane result = new BGridPane(1);
        result.setHalign(BHalign.left);
        result.setColumnAlign(BHalign.left);
        result.add(null, (BValue)content);
        return result;
    }

    private static final class NameContainerDRS
    implements ObjectUtil.NameContainer {
        BComplex complex = null;

        public NameContainerDRS(BComplex pComplex) {
            this.complex = pComplex;
        }

        public boolean contains(String name) {
            return this.complex.getSlot(name) != null;
        }
    }
}

