/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.util;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.UnsolicitedMessageListener;
import com.tridium.basicdriver.message.ReceivedMessage;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public abstract class BBasicUnsolicitedReceive
extends BComponent
implements Runnable,
UnsolicitedMessageListener {
    public static final Property unsolicitedMessageCount = BBasicUnsolicitedReceive.newProperty((int)3, (int)0, null);
    public static final Type TYPE = Sys.loadType(BBasicUnsolicitedReceive.class);
    BBasicNetwork network = null;
    private Queue unsolicitedMessageManager = null;
    private boolean timeToDie = true;
    private Thread myThread = null;

    public int getUnsolicitedMessageCount() {
        return this.getInt(unsolicitedMessageCount);
    }

    public void setUnsolicitedMessageCount(int v) {
        this.setInt(unsolicitedMessageCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.network = (BBasicNetwork)this.getParent();
        this.network.getComm().registerListener(this);
        this.timeToDie = false;
        this.unsolicitedMessageManager = new Queue();
        this.myThread = new Thread((Runnable)this, this.getName() + ':' + this.getParent().getName());
        this.myThread.start();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.network.getComm().unregisterListener(this);
        this.timeToDie = true;
        this.myThread.interrupt();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent.getType().is(BBasicNetwork.TYPE);
    }

    @Override
    public void run() {
        while (!this.timeToDie) {
            ReceivedMessage unsolicitedMsg;
            try {
                unsolicitedMsg = (ReceivedMessage)this.unsolicitedMessageManager.dequeue(-1);
            }
            catch (InterruptedException ie) {
                unsolicitedMsg = null;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (unsolicitedMsg == null) continue;
            this.setUnsolicitedMessageCount(this.getUnsolicitedMessageCount() + 1);
            if (this.network.getLog().isTraceOn()) {
                this.network.getLog().trace("Received unsolicited message " + unsolicitedMsg);
            }
            try {
                this.processUnsolicitedMessage(unsolicitedMsg);
            }
            catch (Exception e) {
                this.network.getLog().error(this.myThread.getName(), (Throwable)e);
            }
        }
    }

    protected abstract void processUnsolicitedMessage(ReceivedMessage var1);

    @Override
    public Object getUnsolicitedListenerCode() {
        return TYPE;
    }

    @Override
    public void receiveMessage(ReceivedMessage message) {
        this.unsolicitedMessageManager.enqueue((Object)message);
    }
}

