/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.serial;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.BCommPlugIn;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BasicException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSerialComm
extends BCommPlugIn
implements BISerialHelperParent {
    public static final Property interMessageDelay = BSerialComm.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)0L), (String)"max", (BIDataValue)BRelTime.SECOND));
    public static final Property serialPortConfig = BSerialComm.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Type TYPE = Sys.loadType(BSerialComm.class);
    private static final long MIN_SLEEP_TIME = 10L;
    private BISerialPort serialPort;
    private InputStream in;
    private OutputStream out;
    private Thread rxThread;
    private long lastRecvMessageTicks = 0L;

    public BRelTime getInterMessageDelay() {
        return (BRelTime)this.get(interMessageDelay);
    }

    public void setInterMessageDelay(BRelTime v) {
        this.set(interMessageDelay, (BValue)v, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper v) {
        this.set(serialPortConfig, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public final void reopenPort() {
        try {
            String newPort = this.getSerialPortConfig().getPortName();
            if (newPort.equals("none")) {
                this.getNetwork().configFail("No port selected for serial communication.");
                this.getNetwork().stopComm();
                return;
            }
            this.restartSerialNetwork();
        }
        catch (Exception e) {
            this.getNetwork().getLog().error("BSerialNetwork caught exception in reopenPort(): ", (Throwable)e);
        }
    }

    private void restartSerialNetwork() throws Exception {
        BBasicNetwork net = this.getNetwork();
        if (!(net.isDisabled() || net.isDown() || net.isFatalFault())) {
            if (net.getLog().isTraceOn()) {
                net.getLog().trace(this.getName() + " *** Restarting serial comm ***");
            }
            net.stopComm();
            net.startComm();
        }
    }

    @Override
    public boolean commStarted() throws Exception {
        try {
            BISerialService platSvc = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.serialPort = this.getSerialPortConfig().open(this.getNetwork().getName());
            this.serialPort.enableReceiveTimeout(platSvc.getMinTimeout());
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
        }
        catch (Exception e) {
            String errMsg = "Error opening and configuring the serial port";
            this.getNetwork().getLog().error(errMsg, (Throwable)e);
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception x) {
                    this.getNetwork().getLog().error("Unable to close serial input stream.", (Throwable)x);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception x) {
                    this.getNetwork().getLog().error("Unable to close serial output stream.", (Throwable)x);
                }
            }
            if (this.serialPort != null) {
                this.serialPort.close();
            }
            throw e;
        }
        CommReceiver commRx = this.getCommReceiver();
        commRx.setInputStream(this.in);
        this.getCommTransmitter().setOutputStream(this.out);
        this.rxThread = new Thread((Runnable)commRx, "SerialRcv:" + this.getNetwork().getName());
        commRx.setAlive(true);
        this.rxThread.start();
        this.rxThread.setPriority(5);
        return true;
    }

    @Override
    public void commStopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.rxThread != null) {
            this.rxThread.interrupt();
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception e) {
                this.getNetwork().getLog().error("Unable to close serial input stream.", (Throwable)e);
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception e) {
                this.getNetwork().getLog().error("Unable to close serial output stream.", (Throwable)e);
            }
        }
        if (this.serialPort != null) {
            this.serialPort.disableReceiveTimeout();
            this.serialPort.close();
        }
        this.in = null;
        this.out = null;
    }

    public Message transmit(Message msg, BRelTime responseTimeout, int retryCount) throws BasicException {
        if (msg == null) {
            return null;
        }
        if (!msg.getResponseExpected()) {
            this.transmitNoResponse(msg);
            return null;
        }
        this.performInterMessageDelay();
        return this.getComm().transmit(msg, responseTimeout, retryCount);
    }

    public void transmitNoResponse(Message msg) throws BasicException {
        if (msg == null) {
            return;
        }
        if (!this.getComm().isCommStarted()) {
            throw new BasicException("Communication handler service not started.");
        }
        this.performInterMessageDelay();
        this.getComm().transmitNoResponse(msg);
    }

    public void receive(ReceivedMessage msg) {
        if (msg == null) {
            return;
        }
        this.setReceivedMessageTicks(Clock.ticks());
        this.getComm().receive(msg);
    }

    protected void performInterMessageDelay() {
        long minDelay = ((BSerialNetwork)this.getNetwork()).getInterMessageDelay().getMillis();
        if (minDelay <= 0L) {
            return;
        }
        long difference = Clock.ticks() - this.lastRecvMessageTicks;
        if (difference >= minDelay) {
            return;
        }
        long sleepTime = Math.max(minDelay - difference, 10L);
        try {
            Thread.sleep(sleepTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setReceivedMessageTicks(long ticks) {
        this.lastRecvMessageTicks = ticks;
    }

    public BISerialPort getSerialPort() {
        return this.serialPort;
    }

    public String toString(Context cx) {
        StringBuffer sb = new StringBuffer();
        BSerialHelper sh = this.getSerialPortConfig();
        sb.append(sh.getPortName());
        sb.append(' ');
        sb.append(sh.getBaudRate());
        sb.append(',');
        sb.append(sh.getDataBits());
        sb.append(',');
        sb.append(sh.getStopBits());
        sb.append(',');
        sb.append(sh.getParity());
        return sb.toString();
    }
}

