/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.comm;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommTransaction;
import com.tridium.basicdriver.message.Message;
import java.util.Hashtable;

public class CommTransactionManager
extends Comm.CommSupport {
    private static final int MAX_TRANSACTIONS = 15;
    private Object waitObject = new Object();
    private CommTransaction[] transactionBuffers = new CommTransaction[15];
    private Hashtable<Object, Integer> tagsToCommTransactionIds = new Hashtable(32);
    private int lastCommTransactionId = 14;
    private static final Integer[] transactionIds = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14)};

    public CommTransactionManager() {
        for (int index = 0; index < 15; ++index) {
            CommTransaction transaction;
            this.transactionBuffers[index] = transaction = new CommTransaction(index);
        }
    }

    private synchronized void setLastCommTransactionId(int transactionId) {
        this.lastCommTransactionId = transactionId;
    }

    private synchronized int getLastCommTransactionId() {
        return this.lastCommTransactionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommTransaction getCommTransaction(Message msg) {
        int buffersChecked = 0;
        int startIndex = this.getLastCommTransactionId() >= 14 ? 0 : this.getLastCommTransactionId() + 1;
        while (true) {
            CommTransaction sameTagCommTransaction;
            if ((sameTagCommTransaction = this.getCommTransactionMatch(msg.getTag())) == null || !sameTagCommTransaction.isUsed()) {
                CommTransaction commTransaction;
                int index;
                for (index = startIndex; index < 15; ++index) {
                    commTransaction = this.transactionBuffers[index];
                    synchronized (commTransaction) {
                        if (!this.transactionBuffers[index].isUsed()) {
                            this.tagsToCommTransactionIds.put(msg.getTag(), transactionIds[index]);
                            this.setLastCommTransactionId(index);
                            this.initCommTransaction(index, msg);
                            return this.transactionBuffers[index];
                        }
                        ++buffersChecked;
                        continue;
                    }
                }
                for (index = 0; index < startIndex; ++index) {
                    commTransaction = this.transactionBuffers[index];
                    synchronized (commTransaction) {
                        if (!this.transactionBuffers[index].isUsed()) {
                            this.tagsToCommTransactionIds.put(msg.getTag(), transactionIds[index]);
                            this.setLastCommTransactionId(index);
                            this.initCommTransaction(index, msg);
                            return this.transactionBuffers[index];
                        }
                        ++buffersChecked;
                        continue;
                    }
                }
                this.getComm().getNetwork().getLog().warning("CommTransactionManager.getCommTransaction All transactions are used. Number checked is " + buffersChecked + "!!!");
            }
            Object object = this.waitObject;
            synchronized (object) {
                try {
                    this.waitObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void initCommTransaction(int index, Message msg) {
        CommTransaction transaction = this.transactionBuffers[index];
        transaction.setUsed(true);
        transaction.setRequestMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeCommTransaction(CommTransaction transaction) {
        this.tagsToCommTransactionIds.remove(transaction.getRequestMessage().getTag());
        Object object = transaction;
        synchronized (object) {
            transaction.setRequestMessage(null);
            transaction.setResponseMessage(null);
            transaction.setUsed(false);
            transaction.setComplete(false);
        }
        object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    public CommTransaction getCommTransactionMatch(Object tag) {
        Integer transactionId = this.tagsToCommTransactionIds.get(tag);
        if (transactionId != null) {
            return this.transactionBuffers[transactionId];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllOutstandingCommTransactions() {
        for (int index = 0; index < 15; ++index) {
            CommTransaction transaction;
            CommTransaction commTransaction = transaction = this.transactionBuffers[index];
            synchronized (commTransaction) {
                if (transaction != null && transaction.isUsed()) {
                    transaction.setResponseMessage(null);
                    transaction.setComplete(true);
                    transaction.notify();
                }
                continue;
            }
        }
    }
}

