/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.util;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.UserValidator;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.LoginFailureCause;
import com.tridium.opcUaServer.BOpcUaServerSession;
import com.tridium.opcUaServer.authn.BOpcUaCallbackHandler;
import com.tridium.session.NiagaraSession;
import com.tridium.session.SessionManager;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.security.auth.callback.CallbackHandler;

public class OpcUaUserValidator
implements UserValidator {
    private BOpcUaServerSession opcUaSession;
    private static final HashMap<String, SessionData> nodeIdSessionDataHashMap = new HashMap();
    private final Logger logger = Logger.getLogger("opcUaServer.userValidator");
    private static final Lexicon lex = Lexicon.make(OpcUaUserValidator.class);

    public boolean onValidate(Session session, ServerUserIdentity userIdentity) throws StatusException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("onValidate: userIdentity.type = " + userIdentity.getType());
        }
        if (userIdentity.getType() == UserTokenType.UserName) {
            try {
                BUser requestedUser = BUserService.getService().getUser(userIdentity.getName());
                BUser authenticatedUser = this.validateOpcUaUser(userIdentity, session);
                if (authenticatedUser == null || !authenticatedUser.equals((Object)requestedUser)) {
                    this.logger.warning(lex.getText("opcuaUserAuth.failure") + ' ' + requestedUser.getName());
                    OpcUaUserValidator.invalidateSessionForNodeId(session.getSessionId());
                    return false;
                }
            }
            catch (AuthenticationException ex) {
                this.logger.warning(ex.getLocalizedMessage());
                OpcUaUserValidator.invalidateSessionForNodeId(session.getSessionId());
                return false;
            }
        }
        return true;
    }

    private BUser validateOpcUaUser(ServerUserIdentity userIdentity, Session session) {
        String userName = userIdentity.getName();
        String password = userIdentity.getPassword();
        String authScheme = lex.getText("opcUaAuthScheme");
        this.opcUaSession = BOpcUaServerSession.make(session);
        BUser requestedUser = BUserService.getService().getUser(userName);
        if (requestedUser == null) {
            this.logger.severe(userName + lex.getText("opcUaUser.invalid"));
            return null;
        }
        BAuthenticationScheme authnScheme = requestedUser.getAuthenticationScheme();
        if (!authnScheme.getSchemeName().equalsIgnoreCase(authScheme)) {
            this.logger.severe(LoginFailureCause.LOGIN_INTERFACE_NOT_SUPPORTED.toString());
            return null;
        }
        BOpcUaCallbackHandler handler = (BOpcUaCallbackHandler)authnScheme.getAgentOn(BOpcUaCallbackHandler.class);
        if (handler == null) {
            this.logger.log(Level.SEVERE, lex.getText("opcuaUserAuth.noCallbackAgent") + ':' + authnScheme.getSchemeName());
            return null;
        }
        handler.init(userName, password);
        SessionManager.addSession((NiagaraSession)this.opcUaSession);
        OpcUaUserValidator.addSessionDataToHashMap(session.getSessionId(), this.opcUaSession.getId(), this.opcUaSession);
        BAuthenticationService authnService = (BAuthenticationService)Sys.getService((Type)BAuthenticationService.TYPE);
        return authnService.authenticate((NiagaraSession)this.opcUaSession, requestedUser, (CallbackHandler)((Object)handler), authnScheme);
    }

    public void onValidationError(Session session, UserIdentityToken userToken, Exception exception) {
        String user = "Unknown User";
        if (session != null && session.getUserIdentity() != null) {
            user = session.getUserIdentity().getName();
        }
        this.logger.warning("onValidationError " + lex.getText("opcUaUserValidation.error") + ' ' + user);
    }

    public static void invalidateSessionForNodeId(NodeId nodeId) {
        SessionData existed = nodeIdSessionDataHashMap.remove(nodeId.toString());
        if (existed != null) {
            existed.getSession().invalidate();
        }
    }

    public static SessionData getSessionDataFromHashMap(NodeId nodeId) {
        return nodeIdSessionDataHashMap.get(nodeId.toString());
    }

    public static void addSessionDataToHashMap(NodeId nodeId, String sessionId, BOpcUaServerSession session) {
        nodeIdSessionDataHashMap.put(nodeId.toString(), new SessionData(sessionId, session));
    }

    public static class SessionData {
        String sessionId;
        BOpcUaServerSession session;

        public SessionData(String sessionId, BOpcUaServerSession session) {
            this.sessionId = sessionId;
            this.session = session;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public BOpcUaServerSession getSession() {
            return this.session;
        }
    }
}

