/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.util;

import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.cert.CertificateCheck;
import com.prosysopc.ua.stack.cert.ValidationResult;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.tridium.opcUaServer.util.OpcUaCertificateValidationListener;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.logging.Logger;

public class OpcUaCertificateValidator
implements CertificateValidator {
    private static final Logger logger = Logger.getLogger("opcUaServer.server");

    public StatusCode validateCertificate(ApplicationDescription applicationDescription, Cert cert) {
        StatusCode statusCode = StatusCode.BAD;
        EnumSet<CertificateCheck> certificateCheckEnumSet = EnumSet.noneOf(CertificateCheck.class);
        X509Certificate certificate = cert.getCertificate();
        try {
            certificate.checkValidity();
            certificateCheckEnumSet.add(CertificateCheck.Validity);
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            logger.warning("The certificate is not valid for current date.");
        }
        try {
            certificate.verify(certificate.getPublicKey());
            certificateCheckEnumSet.add(CertificateCheck.Signature);
            certificateCheckEnumSet.add(CertificateCheck.SelfSigned);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            logger.warning("The certificate is not properly signed.");
        }
        OpcUaCertificateValidationListener validatorListener = new OpcUaCertificateValidationListener();
        ValidationResult validationResult = validatorListener.onValidate(cert, applicationDescription, certificateCheckEnumSet);
        switch (validationResult) {
            case AcceptPermanently: 
            case AcceptOnce: {
                statusCode = StatusCode.GOOD;
                break;
            }
            case Reject: {
                if (!certificateCheckEnumSet.contains(CertificateCheck.Signature)) {
                    statusCode = StatusCode.valueOf((UnsignedInteger)StatusCodes.Bad_SecurityChecksFailed);
                    break;
                }
                if (certificateCheckEnumSet.contains(CertificateCheck.Validity)) break;
                statusCode = StatusCode.valueOf((UnsignedInteger)StatusCodes.Bad_CertificateTimeInvalid);
            }
        }
        return statusCode;
    }

    public StatusCode validateCertificate(Cert cert) {
        return cert == null ? StatusCode.GOOD : this.validateCertificate(null, cert);
    }
}

