/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.util;

import com.prosysopc.ua.stack.cert.CertificateCheck;
import com.prosysopc.ua.stack.cert.DefaultCertificateValidatorListener;
import com.prosysopc.ua.stack.cert.ValidationResult;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.transport.security.Cert;
import java.util.Date;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpcUaCertificateValidationListener
implements DefaultCertificateValidatorListener {
    Logger logger = Logger.getLogger("opcUaServer.certificateValidationListener");

    public ValidationResult onValidate(Cert certificate, ApplicationDescription applicationDescription, EnumSet<CertificateCheck> passedChecks) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "");
            this.logger.log(Level.FINE, "*** The Server Certificate : ");
            this.logger.log(Level.FINE, "");
            this.logger.log(Level.FINE, "Subject   : " + certificate.getCertificate().getSubjectX500Principal().toString());
            this.logger.log(Level.FINE, "Issued by : " + certificate.getCertificate().getIssuerX500Principal().toString());
            this.logger.log(Level.FINE, "Valid from: " + certificate.getCertificate().getNotBefore().toString());
            this.logger.log(Level.FINE, "        to: " + certificate.getCertificate().getNotAfter().toString());
            this.logger.log(Level.FINE, "");
        }
        if (!passedChecks.contains(CertificateCheck.Signature)) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "* The Certificate is NOT SIGNED BY A TRUSTED SIGNER!");
            }
            return ValidationResult.Reject;
        }
        if (!passedChecks.contains(CertificateCheck.Validity)) {
            String oldOrYoung;
            boolean isOld;
            Date today = new Date();
            boolean isYoung = certificate.getCertificate().getNotBefore().compareTo(today) > 0;
            boolean bl = isOld = certificate.getCertificate().getNotAfter().compareTo(today) < 0;
            String string = isOld ? "(anymore)" : (oldOrYoung = isYoung ? "(yet)" : "");
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "* The Certificate time interval IS NOT VALID " + oldOrYoung + "!");
            }
            return ValidationResult.Reject;
        }
        if (passedChecks.contains(CertificateCheck.SelfSigned) && this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "* The Certificate is self-signed.");
        }
        return ValidationResult.AcceptPermanently;
    }
}

