/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaServer.node;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.CallableListener;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.StatusCodes;

public class OpcUaMethodManagerListener
implements CallableListener {
    private final UaNode myMethod;

    public OpcUaMethodManagerListener(UaNode myMethod) {
        this.myMethod = myMethod;
    }

    public boolean onCall(ServiceContext serviceContext, NodeId objectId, UaNode object, NodeId methodId, UaMethod method, Variant[] inputArguments, StatusCode[] inputArgumentResults, DiagnosticInfo[] inputArgumentDiagnosticInfos, Variant[] outputs) throws StatusException {
        if (methodId.equals((Object)this.myMethod.getNodeId())) {
            double result;
            double input;
            String operation;
            MethodManager.checkInputArguments((Class[])new Class[]{String.class, Double.class}, (Variant[])inputArguments, (StatusCode[])inputArgumentResults, (DiagnosticInfo[])inputArgumentDiagnosticInfos, (boolean)false);
            try {
                operation = (String)inputArguments[0].getValue();
            }
            catch (ClassCastException e) {
                throw this.inputError(0, e.getMessage(), inputArgumentResults, inputArgumentDiagnosticInfos);
            }
            try {
                input = inputArguments[1].intValue();
            }
            catch (ClassCastException e) {
                throw this.inputError(1, e.getMessage(), inputArgumentResults, inputArgumentDiagnosticInfos);
            }
            operation = operation.toLowerCase();
            if (operation.equals("sin")) {
                result = Math.sin(Math.toRadians(input));
            } else if (operation.equals("cos")) {
                result = Math.cos(Math.toRadians(input));
            } else if (operation.equals("tan")) {
                result = Math.tan(Math.toRadians(input));
            } else if (operation.equals("pow")) {
                result = input * input;
            } else {
                throw this.inputError(0, "Unknown function '" + operation + "': valid functions are sin, cos, tan, pow", inputArgumentResults, inputArgumentDiagnosticInfos);
            }
            outputs[0] = new Variant((Object)result);
            return true;
        }
        return false;
    }

    private StatusException inputError(int index, String message, StatusCode[] inputArgumentResults, DiagnosticInfo[] inputArgumentDiagnosticInfos) {
        inputArgumentResults[index] = StatusCode.valueOf((UnsignedInteger)StatusCodes.Bad_InvalidArgument);
        DiagnosticInfo di = new DiagnosticInfo();
        di.setAdditionalInfo(message);
        inputArgumentDiagnosticInfos[index] = di;
        return new StatusException(StatusCodes.Bad_InvalidArgument);
    }
}

