/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import com.tridium.neql.BooleanFilterIterator;
import com.tridium.neql.NamespaceContext;
import com.tridium.neql.RelatedEntityIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.neql.AstNode;
import javax.baja.neql.BINeqlQueryHandler;
import javax.baja.neql.NeqlEntityEvaluator;
import javax.baja.neql.NeqlQuery;
import javax.baja.neql.Select;
import javax.baja.neql.Traverse;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.EntityWrapper;
import javax.baja.util.CloseableIterator;
import javax.baja.util.CloseableIteratorWrapper;

@NiagaraType
public abstract class BNeqlEntityQueryHandler
extends BObject
implements BINeqlQueryHandler {
    public static final Type TYPE = Sys.loadType(BNeqlEntityQueryHandler.class);
    private NeqlEntityEvaluator evaluator = new NeqlEntityEvaluator();

    public Type getType() {
        return TYPE;
    }

    protected abstract Iterator<? extends Entity> getIteratorForScope(OrdTarget var1);

    public CloseableIterator<Entity> query(OrdTarget scope, OrdQuery query) {
        AstNode ast = ((NeqlQuery)query).getAst();
        if (ast.getNodeType() == 1) {
            return new CloseableIteratorWrapper(this.selectQuery(scope, (Select)ast));
        }
        if (ast.getNodeType() == 16) {
            return new CloseableIteratorWrapper(this.traverseQuery(scope, (Traverse)ast));
        }
        throw new UnresolvedException();
    }

    private Iterator<Entity> selectQuery(OrdTarget scope, Select selectQuery) {
        Iterator<? extends Entity> scopeIterator = this.getIteratorForScope(scope);
        BObject scopeObj = scope.get();
        Entity scopeEntity = null;
        if (scopeObj instanceof Entity) {
            scopeEntity = (Entity)scopeObj;
        }
        return new BooleanFilterIterator(scopeIterator, new NamespaceContext((Context)scope), scopeEntity, selectQuery.getPredicate(), this.evaluator);
    }

    private Iterator<Entity> traverseQuery(OrdTarget scope, Traverse traverseQuery) {
        BObject scopeObj = scope.get();
        if (!(scopeObj instanceof Entity)) {
            return new ArrayList().iterator();
        }
        Entity scopeEntity = (Entity)scopeObj;
        Collection rels = scopeEntity.relations().getAll(traverseQuery.getRelationId(), traverseQuery.isOutbound() ? 2 : 1);
        RelatedEntityIterator related = new RelatedEntityIterator(rels.iterator(), (Context)scope);
        if (traverseQuery.getPredicate() == null) {
            return related;
        }
        BooleanFilterIterator filter = new BooleanFilterIterator(related, new NamespaceContext((Context)scope), (Entity)new EntityWrapper(scopeEntity, scope.getFacets()), traverseQuery.getPredicate(), this.evaluator);
        return filter;
    }
}

