/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import com.tridium.neql.NeqlUtil;
import java.util.Collection;
import javax.baja.neql.Expression;
import javax.baja.neql.LogicalExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;

public class AndExpression
extends LogicalExpression {
    public AndExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    @Override
    public final String getSqlOperatorString() {
        return " and ";
    }

    public Collection<BBoolean> evaluate(Entity entity, Context context) {
        Collection<Object> leftVals = this.getLeft().evaluate(entity, context);
        Collection<BBoolean> leftSide = NeqlUtil.searchForSingleLogicalBoolean(leftVals);
        if (leftSide.contains(BBoolean.TRUE)) {
            Collection<Object> rightVals = this.getRight().evaluate(entity, context);
            return NeqlUtil.searchForSingleLogicalBoolean(rightVals);
        }
        return SINGLE_FALSE;
    }

    @Override
    protected boolean evalBoolean(Entity entity, Context context) {
        return this.getLeft().evalBoolean(entity, context) && this.getRight().evalBoolean(entity, context);
    }
}

